'use strict';
define(function() {
  var hpoChantiers = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppServices,
    ngProgressFactory,
    $location,
    InitProvider,
    $interval,
    HpoMulticritereServices,
    ConfigFactory,
    extendedNgDialog,
    SirocoFactory,
    HpoChantiersServices,
    gclayers,
    panelsManager,
    DocumentFactory,
    ActionsManager,
    DataStoreFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/chantiers/views/directives/hpo_chantiers.html',
      restrict: 'EA',
      scope: {
        listFormat: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        DataStoreFactory.get();
        scope.ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes('all');
        scope.ftisToUse = HpoCarteAppFactory.getAppFactory().getMulticritereFtis();

        var fti_correspondance_item = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'correspondance_items'
        )[0];
        var fti_correspondance = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'correspondance'
        )[0];
        var fti_priority = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'priority'
        )[0];
        var fti_ponderation = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'ponderation'
        )[0];
        var fti_indicateur = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'indicateur'
        )[0];
        var fti_parametrage = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'parameters'
        )[0];
        var fti_criterea = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'critereas'
        )[0];
        var fticalage = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'calage'
        )[0];
        scope.ftiprevision = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'prevision'
        )[0];
        var ftijeudonnee = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'jeu_de_donnee'
        )[0];
        var ftimodele = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'modal_historic'
        )[0];
        scope.ftiChantiers = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'chantiers'
        )[0];
        scope.ftiChantiersattributes = scope.ftiChantiers.attributes.filter(
          function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                scope.ftiChantiers.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(scope.ftiChantiers.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  scope.ftiChantiers.name
                ))
            )
              return x;
          }
        );

        var ftiChantiers_relations = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'chantiers_relations'
        )[0];
        var rapportName = HpoCarteAppFactory.getAppFactory().getReportName(
          'docx'
        )[0];
        var reportRecapitulatifName = HpoCarteAppFactory.getAppFactory().getReportRecapitulatifName(
          'docx'
        )[0];
        scope.ftis.push(scope.ftiChantiers);
        scope.configHpo = HpoCarteAppFactory.getInitProvider().getHpoConfig();

        var appname = $location.search().app;
        panelsManager.init();
        scope.panelsManager = panelsManager;

        scope.addOrUpdateChantier = function(obj) {
          // reset
          scope.listChantiers = {};
          // scope.closeListChantiers();
          if (!obj && $rootScope.xgos && $rootScope.xgos.getMapAppMap)
            scope.map = $rootScope.xgos.getMapAppMap();
          else {
            scope.map = undefined;
          }

          ConfigFactory.get('forms', 'chantier.form', appname).then(function(
            res
          ) {
            //link.template =  res.data;
            scope.currentChantier = obj || {};
            scope.ftemplatedata = res.data;
            scope.isOpenChantier = true;

            if (obj) {
              scope.currentChantier = {
                current: obj,
              };
              var chantierDialog = ngDialog.open({
                template:
                  'js/XG/widgets/hpoapp/chantiers/views/dialog/modal.chantier.html',
                className: 'ngdialog-theme-plain width1000 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                draggable: {
                  title: $filter('translate')('hpo.chantiers.creation.update'),
                },
                minimizeMaximize: true,
                resizable: true,
              });
            } else {
              var chantierDialog = extendedNgDialog.open({
                template:
                  'js/XG/widgets/hpoapp/chantiers/views/dialog/modal.chantier.html',
                className: 'ngdialog-theme-plain width1000 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                title: $filter('translate')('hpo.chantiers.creation.add'),
                draggable: true,
                minimizeMaximize: true,
                resizable: true,
              });

              chantierDialog.closePromise.then(function(data) {
                scope.isOpenChantier = false;
                try {
                  gclayers
                    .getDrawLayer()
                    .getSource()
                    .clear();
                  gclayers.clearhighLightFeatures();
                } catch (e) {
                  e.stack;
                }
              });
            }
          });
        };

        /**
         * closepanel
         */
        scope.closeListChantiers = function() {
          scope.panelsManager.removePanel('list_chantiers');
          try {
            gclayers
              .getDrawLayer()
              .getSource()
              .clear();
            gclayers.clearhighLightFeatures();
          } catch (e) {
            e.stack;
          }
        };

        var listeChantiers = function() {
          ConfigFactory.get('forms', 'liste_chantiers.form', appname).then(
            function(res) {
              scope.listChantiers = {};
              scope.currentlink = {
                template: res.data,
              };
              scope.special = {
                usescope: true,
                ftisToUse: scope.ftisToUse,
              };
              scope.map = $rootScope.xgos.getMapAppMap();
              scope.closeListChantiers();
              scope.panelsManager.addPanel({
                id: 'list_chantiers',
                stickToRight: true,
                templateUrl:
                  'js/XG/widgets/hpoapp/chantiers/views/dialog/modal.list_chantiers.html',
                scope: scope,
                stickToBorder: true,
                visible: true,
                resizable: true,
              });
            }
          );
        };

        scope.funcs = [
          {
            title: 'hpo.chantiers.creation.add',
            icon: 'plus',
            function: scope.addOrUpdateChantier,
          },
          {
            title: 'hpo.chantiers.creation.listechantiers',
            icon: 'list',
            function: listeChantiers,
          },
        ];

        /**
         * calculer_chantier from the chantier form (intervention)
         */
        scope.$on('hpo_calculer_chantier', function(
          event,
          args,
          templatefields
        ) {
          // chantier id
          var chantierId = args.current.id;
          if (angular.isDefined(chantierId)) {
            var sendata = {
              fti_ponderation: fti_ponderation.uid,
              fti_indicateur: fti_indicateur.uid,
              fti_parametrage: fti_parametrage.uid,
              fti_criterea: fti_criterea.uid,
              fti_priority: fti_priority.uid,
              fti_correspondance: fti_correspondance.uid,
            };
            if (scope.ftiprevision && scope.ftiprevision.uid) {
              Object.assign(sendata, {
                fti_calage: fticalage.uid,
                fti_prevision: scope.ftiprevision.uid,
                fti_jeudonnee: ftijeudonnee.uid,
                fti_modele: ftimodele.uid,
              });
            }
            gaDomUtils.showGlobalLoader();
            HpoChantiersServices.calculerChantier(
              scope.ftiChantiers.uid,
              chantierId,
              sendata
            ).then(
              function(res) {
                if (res.data && res.data.properties) {
                  $rootScope.$broadcast('hpo_calculer_chantier#ended');
                  args.current.properties = res.data.properties;
                  try {
                    gclayers
                      .getDrawLayer()
                      .getSource()
                      .clear();
                    gclayers.clearhighLightFeatures();
                  } catch (e) {
                    e.stack;
                  }
                  $rootScope.$broadcast(
                    'gcOperationalLayerChange',
                    '',
                    'applyall'
                  );
                  $rootScope.$broadcast('reloadDatatable');
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.successSave();
                } else {
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.showErrorMessage(res);
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.failSave();
              }
            );
          } else {
            console.log('no id');
          }
        });

        /**
         * calculer_chantier from the chantier form (intervention)
         */
        scope.$on('hpo_supprimer_chantier', function(
          event,
          args,
          templatefields
        ) {
          // chantier id
          var chantierId = args.chantiers
            .map(function(x) {
              return x.id;
            })
            .join(',');

          if (angular.isDefined(chantierId)) {
            var callback = function(confirmed) {
              if (confirmed) {
                gaDomUtils.showGlobalLoader();
                EditFactory.remove(scope.ftiChantiers.uid, chantierId).then(
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    AlertHpoFactory.successDelete();
                    $rootScope.$broadcast(
                      'gcOperationalLayerChange',
                      '',
                      'applyall'
                    );
                    $rootScope.$broadcast('reloadDatatable');
                  },
                  function(res) {
                    gaDomUtils.hideGlobalLoader();
                    AlertHpoFactory.showErrorMessage(res);
                  }
                );
              }
            };
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              $filter('translate')('datatable.confirm_delete'),
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          } else {
            console.log('no id');
          }
        });

        var getWmsMapUrl = function(chantier, crsOk) {
          var deferred = $q.defer();

          //-- Le chantier est-il dans le bon sustème de projection ?
          var descCana = FeatureTypeFactory.getFeatureByUid(
            chantier.properties.FTIUID
          );
          FeatureTypeFactory.getExtent(descCana.uid, 'EPSG:3857').then(function(
            res
          ) {
            var canaBb = res.data;
            if (crsOk === false) {
              QueryFactory.get(
                scope.ftiChantiers.uid,
                chantier.id,
                'EPSG:3857'
              ).then(function(res) {
                var chantierFromDb = res.data.features[0];
                deferred.resolve(
                  SirocoFactory.getWmsMapUrl1(chantierFromDb, canaBb)
                );
              });
            }
            //-- L'appelant dit que oui: on peut préparer l'url de la carte de suite.
            else
              deferred.resolve(SirocoFactory.getWmsMapUrl1(chantier, canaBb));
          });

          return deferred.promise;
        };
        /**
         * calculer_chantier from the chantier form (intervention)
         */
        var specialTreatement = function(relationTreatement) {
          if (
            relationTreatement &&
            relationTreatement.features &&
            relationTreatement.features.length > 0
          ) {
            var relationsChantiers = {};
            var relations = [];
            relationTreatement.features.map(function(x) {
              if (
                x &&
                x.id &&
                ftiChantiers_relations &&
                x.id.indexOf(ftiChantiers_relations.name) === -1
              ) {
                relations.push(x);
              } else if (
                x &&
                x.id &&
                ftiChantiers_relations &&
                x.id.indexOf(ftiChantiers_relations.name) !== -1 &&
                x.properties &&
                x.properties.FEATID
              ) {
                relationsChantiers[x.properties.FEATID] = {
                  HPO_CALC_CASSE: x.properties.CASSE,
                  HPO_CALC_REPARATION: x.properties.COUT_REPARATION,
                  HPO_CALC_RENOUVELLEMENT: x.properties.COUT_RENOUVELLEMENT,
                  HPO_CALC_RENDEMENT: x.properties.RENDEMENT,
                  HPO_CALC_NOTE_PRIORITE: x.properties.NOTE_PRIORITE,
                };
              }
            });
            relations.map(function(x) {
              if (x && x.id && relationsChantiers.hasOwnProperty(x.id))
                Object.assign(x.properties, relationsChantiers[x.id]);
            });
            return {
              type: 'FeatureCollection',
              crs: relationTreatement.crs,
              totalFeatures: relations.length,
              features: relations,
            };
          } else {
            return relationTreatement;
          }
        };

        scope.printChantier = function(chantierFeature) {
          gaDomUtils.showGlobalLoader();
          QueryFactory.relation(
            scope.ftiChantiers.uid,
            '*',
            chantierFeature.id,
            ''
          ).then(
            function(res1) {
              var relatedfeature = res1.data;
              getWmsMapUrl(chantierFeature, true).then(
                function(url) {
                  try {
                    var result = {
                      type: 'FeatureCollection',
                      features: [chantierFeature],
                    };
                    var componenentsEsri = [];
                    var esriUrl;
                    var esriStoreName;
                    var componenents = [scope.ftiChantiers.name];
                    var componentsStyles = [
                      scope.ftiChantiers.defaultStyle || '',
                    ];
                    var ftiCana = FeatureTypeFactory.getFeatureByUid(
                      chantierFeature.properties.FTIUID
                    );
                    if(ftiCana.type == 'esri'){
                      componenentsEsri.push(ftiCana.ogcId);
                      esriUrl = ftiCana.wms;
                      esriStoreName = ftiCana.storeName;
                    }else{
                      componenents.push(ftiCana.name);
                      componentsStyles.push(ftiCana.defaultStyle || '');
                    }
                    var ftiRelation = ftiCana.relations.map(function(x) {
                      if (x.type === 'REL_SIMPLE' && x.idEnd) {
                        var ftiend = FeatureTypeFactory.getFeatureByUid(
                          x.idEnd
                        );
                        if (ftiend.geographic) {
                          if(ftiCana.type == 'esri'){
                            componenentsEsri.push(ftiend.ogcId);
                          }else{
                           componenents.push(ftiend.name);
                           componentsStyles.push(ftiend.defaultStyle || '');
                          }
                        }
                      }
                    });
                    createEsriUrl(componenentsEsri,esriUrl,esriStoreName).then(function(esriurl){
                      url.plan = url.plan
                        .replace(
                          'siroco_chantier%2Caep_cana%2CAEP_ANOMALIE',
                          componenents.join(',')
                        )
                        .replace(
                          'chantier1%2CAEP_CANA_IMPORTANCE%2Canomalie',
                          componentsStyles.join(',')
                        ).replace(
                          'CQL_FILTER=1%3D1',
                          'CQL_FILTER=fid%3D'+ chantierFeature.id.split(".")[1]
                      );
                      if(componenents.length >3){
                        url.plan = url.plan.replace(
                          '&type',
                          ';1%3D1;1%3D1;1%3D1;1%3D1&type'
                        );
                      }
                      url.planEsri = esriurl ==""?"":esriurl+"&size=880,726"+"&"+url.plan.substring(url.plan.indexOf("BBOX="));
                      // .replace("&WIDTH=880&HEIGHT=726" ,
                      //                    "&WIDTH=395&HEIGHT=325");
                      url.plan_prev01 = url.plan_prev01
                        .replace(
                          'siroco_chantier%2Caep_cana%2CAEP_ANOMALIE',
                          componenents[0]+","+componenents[1]
                        )
                        .replace(
                          'chantier1%2CAEP_CANA_IMPORTANCE%2Canomalie',
                          componentsStyles[0]+","+componentsStyles[1]
                        );
                      url.plan_prev01Esri = esriurl ==""?"":esriurl+"&size=600,600"+"&"+url.plan_prev01.substring(url.plan_prev01.indexOf("BBOX="));
                      // .replace("&WIDTH=600&HEIGHT=600" ,
                      //                    "&WIDTH=285&HEIGHT=235");
                      url.plan_prev02 = url.plan_prev02
                        .replace(
                          'siroco_chantier%2Caep_cana%2CAEP_ANOMALIE',
                          componenents[0]+","+componenents[1]
                        )
                        .replace(
                          'chantier1%2CAEP_CANA_IMPORTANCE%2Canomalie',
                          componentsStyles[0]+","+componentsStyles[1]
                        );
                      url.plan_prev02Esri = esriurl ==""?"":esriurl+"&size=180,180"+"&"+url.plan_prev02.substring(url.plan_prev01.indexOf("BBOX="));
                      url.locator02 =
                        $location
                          .absUrl()
                          .replace($location.url(), '/')
                          .replace('#/', '') + 'img/hpo/locator2.png';
                      url.locator01 =
                        $location
                          .absUrl()
                          .replace($location.url(), '/')
                          .replace('#/', '') + 'img/hpo/locator1.png';
                      relatedfeature = specialTreatement(relatedfeature);
                      var sendataOriginal = ActionsManager.getPortalDoc(
                        chantierFeature,
                        result,
                        scope.ftiChantiers,
                        relatedfeature
                      );
                      var sendata = angular.copy(sendataOriginal);
                      var coordinateplan = url.fdplan.substring(url.fdplan.indexOf("BBOX=")+5).split("%2C");
                      var coordinateplan_prev01 = url.fdplan_prev01.substring(url.fdplan_prev01.indexOf("BBOX=")+5).split("%2C");
                      sendata.current.properties.SCALE_LINE_PLAN = 800/Math.abs(parseFloat(coordinateplan[2]) - parseFloat(coordinateplan[0]))
                      sendata.current.properties.SCALE_LINE_PLAN_PREV01 =  600/Math.abs(parseFloat(coordinateplan_prev01[2]) - parseFloat(coordinateplan_prev01[0]))
                      sendata.SCALE_LINE = 800/Math.abs(parseFloat(coordinateplan[2]) - parseFloat(coordinateplan[0]))
                      sendata.SCALE_LINE01 =  600/Math.abs(parseFloat(coordinateplan_prev01[2]) - parseFloat(coordinateplan_prev01[0]))
                      
                      sendata.SPECIAL_RELATED_FEATURES=[];
                      var currentResourceConfig = scope.configHpo.currentResources.filter((chantier) => chantier.uid==chantierFeature.properties.FTIUID)[0]
                      createSpecialRelatedFeature(relatedfeature,sendata,currentResourceConfig);
                      calculateAndFormatSendData(sendata,chantierFeature.properties.FTIUID);
                      Object.assign(sendata, url);
                      sendata.hpoFtiuid = ftiCana.uid;
                      for (
                        var idx = 0;
                        idx < scope.ftiChantiers.relations.length;
                        idx++
                      ) {
                        var relation = scope.ftiChantiers.relations[idx];
                        if (
                          relation.type === 'REL_NM' &&
                          relation.idEnd === ftiCana.uid
                        ) {
                          sendata.REL_NAME = relation.name;
                          break;
                        }
                      }
                      DocumentFactory.generatedocx(
                        sendata,
                        rapportName,
                        chantierFeature.id
                      ).then(
                        function(res) {
                          window.open(
                            '/services/' +
                              angular.module('gcMainHpo').portalid +
                              '/documents/downloaddocx?' +
                              '&name=' +
                              res.data.name
                          );
                          gaDomUtils.hideGlobalLoader();
                        },
                        function(res) {
                          gaDomUtils.hideGlobalLoader();
                          AlertHpoFactory.showErrorMessage(res);
                        }
                      );
                  });
                  } catch (e) {
                    e.stack;
                    gaDomUtils.hideGlobalLoader();
                  }
                },
                function(res) {
                  gaDomUtils.hideGlobalLoader();
                  AlertHpoFactory.showErrorMessage(res);
                }
              );
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };
        scope.printChantierSyntheseTable = function() {
          gaDomUtils.showGlobalLoader();
          QueryFactory.data(scope.ftiChantiers.uid).then(
            function(res1) {
              if(res1 && res1.data && res1.data.features && res1.data.features.length>0){
                var sendata = {};
                sendata.SPECIAL_RELATED_FEATURES=[];
                sendata.current = {};
                sendata.current.properties = {};
                sendata.current.properties.COUT_RENOUVELLEMENT= 0;
                sendata.current.properties.DIVERS =0;
                scope.numberPromises = 0;
                for(let i=0;i<res1.data.features.length;i++){
                  var chantierFeature = res1.data.features[i];
                  if(chantierFeature.properties.DIVERS != null)
                    sendata.current.properties.DIVERS = chantierFeature.properties.DIVERS;
                  QueryFactory.relation(
                    scope.ftiChantiers.uid,
                    '*',
                    chantierFeature.id,
                    ''
                  ).then(
                    function(res2) {
                      var relatedfeature = res2.data;
                      relatedfeature = specialTreatement(relatedfeature);
                      var currentResourceConfig = scope.configHpo.currentResources.filter((chantier) => chantier.uid==chantierFeature.properties.FTIUID)[0]
                      createSpecialRelatedFeature(relatedfeature,sendata,currentResourceConfig);
                      scope.numberPromises ++;
                    },
                    function(res3) {
                      gaDomUtils.hideGlobalLoader();
                      AlertHpoFactory.showErrorMessage(res);
                      scope.numberPromises ++;
                    }
                    );

                }
                scope.$watch("numberPromises",function(val){
                  if(val == res1.data.features.length){
                    scope.numberPromises = 0;
                    calculateAndFormatSendData(sendata,chantierFeature.properties.FTIUID);
                    DocumentFactory.generatedocx(
                      sendata,
                      reportRecapitulatifName
                    ).then(
                      function(res) {
                        window.open(
                          '/services/' +
                            angular.module('gcMainHpo').portalid +
                            '/documents/downloaddocx?' +
                            '&name=' +
                            res.data.name
                        );
                        gaDomUtils.hideGlobalLoader();
                      },
                      function(res) {
                        gaDomUtils.hideGlobalLoader();
                        AlertHpoFactory.showErrorMessage(res);
                      }
                    );
                    gaDomUtils.hideGlobalLoader();
                  }
                });
              }
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        var calculateAndFormatSendData = function(sendata,uid){
          var currentResourceConfig = scope.configHpo.currentResources.filter((chantier) => chantier.uid==uid)[0]
          sendata.SPECIAL_RELATED_FEATURES.sort((a, b) => parseFloat(a[currentResourceConfig.diametre]) - parseFloat(b[currentResourceConfig.diametre]));
           //Arrondir les valeurs au milier pret et calculer la somme
          sendata.current.properties.COUT_RENOUVELLEMENT_EXACT = 0 ;
          for (let i = 0;i< sendata.SPECIAL_RELATED_FEATURES.length;i++) {
            sendata.SPECIAL_RELATED_FEATURES[i].HPO_CALC_RENOUVELLEMENT = Math.round(sendata.SPECIAL_RELATED_FEATURES[i].HPO_CALC_RENOUVELLEMENT/1000)*1000
            sendata.current.properties.COUT_RENOUVELLEMENT_EXACT += sendata.SPECIAL_RELATED_FEATURES[i].HPO_CALC_RENOUVELLEMENT;
          }
          if(sendata.current.properties.DIVERS == null || !angular.isDefined(sendata.current.properties.DIVERS)){
            sendata.current.properties.DIVERS = 0;
          }
          sendata.current.properties.DIVERS_VALUE = 
            sendata.current.properties.COUT_RENOUVELLEMENT_EXACT * sendata.current.properties.DIVERS/ 100;
          sendata.current.properties.COUT_RENOUVELLEMENT = sendata.current.properties.COUT_RENOUVELLEMENT_EXACT + sendata.current.properties.DIVERS_VALUE;
          sendata.hpoConfig = scope.configHpo;
        }
        var createSpecialRelatedFeature = function(relatedfeature,sendata,currentResourceConfig){
            for (var i = 0;i< relatedfeature.features.length;i++) {
              var diametre = relatedfeature.features[i].properties[currentResourceConfig.diametre];
              var feature = undefined;
              if(sendata.SPECIAL_RELATED_FEATURES.length>0){
                for(var j = 0;j< sendata.SPECIAL_RELATED_FEATURES.length;j++){
                  if(sendata.SPECIAL_RELATED_FEATURES[j][currentResourceConfig.diametre] == diametre){
                    feature = sendata.SPECIAL_RELATED_FEATURES[j];
                    break;
                  }
                }
              }
              if(feature == undefined){
                relatedfeature.features[i].properties.chantierUid = currentResourceConfig.uid;
                sendata.SPECIAL_RELATED_FEATURES.push(relatedfeature.features[i].properties);
              }else{
                var featureCurrentResourceConfig = scope.configHpo.currentResources.filter((chantier) => chantier.uid==feature.chantierUid)[0];
                feature['HPO_CALC_NOTE_PRIORITE'] = (feature['HPO_CALC_NOTE_PRIORITE'] * feature[featureCurrentResourceConfig.longueur]
                 + relatedfeature.features[i].properties['HPO_CALC_NOTE_PRIORITE']*relatedfeature.features[i].properties[currentResourceConfig.longueur])
                /(feature[featureCurrentResourceConfig.longueur]+relatedfeature.features[i].properties[currentResourceConfig.longueur])
                feature[featureCurrentResourceConfig.longueur] = feature[featureCurrentResourceConfig.longueur]+relatedfeature.features[i].properties[currentResourceConfig.longueur]; 
                feature['HPO_CALC_RENOUVELLEMENT'] = feature['HPO_CALC_RENOUVELLEMENT']+relatedfeature.features[i].properties['HPO_CALC_RENOUVELLEMENT']; 
              }

            }
        }
        var createEsriUrl = function(componenents,createEsriUrl,storeName){
          var defer = $q.defer();
          if(componenents && createEsriUrl && storeName && componenents.length != 0){
             DataStoreFactory.getEsriUrl(storeName).then(function(res){
                let urlEsri = res.data+"/export?bboxSR=3857&layerDefs=&imageSR=&historicMoment=&format=png&transparent=true&dpi=&time=&layerTimeOptions=&dynamicLayers=&gdbVersion=&mapScale=&rotation=&datumTransformations=&layerParameterValues=&mapRangeValues=&layerRangeValues=&f=image";
                urlEsri += "&layers=show:"+componenents.join(',');
                let token ="";
                DataStoreFactory.getEsriToken(storeName).then(function(res1){
                   urlEsri += "&token="+res1.data;
                   defer.resolve(urlEsri);
                },function() {
                   defer.resolve(urlEsri);
                });
            },function() {
               defer.resolve("");;
            });
          }else{
            defer.resolve("");
          }
          return defer.promise;
        }
        function resolveAfter2Seconds() {
          return new Promise(resolve => {
            setTimeout(() => {
              resolve('resolved');
            }, 2000);
          });
        }

        scope.$on('hpo_imprimer_chantier', function(event, args) {
          var chantierFeature = args.chantiers[0];
          scope.printChantier(chantierFeature);
        });
        scope.$on('hpo_generateSynthTab', function(event, args) {
          scope.printChantierSyntheseTable();
        });

        /**
         * Liste chantiers
         * @type {Array}
         */
        scope.buttonSpecialActions = [
          {
            class: 'btn btn-default btn-xs',
            icone: 'fa fa-print',
            text: $filter('translate')('applications.print.title'),
            callFunction: scope.printChantier,
          },
        ];
      },
    };
  };

  hpoChantiers.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppServices',
    'ngProgressFactory',
    '$location',
    'InitProvider',
    '$interval',
    'HpoMulticritereServices',
    'ConfigFactory',
    'extendedNgDialog',
    'SirocoFactory',
    'HpoChantiersServices',
    'gclayers',
    'panelsManager',
    'DocumentFactory',
    'ActionsManager',
    'DataStoreFactory',
  ];
  return hpoChantiers;
});
