'use strict';
define(function() {
  var preparationAnalysisDataHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppServices,
    InitProvider
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/preparation_analysis_data_hpo.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoPreparationDataAnalysisConfig';
        scope.configNameGlobal =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoDataConfig';
        scope.ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes('all');
        scope.datatableHeightCorrection = $window.innerHeight + 200 + 'px';
        var configData = HpoCarteAppFactory.getInitProvider().getHpoConfig();

        scope.reinitialiseThisWidget = function() {
          scope.ftis = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
            'all'
          );
          scope.emptyAnalysisTools();
        };

        scope.analysistoolsAttributes = HpoCarteAppFactory.getAppFactory().getAnalysisToolsAttributes();
        scope.analysistoolsLinesColumns = HpoCarteAppFactory.getAppFactory().getAnalysisToolsLines();
        scope.analysistoolsTables = HpoCarteAppFactory.getAppFactory().getAnalysisToolsTables();
        scope.analysistoolsFuites = HpoCarteAppFactory.getAppFactory().getAnalysisToolsFuites();
        scope.supplementanalysistools = HpoCarteAppFactory.getAppFactory().getSuppAnalysisTools();

        scope.analysistoolsAttributesNames = scope.analysistoolsAttributes.map(
          function(x) {
            return x.value;
          }
        );
        scope.analysistoolsLinesColumnsNames = scope.analysistoolsLinesColumns.map(
          function(x) {
            return x.value;
          }
        );
        scope.analysistoolsTablesNames = scope.analysistoolsTables.map(function(
          x
        ) {
          return x.value;
        });
        if (scope.analysistoolsFuites)
          scope.analysistoolsFuitesNames = scope.analysistoolsFuites.map(
            function(x) {
              return x.value;
            }
          );

        scope.doublonInfo = $filter('translate')(
          'hpo.data.prepare.doublonidentifier'
        );

        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;

        scope.saveTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.templates.html';
        scope.getTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.gettemplates.html';

        scope.buttonactions = [];

        scope.propertiestoexclude = {
          result: [],
          geoj: {},
          supplementAttributes: [],
          attributestouseindatatable: {},
        };
        scope.emptyAnalysisTools = function(btn) {
          if (btn) {
            var callback = function(isconfirm) {
              if (isconfirm) {
                scope.analysis = {
                  analysistool: 'allanalysis',
                  tableselected: {},
                  result: [],
                  geoj: {},
                  operands: [],
                  attributestoselect: {},
                  expression: '',
                  interpreteattributes: 'and',
                  interpreteconditions: 'and',
                  selectedall: false,
                  clauseWhere: '',
                  attributestouseindatatable: [],
                  supplementAttributes: null,
                };
                try {
                  scope.$apply();
                } catch(err) {}
              }
            };
            var message =
              $filter('translate')('hpo.data.prepare.emptyanalyse') +
              '. ' +
              $filter('translate')('hpo.common.sur');
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              message,
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          } else {
            scope.analysis = {
              analysistool: 'allanalysis',
              tableselected: {},
              result: [],
              geoj: {},
              correction: [],
              operands: [],
              attributestoselect: {},
              expression: '',
              interpreteattributes: 'and',
              interpreteconditions: 'and',
              selectedall: false,
              clauseWhere: '',
              attributestouseindatatable: [],
              supplementAttributes: null,
            };
          }
        };

        var usedInDefail = HpoCarteAppFactory.getAppFactory().getFuiteTables;

        scope.emptyAnalysisTools();
        scope.changedAnalysisToolOrFti = function() {
          scope.analysis.operands = [];
          scope.analysis.attributestoselect = {};
          scope.analysis.attributestouseindatatable = {};
          scope.analysis.result = [];
          scope.analysis.geoj = {};
          scope.analysis.expression = '';
          scope.analysis.selectedall = false;
          scope.analysis.supplementAttributes = null;
          delete scope.analysis.relationselected;
          if (
            scope.analysis.analysistool === 'fuiteanalysis' &&
            scope.analysis.tableselected &&
            usedInDefail(scope.analysis.tableselected)
          )
            scope.analysis.tableselected = {};
        };

        scope.filterFuiteOnly = function(v) {
          switch (scope.analysis.analysistool) {
            case 'fuiteanalysis':
              if (usedInDefail(v)) v = undefined;
              break;
          }
          return v;
        };

        scope.filterDependOnTool = function(v) {
          switch (scope.analysis.analysistool) {
            case 'stringanalysis':
              if (
                HpoCarteAppFactory.getAppFactory()
                  .getStringTypes()
                  .indexOf(v.type) === -1
              )
                v = undefined;
              break;
            case 'dataanalysis':
              if (
                HpoCarteAppFactory.getAppFactory()
                  .getDateTypes()
                  .indexOf(v.type) === -1
              )
                v = undefined;
              break;
            case 'numberanalysis':
            case 'calculatoranalysis':
              if (
                HpoCarteAppFactory.getAppFactory()
                  .getNumberTypes()
                  .indexOf(v.type) === -1
              )
                v = undefined;
              break;
          }
          return v;
        };

        scope.showDragAttributes = function() {
          return (
            scope.analysistoolsAttributes
              .map(function(x) {
                return x.value;
              })
              .indexOf(scope.analysis.analysistool) !== -1 &&
            scope.analysis.tableselected &&
            scope.analysis.tableselected.attributes &&
            scope.analysis.tableselected.attributes.length > 0
          );
        };

        scope.showSimpleSelectAttributes = function() {
          return (
            scope.analysistoolsLinesColumns
              .map(function(x) {
                return x.value;
              })
              .indexOf(scope.analysis.analysistool) !== -1 &&
            scope.analysis.analysistool === 'uniqueanalysis' &&
            scope.analysis.tableselected &&
            scope.analysis.tableselected.attributes &&
            scope.analysis.tableselected.attributes.length > 0
          );
        };

        scope.showDoublonSelectAttributes = function() {
          return (
            scope.analysistoolsLinesColumns
              .map(function(x) {
                return x.value;
              })
              .indexOf(scope.analysis.analysistool) !== -1 &&
            (scope.analysis.analysistool === 'doublonanalysis' ||
              scope.analysis.analysistool === 'emptyanalysis' ||
              scope.analysis.analysistool === 'distributionanalysis') &&
            scope.analysis.tableselected &&
            scope.analysis.tableselected.attributes &&
            scope.analysis.tableselected.attributes.length > 0
          );
        };

        scope.showCalculatorSelectAttributes = function() {
          return (
            scope.analysistoolsTables
              .map(function(x) {
                return x.value;
              })
              .indexOf(scope.analysis.analysistool) !== -1 &&
            scope.analysis.analysistool === 'calculatoranalysis' &&
            scope.analysis.tableselected &&
            scope.analysis.tableselected.attributes &&
            scope.analysis.tableselected.attributes.length > 0
          );
        };

        scope.selectAll = function() {
          scope.analysis.tableselected.attributes.map(function(x) {
            if (scope.filterDependOnTool(x)) {
              scope.analysis.attributestoselect[x.name] = true;
            }
          });
        };

        scope.renderValue = function(value, attr) {
          if (attr) {
            if (
              value &&
              HpoCarteAppFactory.getAppFactory()
                .getDateTypes()
                .indexOf(attr.type) !== -1
            )
              return HpoCarteAppFactory.getAppFactory().formatDateShow(
                new Date(value)
              );
            else if (attr.type === 'java.lang.Boolean') {
              if (angular.isDefined(value)) {
                return value;
              } else {
                return $filter('translate')('hpo.common.vnull');
              }
            } else {
              if (value !== 0 && !value) {
                if (value === '')
                  return $filter('translate')('hpo.common.emptychar');
                else return $filter('translate')('hpo.common.vnull');
              } else {
                return value;
              }
            }
          } else {
            if (value !== 0 && !value) {
              if (value === '')
                return $filter('translate')('hpo.common.emptychar');
              else return $filter('translate')('hpo.common.vnull');
            } else {
              return value;
            }
          }
        };

        scope.deselectAll = function() {
          scope.analysis.attributestoselect = {};
        };

        scope.changedAttribute = function(name) {
          if (
            name &&
            scope.analysis.attributestoselect &&
            scope.analysis.attributestoselect[name]
          ) {
            scope.analysis.operands[name] = {};
          } else if (
            name &&
            scope.analysis.attributestoselect &&
            angular.isDefined(scope.analysis.attributestoselect[name]) &&
            !scope.analysis.attributestoselect[name]
          ) {
            delete scope.analysis.operands[name];
          }
        };

        scope.onDrop = function($event, $data, array) {
          if ($data) {
            var data = angular.copy($data);
            data.operand = {};
            array.push(data);
            $data = null;
          }
        };

        scope.removeFromList = function($index) {
          scope.analysis.operands.splice($index, 1);
        };

        scope.dblClickAttr = function($data, array, type) {
          if (type === 'correction') scope.fromdrag = true;
          var data = angular.copy($data);
          data.operand = {};
          array.push(data);
          if (type === 'correction')
            setTimeout(function() {
              scope.fromdrag = false;
            }, 500);
        };

        scope.getReturnedTemplate = function(dataHpo) {
          if (dataHpo) {
            scope.analysis = dataHpo.savedata;
            if (
              scope.analysis.tableselected &&
              scope.analysis.tableselected.uid
            ) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(scope.analysis.tableselected.uid);
              if (~idx) {
                scope.analysis.tableselected = scope.ftis[idx];
                var attributesName = scope.analysis.tableselected.attributes.map(
                  function(x) {
                    return x.name;
                  }
                );
                /**
                 * Case attributes
                 */
                if (
                  scope.analysistoolsAttributesNames.indexOf(
                    scope.analysis.analysistool
                  ) !== -1 &&
                  scope.analysis.operands &&
                  scope.analysis.operands.length > 0
                ) {
                  var todeleteAttributes = [];
                  scope.analysis.operands.map(function(x, i) {
                    if (x) {
                      var idx = attributesName.indexOf(x.name);
                      if (idx !== -1)
                        scope.analysis.operands[i] = Object.assign(
                          scope.analysis.operands[i],
                          scope.analysis.tableselected.attributes[idx]
                        );
                      else {
                        todeleteAttributes.push(i);
                      }
                    }
                  });
                  if (todeleteAttributes.length > 0) {
                    for (var i = todeleteAttributes.length - 1; i >= 0; i--)
                      scope.analysis.operands.splice(todeleteAttributes[i], 1);
                    AlertHpoFactory.showAlertTemplateUpdate();
                  }
                }
                /**
                 * Case Lines & Columns
                 */
                if (
                  scope.analysistoolsLinesColumnsNames.indexOf(
                    scope.analysis.analysistool
                  ) !== -1 &&
                  scope.analysis.attributestoselect &&
                  Object.keys(scope.analysis.attributestoselect).length > 0
                ) {
                  var nodeletedelements = true;
                  for (var name in scope.analysis.attributestoselect) {
                    if (!scope.analysis.attributestoselect.hasOwnProperty(name))
                      continue;
                    if (attributesName.indexOf(name) === -1) {
                      delete scope.analysis.attributestoselect[name];
                      nodeletedelements = false;
                    }
                  }
                  if (!nodeletedelements)
                    AlertHpoFactory.showAlertTemplateUpdate();
                }
              }
            }
          }
        };

        var parsedDataCorrect = function(data) {
          var response = false;
          scope.dateattributes =
            scope.analysis.tableselected.attributes
              .map(function(x) {
                if (
                  HpoCarteAppFactory.getAppFactory()
                    .getDateTypes()
                    .indexOf(x.type) !== -1
                )
                  return x.name;
              })
              .filter(function(x) {
                if (x) return x;
              }) || [];
          scope.analysis.attributestouseindatatable =
            scope.analysis.tableselected.attributes;
          scope.analysis.supplementAttributes = undefined;
          if (scope.analysistoolsAttributesNames.indexOf(data.type) !== -1) {
            scope.analysis.geoj = data.result;
            try {
              if (
                scope.analysis.geoj &&
                scope.analysis.geoj.features &&
                scope.analysis.geoj.features.length === 0
              ) {
                try {
                  scope.$apply();
                } catch(err) {}
                $rootScope.$broadcast(
                  'reloadDatatable',
                  scope.analysis.tableselected.uid
                );
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.common.success'),
                  $filter('translate')(
                    'hpo.data.prepare.analysissuccessbutnodata'
                  ),
                  true,
                  'info'
                );
              } else {
                return true;
              }
            } catch (e) {
              console.error(e.stack);
            }
          } else if (data.type === 'calculatoranalysis') {
            scope.analysis.geoj = data.result;
            scope.analysis.supplementAttributes = [
              HpoCarteAppFactory.getAppFactory().getCalcAttribute(),
            ];
            try {
              if (
                scope.analysis.geoj &&
                scope.analysis.geoj.features &&
                scope.analysis.geoj.features.length === 0
              ) {
                try {
                  scope.$apply();
                } catch(err) {}
                $rootScope.$broadcast(
                  'reloadDatatable',
                  scope.analysis.tableselected.uid
                );
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.common.success'),
                  $filter('translate')(
                    'hpo.data.prepare.analysissuccessbutnodata'
                  ),
                  true,
                  'info'
                );
              } else {
                return true;
              }
            } catch (e) {
              console.error(e.stack);
            }
          } else if (
            data.type === 'uniqueanalysis' ||
            data.type === 'distributionanalysis'
          ) {
            scope.analysis.geoj = data.result;
            try {
              if (scope.analysis.geoj && scope.analysis.geoj.length === 0) {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.common.success'),
                  $filter('translate')(
                    'hpo.data.prepare.analysissuccessbutnodata'
                  ),
                  true,
                  'info'
                );
              } else {
                return true;
              }
            } catch (e) {
              console.error(e.stack);
            }
          } else if (
            data.type === 'doublonanalysis' ||
            data.type === 'emptyanalysis'
          ) {
            scope.analysis.geoj = data.result;
            data.attributes.map(function(x) {
              if (x.name === 'COUNTELEMENTS')
                x.alias = $filter('translate')('chart.count');
            });
            scope.analysis.attributestouseindatatable = data.attributes;
            try {
              if (
                scope.analysis.geoj &&
                scope.analysis.geoj.features &&
                scope.analysis.geoj.features.length === 0
              ) {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.common.success'),
                  $filter('translate')(
                    'hpo.data.prepare.analysissuccessbutnodata'
                  ),
                  true,
                  'info'
                );
              } else {
                // scope.tableParamsDoublon.reload();
                return true;
              }
            } catch (e) {
              console.error(e.stack);
            }
          } else if (data.type === 'fuiteanalysis') {
            scope.analysis.geoj = data.result;
            scope.analysis.attributestouseindatatable = HpoCarteAppFactory.getAppFactory().getFuiteAnalysisAttributes();
            scope.analysis.attrstotranslate = HpoCarteAppFactory.getAppFactory().HPO_DIVERS_PARAMS();
            try {
              if (
                scope.analysis.geoj &&
                scope.analysis.geoj.features &&
                scope.analysis.geoj.features.length === 0
              ) {
                try {
                  scope.$apply();
                } catch(err) {}
                $rootScope.$broadcast(
                  'reloadDatatable',
                  scope.analysis.tableselected.uid
                );
                $timeout(function() {
                  scope.datatableHeightCorrection =
                    angular
                      .element('.tableshow .fixInner .table.table-striped')
                      .height() +
                    angular
                      .element('.tableshow .fixInner [ng-table-pagination]')
                      .height() +
                    angular.element('.tableshow .fixThWrapper').height() +
                    50 +
                    'px';
                }, 500);
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('hpo.common.success'),
                  $filter('translate')(
                    'hpo.data.prepare.analysissuccessbutnodata'
                  ),
                  true,
                  'info'
                );
              } else {
                return true;
              }
            } catch (e) {
              console.error(e.stack);
            }
          }
          return response;
        };

        scope.analyseData = function() {
          if (scope.analysis) {
            var analysis = angular.copy(scope.analysis);
            analysis.adminConfig = configData;
            gaDomUtils.showGlobalLoader();
            HpoAppServices.analyseData(analysis).then(
              function(res) {
                try {
                  if (
                    res.data &&
                    res.data.status &&
                    parsedDataCorrect(res.data)
                  ) {
                    console.log('result ok', res.data);
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('hpo.common.success'),
                      $filter('translate')('hpo.data.prepare.analysissuccess'),
                      false,
                      'info'
                    );
                  } else if (res.data && !res.data.status) {
                    AlertHpoFactory.showErrorMessage(res);
                  }
                } catch (e) {
                  console.error(e.stack);
                }
                gaDomUtils.hideGlobalLoader();
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };

        scope.initJoin = function() {
          scope.joinCorrection = {
            fids: undefined,
            joincorrection: false,
          };
          scope.specialFilters = undefined;
        };
        scope.initJoin();

        scope.refreshOperands = function() {
          if (
            scope.analysis &&
            scope.analysis.operands &&
            scope.analysis.operands.length > 0
          ) {
            scope.specialFilters = {
              operands: scope.analysis.operands,
              conditionattributes: scope.analysis.interpreteattributes,
            };
            return true;
          } else {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('hpo.common.info'),
              $filter('translate')('hpo.common.noconfigtoextract'),
              true,
              'info'
            );
            return false;
          }
        };

        scope.correctObjects = function() {
          if (
            scope.analysis &&
            scope.analysis.results &&
            scope.analysis.results.length > 0
          ) {
            var data = scope.analysis.results
              .map(function(x) {
                if (x) return x.id;
              })
              .filter(function(x) {
                if (x) return x;
              });
            scope.joinCorrection = {
              fids: data.join(','),
              joincorrection: true,
            };
            if (
              scope.correctionToolsAttributesNames.indexOf(
                scope.correction.analysistool
              ) !== -1
            )
              scope.correction.analysistool = 'changevalue';
            if (scope.analysis.analysistool === 'doublonanalysis') {
              scope.correction.analysistool = 'doublons';
              scope.correction.attributestoselect =
                scope.analysis.attributestoselect;
            } else if (scope.analysis.analysistool === 'emptyanalysis') {
              scope.correction.analysistool = 'emptyline';
              scope.correction.attributestoselect =
                scope.analysis.attributestoselect;
            } else if (
              scope.analysistoolsAttributesNames.indexOf(
                scope.analysis.analysistool
              ) !== -1
            ) {
              scope.specialFilters = {
                operands: scope.analysis.operands,
                conditionattributes: scope.analysis.interpreteattributes,
              };
            }
            scope.correction.tableselected = scope.analysis.tableselected;
            if (scope.analysis.globalfilter) {
              scope.correction.globalfilter = scope.analysis.globalfilter;
              scope.correction.globalfilteroperands =
                scope.analysis.globalfilteroperands;
            }
            scope.tabs.activeTab = 1;
          }
        };

        scope.searchAttribute = function(name) {
          if (
            scope.analysis &&
            scope.analysis.tableselected &&
            scope.analysis.tableselected.attributes
          ) {
            var attributes = scope.analysis.tableselected.attributes;
            for (var i = 0; i < attributes.length; i++) {
              if (attributes[i].name === name) return attributes[i].alias;
            }
          }
          return name;
        };

        scope.searchAttributeType = function(name) {
          if (
            scope.analysis &&
            scope.analysis.tableselected &&
            scope.analysis.tableselected.attributes
          ) {
            var attributes = scope.analysis.tableselected.attributes;
            for (var i = 0; i < attributes.length; i++) {
              if (attributes[i].name === name) return attributes[i].alias;
            }
          }
          return name;
        };

        scope.hideButton = function() {
          return scope.analysis.analysistool === 'fuiteanalysis';
        };

        scope.correctionDatatableCrudHpo = {
          extraActions: [
            {
              name: $filter('translate')('hpo.data.prepare.correct'),
              class: 'btn-success',
              func: scope.correctObjects,
              disable: scope.hideButton,
            },
          ],
          remove: false,
        };

        scope.checkData = function(v) {
          var b = false;
          if (v instanceof Array) {
            if (b.length === 0) b = true;
          } else {
            if (Object.keys(v).length === 0) b = true;
          }
          return b;
        };

        scope.disableAnalyseButton = function() {
          var b = false;
          if (
            !scope.analysis.tableselected ||
            !scope.analysis.tableselected.uid
          )
            return true;

          switch (scope.analysis.analysistool) {
            case 'allanalysis':
            case 'dataanalysis':
            case 'numberanalysis':
            case 'stringanalysis':
              if (
                !scope.analysis.operands ||
                scope.analysis.operands.length === 0
              )
                return true;
              break;
            case 'uniqueanalysis':
            case 'distributionanalysis':
            case 'doublonanalysis':
            case 'emptyanalysis':
              if (
                !scope.analysis.attributestoselect ||
                Object.keys(scope.analysis.attributestoselect).length === 0
              )
                return true;
              break;
            case 'calculatoranalysis':
              if (!scope.analysis.expression) return true;
              break;
          }
          return b;
        };

        scope.addfilter = function(analysis) {
          var newScope = $rootScope.$new();
          newScope.hpo = angular.copy(analysis);
          if (
            newScope.hpo.globalfilter &&
            newScope.hpo.globalfilteroperands &&
            newScope.hpo.globalfilteroperands.length > 0
          ) {
            newScope.hpo.clauseWhere = newScope.hpo.globalfilter;
            newScope.hpo.operands = newScope.hpo.globalfilteroperands;
          }
          var dialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/hpoapp/home_admin_data/views/dialog/add_global_filter.html',
            className:
              'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
            closeByDocument: false,
            scope: newScope,
          });
          dialog.then(function(data) {
            if (data && data.clauseWhere && data.operands) {
              analysis.globalfilter = data.clauseWhere;
              analysis.globalfilteroperands = data.operands;
              if (!scope.lastWhere.hasOwnProperty(analysis.tableselected.uid))
                scope.lastWhere[analysis.tableselected.uid] = {};
              scope.lastWhere[analysis.tableselected.uid].filter =
                analysis.globalfilter;
              scope.lastWhere[analysis.tableselected.uid].operands =
                analysis.globalfilteroperands;
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')('hpo.common.success'),
                $filter('translate')('hpo.data.validation.getsuccess'),
                false
              );
            }
          });
        };

        scope.lastWhere = {};
        scope.getlastfilter = function(analysis) {
          analysis.globalfilter =
            scope.lastWhere[analysis.tableselected.uid].filter;
          analysis.globalfilteroperands =
            scope.lastWhere[analysis.tableselected.uid].operands;
          AlertHpoFactory.getSimpleSuccess(
            $filter('translate')('hpo.common.success'),
            $filter('translate')('hpo.data.validation.getsuccess'),
            false
          );
        };

        scope.evaluatelastFitler = function(analysis) {
          if (
            !analysis ||
            !analysis.tableselected ||
            !scope.lastWhere.hasOwnProperty(analysis.tableselected.uid) ||
            scope.lastWhere[analysis.tableselected.uid].filter ===
              analysis.globalfilter
          )
            return true;
          else {
            return false;
          }
        };
        scope.removeFilter = function(analysis) {
          analysis.globalfilter = '1=1';
          analysis.globalfilteroperands = [];
          AlertHpoFactory.getSimpleSuccess(
            $filter('translate')('hpo.common.success'),
            $filter('translate')('hpo.data.validation.removesuccess'),
            false
          );
        };

        /**
         * exportCsv if scope.exportCsv
         */
        scope.exportCsvFile = function(result) {
          if (!result.result.length) return;

          var toExport = [];
          var headers = [];
          // push headers
          switch (scope.analysis.analysistool) {
            case 'uniqueanalysis':
              headers = [$filter('translate')('common.value')];
              break;
            case 'distributionanalysis':
              headers = [
                $filter('translate')('common.value'),
                $filter('translate')('chart.count'),
                $filter('translate')('chart.percentage'),
              ];
              break;
          }
          toExport.push(headers);

          // push values
          result.result.forEach(function(d) {
            var tmpObj = [];
            switch (scope.analysis.analysistool) {
              case 'uniqueanalysis':
                tmpObj = [scope.renderValue(d, result.attribute)];
                toExport.push(tmpObj);
                break;
              case 'distributionanalysis':
                tmpObj = [
                  scope.renderValue(d.value, result.attribute),
                  d.count,
                  d.percentage,
                ];
                toExport.push(tmpObj);
                break;
            }
          });
          return toExport;
        };

        scope.configuser = { columnDelimiter: ';' };
        ParametersFactory.getbytype(scope.configNameGlobal).then(
          function(res) {
            if (res.data && res.data.length > 0) {
              scope.configuser = res.data[0].data;
              scope.id = res.data[0].id;
            }
          },
          function(data) {
            console.log(scope.config);
          }
        );

        scope.saveConfig = function(configuser) {
          scope.configuser = configuser;
          ParametersFactory.getbytype(scope.configNameGlobal).then(function(
            res
          ) {
            var nameSaved = res.data.map(function(x) {
              return x.id;
            });
            if (
              scope.configuser &&
              scope.id &&
              nameSaved.indexOf(scope.id) !== -1
            ) {
              var idx = res.data
                .map(function(x) {
                  return x.id;
                })
                .indexOf(scope.id);
              var id = res.data[idx].id;
              res.data[idx].data = scope.configuser;
              ParametersFactory.update(res.data[idx], id).then(
                function(res) {
                  if (res.data && res.data.data > 0) {
                    scope.configuser = res.data.data;
                    scope.id = res.data.data;
                  }
                  require('toastr').success(
                    $filter('translate')('elastic.search.save_ok')
                  );
                },
                function() {
                  require('toastr').error(
                    $filter('translate')('elastic.search.save_nok')
                  );
                }
              );
            } else {
              ParametersFactory.add(
                scope.configuser,
                scope.configNameGlobal,
                scope.configNameGlobal
              ).then(
                function(res) {
                  if (res.data && res.data.data > 0) {
                    scope.configuser = res.data.data;
                    scope.id = res.data.data;
                  }
                  require('toastr').success(
                    $filter('translate')('elastic.search.save_ok')
                  );
                },
                function() {
                  require('toastr').error(
                    $filter('translate')('elastic.search.save_nok')
                  );
                }
              );
            }
          });
        };

        var exportcsvdialog;
        scope.showConfigSparator = function() {
          exportcsvdialog = ngDialog.openConfirm({
            template:
              'js/XG/widgets/utilities/data/views/cfg/csvFormatPrompt.html',
            className: 'ngdialog-theme-plain nopadding miniclose',
            scope: scope,
            showClose: true,
          });
          exportcsvdialog.then(function(data) {
            scope.configuser.columnDelimiter = data;
            scope.saveConfig(scope.configuser);
          });
        };
      },
    };
  };

  preparationAnalysisDataHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppServices',
    'InitProvider',
  ];
  return preparationAnalysisDataHpo;
});
