'use strict';
define(function() {
  var preparationCorrectionDataHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppServices,
    InitProvider,
    UnitFactory,
    CalculFactory,
    authFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/preparation_correction_data_hpo.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.configureName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoPreparationDataCorrectionConfig';

        scope.description = $filter('translate')(
          'hpo.data.prepare.correctiontools.columntosplitorjoindescription'
        );
        scope.fixedTypes = [
          {
            id: 'java.lang.String',
            label: 'java.lang.String',
          },
        ];

        scope.correctionToolsAttributes = HpoCarteAppFactory.getAppFactory().getCorrectionToolsAttributes();
        scope.correctionToolsValues = HpoCarteAppFactory.getAppFactory().getCorrectionToolsValues();
        scope.correctionToolsDoublon = HpoCarteAppFactory.getAppFactory().getCorrectionToolsDoublon();
        scope.correctionToolsGeneral = HpoCarteAppFactory.getAppFactory().getCorrectionToolsGeneral();
        // scope.correctionToolsFuites = HpoCarteAppFactory.getAppFactory().getCorrectionToolsFuites();

        scope.correctionToolsAttributesNames = HpoCarteAppFactory.getAppFactory()
          .getCorrectionToolsAttributes()
          .map(function(x) {
            return x.value;
          });
        scope.correctionToolsValuesNames = HpoCarteAppFactory.getAppFactory()
          .getCorrectionToolsValues()
          .map(function(x) {
            return x.value;
          });
        scope.correctionToolsDoublonNames = HpoCarteAppFactory.getAppFactory()
          .getCorrectionToolsDoublon()
          .map(function(x) {
            return x.value;
          });
        scope.correctionToolsGeneralNames = HpoCarteAppFactory.getAppFactory()
          .getCorrectionToolsGeneral()
          .map(function(x) {
            return x.value;
          });
        // scope.correctionToolsFuitesNames = HpoCarteAppFactory.getAppFactory().getCorrectionToolsFuites().map(function(x){ return x.value; });

        scope.isAuthorisedToAddAttribute = HpoCarteAppFactory.getAppFactory().isAuthorisedToAddAttribute;
        scope.isAuthorisedToDeleteAttribute = HpoCarteAppFactory.getAppFactory().isAuthorisedToDeleteAttribute;

        scope.saveTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.templates.html';
        scope.getTemplateHtml =
          'js/XG/widgets/hpoapp/main/views/templates/data/hpo.data.prepare.gettemplates.html';

        scope.generateAutoComment = function() {
          if (
            scope.correction.analysistool &&
            scope.correction.tableselected &&
            scope.correction.tableselected.alias
          )
            scope.correction.commentaire =
              $filter('translate')(
                'hpo.data.prepare.correctiontools.' +
                  scope.correction.analysistool
              ) +
              ' ' +
              scope.correction.tableselected.alias;
        };

        scope.emptyCorrectionTools = function(btn) {
          if (btn) {
            var callback = function(isconfirm) {
              if (isconfirm) {
                scope.correction = {
                  analysistool: 'retypage',
                  tableselected: {},
                  result: [],
                  geoj: {},
                  operands: [],
                  attributestoselect: {},
                  expression: '',
                  specialcorrectiontype: 'jointure',
                  interpreteattributes: 'and',
                  interpreteconditions: 'and',
                  selectedall: false,
                  attributestouseindatatable: [],
                  attributestoadd: [],
                  supplementAttributes: null,
                  newattributeName: null,
                  commentaire: null,
                };
                if (scope.joinCorrection && scope.joinCorrection.joincorrection)
                  scope.correction.analysistool = 'changevalue';
                try {
                  scope.$apply();
                } catch(err) {}
              }
            };
            var message =
              $filter('translate')('hpo.data.prepare.emptyanalyse') +
              '. ' +
              $filter('translate')('hpo.common.sur');
            AlertHpoFactory.alertConfirmCallback(
              $filter('translate')('hpo.common.warning'),
              message,
              'warning',
              true,
              undefined,
              '#F50072',
              true,
              undefined,
              undefined,
              true,
              true,
              callback
            );
          } else {
            scope.correction = {
              analysistool: 'retypage',
              tableselected: {},
              result: [],
              geoj: {},
              correction: [],
              operands: [],
              attributestoselect: {},
              expression: '',
              interpreteattributes: 'and',
              interpreteconditions: 'and',
              selectedall: false,
              attributestouseindatatable: [],
              attributestoadd: [],
              specialcorrectiontype: 'jointure',
              supplementAttributes: null,
              newattributeName: null,
              commentaire: null,
            };
          }
        };
        scope.emptyCorrectionTools();
        scope.changedCorrectionToolOrFti = function() {
          scope.correction.operands = [];
          scope.correction.attributestoselect = {};
          scope.correction.attributestouseindatatable = {};
          scope.correction.result = [];
          scope.correction.geoj = {};
          scope.correction.expression = '';
          scope.correction.selectedall = false;
          scope.correction.supplementAttributes = null;
          scope.correction.attributestoadd = [];
          scope.correction.specialcorrectiontype = 'jointure';
          scope.correction.newattributeName = null;
          if (
            scope.correction.analysistool === 'fuiteanalysis' &&
            scope.correction.tableselected &&
            [
              HpoCarteAppFactory.getAppFactory().HPO_CANA_DEFAILLANCE(),
              HpoCarteAppFactory.getAppFactory().HPO_BRANCHEMENT_DEFAILLANCE(),
            ].indexOf(scope.correction.tableselected.name) === -1
          )
            scope.correction.tableselected = {};
          if (
            scope.correction.tableselected &&
            Object.keys(scope.correction.tableselected).length > 0
          ) {
            scope.attributesAuthorized = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
              scope.correction.tableselected
            );
            scope.attributesAuthorizedNames = scope.attributesAuthorized.map(
              function(x) {
                return x.name;
              }
            );
            scope.attributesAuthorizedWrite = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
              scope.correction.tableselected,
              'w'
            );
            scope.attributesAuthorizedWriteNames = scope.attributesAuthorizedWrite.map(
              function(x) {
                return x.name;
              }
            );
          }
        };

        scope.hideResultShowed = function() {
          scope.geoj = {};
          scope.showFtiResult = null;
        };

        scope.correctionAnalysisDatatableCrudHpo = {
          extraActions: [
            {
              name: $filter('translate')('hpo.common.hide'),
              class: 'btn-default',
              func: scope.hideResultShowed,
            },
          ],
          remove: false,
        };

        scope.getReturnedTemplateCorrection = function(dataHpo) {
          if (dataHpo) {
            scope.correction = dataHpo.savedata;
            if (
              scope.correction.tableselected &&
              scope.correction.tableselected.uid
            ) {
              var idx = scope.ftis
                .map(function(x) {
                  return x.uid;
                })
                .indexOf(scope.correction.tableselected.uid);
              if (~idx) {
                scope.correction.tableselected = scope.ftis[idx];
                var attributesName = scope.correction.tableselected.attributes.map(
                  function(x) {
                    return x.name;
                  }
                );
                var changed = false;
                switch (scope.correction.analysistool) {
                  case 'retypage':
                  case 'changevaluereal':
                  case 'changevalue':
                    if (
                      scope.correction.operands &&
                      scope.correction.operands.length > 0
                    ) {
                      var todeleteAttributes = [];
                      scope.correction.operands.map(function(x, i) {
                        if (x) {
                          var idx = attributesName.indexOf(x.name);
                          if (idx !== -1)
                            scope.correction.operands[i] = Object.assign(
                              scope.correction.operands[i],
                              scope.correction.tableselected.attributes[idx]
                            );
                          else {
                            todeleteAttributes.push(i);
                          }
                        }
                      });
                      if (todeleteAttributes.length > 0) {
                        todeleteAttributes.reverse();
                        todeleteAttributes.map(function(x) {
                          scope.correction.operands.splice(x, 1);
                        });
                        changed = true;
                      }
                    }
                    break;
                  case 'createorremove':
                  case 'jointrim':
                  case 'trim':
                  case 'doublons':
                  case 'emptyline':
                    if (
                      scope.correction.attributestoselect &&
                      Object.keys(scope.correction.attributestoselect).length >
                        0
                    ) {
                      for (var key in scope.correction.attributestoselect) {
                        if (
                          key &&
                          scope.correction.attributestoselect.hasOwnProperty(
                            key
                          ) &&
                          scope.correction.attributestoselect[key] &&
                          attributesName.indexOf(key) === -1
                        ) {
                          delete scope.correction.attributestoselect[key];
                          changed = true;
                        }
                      }
                    }
                    break;
                  case 'diversreplace':
                    if (
                      scope.correction.attributestoselect &&
                      Object.keys(scope.correction.attributestoselect).length >
                        0 &&
                      scope.correction.attributestoselect.name
                    ) {
                      var idx = scope.correction.tableselected.attributes
                        .map(function(x) {
                          return x.name;
                        })
                        .indexOf(scope.correction.attributestoselect.name);
                      if (~idx)
                        scope.correction.attributestoselect =
                          scope.correction.tableselected.attributes[idx];
                    }
                    break;
                }
                if (
                  !scope.lastWhere.hasOwnProperty(
                    scope.correction.tableselected.uid
                  )
                )
                  scope.lastWhere[scope.correction.tableselected.uid] = {};
                scope.lastWhere[scope.correction.tableselected.uid].filter =
                  scope.correction.globalfilter;
                scope.lastWhere[scope.correction.tableselected.uid].operands =
                  scope.correction.globalfilteroperands;
                if (changed) AlertHpoFactory.showAlertTemplateUpdate();
              }
            }
          }
        };

        scope.filterFuiteCorrectionOnly = function(v) {
          switch (scope.correction.analysistool) {
            case 'fuite':
              if (
                v.name.indexOf(
                  HpoCarteAppFactory.getAppFactory().getFuitePrefix()
                ) === -1
              )
                v = undefined;
              break;
          }
          return v;
        };

        scope.selectAllCorrection = function() {
          scope.correction.tableselected.attributes.map(function(x) {
            if (scope.filterDependOnToolcorrection(x)) {
              scope.correction.attributestoselect[x.name] = true;
            }
          });
        };

        scope.deselectAllCorrection = function() {
          scope.correction.attributestoselect = {};
        };

        scope.filterDependOnToolcorrection = function(v) {
          switch (scope.correction.analysistool) {
            case 'dataanalysis':
              if (
                HpoCarteAppFactory.getAppFactory()
                  .getDateTypes()
                  .indexOf(v.type) === -1
              )
                v = undefined;
              break;
            case 'numberanalysis':
            case 'calculatoranalysis':
              if (
                HpoCarteAppFactory.getAppFactory()
                  .getNumberTypes()
                  .indexOf(v.type) === -1
              )
                v = undefined;
              break;
            case 'changevaluereal':
              if (
                HpoCarteAppFactory.getAppFactory()
                  .getRealTypes()
                  .indexOf(v.type) === -1
              )
                v = undefined;
              break;
          }
          return v;
        };

        scope.showAttributesToCorrectDrag = function() {
          return (
            (scope.correction.analysistool === 'retypage' ||
              scope.correction.analysistool === 'changevalue' ||
              scope.correction.analysistool === 'changevaluereal') &&
            scope.correction.tableselected &&
            scope.correction.tableselected.attributes &&
            scope.correction.tableselected.attributes.length > 0
          );
        };

        scope.showAttributesToCorrectJointureSperation = function() {
          return (
            scope.correctionToolsAttributes
              .map(function(x) {
                return x.value;
              })
              .indexOf(scope.correction.analysistool) !== -1 &&
            scope.correction.analysistool === 'jointrim' &&
            scope.correction.tableselected &&
            scope.correction.tableselected.attributes &&
            scope.correction.tableselected.attributes.length > 0
          );
        };

        scope.showAttributesToCorrectAddRemove = function() {
          return (
            scope.correctionToolsAttributes
              .map(function(x) {
                return x.value;
              })
              .indexOf(scope.correction.analysistool) !== -1 &&
            scope.correction.analysistool === 'createorremove' &&
            scope.correction.tableselected &&
            scope.correction.tableselected.attributes &&
            scope.correction.tableselected.attributes.length > 0
          );
        };

        scope.showAttributesToTrim = function() {
          return (
            (scope.correction.analysistool === 'trim' ||
              scope.correction.analysistool === 'doublons' ||
              scope.correction.analysistool === 'emptyline') &&
            scope.correction.tableselected &&
            scope.correction.tableselected.attributes &&
            scope.correction.tableselected.attributes.length > 0
          );
        };

        scope.showAttributesToDiversReplace = function() {
          return (
            scope.correction.analysistool === 'diversreplace' &&
            scope.correction.tableselected &&
            scope.correction.tableselected.attributes &&
            scope.correction.tableselected.attributes.length > 0
          );
        };

        scope.showAttributesToDiversRemove = function() {
          return (
            scope.correction.analysistool === 'diversremove' &&
            scope.correction.tableselected &&
            scope.correction.tableselected.attributes &&
            scope.correction.tableselected.attributes.length > 0
          );
        };

        scope.fromdrag = false;
        scope.onDropCorrection = function($event, $data, array) {
          if ($data) {
            var data = angular.copy($data);
            data.operand = {};
            array.push(data);
            $data = null;
            scope.fromdrag = true;
          }
        };
        scope.dragEnded = function() {
          scope.fromdrag = false;
        };

        scope.disbaleCheckBox = function(att) {
          var elements = [];
          for (var i in scope.correction.attributestoselect) {
            if (scope.correction.attributestoselect[i]) elements.push(i);
          }

          return (
            (scope.correction.specialcorrectiontype === 'jointure' &&
              !scope.correction.attributestoselect[att.name] &&
              elements.length === 2) ||
            (scope.correction.specialcorrectiontype === 'separation' &&
              !scope.correction.attributestoselect[att.name] &&
              elements.length === 1)
          );
        };

        scope.removeFromListCorrection = function($index) {
          var callback = function(isconfirm) {
            if (isconfirm) {
              scope.correction.operands.splice($index, 1);
              try {
                scope.$apply();
              } catch(err) {}
            }
          };
          var message = $filter('translate')(
            'hpo.data.prepare.correctiontools.removethiscorrection'
          );
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            message,
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        scope.initApplicationInformations = function() {
          HpoCarteAppFactory.getInitProvider()
            .initialiseApplication()
            .then(
              function() {
                scope.reinitialiseThisWidget();
                scope.emptyCorrectionTools();
                $rootScope.$broadcast(
                  'reloadDatatable',
                  scope.historique.selectedfti.uid
                );
              },
              function() {
                console.error('unable to reinitialise application parameter');
              }
            );
        };

        scope.specialFunc = function(attr) {
          if (
            scope.correction.analysistool !== 'changevalue' &&
            scope.correction.analysistool !== 'changevaluereal'
          )
            return true;

          return !~scope.correction.operands
            .map(function(x) {
              if (x) return x.name;
            })
            .indexOf(attr.name);
        };

        var parsedCorrectionCorrect = function(data) {
          var response = true;
          scope.dateattributes =
            scope.correction.tableselected.attributes
              .map(function(x) {
                if (
                  HpoCarteAppFactory.getAppFactory()
                    .getDateTypes()
                    .indexOf(x.type) !== -1
                )
                  return x.name;
              })
              .filter(function(x) {
                if (x) return x;
              }) || [];
          scope.correction.attributestouseindatatable =
            scope.correction.tableselected.attributes;
          scope.correction.supplementAttributes = undefined;
          scope.geoj = data.result;
          switch (data.type) {
            case 'retypage':
              message =
                $filter('translate')(
                  'hpo.data.prepare.correctiontools.correctsuccess.' +
                    data.type +
                    '1'
                ) +
                data.result.join(', ') +
                $filter('translate')(
                  'hpo.data.prepare.correctiontools.correctsuccess.' +
                    data.type +
                    '2'
                );
              break;
            case 'createorremove':
              message =
                (data.result.added
                  ? data.result.added
                      .map(function(x) {
                        return x.alias;
                      })
                      .join(', ') +
                    $filter('translate')(
                      'hpo.data.prepare.correctiontools.correctsuccess.create'
                    )
                  : '') +
                (data.result.removed
                  ? data.result.removed
                      .map(function(x) {
                        return x.alias;
                      })
                      .join(', ') +
                    $filter('translate')(
                      'hpo.data.prepare.correctiontools.correctsuccess.remove'
                    )
                  : '');
              break;
            case 'jointrim':
            case 'diversreplace':
            case 'diversremove':
              scope.showFtiResult = data.fti;
              message = $filter('translate')(
                'hpo.data.prepare.correctiontools.correctsuccess.general'
              );
              $rootScope.$broadcast('reloadDatatable', scope.showFtiResult.uid);
              break;
            case 'trim':
            case 'changevalue':
            case 'changevaluereal':
              scope.showFtiResult = data.fti;
              message = $filter('translate')(
                'hpo.data.prepare.correctiontools.correctsuccess.general'
              );
              $rootScope.$broadcast('reloadDatatable', scope.showFtiResult.uid);
              break;
            case 'doublons':
            case 'emptyline':
              message = $filter('translate')(
                'hpo.data.prepare.correctiontools.correctsuccess.general'
              );
              break;
          }
          var callback = function(res) {
            AlertHpoFactory.getSimpleSuccess(
              $filter('translate')('hpo.data.prepare.correctiontools.succes'),
              message,
              true
            );
            scope.initApplicationInformations();
          };
          if (data.type === 'createorremove' || data.type === 'jointrim') {
            authFactory.getcurrentuser().then(callback, callback);
          } else {
            callback();
          }
          return response;
        };

        var runCorrection = function() {
          gaDomUtils.showGlobalLoader();
          if (scope.joinCorrection && scope.joinCorrection.joincorrection)
            scope.correction.joinCorrection = scope.joinCorrection;
          else {
            delete scope.correction.joinCorrection;
          }
          HpoAppServices.correctData(scope.correction).then(
            function(res) {
              try {
                if (
                  res.data &&
                  res.data.status &&
                  parsedCorrectionCorrect(res.data)
                ) {
                  if (
                    scope.joinCorrection &&
                    scope.joinCorrection.joincorrection
                  ) {
                    scope.initJoin();
                    delete scope.correction.joinCorrection;
                  }
                } else {
                  AlertHpoFactory.showErrorMessage(res);
                }
              } catch (e) {
                console.error(e.stack);
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              gaDomUtils.hideGlobalLoader();
              AlertHpoFactory.showErrorMessage(res);
            }
          );
        };

        var message;
        scope.correctData = function() {
          if (scope.correction) {
            if (scope.correction.commentaire) {
              runCorrection();
            } else {
              var callback = function(isconfirm) {
                if (isconfirm) {
                  runCorrection();
                }
              };
              var message = $filter('translate')(
                'hpo.data.prepare.correctiontools.commentairenotadded'
              );
              AlertHpoFactory.alertConfirmCallback(
                $filter('translate')('hpo.common.warning'),
                message,
                'warning',
                true,
                undefined,
                '#F50072',
                true,
                undefined,
                undefined,
                true,
                true,
                callback
              );
            }
          }
        };

        scope.isString = function(att) {
          return (
            HpoCarteAppFactory.getAppFactory()
              .getStringTypes()
              .indexOf(att.type) !== -1
          );
        };

        scope.disableCorrectionButton = function() {
          var b = false;
          if (
            !scope.correction.tableselected ||
            !scope.correction.tableselected.uid
          )
            return true;

          switch (scope.correction.analysistool) {
            case 'retypage':
            case 'changevalue':
            case 'changevaluereal':
              if (
                !scope.correction.operands ||
                scope.correction.operands.length === 0
              )
                return true;
              break;
            case 'trim':
            case 'doublons':
            case 'emptyline':
              if (
                !scope.correction.attributestoselect ||
                Object.keys(scope.correction.attributestoselect).length === 0
              )
                return true;
              break;
            case 'createorremove':
            case 'jointrim':
              if (scope.correction.attributestoselect) {
                var truevalues = [];
                for (var key in scope.correction.attributestoselect) {
                  if (
                    scope.correction.attributestoselect.hasOwnProperty(key) &&
                    scope.correction.attributestoselect[key]
                  ) {
                    truevalues.push(key);
                  }
                }
              }
              if (
                (!scope.correction.attributestoadd ||
                  scope.correction.attributestoadd.length === 0) &&
                (!scope.correction.attributestoselect ||
                  (truevalues && truevalues.length === 0))
              )
                return true;
              break;
            case 'diversreplace':
              if (
                !scope.correction.attributestoselect ||
                Object.keys(scope.correction.attributestoselect).length === 0
              )
                return true;
              if (!scope.correction.expression) return true;
              break;
          }
          return b;
        };

        scope.getAttributesFromAnalysis = function() {
          if (scope.refreshOperands()) {
            scope.correction.operands = [];
            scope.specialFilters.operands.map(function(x) {
              if (
                scope.correction.operands
                  .map(function(x) {
                    return x.name;
                  })
                  .indexOf(x.name) === -1
              )
                scope.correction.operands.push(angular.copy(x));
            });
            scope.usespecialfilters = angular.copy(scope.specialFilters);
            if (scope.correction.operands.length > 0) {
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')('hpo.common.warning'),
                $filter('translate')('hpo.common.configurerules'),
                true,
                'info'
              );
              scope.clign = true;
            }
          }
        };
      },
    };
  };

  preparationCorrectionDataHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppServices',
    'InitProvider',
    'UnitFactory',
    'CalculFactory',
    'authFactory',
  ];
  return preparationCorrectionDataHpo;
});
