'use strict';
define(function() {
  var selectAttributesHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    UnitFactory,
    CalculFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/data/select_attributes_hpo.html',
      restrict: 'EA',
      scope: {
        analysis: '=',
        res: '=?',
        unique: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.filterFunc = HpoCarteAppFactory.getAppFactory().filterFunc;

        scope.attributesAuthorised = [];
        if (scope.analysis && scope.analysis.tableselected)
          scope.attributesAuthorised = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
            scope.analysis.tableselected
          );

        scope.$watch('analysis.tableselected', function(newval) {
          if (newval) {
            scope.attributesAuthorised = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
              newval
            );
          }
        });

        scope.selectAll = function() {
          scope.analysis.tableselected.attributes.map(function(x) {
            if (scope.filterDependOnTool(x)) {
              scope.analysis.attributestoselect[x.name] = true;
            }
          });
        };

        scope.deselectAll = function() {
          scope.analysis.attributestoselect = {};
        };

        scope.filterDependOnTool = function(v) {
          switch (scope.analysis.analysistool) {
            case 'stringanalysis':
              if (
                HpoCarteAppFactory.getAppFactory()
                  .getStringTypes()
                  .indexOf(v.type) === -1
              )
                v = undefined;
              break;
            case 'dataanalysis':
              if (
                HpoCarteAppFactory.getAppFactory()
                  .getDateTypes()
                  .indexOf(v.type) === -1
              )
                v = undefined;
              break;
            case 'numberanalysis':
            case 'calculatoranalysis':
              if (
                HpoCarteAppFactory.getAppFactory()
                  .getNumberTypes()
                  .indexOf(v.type) === -1
              )
                v = undefined;
              break;
          }
          return v;
        };

        scope.onDrop = function($event, $data, array) {
          if ($data) {
            var data = angular.copy($data);
            data.operand = {};
            array.push(data);
            $data = null;
          }
        };

        scope.removeFromList = function($index) {
          var callback = function(isconfirm) {
            if (isconfirm) {
              scope.analysis.operands.splice($index, 1);
              try {
                scope.$apply();
              } catch(err) {}
            }
          };
          var message = $filter('translate')(
            'hpo.data.prepare.correctiontools.removethiscorrection'
          );
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            message,
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };
      },
    };
  };

  selectAttributesHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'UnitFactory',
    'CalculFactory',
  ];
  return selectAttributesHpo;
});
