'use strict';
define(function() {
  var AlertHpoFactory = function($timeout, $filter) {
    /**
     *
     * @param {String} title
     * @param {String} msg
     * @param {String / info,warning,success,question,error} type
     * @param {boolean} okbutton
     * @param {String} okbuttontext
     * @param {HexColor/RGB} okbuttoncolor
     * @param {boolean} cancelbutton
     * @param {String} cancelbuttontext
     * @param {HexColor/rgb} cancelbuttoncolor
     * @param {boolean} closeOnconfirm
     * @param {boolean} closeOnConfirm
     * @param {callback} callback
     */
    var alertConfirmCallback = function(
      title,
      msg,
      type,
      okbutton,
      okbuttontext,
      okbuttoncolor,
      cancelbutton,
      cancelbuttontext,
      cancelbuttoncolor,
      closeOnconfirm,
      closeOnCancel,
      callback
    ) {
      swal(
        {
          title: title,
          text: msg,
          type: type,
          showCancelButton: cancelbutton,
          confirmButtonColor: okbuttoncolor,
          confirmButtonText: okbuttontext
            ? okbuttontext
            : $filter('translate')('common.yes'),
          cancelButtonText: okbuttontext
            ? okbuttontext
            : $filter('translate')('common.no'),
          closeOnConfirm: closeOnconfirm,
          closeOnCancel: closeOnCancel,
        },
        callback
      );
    };

    /**
     *
     * @param {String} confirmCallbackTitle
     * @param {String} confirmCallbackText
     */
    var getSimpleSuccess = function(
      confirmCallbackTitle,
      confirmCallbackText,
      confirm,
      type
    ) {
      $timeout(function() {
        if (confirm)
          swal({
            title: confirmCallbackTitle,
            text: confirmCallbackText,
            type: !type ? 'success' : type,
            confirmButtonColor: '#F50072',
            showConfirmButton: confirm,
          });
        else
          swal({
            title: confirmCallbackTitle,
            text: confirmCallbackText,
            type: 'success',
            showConfirmButton: false,
            buttons: false,
            timer: 1000,
          });
      }, 500);
    };

    /**
     *
     * @param {String} failTitle
     * @param {String} failFullText
     */
    var getSimpleFail = function(failTitle, failFullText, confirm) {
      $timeout(function() {
        let failShortText;
        if (!failFullText) {
          failShortText = '';
        }
        else {
          failShortText
            = failFullText.length > 500 ? failFullText.substring(0, 499) + "..." : failFullText;
        }
        if (confirm) {
          swal({
            title: failTitle,
            text: failShortText,
            type: 'error',
            showConfirmButton: true,
            showCancelButton: true,
            confirmButtonText: $filter('translate')('hpo.alert.copy_error_message'),
            cancelButtonText: $filter('translate')('common.ok')
          }, () => {
            navigator.clipboard.writeText(failFullText).then(function() {
              require('toastr').success($filter('translate')('hpo.alert.error_message_copied'));
            }, function() {
              /* échec de l’écriture dans le presse-papiers */
              require('toastr').error($filter('translate')('hpo.alert.error_message_not_copied'));
            });
          });
        } else {
          swal({
            title: failTitle,
            text: failShortText,
            type: 'error',
            showConfirmButton: false,
            buttons: false,
            timer: 1000,
          });
        }
      }, 500);
    };

    /**
     *
     * @param {boolean} isSuccess
     * @param {String} confirmCallbackTitle
     * @param {String} confirmCallbackText
     * @param {String} failCallbacktitle
     * @param {String} failCallbackText
     */
    var getSimpleSuccessOrFail = function(
      isSuccess,
      confirmCallbackTitle,
      confirmCallbackText,
      failCallbacktitle,
      failCallbackText
    ) {
      $timeout(function() {
        if (isSuccess){
          getSimpleSuccess(confirmCallbackTitle, confirmCallbackText, false);
        } else {
          getSimpleFail(failCallbacktitle, failCallbackText, false);
        }
      }, 500);
    };

    var showErrorMessage = function(res) {
      try {
        if (
          res &&
          res.data &&
          res.data.message &&
          res.data.details &&
          res.data.code === 500
        )
          getSimpleFail(
            $filter('translate')(res.data.message),
            res.data.details[0],
            true
          );
        else if (res && res.statusText && res.data && res.data.message)
          getSimpleFail(res.statusText, res.data.message, true);
        else if (res && res.data && res.data.message)
          getSimpleFail(
            $filter('translate')('hpo.alert.fail'),
            res.data.message,
            true
          );
        else if (res && res.data && !res.data.message)
          getSimpleFail($filter('translate')('hpo.alert.fail'), res.data, true);
        else if (res && res.data && res.statusText && res.status)
          getSimpleFail(res.statusText, undefined, true);
        else if (res && res.message && res.stack)
          getSimpleFail(res.message, res.stack.split('\n')[0], true);
        else {
          getSimpleFail(
            $filter('translate')('hpo.alert.fail'),
            $filter('translate')('hpo.alert.internalfail'),
            true
          );
        }
      } catch (e) {
        if (res && res.data && res.statusText && res.status)
          getSimpleFail(res.statusText, undefined, true);
      }
      console.error(res);
    };

    var showAlertTemplateUpdate = function() {
      getSimpleSuccess(
        $filter('translate')('hpo.common.warning'),
        $filter('translate')('hpo.data.exchange.importtemplate'),
        true,
        'warning'
      );
    };

    var successAdd = function() {
      getSimpleSuccess(
        $filter('translate')('hpo.alert.succes'),
        $filter('translate')('hpo.alert.add'),
        false
      );
    };

    var failAdd = function() {
      getSimpleSuccess(
        $filter('translate')('hpo.alert.fail'),
        $filter('translate')('hpo.alert.addFail'),
        true,
        'error'
      );
    };

    var successUpdate = function() {
      getSimpleSuccess(
        $filter('translate')('hpo.alert.succes'),
        $filter('translate')('hpo.alert.update'),
        false
      );
    };

    var failUpdate = function() {
      getSimpleSuccess(
        $filter('translate')('hpo.alert.fail'),
        $filter('translate')('hpo.alert.updateFail'),
        true,
        'error'
      );
    };

    var successSave = function() {
      getSimpleSuccess(
        $filter('translate')('hpo.alert.succes'),
        $filter('translate')('hpo.alert.saves'),
        false
      );
    };

    var failSave = function() {
      getSimpleSuccess(
        $filter('translate')('hpo.alert.fail'),
        $filter('translate')('hpo.alert.savesFail'),
        true,
        'error'
      );
    };

    var successDelete = function() {
      getSimpleSuccess(
        $filter('translate')('hpo.alert.succes'),
        $filter('translate')('hpo.alert.delete'),
        false
      );
    };

    var failDelete = function() {
      getSimpleSuccess(
        $filter('translate')('hpo.alert.fail'),
        $filter('translate')('hpo.alert.deleteFail'),
        true,
        'error'
      );
    };

    var successGet = function() {
      getSimpleSuccess(
        $filter('translate')('hpo.alert.succes'),
        $filter('translate')('hpo.alert.get'),
        false
      );
    };

    var failGet = function() {
      getSimpleSuccess(
        $filter('translate')('hpo.alert.fail'),
        $filter('translate')('hpo.alert.getFail'),
        true,
        'error'
      );
    };

    return {
      alertConfirmCallback: alertConfirmCallback,
      getSimpleSuccessOrFail: getSimpleSuccessOrFail,
      getSimpleFail: getSimpleFail,
      getSimpleSuccess: getSimpleSuccess,
      showErrorMessage: showErrorMessage,
      showAlertTemplateUpdate: showAlertTemplateUpdate,
      successAdd: successAdd,
      failAdd: failAdd,
      successUpdate: successUpdate,
      failUpdate: failUpdate,
      successSave: successSave,
      failSave: failSave,
      successDelete: successDelete,
      failDelete: failDelete,
      successGet: successGet,
      failGet: failGet,
    };
  };
  AlertHpoFactory.$inject = ['$timeout', '$filter'];
  return AlertHpoFactory;
});
