'use strict';
define(function () {
  var itv = function (extendedNgDialog, $filter, itvSoumFactory,
    DataStoreFactory, NetworkFactory, SelectManager, itvUtilsFactory, $q, $rootScope, gclayers,
    gaDomUtils, gaJsUtils, FeatureTypeFactory) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/LITV/views/itv.html',
      restrict: 'AE',


      link: function (scope) {

        scope.mass_loading = {};


        /**
         * Marque les ITV comme inactives pour la configuration courante.
         * Gère l'affichage du chargement, les appels au service et les retours utilisateur.
         * Met à jour les FTI si nécessaire et affiche un récapitulatif des modifications.
         * @returns {void}
         */
        const confirmMarkInactive = () => {
          // Afficher le loader global
          gaDomUtils.showGlobalLoader();

          // Appeler le service pour marquer les ITVs comme inactives
          itvSoumFactory.markInactiveOutOfService(scope.ConfigName).then((response) => {
            // Cacher le loader global
            gaDomUtils.hideGlobalLoader();
            if (response.data.errorList && response.data.errorList.length !== 0) {
              gaJsUtils.swalHtmlError(response.data.errorList[0].message_kis);
              return;
            }
            if (response.data.objValeur.isFtiModified) {
              // -- Au moins un FTI a été is à jour donc on recharge les FTIs
              FeatureTypeFactory.get(true);
            }

            // -- Afficher le message récapitulatif du traitement effectué
            swal({
              title: $filter('translate')('itv.itvMarkInactive.success'),
              text: $filter('translate')('itv.itvMarkInactive.processEndedMessage')
                .replace('${inactivePortions}', response.data.objValeur.inactivePortions)
                .replace('${inactiveInspections}', response.data.objValeur.inactiveInspections),
              html: true,
              type: 'success',
              confirmButtonColor: '#428bca',
              showCancelButton: false,
              confirmButtonText: $filter('translate')('common.ok'),
              showConfirmButton: true
            });
          }).catch((error) => {
            // -- En cas d'erreur, cacher le loader et afficher un message d'erreur
            gaDomUtils.hideGlobalLoader();
            gaJsUtils.swalHtmlError($filter('translate')('common.unknownError')+': '+error);
          });
        };


        /**
         * Affiche la popup de confirmation pour marquer les ITVs comme inactives
         * pour les tronçons hors service.
         */
        scope.markInactiveOutOfService = function() {
          const confirmDialog = extendedNgDialog.open({
            title: $filter('translate')('itv.itvMarkInactive.title'),
            template: 'js/XG/widgets/mapapp/LITV/views/confirmMarkInactive.html',
            className: 'ngdialog-theme-plain width800',
            showClose: true,
            closeByDocument: true,
            closeByEscape: true,
            scope: scope,
            controller: ['$scope', function($scope) {
              $scope.confirmMarkInactive = () => {
                confirmMarkInactive(scope.ConfigName);
                confirmDialog.close();
              };
              $scope.cancelMarkInactive = () => {
                confirmDialog.close();
              };
            }]
          });
        };


        // Get configs
        if (!scope.ConfigName && scope.$parent.ConfigName) {
          scope.ConfigName = scope.$parent.ConfigName;
        }


        /**
         * Vérifier si la configuration du chargement en masse est OK.
         * Quand elle ne l'est pas, mettre en place les informations pour
         * faire apparaître la ligne d'ouverture de la fenêtre en rouge
         * avec ouverture sur clic d'une popup contenant
         * le message d'erreur reçu en retour.
         */
        const checkConfiguration = () => {
          if (!scope.conf) {
            return;
          }
          itvSoumFactory.checkItvConf(scope.conf, 'MASS_LOADING').then((res) => {
            scope.wrong_mass_loading_conf
              = (res.data && res.data.etat === 'erreur');
            scope.mass_loading.errors = '';
            if (res.data.errorList) {
              //-- Construction du message d'erreur à mettre dans la popup.
              for (let ii = 0; ii < res.data.errorList.length; ii++) {
                if (scope.mass_loading.errors != '') {
                  scope.mass_loading.errors += '\n';
                }
                let msg = $filter('translate')(res.data.errorList[ii].message_kis);
                //-- Le message ne doit pas dépasser le cadre de la popup !!
                const maxlen = 35;
                while (msg.length > maxlen
                  && (msg.indexOf(' ') === -1 || msg.indexOf(' ') > maxlen)) {
                  scope.mass_loading.errors += msg.substr(0, maxlen) + '\n';
                  msg = msg.substr(maxlen);
                }
                scope.mass_loading.errors += msg;
              }
            }
          });
        };


        /**
         * Récupération de la configuration de gestion des ITVs
         * s'il en existe une.
         */
        itvSoumFactory.getConf(scope.ConfigName).then((conf) => {
          scope.conf = conf;
          checkConfiguration();
        });


        // Datastores
        DataStoreFactory.get().then(function () {
          scope.datastores = DataStoreFactory.resources.datastores;
        });
        // Networks
        if (NetworkFactory.resources.networks.length > 0) {
          scope.networks = NetworkFactory.resources.networks;
        }
        else {
          NetworkFactory.get().then(function () {
            scope.networks = NetworkFactory.resources.networks;
          });
        }



        let itvConfigurationLoading = false;
        scope.openItvConfiguration = () => {
          if (itvConfigurationLoading) return;
          itvConfigurationLoading = true;

          scope.conf4mod = angular.copy(scope.conf);
          extendedNgDialog.open({
            template: 'js/XG/widgets/mapapp/LITV/views/itvConfig.html',
            className: 'ngdialog-theme-plain overflowY miniclose',
            closeByDocument: false,
            scope: scope,
            title: $filter('translate')('geolocalisation.OpenConfig'),
            preCloseCallback: function () {
              itvConfigurationLoading = false;
              checkConfiguration();
            },
          });
        };


        /**
         * Mise en place des propriétés du scope nécessaires à la gestion
         * de la création des branchements.
         *
         * @param {*} theScope Scope à préparer
         */
        const prepareConnectionPipeScope = (theScope) => {
          //-- Récupérer la carte openlayers et la configuration des ITVs
          return itvSoumFactory.getConf('creationBranchement').then((conf) => {
            scope.connectionPipeConfig = conf;
          }).finally(() => {
            theScope.conf = scope.conf;
            theScope.connectionPipeConfig = scope.connectionPipeConfig;
            if (!theScope.connectionPipeConfig) {
              //-- Configuration initale pour la création des branchements,
              //-- car pas de configuration existante.
              theScope.connectionPipeConfig = {};
              theScope.attrToAdd = '';
              theScope.connectionPipeConfig.pipeLength = 2;
            }
            //-- Workspace pour propriétés partagées entre scopes
            theScope.ws = {};
          });
        };

        // Open a new window when clicked on Itv's rows
        scope.itv_open = function (str) {
          // Window : Visualisation
          if (str === 'visualisation' || str === 'creationBranchement') {
            let titleItem;
            let theScope = scope.$new(true, scope);
            theScope.map = scope.map;
            let promises = [];
            if (str === 'visualisation') {
              if (scope.isVisualisationOpen) {
                return;
              }
              scope.isVisualisationOpen = true;
              titleItem = 'view';
              theScope.conf = scope.conf;
            }
            else {
              //-- Instancier un scope pour les branchements,
              //-- sinon il y aura du méli - mélo
              titleItem = 'connectionPipeCreation';
              const promise = prepareConnectionPipeScope(theScope);
              promises.push(promise);
            }
            $q.all(promises).then(()=>{
              theScope.mode = str;
              extendedNgDialog.open({
                template:
                  'js/XG/widgets/mapapp/LITV/views/visualisation/visualisation.html',
                className:
                  'ngdialog-theme-plain max-heigth550 nopadding miniclose itvvisua',
                closeByDocument: false,
                scope: theScope,
                minimizeMaximize: true,
                disableMaximizeButton: true,
                title: $filter('translate')('itv.'+titleItem),
                draggable: true,
                preCloseCallback: function () {
                  if (str === 'visualisation') {
                    scope.isVisualisationOpen = false;
                  }
                  itvUtilsFactory.getitvoperationalLayers()
                    .forEach(function (featureLayer) {
                      scope.map.getLayers().forEach(function (Layer) {
                        if (
                          Layer.getProperties().name ==
                          featureLayer.getProperties().name
                        ) {
                          scope.map.removeLayer(Layer);
                        }
                      });
                    });
                  // Enlever La couche EVT_Inspection_Part_Detail
                  const partDetailLayer
                    = gclayers.getOperationalLayerByLayerName('EVT_Inspection_Part_Detail');
                  if (partDetailLayer) {
                    partDetailLayer.cql_filter = '1=1';
                    partDetailLayer.setVisible(false);
                    $rootScope.$broadcast('gcOperationalLayerChange', '', 'applyall');
                  }

                  SelectManager.clear();
                  itvUtilsFactory.clearoriginsourcecanal();
                  itvUtilsFactory.clearitvoperationalLayers();
                  scope.map.removeInteraction(scope.$$childHead.pointer);
                  scope.map.removeInteraction(scope.$$childHead.dragBox);
                },
              });
            });
            // Window : Create ITV window
          }
          else if (str === 'soumission') {
            extendedNgDialog.open({
              template:
                'js/XG/widgets/mapapp/LITV/views/soumission/soumission.html',
              className:
                'ngdialog-theme-plain nopadding miniclose width500 itvsoum displayAsTable',
              closeByDocument: false,
              resizable: false,
              scope: scope,
              minimizeMaximize: true,
              disableMaximizeButton: true,
              title: $filter('translate')('itv.create'),
              draggable: true,
              preCloseCallback: () => {
                d3.select('.svgitv').selectAll('*').remove();
                angular.element('#details').empty();
                angular.element('.detailtablesec .ng-table-pager').remove();
                const layers = itvUtilsFactory.getitvoperationalLayers();
                for (let iLyr = 0; iLyr < layers.length; iLyr++) {
                  const featureLayerName = layers[iLyr].getProperties().name;
                  scope.map.getLayers().forEach(function (Layer) {
                    if (Layer.getProperties().name == featureLayerName) {
                      try {
                        scope.map.removeLayer(Layer);
                      }
                      catch (e) {
                        console.log('Erreur capturée: '+e);
                      }
                    }
                  });
                }
                //-- Informer la directive de correspondance du fait que
                //-- l'on est en train de fermer le widget, afin de rétablir
                //-- la visibilité des couches.
                scope.$broadcast('closingWidget');
                //On vide la selection en fermant le widget Soumission manuelle
                SelectManager.clear();
                itvUtilsFactory.clearoriginsourcecanal();
                itvUtilsFactory.clearitvoperationalLayers();
                $('#closePanel').click();
                scope.map.removeInteraction(scope.$$childHead.pointer);
              },
            });
          }
          else if (str === 'soumissionEnMasse') {
            extendedNgDialog.open({
              template:
                'js/XG/widgets/mapapp/LITV/views/soumissionEnMasse/soumissionEnMasse.html',
              className:
                'ngdialog-theme-plain nopadding miniclose itvsoum displayAsTable',
              closeByDocument: false,
              scope: scope,
              resizable: true,
              minimizeMaximize: true,
              title: $filter('translate')('itv.massCreate'),
              draggable: true,
              preCloseCallback: function () {
                d3.select('.svgitv')
                  .selectAll('*')
                  .remove();
                angular.element('#details').empty();
                angular.element('.detailtablesec .ng-table-pager').remove();
                itvUtilsFactory.getitvoperationalLayers()
                  .forEach(function (featureLayer) {
                    scope.map.getLayers().forEach(function (Layer) {
                      if (
                        Layer.getProperties().name ==
                        featureLayer.getProperties().name
                      ) {
                        scope.map.removeLayer(Layer);
                      }
                    });
                  });
                itvUtilsFactory.clearoriginsourcecanal();
                itvUtilsFactory.clearitvoperationalLayers();
                $('#closePanel').click();
                scope.map.removeInteraction(scope.$$childHead.pointer);
              },
            });
          }

        };

        //Reinitialisation si fermeture du widget
        scope.$on('closeTools_itvdirective', function () {
          itvUtilsFactory.getitvoperationalLayers()
            .forEach(function (featureLayer) {
              scope.map.getLayers().forEach(function (Layer) {
                if (
                  Layer.getProperties().name ==
                  featureLayer.getProperties().name
                ) {
                  scope.map.removeLayer(Layer);
                }
              });
            });
          SelectManager.clear();
          itvUtilsFactory.clearoriginsourcecanal();
          itvUtilsFactory.clearitvoperationalLayers();
          if (scope.$$childHead) {
            scope.map.removeInteraction(scope.$$childHead.pointer);
            scope.map.removeInteraction(scope.$$childHead.dragBox);
          }
        });
        scope.itvTabs = {
          tabs: [
            {
              title: $filter('translate')('itv.soumission.conf.general'),
            },
            {
              title: $filter('translate')('itv.soumission.conf.indigau'),
            },
            {
              title: $filter('translate')('itv.soumission.conf.advanced'),
            }
          ],
          activeTab: 0
        };


        /**
         * Vérification de la présence d'une configuration pour
         * la création de branchement.
         *
         * @returns VRAI si la configuration de création de branchement
         *          est définie et correcte, FAUX sinon
         */
        scope.createConnectionPipeCfgOk = () => {
          return scope.connectionPipeConfig !== undefined
            && (scope.connectionPipeConfig.destinationLineFtid
              || scope.connectionPipeConfig.destinationPointFtid);
        };
      },
    };
  };

  itv.$inject = ['extendedNgDialog', '$filter', 'itvSoumFactory',
    'DataStoreFactory', 'NetworkFactory','SelectManager', 'itvUtilsFactory', '$q',
    '$rootScope','gclayers', 'gaDomUtils', 'gaJsUtils', 'FeatureTypeFactory'
  ];
  return itv;
});
