define(function() {
  'use strict';

  var basemapwidget = function(gclayers, BaseMapFactory, gaJsUtils) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/basemap/views/basemapwidget.html',
      restrict: 'A',
      link: function(scope) {
        scope.currentlayer = null;
        var portalid = angular.module('gcMain').portalid;

        function init() {

          // Parcours des couches pour trouver le baseMap déjà activé par default sur la map
          // On le passe ainsi à actif et dans currentlayer
          const layers = scope.map.getLayers().getArray();
          let found = false;
          for(const layer of layers) {
            if (!layer.getVisible()) {
              continue;
            }
            for (const baseMap of BaseMapFactory.resources.basemaps) {
              if (baseMap.name === layer.get('name')) {
                baseMap.active = true;
                scope.currentlayer = baseMap;
                found = true;
                break;
              }
            }
            if (found) {
              break;
            }
          }
          // KIS-3487: un fond de plan de type "COMPOSED" ne peut être activé depuis une layer de la map puisqu'il est composé de plusieurs layers
          // Lecture du nom de la couche de base active du service BaseMapFactory
          // @see gcMainController#getMainMapConfig
          // PS: l'activation par lecture des couches de la map ci-dessus devient obsolète même dans le cas d'un fond de plan simple...
          if (BaseMapFactory.resources.hasOwnProperty('activeBaseMap')) {
            const activeBaseMap = BaseMapFactory.resources.activeBaseMap;
            if (activeBaseMap) {
              const baseMap = BaseMapFactory.resources.basemaps.find(bmap => bmap.name === activeBaseMap);
              if (baseMap) {
                for (const bm of BaseMapFactory.resources.basemaps) {
                  bm.active = false;
                }
                baseMap.active = true;
                scope.currentlayer = baseMap;
              }
            }
          }
          scope.baselayers = prepareBaseLayers(
            BaseMapFactory.resources.basemaps
          );

        }

        function prepareBaseLayers(factoryBasemaps) {
          var baselayers = [];

          for (var i = 0; i < factoryBasemaps.length; i++) {
            var factoryBasemap = factoryBasemaps[i];

            if (angular.isDefined(factoryBasemap.thumbnail)) {
              var thumbUrl =
                '/services/' +
                portalid +
                '/thumbnail/getthumb?f=json&fileName=' +
                factoryBasemap.thumbnail;

              factoryBasemap['thumbUrl'] = thumbUrl;
            } else {
              factoryBasemap['thumbUrl'] = 'img/common/osm_placeholder.png';
            }

            // Ajoute le fond de plan à la liste des fonds de plan disponibles
            // s'il n'est pas désactivé dans la config ou déjà actif sur la carte
            if(!factoryBasemap.inactive || factoryBasemap.active === true) {
              baselayers.push(factoryBasemap);
            }
          }

          return baselayers;
        }

        function hideBglayer(layerName) {
          scope.map.getLayers().forEach(function(l) {
            if (
              l &&
              l.theme &&
              l.name &&
              l.theme === 'WebBackGround' &&
              l.name === layerName
            ) {
              gclayers.removeBackGroundLayer(l, scope.map);
            }
          });
        }

        function hideBgLayer0(layer) {
          if (layer.type === 'COMPOSED') {
            gclayers.clearBackgroundLayer(scope.map, undefined);
          }
          else hideBglayer(layer.name);
        }

        scope.add = function(layer) {
          if (scope.currentlayer === layer) {
            scope.currentlayer = null;
            layer.active = false;
          } else {
            if (scope.currentlayer !== null) {
              scope.currentlayer.active = false;
              hideBgLayer0(scope.currentlayer);
            }
            layer.active = true;
            scope.currentlayer = layer;
          }
          if (layer.active) {
            gclayers.addBackGroundLayerByDesc(layer, gaJsUtils.getMap(scope));
            // KIS-3487: enregistre le nom du fond de carte dans le service
            BaseMapFactory.resources.activeBaseMap = layer.name;
          } else {
            hideBgLayer0(layer);
            BaseMapFactory.resources.activeBaseMap = null;
          }
        };

        if (BaseMapFactory.resources.basemaps.length) {
          init();
        } else {
          BaseMapFactory.get().then(init);
        }
      },
    };
  };

  basemapwidget.$inject = ['gclayers', 'BaseMapFactory', 'gaJsUtils'];
  return basemapwidget;
});
