'use strict';
define(function() {
  const DICTFactory = function($http, $q, PortalsFactory) {
    var DICTFactory = {};
    /**
     * Class : DICTFactory
     * Factory WebServices
     */

    /**
     * Function: testservice
     */
    function testservice(senddata) {
      var promise = $http.post(
        '/services/{portalid}/dict/{appname}/testService?f=json',
        senddata
      );

      return promise;
    }

    /**
     * Function: loadDraftItems
     */
    function loadDraftItems(draftItems, uploadProcessId) {
      var processConfig = {
        draftProcessId: uploadProcessId,
        draftItemsCount: draftItems.length,
        loadedDraftItemCount: 0,
      };

      const allPromises = [];
      angular.forEach(draftItems, function(draftItem) {
        var itemPromise = loadTmpDraftItem(
          draftItem.data,
          draftItem.title,
          processConfig.draftProcessId
        );
        allPromises.push(itemPromise);
      });

      var fullPromise = $q.all(allPromises);

      return fullPromise;
    }

    /**
     * Function: getdatastates
     */
    function downloadPrintPDF(printUrl) {
      var promise = $http({
        url: printUrl,
        method: 'GET',
        responseType: 'arraybuffer',
      });

      return promise;
    }

    function getdownloadurl(documentId, fileName) {
      var promise = $http.get(
        '/services/{portalid}/dict/{appname}/getDownloadURL?f=json' +
          '&documentId=' +
          documentId +
          '&fileName=' +
          fileName
      );

      return promise;
    }
    /**
     * Function: getdatastates
     */
    function loadTmpDraftItem(byteArray, draftFileItem, draftProcessId) {
      var promise = $http({
        url: '/services/{portalid}/dict/{appname}/loadTmpDraftItem?f=json',
        method: 'PUT',
        headers: {
          'Content-Type': 'application/pdf',
        },
        params: {
          // Other params here, including string metadata about uploads
          draftFileItem: draftFileItem,
          draftProcessId: draftProcessId,
        },
        data: byteArray,
        transformRequest: [],
      });

      return promise;
    }

    /**
     * Function: saveconfig
     */
    function saveconfig(senddata,onlySaveConfigFile) {
      onlySaveConfigFile =!!onlySaveConfigFile;
      return $http.post(
        '/services/{portalid}/dict/{appname}/saveConfig?f=json'
        + '&onlysaveconfigfile='+onlySaveConfigFile,
        senddata
      );
    }

    /**
     * Function: fillmodel
     */
    function fillmodel(datastore) {
      var promise = $http.get(
        '/services/{portalid}/dict/{appname}/fillModel?f=json' +
          '&datastore=' +
          datastore
      );

      return promise;
    }

    /**
     * Function: buildmodel
     */
    function buildmodel(datastore, srid) {
      var promise = $http.get(
        '/services/{portalid}/dict/{appname}/buildModel?f=json' +
          '&datastore=' +
          datastore +
          '&srid=' +
          srid
      );

      return promise;
    }

    /**
     * Function: initconcerning
     */
    function initconcerning(senddata, documentId, isConcerned) {
      var promise = $http.post(
        '/services/{portalid}/dict/{appname}/initConcerning?f=json' +
          '&documentId=' +
          documentId +
          '&isConcerned=' +
          isConcerned,
        senddata
      );

      return promise;
    }

    /**
     * Function: updateinnerstate
     */
    function updateinnerstate(documentId, innerstatevalue, automatic) {
      return $http.get(
        '/services/{portalid}/dict/{appname}/updateinnerstate?f=json'
        + '&documentId=' + documentId
        + '&automatic=' + automatic
        + '&innerstatevalue=' + innerstatevalue
      );
    }

    /**
     * Function: createorupdatedraftfordocument
     */
    function createorupdatedraftfordocument(senddata, delDraftItems, documentId) {
      return $http.post(
        '/services/{portalid}/dict/{appname}/createOrUpdateDraftForDocument?f=json' +
          '&delDraftItems=' + delDraftItems +
          '&documentId=' + documentId,
        senddata
      );
    }
    /**
     * Function: getdatastateatdate
     */
    function getdatastateatdate(senddata, dataState, minDate) {
      var promise = $http.post(
        '/services/{portalid}/dict/{appname}/getDataStateAtDate?f=json' +
          '&dataState=' +
          dataState +
          '&minDate=' +
          minDate,
        senddata
      );

      return promise;
    }
    /**
     * Function: getspecifieddatastates
     */
    function getspecifieddatastates(senddata, dataState) {
      var promise = $http.post(
        '/services/{portalid}/dict/{appname}/getSpecifiedDataStates?f=json' +
          '&dataState=' +
          dataState,
        senddata
      );

      return promise;
    }

    /**
     * Function: getalldocuments
     */
    function getalldocuments(senddata, reset, mapCRS) {
      if (reset == undefined) reset = false;
      var crs = '&outsrid=' + mapCRS;
      var promise = reset
        ? $http.post(
          '/services/{portalid}/dict/{appname}/resetandgetalldocuments?f=json'+crs,
          senddata
        )
        : $http.post(
          '/services/{portalid}/dict/{appname}/getalldocuments?f=json'+crs,
          senddata
        );

      return promise;
    }

    /**
     * Function: getmanueldocscount
     */
    function getmanueldocscount(senddata, reset) {
      if (reset == undefined) reset = false;

      var promise = reset
        ? $http.post(
          '/services/{portalid}/dict/{appname}/resetandgetmanueldocscount?f=json',
          senddata
        )
        : $http.post(
          '/services/{portalid}/dict/{appname}/getmanueldocscount?f=json',
          senddata
        );

      return promise;
    }

    /**
     * Function: getmoduleconfig
     */
    function getmoduleconfig() {
      var promise = $http.get(
        '/services/{portalid}/dict/{appname}/getModuleConfig?f=json'
      );

      return promise;
    }

    /**
     * Function: getdocumentdata
     */
    function getdocumentdata(senddata, documentId, fullData) {
      var promise = $http.post(
        '/services/{portalid}/dict/{appname}/getDocumentData?f=json' +
          '&documentId=' +
          documentId +
          '&fullData=' +
          fullData,
        senddata
      );

      return promise;
    }

    /**
     * Function: getdocumentsdata
     */
    function getdocumentsdata(senddata, documentIds, mapCRS, fullData) {
      var promise = $http.post(
        '/services/{portalid}/dict/{appname}/getDocumentsData?f=json' +
          '&documentIds=' +
          documentIds +
          '&mapCRS=' +
          mapCRS +
          '&fullData=' +
          fullData,
        senddata
      );

      return promise;
    }

    /**
     * Function: documentshavedraftsandnoconcerningdocuments
     */
    function documentshavedraftsandnoconcerningdocuments(documentIds, appname) {
      return $http.get(
        '/services/{portalid}/dict/{appname}/documentsHaveDraftsAndNoConcerningDocuments?f=json' +
          '&documentIds=' +
          documentIds +
          '&appname=' +
          appname
      );
    }

    /**
     * Function: receivedocument
     */
    function receivealldocuments(senddata, documentsIds, mapCRS) {
      return $http.post(
        '/services/{portalid}/dict/{appname}/receiveAllDocuments?f=json' +
          '&documentsIds=' +
          documentsIds +
          '&mapCRS=' +
          mapCRS,
        senddata
      );
    }

    /**
     * Function: receivedocument
     */
    function receivedocument(senddata, documentId, mapCRS) {
      return $http.post(
        '/services/{portalid}/dict/{appname}/receiveDocument?f=json' +
          '&documentId=' +
          documentId +
          '&mapCRS=' +
          mapCRS,
        senddata
      );
    }
    /**
     * Function: getdocumentpdf
     */
    function getdocumentpdf(documentId, appname) {
      var portalId = PortalsFactory.getPortalId();
      var appName = localStorage.getItem('app');
      var authToken = localStorage.getItem('auth_token');
      var downloadurl =
        '/services/' +
        portalId +
        '/dict/' +
        appName +
        '/getDocumentPDF?documentId=' +
        documentId +
        '&token=' +
        authToken;
      window.open(downloadurl);
    }
    /**
     * Function: deletedraftfordocument
     */
    function deletedraftfordocument(senddata, documentId) {
      return $http.post(
        '/services/{portalid}/dict/{appname}/deleteDraftForDocument?f=json' +
          '&documentId=' +
          documentId,
        senddata
      );
    }
    /**
     * Function: getdraftfordocument
     */
    function getdraftfordocument(senddata, documentId) {
      return $http.post(
        '/services/{portalid}/dict/{appname}/getDraftForDocument?f=json' +
          '&documentId=' +
          documentId,
        senddata
      );
    }

    /**
     * Appel du service calculant les états et DT/DICT et générant automatiquement les rapports
     */
    const computeStatesAndReports = (mapCRS, changeConfig) => {
      return $http.get('/services/{portalid}/dict/{appname}'
          + '/computeStatesAndReports?f=json'
          + '&outsrid=' + mapCRS
          + '&changeConfig=' + changeConfig);
    };

    /**
     * Sauvegarde une pièce jointe pour une DT/DICT
     * @param documentId
     * @param attachedDocumentUrl
     * @returns {*}
     */
    const saveAttachedDocumentByUrl = (documentId, attachedDocumentUrl, fileType, automatic,
      newFileName) => {
      fileType = fileType ? fileType : '';
      newFileName = newFileName ? '&newfilename='+newFileName : '';
      return $http.post('/services/{portalid}/dict/{appname}'
          + '/saveAttachedDocumentByUrl?f=json'
          + '&documentId=' + documentId
          + '&automatic=' + automatic
          + newFileName
          + '&fileType='+fileType, attachedDocumentUrl);
    };

    return {
      DICTFactory: DICTFactory,
      testservice: testservice,
      loadDraftItems: loadDraftItems,
      downloadPrintPDF: downloadPrintPDF,
      getdownloadurl: getdownloadurl,
      saveconfig: saveconfig,
      fillmodel: fillmodel,
      buildmodel: buildmodel,
      updateinnerstate,
      initconcerning: initconcerning,
      createorupdatedraftfordocument: createorupdatedraftfordocument,
      getdatastateatdate: getdatastateatdate,
      getspecifieddatastates: getspecifieddatastates,
      getalldocuments: getalldocuments,
      getmanueldocscount: getmanueldocscount,
      getmoduleconfig: getmoduleconfig,
      getdocumentdata: getdocumentdata,
      getdocumentsdata: getdocumentsdata,
      documentshavedraftsandnoconcerningdocuments: documentshavedraftsandnoconcerningdocuments,
      receivealldocuments: receivealldocuments,
      receivedocument: receivedocument,
      getdocumentpdf: getdocumentpdf,
      deletedraftfordocument: deletedraftfordocument,
      getdraftfordocument: getdraftfordocument,
      computeStatesAndReports: computeStatesAndReports,
      saveAttachedDocumentByUrl: saveAttachedDocumentByUrl
    };
  };
  DICTFactory.$inject = [
    '$http',
    '$q',
    'PortalsFactory'
  ];
  return DICTFactory;
});
