'use strict';
define(function() {
  var basemapwidget = function(
    gcPropertiesLayers,
    gclayers,
    ParametersFactory,
    gcPopup,
    extendedNgDialog,
    gaDomUtils,
    GeoTreatmentFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/geotreatment/views/treatments/treatOrientedPoint.html',
      restrict: 'A',
      link: function(scope, elt, attrs, ctrl) {
        scope.activetreatment = '';
        scope.res = {};
        scope.attributes_select = [];
        scope.inprogress = false;
        scope.interrupt = false;
        scope.geoLimit = GeoTreatmentFactory.DATABASE;
        scope.typeOfGeotreatment = 'orientedPoint';
        scope.attributesTochange = '';

        let handlePromiseError= () =>{
          scope.inprogress = false;
        };

        scope.stop = function() {
          GeoTreatmentFactory.stoptreatment(scope.state).then(function(data) {
            scope.inprogress = false;
            scope.interrupt = true;
          }).catch(handlePromiseError);
        };

        function getAttrListOfFtipoint() {
          var aliases = [];
          aliases.push('ID');
          aliases.push(scope.attributesTochange);
          aliases.push(scope.attributesTochange + ' NEW');
          return aliases;
        }

        scope.correction = function(obj) {
          scope.currentobj = obj;
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/geotreatment/views/modals/modal.correct.fusionLine.html',
            className: 'ngdialog-theme-plain width400 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: {
              title: 'Corrections',
            },
          });
        };

        scope.run = function(ftiPoint, ftiSupport, attr, theta) {
          scope.attributesTochange = attr;
          scope.inprogress = true;
          const featureCollections = [];
          const spatialClause = 
            GeoTreatmentFactory.getSpatialClause(
              scope.geoLimit,
              scope.map,
              scope.limitZoneGeometry,
              [ftiPoint.name],
              featureCollections);
          var param = {
            spatialclause: spatialClause,
            featureCollections: featureCollections,
            ftipoint: ftiPoint.uid,
            ftisupport: ftiSupport.uid,
            attribute: attr,
            theta: theta == null ? 0 : theta,
            srid: scope.map.getView().getProjection().getCode()
          };
          GeoTreatmentFactory.treatment(
            param,
            'OrientedPoint'
          ).then(function(data) {
            scope.state = data.data;
            scope.httpStatus=data.status;
            GeoTreatmentFactory.tick(scope, getAttrListOfFtipoint());
          }).catch(handlePromiseError);
        };
      },
    };
  };

  basemapwidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'ParametersFactory',
    'gcPopup',
    'extendedNgDialog',
    'gaDomUtils',
    'GeoTreatmentFactory',
    '$timeout',
  ];
  return basemapwidget;
});
