'use strict';
define(function() {

  var localisationMultiLevelFactory = function(
      $filter,
      $http
  ) {

    /**
     * specific call for localisationMultiLevelWidget
     */
    let localisationMultiLevelSpacial = (superiorLevelFtid, superiorLevelFeatureId,
        currentLevelFtid, currentLevelAttributeName, buffer, spatialSearchOperator,
        extraAttributeName, currentLevelFtiName) => {
      return $http.get(
          '/services/{portalid}/localisationmultilevel/localisationMultiLevelSpacial?f=json' +
          '&superiorLevelFtid=' + superiorLevelFtid +
          '&superiorLevelFeatureId=' + superiorLevelFeatureId +
          '&currentLevelFtid=' + currentLevelFtid +
          '&currentLevelAttributeName=' + currentLevelAttributeName +
          '&buffer=' + buffer +
          '&spatialSearchOperator=' + spatialSearchOperator +
          '&extraAttributeName=' + extraAttributeName
      ).then(res => {
        // the format of the 'id' is not good
        // change it from '1' to 'myLayer.1'
        if (res.data && Array.isArray(res.data.features)) {
          res.data.features = res.data.features.map(
            feature => {
              if (typeof feature.id == 'string' && !feature.id.includes('.')){
                feature.id = currentLevelFtiName + '.' + feature.id;
              }
              return feature;
            });
        }
        return res;
      });
    };

    return {
      localisationMultiLevelSpacial: localisationMultiLevelSpacial
    };
  };
  localisationMultiLevelFactory.$inject = [
      '$filter',
      '$http'
  ];
  return localisationMultiLevelFactory;
});