'use strict';
define(function () {
  /**
   * Class : EditRulesFactory
   * Cette classe est chargée d'exécuter les règles métiers d'édition
   * associées à une couche (un FeatureTypeInfo).
   */
  var networkEditFactory = function (FeatureTypeFactory, ConfigFactory) {
    function rulesAreTheSame(rule1, rule2) {
      let ind;
      if (
        rule1.name != rule2.name ||
        rule1.type != rule2.type ||
        //                || rule1.id!=rule2.id
        rule1.editTypes.length != rule2.editTypes.length
      )
        return false;

      for (ind = 0; ind < rule1.editTypes.length; ind++) {
        if (
          rule1.editTypes[ind].name != rule2.editTypes[ind].name ||
          rule1.editTypes[ind].label != rule2.editTypes[ind].label
        )
          return false;
      }

      return true;
    }

    function getRuleFromRuleAndConf(rule, fti, config) {
      let ind1, ind2, key, val, reg, cfgFtiDesc, cfgFtiAlias;
      let ruleAsStr = JSON.stringify(rule);
      reg = new RegExp('____thislayername____', 'g');
      ruleAsStr = ruleAsStr.replace(reg, fti.name);

      while ((ind1 = ruleAsStr.indexOf('____')) != -1) {
        ind2 = ruleAsStr.indexOf('____', ind1 + 4);
        key = ruleAsStr.slice(ind1 + 4, ind2);
        val = '';
        if (config.specialComponents != undefined) {
          if (config.specialComponents[key] != undefined) {
            val = config.specialComponents[key];
            val = FeatureTypeFactory.getFeatureByUid(val);
            if (val != undefined) val = val.name;
          }
        }
        if (val == undefined || val == '') {
          //-- Traitement du cas de type key = "____canaLayer.name__"
          cfgFtiDesc = key.split('.');
          cfgFtiAlias = cfgFtiDesc[0] + 'UID';
          if (config[cfgFtiAlias] != undefined) {
            val = FeatureTypeFactory.getFeatureByUid(config[cfgFtiAlias]);
            if (val != undefined) val = val[cfgFtiDesc[1]];
          }
        }
        reg = new RegExp('____' + key + '____', 'g');
        ruleAsStr = ruleAsStr.replace(reg, val);
      }
      return JSON.parse(ruleAsStr);
    }

    function addRuleToFti(fti, rule, ruleIndex, config) {
      let iRule;
      let origRules = angular.copy(fti.rules);
      fti.rules.splice(0, fti.rules.length);
      for (iRule = 0; iRule < ruleIndex && iRule < origRules.length; iRule++) {
        fti.rules.push(origRules[iRule]);
      }
      fti.rules.push(getRuleFromRuleAndConf(rule, fti, config));
      for (; iRule < origRules.length; iRule++) {
        fti.rules.push(origRules[iRule]);
      }
    }

    function checkRulesForRmAddedRules(rules, fti, ftiUpdated) {
      let iNeededRule;
      for (let iFtiRule = fti.rules.length - 1; iFtiRule >= 0; iFtiRule--) {
        for (iNeededRule = 0; iNeededRule < rules.length; iNeededRule++) {
          if (rules[iNeededRule] == null) {
            continue;
          }
          if (
            fti.rules[iFtiRule] != null &&
            rulesAreTheSame(rules[iNeededRule], fti.rules[iFtiRule])
          ) {
            break;
          }
        }
        if (iNeededRule == rules.length) {
          //-- Règle non trouvée dans la liste des règles à utiliser pour le FTI
          fti.rules.splice(iFtiRule, 1);
          ftiUpdated = true;
        }
      }
      return ftiUpdated;
    }

    function checkRulesFor(ruleLayerTypes, rules, ftisOrUids, config, cause) {
      let ind, list, uid, ftiRules, fti, ftiUpdated;
      let iFtiRule, iNeededRule;

      if (ftisOrUids == undefined) return;
      if (!Array.isArray(ftisOrUids)) {
        list = [];
        list.push(ftisOrUids);
      } else {
        list = ftisOrUids;
      }
      for (ind = 0; ind < list.length; ind++) {
        fti = list[ind];
        fti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          fti.storeName,
          fti.name
        );
        ftiRules = fti.rules;
        if (ftiRules == undefined) {
          if (typeof list[ind] == 'string') {
            fti = FeatureTypeFactory.getFeatureByUid(list[ind]);
          } else {
            fti = list[ind];
          }
        }
        if (fti == undefined) {
          continue;
        }

        ftiUpdated = false;

        for (iNeededRule = 0; iNeededRule < rules.length; iNeededRule++) {
          if (rules[iNeededRule] == null) {
            continue;
          }
          for (iFtiRule = 0; iFtiRule < fti.rules.length; iFtiRule++) {
            if (
              fti.rules[iFtiRule] != null &&
              rulesAreTheSame(rules[iNeededRule], fti.rules[iFtiRule])
            ) {
              break;
            }
          }
          if (iFtiRule == fti.rules.length) {
            //-- Règle non trouvée dans le FTI
            addRuleToFti(fti, rules[iNeededRule], iNeededRule, config);
            ftiUpdated = true;
          } else if (iNeededRule != iFtiRule || cause == 'savecfg') {
            //-- Règle déplacée dans le FTI => remettre dans l'ordre
            //-- OU  enregistrement de configuration => "recalculer" les règles
            fti.rules.splice(iFtiRule, 1);
            addRuleToFti(fti, rules[iNeededRule], iNeededRule, config);
            ftiUpdated = true;
          } else {
            ftiUpdated = checkRulesForRmAddedRules(rules, fti, ftiUpdated);
          }
        }
        if (ftiUpdated) {
          FeatureTypeFactory.update(fti);
        }
      }
    }

    function checkRules(rulesNetwork, rulesLayerTypes, config, cause) {
      let rules, ind;
      FeatureTypeFactory.get().then(() => {
        //-- Récupérer les règles imposées par le spécifications.
        //-- et vérifier qu'elles n'ont pas disparus
        ConfigFactory.getRulesFor(
          rulesNetwork,
          rulesLayerTypes.toString()
        ).then(
          (res) => {
            if (res.status == 200) {
              let ind;
              for (ind = 0; ind < rulesLayerTypes.length; ind++) {
                if (res.data[rulesLayerTypes[ind]] != undefined) {
                  checkRulesFor(
                    rulesLayerTypes[ind],
                    res.data[rulesLayerTypes[ind]].rules,
                    config[rulesLayerTypes[ind]],
                    config,
                    cause
                  );
                }
              }
            }
          },
          (reason) => {
            require('toastr').error(reason);
          }
        );
      });
    }

    return {
      checkRules: checkRules,
    };
  };
  networkEditFactory.$inject = ['FeatureTypeFactory', 'ConfigFactory'];
  return networkEditFactory;
});
