/**
 *
 */
'use strict';
define(function() {
  var gcPropertiesLayers = function() {
    this.$get = function() {
      return function defineProperties(olLayer) {
        Object.defineProperties(olLayer, {
          attribution: {
            get: function() {
              return this.get('attribution');
            },
            set: function(val) {
              this.set('attribution', val);
            },
          },
          index: {
            get: function() {
              return this.get('index');
            },
            set: function(val) {
              this.set('index', val);
            },
          },
          theme: {
            get: function() {
              return this.get('theme');
            },
            set: function(val) {
              this.set('theme', val);
            },
          },
          legend: {
            get: function() {
              return this.get('legend');
            },
            set: function(val) {
              this.set('legend', val);
            },
          },
          visible: {
            get: function() {
              return this.getVisible();
            },
            set: function(val) {
              this.setVisible(val);
            },
          },
          maxScale: {
            get: function() {
              return this.get('maxScale');
            },
            set: function(val) {
              var isValidScale =
                val != undefined &&
                ((typeof val == 'string' && val.length > 0) ||
                  (typeof val == 'number' && val > 0));
              if (isValidScale) {
                var dpi = 25.4 / 0.28;
                //var scale = 256000;
                this.setMaxResolution(parseFloat(val) / (39.37 * dpi));
                this.set('maxScale', val);
              } else {
                this.setMaxResolution(Infinity);
                this.set('maxScale', null);
              }
            },
          },
          gctype: {
            get: function() {
              return this.get('gctype');
            },
            set: function(val) {
              this.set('gctype', val);
            },
          },
          minScale: {
            get: function() {
              return this.get('minScale');
            },
            set: function(val) {
              var isValidScale =
                val != undefined &&
                ((typeof val == 'string' && val.length > 0) ||
                  (typeof val == 'number' && val != 0));
              if (isValidScale) {
                var dpi = 25.4 / 0.28;
                //var scale = 256000;
                this.setMinResolution(parseFloat(val) / (39.37 * dpi));
                this.set('minScale', val);
              } else {
                this.setMinResolution(null);
                this.set('minScale', null);
              }
            },
          },
          style: {
            get: function() {
              return this.get('style');
            },
            set: function(val) {
              this.set('style', val);
              if (this instanceof ol.layer.Layer) {
                var src = this.getSource();
                if (val != 'undefined' && val != '') {
                  src.updateParams({ STYLES: val });
                } else {
                  this.set('style', '');
                  src.updateParams({ STYLES: '' });
                }
              }
            },
          },
          cql_filter: {
            get: function() {
              return this.get('cql_filter');
            },
            set: function(val) {
              this.set('cql_filter', val);
              if (this instanceof ol.layer.Layer) {
                var src = this.getSource();
                if (val != 'undefined' && val != '') {
                  src.updateParams({ CQL_FILTER: val });
                } else {
                  this.set('cql_filter', '1=1');
                  src.updateParams({ CQL_FILTER: '1=1' });
                }
              }
            },
          },
          ogcDefinitionExpression: {
            get: function() {
              return this.get('ogcDefinitionExpression');
            },
            set: function(val) {
              this.set('ogcDefinitionExpression', val);
            },
          },
          ogcMaxScale: {
            get: function() {
              return this.get('ogcMaxScale');
            },
            set: function(val) {
              this.set('ogcMaxScale', val);
            },
          },
          ogcMinScale: {
            get: function() {
              return this.get('ogcMinScale');
            },
            set: function(val) {
              this.set('ogcMinScale', val);
            },
          },
          name: {
            get: function() {
              return this.get('name');
            },
            set: function(val) {
              this.set('name');
            },
          },
          fti: {
            get: function() {
              return this.get('fti');
            },
            set: function(val) {
              this.set('fti');
            },
          },
          invertedOpacity: {
            get: function() {
              return Math.round((1 - this.getOpacity()) * 100) / 100 + '';
            },
            set: function(val) {
              this.setOpacity(1 - val);
            },
          },
          id: {
            get: function() {
              return this.get('id') || this.bodId;
            },
            set: function(val) {
              this.set('id', val);
            },
          },
          selected: {
            get: function() {
              return this.get('selected') || this.bodId;
            },
            set: function(val) {
              this.set('selected', val);
            },
          },
          bodId: {
            get: function() {
              return this.get('bodId');
            },
            set: function(val) {
              this.set('bodId', val);
            },
          },
          label: {
            get: function() {
              return this.get('label');
            },
            set: function(val) {
              this.set('label', val);
            },
          },
          url: {
            get: function() {
              return this.get('url');
            },
            set: function(val) {
              this.set('url', val);
            },
          },
          type: {
            get: function() {
              return this.get('type');
            },
            set: function(val) {
              this.set('type', val);
            },
          },
          timeEnabled: {
            get: function() {
              return this.get('timeEnabled');
            },
            set: function(val) {
              this.set('timeEnabled', val);
            },
          },
          time: {
            get: function() {
              if (this instanceof ol.layer.Layer) {
                var src = this.getSource();
                if (src instanceof ol.source.WMTS) {
                  return src.getDimensions().Time;
                } else if (
                  src instanceof ol.source.ImageWMS ||
                  src instanceof ol.source.TileWMS
                ) {
                  return src.getParams().TIME;
                }
              }
              return undefined;
            },
            set: function(val) {
              if (this instanceof ol.layer.Layer) {
                var src = this.getSource();
                if (src instanceof ol.source.WMTS) {
                  src.updateDimensions({ Time: val });
                } else if (
                  src instanceof ol.source.ImageWMS ||
                  src instanceof ol.source.TileWMS
                ) {
                  src.updateParams({ TIME: val });
                }
              }
            },
          },
          background: {
            writable: true,
            value: false,
          },
          displayInLayerManager: {
            writable: true,
            value: true,
          },
          preview: {
            writable: true,
            value: false,
          },
        });
      };
    };

    ////////////////////////////////
  };
  return gcPropertiesLayers;
});
