'use strict';
define([], function() {
  var maUtils = function(gaJsUtils) {
    function removeFeatureFromSource(draw, feat) {
      let vt;
      if (feat.feat == undefined) {
        draw.source.getFeatures().some(function(featFromSrc) {
          if (feat === featFromSrc || feat.getId() == featFromSrc.getId()) {
            try {
              draw.source.removeFeature(featFromSrc);
            } catch (e) {}
            return true;
          }
        });
      } else {
        vt = feat.feat.vectorText;
        if (vt) {
          if (vt.getId()) {
            if (draw.source.getFeatureById(vt.getId()))
              draw.source.removeFeature(vt);
          } else draw.source.removeFeature(vt);
        } else draw.source.removeFeature(feat.feat.vector);
      }
    }

    function sameObject(o1, o2) {
      if (o1 instanceof Array) {
        if (o1.length != o2.length) return false;
        for (var ind = 0; ind < o1.length; ind++) {
          if (!sameObject(o1[ind], o2[ind])) return false;
        }
        return true;
      } else if (o1 instanceof Object) {
        for (var prop in o1)
          if (prop != 'visible' && !sameObject(o1[prop], o2[prop]))
            return false;
        return true;
      } else {
        return o1 == o2;
      }
    }

    function featureIsTexteABulle(features, scope) {
      var feat,
        fts = features.getArray();
      console.log(
        'scope.current.isTexteABulle(fts[0]) -> ' +
          scope.current.isTexteABulle(fts[0])
      );
      return scope.current.isTexteABulle(fts[0]);
    }

    function getFeatSize(scope, feat) {
      let size, featImage;
      if (feat.getStyle().getImage) featImage = feat.getStyle().getImage();

      if (featImage == null) {
        let ext = feat.getGeometry().getExtent();
        let pixelExt = [];
        pixelExt[0] = scope.map.getPixelFromCoordinate([ext[0], ext[1]]);
        pixelExt[1] = scope.map.getPixelFromCoordinate([ext[2], ext[3]]);
        size = pixelExt[1][0] - pixelExt[0][0];
        if (pixelExt[1][1] - pixelExt[0][1] > size)
          size = pixelExt[1][1] - pixelExt[0][1];
      } else {
        if (featImage.getRadius) size = featImage.getRadius();
        else {
          size = featImage.getSize();
          size = size[0] > size[1] ? size[0] : size[1];
          if (featImage.getScale) size *= featImage.getScale();
        }
      }
      return size;
    }

    function featureIsTipText(feat) {
      let prop;
      if (feat.getProperties) {
        //-- Cas du texte à bulle en mode sélection
        prop = feat.getProperties();
        return (
          prop.featureType == 'Polygon' &&
          prop.styleGraphic.type == 'TextSymbolizer'
        );
      } else {
        //-- Cas du feature stocké dans l'annotation
        prop = feat.properties;
        return feat.vectorText != undefined;
      }
    }

    let defaultStyles = {
      Point: {
        Rotation: 0,
        Mark: {
          WellKnownName: 'circle',
          Stroke: {
            CssParameter: [
              { _name: 'stroke', __text: '#000000' },
              { _name: 'stroke-width', __text: '1' },
              { _name: 'stroke-dasharray', __text: '' },
            ],
          },
          Fill: {
            CssParameter: [{ _name: 'fill', __text: '#000000' }],
          },
        },
        noColorFill: false,
        fixedSize: false,
        Size: '10',
        Displacement: {
          DisplacementX: '0',
          DisplacementY: '0',
        },
        styleMode: 'SYMBOL',
      },
      PointSVG: {
        ExternalGraphic: {
          OnlineResource: { _href: null },
          Format: null,
        },
        Rotation: 0,
        Size: '1',
        Displacement: {
          DisplacementX: '0.5',
          DisplacementY: '0.5',
        },
        styleMode: 'SVG',
      },
      LineString: {
        type: 'LineSymbolizer',
        Stroke: {
          CssParameter: [
            { _name: 'stroke', __text: '#000000' },
            { _name: 'stroke-dasharray', __text: '' },
            { _name: 'stroke-width', __text: '1' },
            { _name: 'stroke-linejoin', __text: '' },
            { _name: 'stroke-linecap', __text: '' },
            { _name: 'stroke-dashoffset', __text: '' },
          ],
        },
        Size: '10',
        Displacement: {
          DisplacementX: '0',
          DisplacementY: '0',
        },
      },
      Polygon: {
        type: 'PolygonSymbolizer',
        Stroke: {
          CssParameter: [
            { _name: 'stroke', __text: '#000000' },
            { _name: 'stroke-dasharray', __text: '' },
            { _name: 'stroke-width', __text: '1' },
            { _name: 'stroke-linejoin', __text: '' },
            { _name: 'stroke-linecap', __text: '' },
            { _name: 'stroke-dashoffset', __text: '' },
          ],
        },
        Fill: {
          CssParameter: [{ _name: 'fill', __text: '#000000' }],
        },
        noColorFill: false,
        fixedSize: false,
        _uom: '',
        styleMode: 'SYMBOL',
        opacity: 100,
      },
      PolygonHASH: {
        type: 'PolygonSymbolizer',
        Stroke: {
          CssParameter: [
            { _name: 'stroke', __text: '#000000' },
            { _name: 'stroke-dasharray', __text: '' },
            { _name: 'stroke-width', __text: '1' },
            { _name: 'stroke-linejoin', __text: '' },
            { _name: 'stroke-linecap', __text: '' },
            { _name: 'stroke-dashoffset', __text: '' },
          ],
        },
        Fill: {
          CssParameter: [
            { _name: 'fill', __text: '#FFFFFF' },
            { _name: 'hash-color', __text: '#000000' },
          ],
        },
        hashtemplate: 'hatch',
        noColorFill: false,
        fixedSize: false,
        _uom: '',
        styleMode: 'HASH',
      },
      Text: {
        type: 'TextSymbolizer',
        Stroke: {
          CssParameter: [
            { _name: 'stroke', __text: '#FFFFFF' },
            { _name: 'stroke-width', __text: '1' },
          ],
        },
        Fill: {
          CssParameter: [
            { _name: 'fill', __text: '#000000' },
            { _name: 'hash-color', __text: '#000000' },
          ],
        },
        noColorFill: false,
        fixedSize: false,
        text: 'Label',
        Size: '10',
        Rotation: 0,
        Displacement: {
          DisplacementX: '0',
          DisplacementY: '0',
        },
      },
    };

    return {
      removeFeatureFromSource: removeFeatureFromSource,
      defaultStyles: defaultStyles,
      sameObject: sameObject,
      featureIsTexteABulle: featureIsTexteABulle,
      getFeatSize: getFeatSize,
      featureIsTipText: featureIsTipText,
    };
  };

  maUtils.$inject = ['gaJsUtils'];
  return maUtils;
});
