'use strict';
define(function() {
  var rasterWidget = function(
    gcPropertiesLayers,
    gclayers,
    ParametersFactory,
    FilesFactory,
    ngDialog,
    extendedNgDialog,
    $filter,
    $rootScope,
    PortalsFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/mapapp/rastercalage/views/rasterwidget.html',

      restrict: 'A',

      link: function(scope, elt, attrs, ctrl) {
        var mode = '';
        var map = scope.map;
        scope.currentuser = $rootScope.xgos.user.login;
        var portalid = angular.module('gcMain').portalid;

        if (portalid == undefined || portalid == '') {
          portalid = PortalsFactory.getPortalId();
        }
        scope.layer_preview = {};
        scope.project = [];
        // gestion des points d'edition ps
        /**
         * [sourceGeo nouveau vecteur pour le dessin]
         * @type {ol}
         */
        scope.sourceGeo = new ol.source.Vector({ wrapX: false });
        /**
         * [featureOverlayGeo layer pour dessin avec un style]
         * @type {ol}
         */
        scope.featureOverlayGeo = new ol.layer.Vector({
          source: scope.sourceGeo,
          style: new ol.style.Style({
            fill: new ol.style.Fill({
              color: 'rgba(255, 255, 255, 0.2)',
            }),
            stroke: new ol.style.Stroke({
              color: '#ffcc33',
              width: 2,
            }),
            image: new ol.style.Circle({
              radius: 7,
              fill: new ol.style.Fill({
                color: '#ffcc33',
              }),
            }),
          }),
        });

        /**
         * [clearMap nettoie la map]
         * @returns {undefined}
         */
        scope.clearMap = function() {
          scope.map.removeLayer(scope.layer_preview);
          // scope.map.removeLayer(scope.featureOverlayGeo);
        };

        /**
         * [openCalage ouvre une fenetre de dialogue pour le calage d'une image]
         * @returns {undefined}
         */
        scope.openCalage = function() {
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/rastercalage/views/modals/modals.calage.html',
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: true,
            title: $filter('translate')('rastercalage.modalCalage'),
            preCloseCallback: function() {
              scope.map.removeLayer(scope.layer_preview);
              scope.map.removeLayer(scope.featureOverlayGeo);
              scope.sourceGeo.clear();
              scope.$broadcast('removelayerraster');
            },
          });
        };
        /**
         * [viewdb rendre visible l'image sur la map]
         * @param   data
         * @returns {undefined}
         */
        scope.viewdb = function(data) {
          //console.log(data);
          scope.map.removeLayer(scope.layer_preview);
          var indx = data.url.lastIndexOf('\\');
          var myurl = data.url.substring(indx);
          scope.layer_preview = new ol.layer.Image({
            source: new ol.source.ImageStatic({
              //url: '/services/'+portalid+'/files/getfile?f=json' +'&fileName=' +  data.url,
              //on recupere directement le nom de l'image géoréférencé
              url:
                '/services/' +
                portalid +
                '/files/getfile?f=json' +
                '&fileName=' +
                myurl,
              /*projection: scope.projection,*/
              imageExtent: data.extent,
            }),
          });
          scope.map.addLayer(scope.layer_preview);
        };
        /**
         * [unviewdb rendre invisible l'image sur la map]
         * @param  data
         * @returns {undefined}
         */
        scope.unviewdb = function(data) {
          // console.log(data);
          scope.map.removeLayer(scope.layer_preview);
          scope.layeropacity.value = 0;
        };
        //FONCTION IHM permet de modifier la transparence de l'image sur la map
        //opacity
        scope.theOpacity = 1.0;
        scope.layeropacity = {
          value: Math.round((1 - scope.theOpacity) * 100 * 2) / 2,
        };

        scope.$watch(
          'layeropacity',
          function(opacity) {
            scope.theOpacity = 1 - scope.layeropacity.value / 100;
            if (
              scope.layer_preview &&
              typeof scope.layer_preview.setOpacity === 'function'
            ) {
              scope.layer_preview.setOpacity(scope.theOpacity);
            }
            //$rootScope.$broadcast('gcOperationalLayerChange',scope.currlayer,"opacity");
          },
          1
        );

        /**
         * [setRasterCalage description]
         */
        var setRasterCalage = function() {
          scope.project = [];
          ParametersFactory.getbytype('calageraster').then(function(res) {
            angular.forEach(res.data, function(r) {
              //scope.project.push(r.data);

              scope.project.push(r);
            });
          });
        };
        /**
         * [removedb supprime l'annotation du calage de l'image]
         * @param   index
         * @param   data
         * @returns {undefined}
         */
        scope.removedb = function(index, data) {
          scope.clearMap();
          var ans = confirm($filter('translate')('annotations.confirm_delete'));
          if (ans) {
            ParametersFactory.deletebyname(data.name).then(function(res) {
              scope.project.splice(index, 1);
            });
          }
        };

        setRasterCalage();
      },
    };
  };

  rasterWidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'ParametersFactory',
    'FilesFactory',
    'ngDialog',
    'extendedNgDialog',
    '$filter',
    '$rootScope',
    'PortalsFactory',
  ];
  return rasterWidget;
});
