'use strict';
define(function() {
  var toolbarselecttoolutilities = function(
    $http,
    SelectManager,
    gclayers,
    gcPopup,
    $filter,
    gcRestrictionProvider,
    extendedNgDialog,
    ConfigFactory,
    FeatureTypeFactory,
    ngDialog,
    ReportIndicatorFactory,
    FilesFactory,
    $q,
    DocumentFactory,
    ngTableParams,
    $rootScope,
    EditFactory,
    gcInteractions,
    AncAppFactory,
    BacAppFactory,
    ApplicationFactory,
    QueryFactory,
    EditRulesFactory,
    EditTypesFactory,
    FeatureAttachmentFactory,
    ObjectFilesFactory,
    gaJsUtils,
    MajicFactory,
    $timeout,
    selecttoolbypointutilitiesservice,
    PortalsFactory,
    RightsFactory,
    bizeditProvider
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/selecttoolbypointutilities/views/toolbarselecttoolbypointutilities.html',
      restrict: 'AE',

      link: function(scope, element) {
        var map = scope.map;
        scope.isActive = false;
        let formatz = new ol.format.GeoJSON();
        scope.altKeyPressed = false;
        if (scope.params != undefined && scope.params.type != undefined) {
          scope.specialInfoCmd = true;
          scope.cmdTitle = $filter('translate')(
            'selectoolsbypointutilities.tbtooltip_' + scope.params.biz
          );
        } else {
          scope.specialInfoCmd = false;
        }

        scope.saveSelectSource = '';

        scope.dataUtilities = {};
        scope.applicationFound = false;
        ApplicationFactory.get().then(function() {
          for (var i in ApplicationFactory.resources.applications) {
            if (scope.params == undefined || scope.params.biz !== 'bac') {
              //-- On trouvait l'application ANC pour i rouge et i bleu.
              if (
                ApplicationFactory.resources.applications[i].type == 'AncApp'
              ) {
                scope.ancapp = {
                  name: ApplicationFactory.resources.applications[i].name,
                };
                scope.applicationFound = true;
                break;
              }
            } else {
              if (
                ApplicationFactory.resources.applications[i].type == 'BacApp'
              ) {
                //-- On a besoin de l'application BAC uniquement pour le i vert.
                scope.bacapp = {
                  name: ApplicationFactory.resources.applications[i].name,
                };
                scope.bacApplicationFound = true;
                break;
              }
            }
          }
        });
        if (scope.insideToolbar) {
          scope.btnStyle = 'border-width: 0px';
        } else {
          scope.btnStyle = '';
        }

        var btnElt = $(element[0]);
        btnElt.bind('click', () => {
          if (scope.pointerByPtUtil.getActive()) {
            deactivate();
          } else {
            activate();
          }
          SelectManager.clear();
        });

        const activate = () =>  {
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          scope.pointerByPtUtil.setActive(true);
          map.addInteraction(scope.pointerByPtUtil);
          if (scope.toolbarInfo){
            scope.toolbarInfo.setActiveBtn(
              'toolbarselecttoolbypointutilities'
            );
          }
          if (scope.applicationFound) {
            scope.showAncPanel();
          }
          if (scope.bacApplicationFound) {
            showBacPanel();
          }
        };

        const deactivate = () => {
          scope.pointerByPtUtil.setActive(false);
          map.removeInteraction(scope.pointerByPtUtil);
          if (scope.toolbarInfo){
            scope.toolbarInfo.setActiveBtn(undefined);
          }
        };

        scope.$on('closeToolsBar_toolbarselecttoolbypointutilities',() => {
          if(scope.pointerByPtUtil.getActive()){
            deactivate();
          }
        }
        );
        scope.$on('closeToolsBar_toolbarselecttoolbypointutilities#2',() => {
          SelectManager.clear();
        }
        );

        scope.pointerByPtUtil = new ol.interaction.Draw({
          type: 'Point',
          style: new ol.style.Style({}),
          condition: function(e) {
            //console.log(e.originalEvent.shiftKey);
            scope.altKeyPressed = e.originalEvent.ctrlKey;
            return true; //always return true but need to set whether shift key is pressed or not
          },
        });

        scope.pointerByPtUtil.set('gctype', 'kis');
        scope.pointerByPtUtil.set('interaction', 'Draw');
        scope.pointerByPtUtil.set('widget', 'select');
        scope.pointerByPtUtil.setActive(false);
        //map.addInteraction(scope.pointerByPtUtil);

        function executeUrl(action, properties) {
          scope.parametersRapportUtilisateur = [];
          var param = [];
          for (var j = 0; j < action.parameters.length; j++) {
            if (
              action.parameters[j].saisieMode ===
                $filter('translate')(
                  'model.featuretypes.actions.saisieUtilisateur'
                ) ||
              action.parameters[j].typeInfo === 'saisieUtilisateur'
            ) {
              param.push(action.parameters[j]);
            }
          }
          if (param.length > 0)
            scope.parametersRapportUtilisateur.push({
              name: action.name,
              parameters: param,
            });
          if (scope.parametersRapportUtilisateur.length > 0) {
            scope.tableParamsParameters = new ngTableParams(
              {
                page: 1, // show first page
                count: 10, // count per page
              },
              {
                total: 0, // length of data
                getData: function($defer, params) {
                  var displayedTab = scope.parametersRapportUtilisateur.slice(
                    (params.page() - 1) * params.count(),
                    params.page() * params.count()
                  );

                  params.total(scope.parametersRapportUtilisateur.length); // set total for recalc pagination
                  $defer.resolve(displayedTab);
                },
              }
            );
            scope.ngdiaParameters = ngDialog.openConfirm({
              template:
                'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverActionsGlobalParameters.html',
              scope: scope,
              className: 'ngdialog-theme-plain width800 nopadding miniclose',
            });
            scope.ngdiaParameters.then(
              function() {
                var url = parseUrl(action, properties);
                window.open(url);
              },
              function() {
                require('toastr').info(
                  $filter('translate')('selectfeaturetree.saisirtocontinue')
                );
              }
            );
          } else {
            var url = parseUrl(action, properties);
            window.open(url);
          }
        }

        function parseUrl(action, properties) {
          var url = action.url;
          var params = action.parameters;
          if (params.length > 0) {
            url += '?';
            var value;
            for (var i = 0; i < params.length; i++) {
              switch (params[i].saisieMode) {
                case $filter('translate')(
                  'model.featuretypes.actions.saisieAttribut'
                ):
                  properties[params[i].value] &&
                  properties[params[i].value] !== null
                    ? (value = properties[params[i].value])
                    : (value = '');
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + value;
                  break;
                case $filter('translate')(
                  'model.featuretypes.actions.saisieStatic'
                ):
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + params[i].attribute;
                  break;
                case $filter('translate')(
                  'model.featuretypes.actions.saisieUtilisateur'
                ):
                  if (i > 0) url += '&';
                  url += params[i].name + '=' + params[i].value;
                  break;
                default:
                  switch (params[i].typeInfo) {
                    case 'saisieAttribut':
                      properties[params[i].value] &&
                      properties[params[i].value] !== null
                        ? (value = properties[params[i].value])
                        : (value = '');
                      if (i > 0) url += '&';
                      url += params[i].name + '=' + value;
                      break;
                    case 'saisieStatic':
                      if (i > 0) url += '&';
                      url += params[i].name + '=' + params[i].attribute;
                      break;
                    case 'saisieUtilisateur':
                      if (i > 0) url += '&';
                      url += params[i].name + '=' + params[i].value;
                      break;
                  }
                  break;
              }
            }
          }
          return url;
        }

        function executeForm(action) {
          ConfigFactory.get(action.type, action.form).then(
            function(res) {
              scope.currentTemplate = res.data;
              if (scope.openFormulaireDialog) {
                scope.openFormulaireDialog.close();
              }
              const newScope = scope.$new();
              scope.openFormulaireDialog = extendedNgDialog.open({
                template:
                  'js/XG/widgets/mapapp/selectFeatureTree/views/panel/formulaire.html',
                className: 'ngdialog-theme-plain width800 nopadding miniclose',
                formOptions: res.data.options,
                closeByDocument: false,
                scope: newScope,
                title: '',
                draggable: true,
                scrollable:true,
                minimizeMaximize: true,
                resizable: true,
              });
              newScope.dlgPopup = scope.openFormulaireDialog;
            },
            function() {
              console.log('form does not exist');
            }
          );
        }

        function openMajicForm(action, parcelle) {
          //-- Si on a déjà ouvert une fenêtre majic depuis le sélecteur d'objet, on le ferme.
          if (scope.magicForm != undefined) {
            scope.magicForm.destroy();
            scope.magicForm = undefined;
          }
          //-- Demande la fermeture d'autres fiches majic éventuellement ouverte
          //-- depuis les widgets majic directement.
          $rootScope.$broadcast('pleaseRemoveExistingMajicForm', {
            id: 'iRouge',
          });

          const communes = $rootScope.xgos !== null && $rootScope.xgos.hasOwnProperty(
            'user') && $rootScope.xgos.user.hasOwnProperty('communes') ? $rootScope.xgos.user.communes : [];

          // recherche de la configuration du widget 'majic' nécessaire
          // pour récupérer le champ identifiant de la parcelle
          selecttoolbypointutilitiesservice.userHasMajicAuthorizationOnParcelle(parcelle,communes).then(
            res => {
              if (res){
                //-- On passe la parcelle au widget de consultation majic.
                scope.parcellefromparent = JSON.stringify(parcelle);
                scope.magicForm = gcPopup.open({
                  title: 'Majic',
                  showClose: true,
                  resizable: true,
                  minWidth: 430,
                  minimizeMaximize: true,
                  template:
                        'js/XG/widgets/mapapp/selecttoolbypointutilities/views/tbselecttoolbypointutilities.majic.html',
                  scope: scope,
                  onclose: function() {
                    gclayers.getselectSource().clear();
                    gclayers.clearhighLightFeatures();
                  }
                });
                $timeout(()=>{
                  MajicFactory.setInitPopupWidthAndMinWidth('consult', true);
                }, 400);
              } else {
                SelectManager.clear();
                require('toastr').warning(
                  $filter('translate')('tools.majicedigeo.majic.parcNonAutorise')
                );
              }
            }
          );
        }

        //-- On peut ouvrir une fiche majic depuis le "i rouge",
        //-- dans ce cas, pour éviter d'avoir plusieur fenêtre
        //-- majic à l'écran, on demande à effacer toute fiche majic
        //-- déjà dans lapage Web.
        scope.$on('pleaseRemoveExistingMajicForm', function(context, origin) {
          if (origin.id != 'iRouge')
            if (scope.magicForm != undefined) {
              scope.magicForm.destroy();
              scope.magicForm = undefined;
            }
        });

        function executeHtml(action) {
          if (scope.openHTMLDialog) scope.openHTMLDialog.close();
          scope.openHTMLDialog = extendedNgDialog.open({
            template: 'fichemetiers/' + action.url,
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: scope.fti.alias,
            draggable: true,
          });
        }

        const editFactoryUpdate = (sendata) => {
          EditFactory.update(
            scope.ftid,
            sendata,
            scope.map.getView().getProjection().getCode()).then(
            (res) => {
              let fNames = scope.removedfile == undefined ? null :
                Array.from(scope.removedfile).join();
              let id = gaJsUtils.getIdInCaseEsriId(scope.selectedCurrentFeature, scope.fti, null);
              if (fNames) {
                FeatureAttachmentFactory.remove(fNames, scope.fti.name, id).then( (res) => {
                  console.log('remove files : ', fNames);
                  selecttoolbypointutilitiesservice.displayToastrAfterUpdate(res.data);
                });
              } else {
                selecttoolbypointutilitiesservice.displayToastrAfterUpdate(res.data);
              }
            });
        };


        scope.validFeatures = function() {
          let editdescriptionTemplate = {
            theme: '',
            editType: '',
            fastMode: false,
            fti: undefined,
            editedfeature: undefined,
            relatedfeatures: [],
            shareObjects: [],
            interactions: [],
          };

          if (!bizeditProvider.checkMandatory(newScope, newScope.authorizedReadAttributes, 1,
            undefined, newScope.currentFeature.properties)) {
            return;
          }

          //Méthode appelée par les composant d'édition lors de leur activation
          //pour créer un nouvel objet décrivant l'action d'édition .
          scope.createeditdescription = () => {
            const description = angular.copy(editdescriptionTemplate);
            description.fastMode = false;
            description.theme = 'Default';
            return description;
          };

          /* save rules */
          scope.editdescription = scope.createeditdescription();
          if(scope.editdescription === undefined) return;
          scope.editdescription.editType =
            EditTypesFactory.editTypes.updateattributes.name;
          scope.editdescription.fti = scope.fti;
          let collection = {
            features: [scope.selectedCurrentFeature],
            type: 'FeatureCollection',
          };

          let feat = formatz.readFeatures(collection);
          scope.editdescription.editedfeature = feat[0];
          let postValidation = EditRulesFactory.executePostValidationRules(
            scope.editdescription,
            scope.fti,
            map
          );
          postValidation.then(
            () => {
              let saveEnd = EditRulesFactory.executeEndRules(
                scope.editdescription,
                scope.fti,
                scope.map
              );
              saveEnd.then(
                () => {
                  //Mise à jour attributaires
                  let prop = scope.editdescription.editedfeature.getProperties();
                  delete prop.geometry;
                  scope.newobj.current.properties = prop;
                  var sendata = {
                    type: 'FeatureCollection',
                    features: [scope.newobj.current],
                  };

                  editFactoryUpdate(sendata);

                  scope.p.destroy();
                },
                function () { }
              );
            },
            (error) => {
              require('toastr').error(
                $filter('translate')('bizedition.postValidError') + error
              );
            }
          );

        };
        /**
         *  closeAncPanel
         */
        scope.closeAncPanel = function() {
          scope.panelsManager.hidePanel('ancMapPanel');
          scope.panelVisible = false;
        };

        var dossierFti;
        scope.panelVisible = true;
        scope.showAncPanel = function() {
          scope.panelsManager.removePanel('ancMapPanel');
          scope.panelVisible = true;
          AncAppFactory.getAppCfg(false, true, scope.ancapp.name).then(function() {
            // acces au file manager autorisé
            var filemanager = angular.copy(
              AncAppFactory.appCfg.main.properties.filemanager
            );
            var canAccessFM = $rootScope.xgos.user.roles.filter(function(x) {
              return x.name.indexOf('ANC_rapports_') == 0;
            }).length;

            scope.allowGoToRapports =
              angular.isDefined(filemanager) &&
              filemanager.active &&
              ($rootScope.xgos.isroot || canAccessFM);

            scope.showAdminButton = AncAppFactory.appCfg.isAdmin;
            scope.showFilieresButtons =
              AncAppFactory.appCfg.main.properties.filieresVectorielles.active;

            dossierFti = angular.copy(
              FeatureTypeFactory.getFeatureByNameAndDatastore(
                AncAppFactory.appCfg.main.datastore,
                'kis_anc_dossier'
              )
            );

            scope.panelsManager.addPanel({
              id: 'ancMapPanel',
              stickToRight: true,
              templateUrl:
                'js/XG/widgets/ancapp/main/views/map/anc_map_panel.html',
              scope: scope,
              stickToBorder: true,
              resizable: true,
            });
            scope.closeAncPanel();

            if (
              AncAppFactory.appCfg.main.properties.filieresVectorielles.active
            ) {
              var portalId = PortalsFactory.getPortalId();
              var efWMS = new ol.layer.Tile({
                id: 'efLayerAll',
                source: new ol.source.TileWMS({
                  url:
                    '/services/' +
                    portalId +
                    '/geoserver/wms?token=' +
                    localStorage.auth_token,
                  params: {
                    LAYERS:
                      portalId +
                      ':lg_anc_ef_pretraitement,' +
                      portalId +
                      ':lg_anc_ef_traitement,' +
                      portalId +
                      ':lg_anc_ef_autre,' +
                      portalId +
                      ':lg_anc_ef_agree',
                    TILED: true,
                    // 'CQL_FILTER': "1=1;1=1;1=1;1=1"
                    CQL_FILTER:
                      'filiere_active=true;filiere_active=true;filiere_active=true;filiere_active=true;',
                  },
                  serverType: 'geoserver',
                  crossOrigin: 'anonymous',
                }),
              });
              scope.map.addLayer(efWMS);

              var efWMSPTraitement = new ol.layer.Tile({
                id: 'efLayerTraitement',
                visible: false,
                source: new ol.source.TileWMS({
                  url:
                    '/services/' +
                    PortalsFactory.getPortalId() +
                    '/geoserver/wms?token=' +
                    localStorage.auth_token,
                  params: {
                    LAYERS:
                      PortalsFactory.getPortalId() + ':lg_anc_ef_traitement',
                    TILED: true,
                    // 'CQL_FILTER': "1=1"
                    CQL_FILTER: 'filiere_active=true',
                  },
                  serverType: 'geoserver',
                  crossOrigin: 'anonymous',
                }),
              });

              var efWMSPretraitement = new ol.layer.Tile({
                id: 'efLayerPretraitement',
                visible: false,
                source: new ol.source.TileWMS({
                  url:
                    '/services/' +
                    PortalsFactory.getPortalId() +
                    '/geoserver/wms?token=' +
                    localStorage.auth_token,
                  params: {
                    LAYERS:
                      PortalsFactory.getPortalId() +
                      ':lg_anc_ef_pretraitement',
                    TILED: true,
                    // 'CQL_FILTER': "1=1"
                    CQL_FILTER: 'filiere_active=true',
                  },
                  serverType: 'geoserver',
                  crossOrigin: 'anonymous',
                }),
              });
              var efWMSAgrees = new ol.layer.Tile({
                id: 'efLayerAgrees',
                visible: false,
                source: new ol.source.TileWMS({
                  url:
                    '/services/' +
                    PortalsFactory.getPortalId() +
                    '/geoserver/wms?token=' +
                    localStorage.auth_token,
                  params: {
                    LAYERS: PortalsFactory.getPortalId() + ':lg_anc_ef_agree',
                    TILED: true,
                    // 'CQL_FILTER': "1=1"
                    CQL_FILTER: 'filiere_active=true',
                  },
                  serverType: 'geoserver',
                  crossOrigin: 'anonymous',
                }),
              });
              var efWMSAutres = new ol.layer.Tile({
                id: 'efLayerAutres',
                visible: false,
                source: new ol.source.TileWMS({
                  url:
                    '/services/' +
                    PortalsFactory.getPortalId() +
                    '/geoserver/wms?token=' +
                    localStorage.auth_token,
                  params: {
                    LAYERS: PortalsFactory.getPortalId() + ':lg_anc_ef_autre',
                    TILED: true,
                    // 'CQL_FILTER': "1=1",
                    CQL_FILTER: 'filiere_active=true',
                  },
                  serverType: 'geoserver',
                  crossOrigin: 'anonymous',
                }),
              });

              var efCanalisations = new ol.layer.Tile({
                id: 'efCanalisations',
                visible: false,
                source: new ol.source.TileWMS({
                  url:
                    '/services/' +
                    PortalsFactory.getPortalId() +
                    '/geoserver/wms?token=' +
                    localStorage.auth_token,
                  params: {
                    LAYERS: portalId + ':kis_anc_efx_canalisations',
                    TILED: true,
                    // 'CQL_FILTER': "1=1",
                    CQL_FILTER: 'filiere_active=true',
                    STYLES: portalId + ':kis_anc_efx_canalisations',
                  },
                  serverType: 'geoserver',
                  crossOrigin: 'anonymous',
                }),
              });

              scope.map.addLayer(efWMS);
              scope.map.addLayer(efWMSPTraitement);
              scope.map.addLayer(efWMSPretraitement);
              scope.map.addLayer(efWMSAgrees);
              scope.map.addLayer(efWMSAutres);
              scope.map.addLayer(efCanalisations);
            }
          });
        };

        function showBacPanel() {
          scope.panelsManager.removePanel('bacMapPanel');
          BacAppFactory.getAppCfg(false, true, scope.bacapp.name).then(
            function() {
              scope.showAdminButton = BacAppFactory.appCfg.isAdmin;

              dossierFti = angular.copy(
                FeatureTypeFactory.getFeatureByNameAndDatastore(
                  BacAppFactory.appCfg.main.datastore,
                  'kis_bac_dossier'
                )
              );

              scope.panelsManager.addPanel({
                id: 'bacMapPanel',
                stickToRight: true,
                templateUrl:
                  'js/XG/widgets/bacapp/main/views/map/bac_map_panel.html',
                scope: scope,
                stickToBorder: true,
                resizable: true,
                visible: false,
              });
            }
          );
        }

        var openDossierAnc = function(dossier, typeDossier) {
          openDossier([dossier], typeDossier);
        };
        var openDossier = function(dossier, typeDossier) {
          var eventName = 'anc_open_dossier';
          if (typeDossier == 'DossierBAC') {
            eventName = 'bac_open_dossier';
          }
          $rootScope.$broadcast(eventName, dossier);
          //gclayers.getDrawLayer().getSource().clear();
        };

        function getAuthorizedFeatures(features) {
          const isAdmin = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;
          if (isAdmin) return features;
          const authorizedFeats = [];
          for (let i = 0; i < features.length; i++) {
            const ftid = FeatureTypeFactory.getFeatureUidByName(
              features[i].id.split('.')[0]
            );
            $rootScope.xgos.user.roles.forEach((role) => {
              role.authorizations.forEach((authorization) => {
                if (authorization.item == ftid) {
                  if (authorization.write == true) {
                    authorizedFeats.push(features[i]);
                  }
                }
              });
            });
            $rootScope.xgos.user.groups.forEach((group) => {
              group.roles.forEach((role) => {
                role.authorizations.forEach((authorization) => {
                  if (authorization.item == ftid) {
                    if (authorization.write == true) {
                      authorizedFeats.push(features[i]);
                    }
                  }
                });
              });
            });
          }
          return authorizedFeats;
        }

        //scope.pointerByPtUtil.setActive(scope.isActive);

        let newScope;
        function openDefaultFormWhenNoAction() {
          scope.uploadfile = {};
          scope.removedfile = new Set();
          if (scope.p != undefined && scope.p.element != null) {
            try {
              if (scope.p.element) {
                scope.p.destroy();
              }
              if (scope.p.scope) {
                scope.p.scope.$broadcast('$destroy');
              }
            } catch (e) {
              scope.p = null;
            }
          }
          newScope = $rootScope.$new();
          newScope.map = scope.map;
          newScope.panelsManager = scope.panelsManager;
          newScope.currentFti = scope.fti;
          newScope.currentFeature = scope.newobj.current;
          if ($rootScope.xgos) {
            scope.isAdmin = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;
            newScope.authorizedReadAttributes =RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user, scope.fti, scope.isAdmin, true);
            newScope.authorizedWriteAttributes = RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user, scope.fti, scope.isAdmin);
            newScope.authorizedWriteAttributesNames = newScope.authorizedWriteAttributes.map(att => att.name);
          } else {
            newScope.authorizedReadAttributes = [];
            console.error('$rootScope.xgos = ', $rootScope.xgos);
          }
          newScope.currentProperties = scope.newobj.current.properties;
          newScope.validFeatures = scope.valid;
          newScope.uploadfile = scope.uploadfile;
          newScope.configurationTab = false;
          // no need to handle rejection, on n'affiche pas l'objectFile "configurationTab = false"
          ObjectFilesFactory.getObjectFilesFiltredByAuthorizedAttributes(scope.fti.uid, newScope.authorizedReadAttributes).then(
            res => {
              if (typeof res === 'object' && res != null && res.active) {
                newScope.configurationTab = res;
              }
            }
          ).finally (() => {
            let hasTabs = false;
            let popupWidth = null;
            if (newScope.configurationTab !== undefined && typeof newScope.configurationTab !== 'boolean'
                && Array.isArray(newScope.configurationTab.configuration)
                && newScope.configurationTab.configuration.length > 0) {
              hasTabs = true;
              const firstConf = newScope.configurationTab.configuration[0];
              if (firstConf.popupWidth > 0 && firstConf.popupWidth < window.innerWidth) {
                popupWidth = firstConf.popupWidth;
              }
            }
            scope.p = gcPopup.open({
              scope: newScope,
              title: scope.fti.alias,
              template:
                'js/XG/widgets/mapapp/bizedition/views/attribute_popup2.html',
              showClose: true,
                resizable: false,
                minWidth: hasTabs ? 430 : 400,
                minHeight: 300,
                minimizeMaximize: true,
                className: hasTabs ? ' objectFilePopup' : ' nomaximize',
                width: popupWidth,
              onClose: () => {
                SelectManager.clear();
                gclayers.clearhighLightFeatures();
              }
            });

            if (hasTabs) {
              // sélecteur de la règle CSS que l'on va modifier
              // on ne peut pas modifier directement le style de l'élement HTML car il est modifiable par le redimensionnement vertical
              const cssRuleIdentifier = '.gcPopup.objectFilePopup .popup-template .myBody .popupContent.attributes-info-box .scrolledTabs .tab-content';
              bizeditProvider.adjustObjectFileTabContentHeight(scope.p.popup.iddiv, cssRuleIdentifier,'scrolledTabs', 3);
            }
          });
        }

        scope.valid = () => {
          scope.validFeatures(scope.newobj.current.properties);
        };


        function runJasperAction(selectedAction) {
          if (scope.fti.defaultsAction.currentComponent) {
            scope.uploadfile = {};
            if (scope.p != undefined && scope.p.element != null) {
              try {
                if (scope.p.element) {
                  scope.p.destroy();
                }
                if (scope.p.scope) {
                  scope.p.scope.$broadcast('$destroy');
                }
              } catch (e) {
                scope.p = null;
              }
            }
            var newScope = $rootScope.$new();
            newScope.map = scope.map;
            newScope.panelsManager = scope.panelsManager;
            newScope.currentFti = scope.fti;
            newScope.currentFeature = scope.newobj.current;
            if ($rootScope.xgos) {
              scope.isAdmin = $rootScope.xgos.isroot || $rootScope.xgos.isadmin;
              newScope.authorizedWriteAttributes =RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user, featureType, scope.isAdmin, true);
              newScope.authorizedReadAttributes = RightsFactory.getUserWriteOrReadRightsAttributes($rootScope.xgos.user, featureType, scope.isAdmin);
            } else {
              newScope.authorizedReadAttributes = [];
              console.error('$rootScope.xgos = ', $rootScope.xgos);
            }
            newScope.currentProperties = scope.newobj.current.properties;
            newScope.validFeatures = scope.validFeatures;
            newScope.configurationTab = false;
            ObjectFilesFactory.getObjectFilesFiltredByAuthorizedAttributes(scope.fti.uid,newScope.authorizedReadAttributes).then(res =>{
              if (typeof res === 'object' && res != null && res.active) {
              newScope.configurationTab = res;
              }
            }).finally(() => {
              let hasTabs = false;
              let popupWidth = null;
              if (gaJsUtils.notNullAndDefined(newScope.configurationTab) && typeof newScope.configurationTab !== 'boolean'
                  && Array.isArray(newScope.configurationTab.configuration) && newScope.configurationTab.configuration.length > 0) {
                hasTabs = true;
                const firstConf = newScope.configurationTab.configuration[0];
                if (firstConf.popupWidth > 0 && firstConf.popupWidth < window.innerWidth) {
                  popupWidth = firstConf.popupWidth;
                }
              }
            scope.p = gcPopup.open({
              scope: newScope,
              title: scope.fti.alias,
              template:
                'js/XG/widgets/mapapp/bizedition/views/attribute_popup2.html',
              showClose: true,
                resizable: false,
                minWidth: 430,
                minimizeMaximize: true,
                className: hasTabs ? ' objectFilePopup' : ' nomaximize',
                width: popupWidth
              });
            });
          } else {
            executeJasper(selectedAction, scope.newobj.current, 'onobject');
          }
        }

        function runDefaultAction(selectedAction, res) {
          switch (selectedAction.actionType) {
            case $filter('translate')('model.featuretypes.actions.form'):
              executeForm(selectedAction);
              break;
            case $filter('translate')('model.featuretypes.actions.jasper'):
              runJasperAction(selectedAction);
              break;
            case $filter('translate')('model.featuretypes.actions.url'):
              executeUrl(selectedAction, scope.newobj.current.properties);
              break;
            case $filter('translate')('model.featuretypes.actions.html'):
              executeHtml(selectedAction);
              break;
            case $filter('translate')('model.featuretypes.actions.anomalie'):
              $rootScope.$broadcast('opendosseraep', scope.newobj.current);
              break;
            case $filter('translate')('model.featuretypes.actions.majic'):
              openMajicForm(selectedAction, res.data.features[0]);
              break;
            case $filter('translate')('model.featuretypes.actions.dossier_anc'):
              openDossierAnc(scope.newobj.current);
              break;
            default:
              switch (selectedAction.typeInfo) {
                case 'FORMULAIRE':
                  executeForm(selectedAction);
                  break;
                case 'JASPER':
                  runJasperAction();
                  break;
                case 'URL':
                  executeUrl(selectedAction, scope.newobj.current.properties);
                  break;
                case 'HTML':
                  executeHtml(selectedAction);
                  break;
                case 'ANOMALIE':
                  $rootScope.$broadcast('opendosseraep', scope.newobj.current);
                  break;
                case 'MAJIC':
                  openMajicForm(selectedAction, res.data.features[0]);
                  break;
              }
              break;
          }
        }

        function getDossierAncFromParcelle(typeDossier, evt) {
          if (scope.newobj.current.geometry.type.indexOf('Polygon') == -1) {
            require('toastr').error('Vous devez sélectionner un contour.');
            return;
          }
          var dossierFtiId = 'kis_anc_dossier';
          if (typeDossier == 'DossierBAC') {
            dossierFtiId = 'kis_bac_dossier';
          }
          QueryFactory.objectsWithGeomRelation(
            dossierFtiId,
            scope.newobj.current,
            'WITHIN',
            map
              .getView()
              .getProjection()
              .getCode()
          ).then(
            function(res) {
              if (res.data.features.length == 0) {
                require('toastr').error('Pas de dossier associé à cet objet !');
              } else {
                if (res.data.features.length === 1) {
                  scope.newobj.current = res.data.features[0];
                  openDossierAnc(scope.newobj.current, typeDossier);
                } else {
                  const newScope = $rootScope.$new();
                  newScope.features = res.data.features;
                  newScope.onOpenFeature = (feature) => {
                    scope.newobj.current = feature;
                    openDossierAnc(scope.newobj.current, typeDossier);
                  };
                  let position;
                  if (evt && evt.target && (evt.target.ea || []).length > 0) {
                    position = {
                      left: (evt.target.ea[0] || 0) + 'px',
                      top: (evt.target.ea[1] || 20) - 20 + 'px',
                    };
                  }
                  gcPopup.open({
                    scope: newScope,
                    title: 'Dossiers associés',
                    position,
                    content: `<div>
                      <p ng-repeat="feature in features">
                        {{ feature.properties.ref_dossier }}
                        <span class="btn btn-xs btn-default cursorHelp pull-right">
                          <i class="fa fa-pencil-square-o" ng-click="onOpenFeature(feature)" title="Editer le dossier"></i>
                        </span>
                      </p>
                    </div>`,
                    showClose: true,
                    resizable: true,
                    minimizeMaximize: true,
                    minWidth: 430,
                    onclose: function() {
                      scope.newobj.current = res.data.features[0];
                    },
                  });
                }
              }
            },
            function(res) {
              var ind,
                errors,
                mess = '';
              errors = res.data.errorList;
              for (ind = 0; ind < errors.length; ind++) {
                mess += errors[ind].message_kis + '\n';
              }
              require('toastr').error(mess);
            }
          );
        }

        scope.pointerByPtUtil.on('drawend', (evt) => {
          if (scope.saveSelectSource){
            scope.saveSelectSource.clear();
            gclayers.clearhighLightFeatures();
          }
          const filter = gclayers.getSelectFilterasStringuid(map);
          if (filter !== '') {
            const format = new ol.format.GeoJSON();
            const feature = format.writeFeatureObject(evt.feature);
            const x = feature.geometry.coordinates[0];
            const y = feature.geometry.coordinates[1];
            const resolution = map.getView().getResolution();
            // var pointExtent = [x, y , x, y];
            let leftX;
            let rightX;
            let bottomY;
            let topY;
            if (resolution !== 'undefined') {
              leftX = x - 5 * resolution;
              rightX = x + 5 * resolution;
              bottomY = y - 5 * resolution;
              topY = y + 5 * resolution;
            } else {
              leftX = x - 5;
              rightX = x + 5;
              bottomY = y - 5;
              topY = y + 5;
            }
            const catchments_url =
              '/services/' +
              PortalsFactory.getPortalId() +
              '/ogc/getfeat?service=WFS&version=1.0.0&request=GetFeature&typeName=' + filter +
              '&outputformat=json&srsName=' +
              map.getView().getProjection().getCode() +
              '&cql_filter=INTERSECTS(geom, POLYGON((' +
              leftX + ' ' + bottomY + ',' + rightX + ' ' + bottomY + ',' +
              rightX + ' ' + topY + ',' + leftX + ' ' + topY + ',' +
              leftX + ' ' +  bottomY + ')))';
            const promise = $http.get(catchments_url);
            promise.then(
              (res) => {
                //console.log(userRights);

                if (res.data.features.length > 0) {
                  //// test open popup selon composant
                  ///Du resultat il faut recuperer les features authorizé !!!
                  const authorizedFeatures = getAuthorizedFeatures(
                    res.data.features
                  );
                  if (res.data.features.length > 1) {
                    res.data.features = authorizedFeatures;
                    gaJsUtils.prepareThingsWhenNewSelection(
                      scope,
                      SelectManager,
                      res
                    );
                    res.data.totalFeatures = res.data.features.length;
                    SelectManager.addFeaturesFromGeojson(res.data);

                    const newScope = $rootScope.$new();
                    newScope.map = scope.map;
                    newScope.panelsManager = scope.panelsManager;
                    const pop = gcPopup.open({
                      scope: newScope,
                      title: 'Informations: ',
                      content: '<div selectedfeaturestree ></div>',
                      showClose: true,
                      resizable: true,
                      minWidth: 430,
                      minimizeMaximize: true,
                      className: 'no-default-height',
                      onclose: function() {
                        SelectManager.clear();
                        gclayers.clearhighLightFeatures();
                      },
                    });
                    SelectManager.setpop(pop);
                  } else {
                    scope.selectedCurrentFeature = res.data.features[0];

                    gclayers.clearhighLightFeatures();
                    SelectManager.clear();

                    // KIS-3005 Un objet sélectionné sur la map avec le bouton I ROUGE (I METIER) doit être en surbrillance
                    // comme avec le bouton I BLANC (consultation simple)
                    const selectedFeatures = {
                      features : [scope.selectedCurrentFeature],
                      totalFeatures : 1,
                      type : 'FeatureCollection'
                    };
                    SelectManager.addFeaturesFromGeojson(selectedFeatures);
                    const format = new ol.format.GeoJSON();
                    gclayers.addhighLightFeature(format.readFeature(scope.selectedCurrentFeature));

                    scope.newobj = {};
                    if (
                      res.data &&
                      res.data.features &&
                      res.data.features.length > 0
                    ) {
                      scope.newobj.current = res.data.features[0];
                      scope.ftid = FeatureTypeFactory.getFeatureUidByName(
                        scope.newobj.current.id.split('.')[0]
                      );
                      scope.fti = FeatureTypeFactory.getFeatureByUid(
                        scope.ftid
                      );
                      var selectedAction,
                        somethingOpened = false;
                      if (
                        scope.params !== undefined &&
                        (scope.params.type === 'DossierANC' ||
                          scope.params.type === 'DossierBAC')
                      ) {
                        //-- Cas de la commande d'ouverture de dossier ANC depuis
                        //-- parcelle ou autre conteneur.
                        somethingOpened = true;
                        getDossierAncFromParcelle(scope.params.type, evt);
                      } else {
                        //-- Cas standard de l'action par défaut directement sur l'objet sélectionné.
                        selectedAction = scope.fti.defaultsAction;
                      }
                      if (!somethingOpened) {
                        if (selectedAction !== undefined && selectedAction !== null) {
                          runDefaultAction(selectedAction, res);
                        } else {
                          openDefaultFormWhenNoAction();
                        }
                      }
                    }
                  }
                  scope.saveSelectSource = gclayers.getselectSource();
                } else {
                  gclayers.clearhighLightFeatures();
                  SelectManager.clear();
                  scope.saveSelectSource = gclayers.getselectSource();
                  require('toastr').error(
                    $filter('translate')('layermanager.no_selectable_layer')
                  );
                }
              },
              (err) => {
                gcRestrictionProvider.showDetailsErrorMessage(err);
                gclayers.clearhighLightFeatures();
                SelectManager.clear();
              }
            );
          } else {
            require('toastr').error(
              $filter('translate')('layermanager.no_selectable_layer')
            );
          }
        });

        function executeJasper(action, currentselect, which) {
          scope.parametersRapportUtilisateur = [];
          for (var i = 0; i < action.rapports.length; i++) {
            if (
              (action.rapports[i].type ===
                $filter('translate')(
                  'model.featuretypes.actions.JasperModel'
                ) ||
                action.rapports[i].typeInfo === 'JasperModel') &&
              action.rapports[i].parameters &&
              action.rapports[i].parameters.length > 0
            ) {
              var param = [];
              for (var j = 0; j < action.rapports[i].parameters.length; j++) {
                if (
                  action.rapports[i].parameters[j].saisieMode ===
                    $filter('translate')(
                      'model.featuretypes.actions.saisieUtilisateur'
                    ) ||
                  action.rapports[i].parameters[j].typeInfo ===
                    'saisieUtilisateur'
                ) {
                  param.push(action.rapports[i].parameters[j]);
                }
              }
              if (param.length > 0)
                scope.parametersRapportUtilisateur.push({
                  name: action.rapports[i].name,
                  parameters: param,
                });
            }
          }
          if (scope.parametersRapportUtilisateur.length > 0) {
            scope.tableParamsParameters = new ngTableParams(
              {
                page: 1, // show first page
                count: 10, // count per page
              },
              {
                total: 0, // length of data
                getData: function($defer, params) {
                  var displayedTab = scope.parametersRapportUtilisateur.slice(
                    (params.page() - 1) * params.count(),
                    params.page() * params.count()
                  );

                  params.total(scope.parametersRapportUtilisateur.length); // set total for recalc pagination
                  $defer.resolve(displayedTab);
                },
              }
            );
            scope.ngdiaParameters = ngDialog.openConfirm({
              template:
                'js/XG/widgets/mapapp/selectFeatureTree/views/panel/popoverActionsGlobalParameters.html',
              scope: scope,
              className: 'ngdialog-theme-plain width800 nopadding miniclose',
            });
            scope.ngdiaParameters.then(
              function() {
                switch (which) {
                  case 'oncomponent':
                    JasperOnComponent(action, currentselect);
                    break;
                  case 'onobject':
                    Jasper(action, currentselect);
                    break;
                }
              },
              function() {
                require('toastr').info(
                  $filter('translate')('selectfeaturetree.saisirtocontinue')
                );
              }
            );
          } else {
            switch (which) {
              case 'oncomponent':
                JasperOnComponent(action, currentselect);
                break;
              case 'onobject':
                Jasper(action, currentselect);
                break;
            }
          }
        }

        function getPortalModel(rapport, currentselect) {
          var sendata = getPortalDoc(currentselect);
          DocumentFactory.generatedocx(
            sendata,
            rapport.file,
            currentselect.id,
            false,
            map
              .getView()
              .getProjection()
              .getCode()
          ).then(function(res) {
            window.open(
              '/services/' +
                angular.module('gcMain').portalid +
                '/documents/downloaddocx?' +
                '&name=' +
                res.data.name
            );
          });
        }

        function generatePortalReportFromDocX(
          currentselect,
          rapport,
          promisses
        ) {
          var sendata = getPortalDoc(currentselect);
          var promise = DocumentFactory.generatedocx(
            sendata,
            rapport.file,
            currentselect.id,
            false,
            map
              .getView()
              .getProjection()
              .getCode()
          ).then(
            function(res) {
              FullDataGenerate.push({
                type: 'PortalModel',
                file: res.data.name,
              });
            },
            function() {
              require('toastr').error('error');
            }
          );
          promisses.push(promise);
        }

        function generateJasperReport(currentselect, rapport, promisses) {
          var promise = generateJasperDocWhithoutDownload(
            rapport,
            currentselect
          ).then(function(res) {
            if (res.data.pdfdone)
              FullDataGenerate.push({
                type: 'JasperModel',
                file: res.data.fileNameGenerated,
                appname: angular.module('gcMain').app,
              });
          });
          promisses.push(promise);
        }

        function Jasper(action, currentselect) {
          if (action.rapports.length === 1) {
            var rapport = action.rapports[0];
            switch (rapport.type) {
              case $filter('translate')(
                'model.featuretypes.actions.PortalModel'
              ):
                getPortalModel(rapport, currentselect);
                break;
              case $filter('translate')(
                'model.featuretypes.actions.StaticModel'
              ):
                window.open(
                  '/services/'+localStorage.getItem('portal')+'/files/getfilestatic?ftiname=' +
                    scope.fti.name +
                    '&filename=' +
                    rapport.file
                );
                break;
              case $filter('translate')(
                'model.featuretypes.actions.JasperModel'
              ):
                generateJasperDoc(rapport, currentselect);
                break;
              default:
                switch (rapport.typeInfo) {
                  case 'PortalModel':
                    getPortalModel(rapport, currentselect);
                    break;
                  case 'StaticModel':
                    window.open(
                      '/services/'+localStorage.getItem('portal')+'/files/getfilestatic?ftiname=' +
                        scope.fti.name +
                        '&filename=' +
                        rapport.file
                    );
                    break;
                  case 'JasperModel':
                    generateJasperDoc(rapport, currentselect);
                    break;
                }
                break;
            }
          } else {
            var promisses = [];
            var FullDataGenerate = [];
            for (var i = 0; i < action.rapports.length; i++) {
              var rapport = action.rapports[i];
              switch (rapport.type) {
                case 'PortalModel':
                case $filter('translate')(
                  'model.featuretypes.actions.PortalModel'
                ):
                  generatePortalReportFromDocX(
                    currentselect,
                    rapport,
                    promisses
                  );
                  break;
                case 'StaticModel':
                case $filter('translate')(
                  'model.featuretypes.actions.StaticModel'
                ):
                  FullDataGenerate.push({
                    type: 'StaticModel',
                    file: rapport.file,
                    ftiname: scope.fti.name,
                  });
                  break;
                case 'JasperModel':
                case $filter('translate')(
                  'model.featuretypes.actions.JasperModel'
                ):
                  generateJasperReport(currentselect, rapport, promisses);
                  break;
              }
            }
            $q.all(promisses).then(function() {
              FilesFactory.getActionsGeneratedZip(FullDataGenerate).then(
                function(res) {
                  window.open(
                    '/services/' +
                      angular.module('gcMain').portalid +
                      '/files/getgeneratedzip?filename=' +
                      res.data.filename
                  );
                },
                function() {
                  require('toastr').error('error');
                }
              );
            });
          }
        }

        function JasperOnComponent(action, geoj) {
          var rapport = action.rapports[0];
          //generateJasperDoc(rapport , geoj);
          var features = geoj.features;
          var sendata = [];
          angular.forEach(features, function(feature) {
            sendata.push(generateSendata(rapport, feature));
          });
          const execStoreName = scope.fti.type === 'esri' && rapport.storeName ? rapport.storeName : scope.fti.storeName;
          ReportIndicatorFactory.generateMultipleReportExtended(
            rapport.file,
            execStoreName,
            sendata
          ).then(
            function(res) {
              if (res.data.etat === 'fini') {
                window.open(
                  '/services/' +
                    angular.module('gcMain').portalid +
                    '/indicator/' +
                    angular.module('gcMain').app +
                    '/getgeneratedzip?filename=' +
                    res.data.file
                );
              } else {
                require('toastr').error('error');
              }
            },
            function() {
              require('toastr').error('error');
            }
          );
        }

        const generateJasperDocWhithoutDownload = (rapport, currentselect) => {
          const sendata = generateSendata(rapport, currentselect);
          const execStoreName = scope.fti.type==='esri' && rapport.storeName ? rapport.storeName : scope.fti.storeName;
          if (!rapport.format || rapport.format.length===0){
            rapport.format = 'pdf';
          }
          const promise = ReportIndicatorFactory.generateReportExtended(
            rapport.file,
            execStoreName,
            sendata,
            rapport.format,
            false
          );
          promise.then(
            (res) => {
              if (!res.data.pdfdone)
                require('toastr').error(
                  $filter('translate')(
                    'model.featuretypes.actions.unabletogeneratepdf'
                  ) +
                    ' ' +
                    rapport.file
                );
            },
            () => {
              require('toastr').error(
                $filter('translate')(
                  'model.featuretypes.actions.unabletogeneratepdf'
                ) +
                  ' ' +
                  rapport.file
              );
            }
          );
          return promise;
        };

        const generateJasperDoc = (rapport, currentselect) => {
          const sendata = generateSendata(rapport, currentselect);
          const execStoreName = scope.fti.type==='esri' && rapport.storeName ? rapport.storeName : scope.fti.storeName;
          if (!rapport.format || rapport.format.length===0){
            rapport.format = 'pdf';
          }
          ReportIndicatorFactory.generateReportExtended(
            rapport.file,
            execStoreName,
            sendata,
            rapport.format,
            false
          ).then(
            (res) => {
              if (res.data.pdfdone) {
                ReportIndicatorFactory.getPdf(res.data.fileNameGenerated,rapport.format).then(
                  (data) => {
                    const resultObject = data.data;
                    const blob
                      = new Blob([resultObject], gaJsUtils.applicationTypes[rapport.format]);
                    const objectUrl = URL.createObjectURL(blob);
                    window.open(objectUrl);
                  },
                  () => {
                    require('toastr').error(
                      $filter('translate')('model.featuretypes.actions.unableToDownloadFile')
                        + rapport.format);
                  }
                );
              } else {
                require('toastr').error(
                  $filter('translate')(
                    'model.featuretypes.actions.unabletogeneratepdf'
                  ) +
                    ' ' +
                    rapport.file
                );
              }
            },
            () => {
              require('toastr').error(
                $filter('translate')(
                  'model.featuretypes.actions.unabletogeneratepdf'
                ) +
                  ' ' +
                  rapport.file
              );
            }
          );
        };

        const generateSendata = (rapport, currentselect) => {
          var res = {};
          angular.forEach(rapport.parameters, (param) => {
            switch (param.saisieMode) {
              case $filter(
                'translate'
              )('model.featuretypes.actions.saisieAttribut'):
                if (param.attribut === 'id') {
                  res[param.name] = Number(
                    currentselect.id.replace(scope.fti.name + '.', '')
                  );
                } else {
                  res[param.name] = currentselect.properties[param.attribut];
                }
                break;
              default:
                switch (param.saisieMode) {
                  case 'saisieAttribut':
                    if (param.attribut === 'id') {
                      res[param.name] = Number(
                        currentselect.id.replace(scope.fti.name + '.', '')
                      );
                    } else {
                      res[param.name] =
                        currentselect.properties[param.attribut];
                    }
                    break;
                  default:
                    res[param.name] = param.value;
                    break;
                }
                break;
            }
          });
          return res;
        };

        function getPortalDoc(currentselect) {
          scope.relatedfeature = {
            features: [],
          };
          var res = {
            current: currentselect,
          };
          var idsNames = getNamesIds();
          res = createSendMessage(res, idsNames);

          return res;
        }

        function createSendMessage(res, idsNames) {
          var relationN = idsNames[2];
          var features = idsNames[3];
          var uniqueRelationNames = angular.copy(relationN);
          uniqueRelationNames = $.unique(uniqueRelationNames);
          for (var i = 0; i < uniqueRelationNames.length; i++) {
            var arr = [];
            for (var j = 0; j < relationN.length; j++) {
              if (relationN[j] === uniqueRelationNames[i])
                arr.push(features[j]);
            }
            res[uniqueRelationNames[i]] = arr;
          }

          return res;
        }

        function getNamesIds() {
          var ids = [];
          var names = [];
          var relationN = [];
          var features = [];
          var relations = scope.fti.relations;
          var relationsComponentsEnd = [];
          var relationsNames = [];
          relations.map(function(x) {
            if (x.componentEnd) {
              relationsComponentsEnd.push(x.componentEnd);
              relationsNames.push(x.name);
            }
          });
          for (var i = 0; i < scope.relatedfeature.features.length; i++) {
            var feature = scope.relatedfeature.features[i];
            var id = feature.id;
            var name = id.substring(0, id.lastIndexOf('.'));
            if (relationsComponentsEnd.indexOf(name) !== -1) {
              ids.push(id);
              names.push(name);
              features.push(feature);
              relationN.push(
                relationsNames[relationsComponentsEnd.indexOf(name)]
              );
            }
          }

          return [ids, names, relationN, features];
        }

        /**
         * A chaque mise à jour du dom,
         * renvoie true si la largeur de la popup est inférieure à 780px
         * ajoute des modifications de mise en page spécifique suivant l'onglet
         * et la largeur de la popup
         * @param viewMode search/consult...
         * @return {boolean} est true si la largeur de la popup est inférieure à 780px
         */
        scope.adaptPopupSizeByViewMode = (viewMode) => {
          return MajicFactory.adaptPopupSizeByViewMode(viewMode, true);
        };
      },
    };
  };

  toolbarselecttoolutilities.$inject = [
    '$http',
    'SelectManager',
    'gclayers',
    'gcPopup',
    '$filter',
    'gcRestrictionProvider',
    'extendedNgDialog',
    'ConfigFactory',
    'FeatureTypeFactory',
    'ngDialog',
    'ReportIndicatorFactory',
    'FilesFactory',
    '$q',
    'DocumentFactory',
    'ngTableParams',
    '$rootScope',
    'EditFactory',
    'gcInteractions',
    'AncAppFactory',
    'BacAppFactory',
    'ApplicationFactory',
    'QueryFactory',
    'EditRulesFactory',
    'EditTypesFactory',
    'FeatureAttachmentFactory',
    'ObjectFilesFactory',
    'gaJsUtils',
    'MajicFactory',
    '$timeout',
    'selecttoolbypointutilitiesservice',
    'PortalsFactory',
    'RightsFactory',
    'bizeditProvider'
  ];

  return toolbarselecttoolutilities;
});