'use strict';
define(function() {
  var affinageCtrl = function(
    $scope,
    $location,
    ParametersFactory,
    SirocoFactory,
    gaDomUtils,
    $timeout,
    $rootScope
  ) {
    $scope.currentVariante = {};
    var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));

    var getListeVariantes = function() {
      ParametersFactory.getbytype('siroco_variante').then(function(res) {
        if (res.data.length > 0) {
          $scope.variantesList = [];
          res.data.forEach(function(cfg) {
            if (cfg.data.app == sirocoCfg.appuid && cfg.data.Generee == 'oui') {
              $scope.variantesList.push(cfg.name);
            }
          });
        }
      });
    };

    getListeVariantes();

    $scope.seuilChoice = {};
    $scope.seuilsList = [
      { key: 'cout', label: 'Enveloppe Budgétaire' },
      { key: 'lineaire', label: '% du linéaire total' },
    ];

    $scope.tranches = {};

    $scope.afterChantierUpdate = function(res, tranches) {
      /*
         SirocoFactory.checkGeneration(res.data.strValeur,"","ActualiserChantiers","CheckTreatment").then(function(res){
            if(res.data.ok){
    */
      SirocoFactory.generationgraphe(
        sirocoCfg.appname,
        'Efficacite',
        '',
        tranches.join(';'),
        $scope.seuilChoice.value,
        '',
        $scope.currentVariante.name
      ).then(function(res) {
        gaDomUtils.setGlobalLoaderScaleValue(100);
        $timeout(function() {
          require('toastr').success("Calcul de l'efficacité terminé");
          gaDomUtils.hideGlobalLoader();
          $scope.efficaciteResult = { src: res.data.strValeur };
          $rootScope.$broadcast('siroco.activateNavigationResults');
          // reload the frame
          document
            .getElementById('comparoFrame')
            .contentDocument.location.reload();
        }, 1000);
      });
      /*
            }else{
                require('toastr').error(res.data.errorMessage,
                    "Erreur lors du calcul de l'efficacité",
                    {"closeButton": true,"timeOut": "0","extendedTimeOut": "0", "positionClass": "toast-bottom-full-width"}
                );
                gaDomUtils.hideGlobalLoader();
            }
         });
    */
    };

    /**
     * select Variante
     */
    $scope.selectVariante = function() {
      var tranches = [];
      for (var i in $scope.tranches) {
        tranches.push($scope.tranches[i].value);
      }

      gaDomUtils.showGlobalLoader();
      gaDomUtils.setGlobalLoaderScale(0, 100);

      SirocoFactory.choixvariante(
        $scope.seuilChoice.value,
        sirocoCfg.appname,
        $scope.currentVariante.name,
        '',
        tranches.join(';')
      ).then(
        function(res) {
          if (res.data.ok) {
            SirocoFactory.checkGeneration(
              res.data.strValeur,
              $scope.currentVariante.name,
              'ChoixVariante',
              'CheckTreatment'
            ).then(function() {
              SirocoFactory.actualiserchantiers('actualiser_chantiers').then(
                function(res) {
                  $scope.afterChantierUpdate(res, tranches);
                }
              );
            });
          } else {
            require('toastr').error(
              res.data.errorMessage,
              'Erreur lors de la sélection du scénario',
              {
                closeButton: true,
                timeOut: '0',
                extendedTimeOut: '0',
                positionClass: 'toast-bottom-full-width',
              }
            );
            gaDomUtils.hideGlobalLoader();
          }
          // error
        },
        function() {
          require('toastr').error('Erreur');
          gaDomUtils.hideGlobalLoader();
        }
      );
    };
  };

  affinageCtrl.$inject = [
    '$scope',
    '$location',
    'ParametersFactory',
    'SirocoFactory',
    'gaDomUtils',
    '$timeout',
    '$rootScope',
  ];
  return affinageCtrl;
});
