'use strict';
define(function() {
  var formBuilderFti = function(ngDialog) {
    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/formBuilderFti.html',
      restrict: 'EA',
      scope: {
        res: '=',
      },
      link: function(scope, element, attrs, ctrl) {
        scope.myfti = {};
        if (angular.isDefined(scope.res)) {
          scope.myfti.uid = scope.res;
        }

        scope.lines = angular.isArray(scope.res) ? scope.res : '';
        /**
         * Update res
         */
        scope.$watch(
          'myfti',
          function(myfti) {
            scope.res = myfti.uid;
          },
          1
        );
      },
    };
  };

  formBuilderFti.$inject = ['ngDialog'];
  return formBuilderFti;
});
