'use strict';
define(function() {
  let dateUtils = function(
  ) {

    let convertAllDatesToTimestamps = (properties, datePropertiesToConvert)=> {
      for (let prop of datePropertiesToConvert){
        if (properties && properties.hasOwnProperty(prop) && properties[prop]
          && isValidDate(properties[prop])){
          if (Number.isInteger( properties[prop])) {
            properties[prop] = properties[prop];
          }
          else {
            properties[prop] = Date.parse(properties[prop].toString());
          }
        }
      }
    };

    let convertAllDatesToDateString = (properties, datePropertiesToConvert)=> {
      for (let prop of datePropertiesToConvert) {
        if (properties && properties.hasOwnProperty(prop) && properties[prop]
          && isValidDate(properties[prop])) {
          properties[prop] = new Date(properties[prop]).toISOString();
        }
      }
    };

    let isValidDate = (param)=>{
      let date;
      try {
        date = new Date(param);
      }
      catch(err){
        return false;
      }
      if (date && Object.prototype.toString.call(date) === "[object Date]") {
        if (isNaN(date.getTime())) {
        return false;
        } else {
          return true;
        }
      } else {
        return false;
      }
    };

    let isValidDateAndExists = (param)=>{
      if (param === null) {
        return false;
      }
      return isValidDate(param);
    };

    /**
     * @param {Date} startDate 
     * @param {Date} endDate 
     * @param {String} resultUnit should be one of the following:
     *      year, month, week, day, hour
     * @returns the number of year (or month/week/day/hour) between startDate and endDate.
     * in case of 'hour' the result is a double otherwise it's an integer.
     */
    const intervalBetween2Dates = (startDate, endDate, resultUnit) => {
      const beginning = moment(startDate);
      const end = moment(endDate);
      switch (resultUnit) {
        case 'year':
        case 'month':
        case 'week':
        case 'day':
          return end.diff(beginning, resultUnit);
        case 'hour':
          // we need to ask for 'minutes' because the result is rounded (integer) and we want decimals.
          const minutes = end.diff(beginning, 'minute');
          return Math.round(minutes/0.6)/100;
        default:
          console.error("error diffDate(): provided 'resultUnit' is not suported");
          return;
      }
    };

    return {
      convertAllDatesToTimestamps:convertAllDatesToTimestamps,
      convertAllDatesToDateString:convertAllDatesToDateString,
      isValidDateAndExists: isValidDateAndExists,
      intervalBetween2Dates: intervalBetween2Dates
    };
  };

  return dateUtils;
});
