/**
 * Extraire une image de la carte sur son étendue complète dans le but initial
 * de la transmettre à un rapport jasper":
 *
 * -- Description de la fonction pour la configuration.
 *
 * -- Affichage de la popup de gestion du snapshot
 *
 * -- Les paramètres en sortie sont :
 *    -- une variable qui contiendra le résultat.
 *       Elle est construite avec 1 property qui a le nom de la variable
 *       dont la valeur est une chaine de caractères
 *       qui est l'image en base 64.
 *
 * Auteur : @EDG
 * Date: 16/11/2021
 */
'use strict';
define(function () {
  const snapshotfunction = function () {
    this.$get = function (extendedNgDialog, $q, $rootScope, $filter) {

      const thisScope = $rootScope.$new(true);


      const init = () => {
        thisScope.nextTitle = $filter('translate')(
          'functions_browser.functions.snapshot.nextTitle')
      };

      init();


      /**
       * Activation de la commande de capture par l'opérateur.
       * -> Réalisation de la capture avec stockage
       *    dans "thisScope.snapshotImage" qui est le ng-src
       *    de la balise "img" de la popup de snapshot.
       */
      thisScope.doTheSnapshot = () => {
        thisScope.map.once('postcompose', (event) => {
          const canvas = event.context.canvas;
          const newCanvas = document.createElement('canvas');

          //-- Extraction de la région de la carte à mettre dans le rapport.
          const sz = thisScope.map.getSize();
          newCanvas.width = sz[0];
          newCanvas.height = sz[1];
          const newContext = newCanvas.getContext('2d');
          newContext.drawImage(canvas,0,0,sz[0],sz[1]);
          thisScope.snapshotImage = newCanvas.toDataURL('image/png');
        });
        thisScope.map.renderSync();
      };


      /**
       * Avant de passer à la suite, on stocke le résultat dans
       * la variable demandée, puis, on "résoud" la promesse.
       * La promesse bloque le passage à la fonction suivante
       * tant qu'elle n'est ni résolu ni rejetée.
       */
      thisScope.preCloseActions = () => {
        if (thisScope.snapshotImage) {
          //-- Positionner le résultat
          if (!thisScope.formRes.miscResult) {
            thisScope.formRes.miscResult = {};
          }
          thisScope.formRes.miscResult[thisScope.resultContent]
            = angular.copy(thisScope.snapshotImage).replace(
              'data:image/png;base64,', '');
          delete thisScope.snapshotImage;
        }
        if (thisScope.parentForm) {
          thisScope.parentForm.features.show();
        }
        //-- Fin de la promesse
        thisScope.defer.resolve();
      };


      /**
       * Avant de passer à la suite, on stocke le résultat dans
       * la variable demandée, puis, on "résoud" la promesse.
       * La promesse bloque le passage à la fonction suivante
       * tant qu'elle n'est ni résolu ni rejetée.
       */
      thisScope.closeSnapshot = (doNotClose) => {
        thisScope.preCloseActions();
        //-- Fermer la popup et ouvrir le formulaire
        //-- depuis lequel l'action a été lancée
        if (doNotClose !== true) {
          thisScope.dlg.close();
        }
      };


      const openSnapShotDialog = () => {
        thisScope.dlg = extendedNgDialog.open({
          template: 'js/XG/widgets/utilities/form/views/gc_formfunctions/snapshotfunction.html',
          className: 'ngdialog-theme-plain nopadding miniclose',
          closeByDocument: false,
          scope: thisScope,
          draggable: true,
          title: $filter('translate')(
            'functions_browser.functions.snapshot.popuptitle'),
          preCloseCallback: function() {
            thisScope.closeSnapshot(true);
          },
        });
      };


      /**
       * Retourne les points d'entrée de ce provider:
       * -1- getParametersDesc: Description des paramétres
       *               pour configuration de la "function".
       * -2- searchUpDownStream: fonction appelé depuis "gc_formfunction"
       *               quand cette foncyionnalité est sollicitée
       *               depuis un formulaire.
       */
      return {
        /**
         * la description retournée est exploitée dans functionsBrowser.html.
         *
         * @returns : description des paramétres de la fonction
         */
        getParametersDesc: () => {

          return [
            [0, 'variable']
          ];
        },

        /**
         * Ouverture de la fenêtre pour prendre la capture écran.
         */
        openSnapshotPopUp: (formRes, map, parentForm, variable) => {
          thisScope.defer = $q.defer();

          thisScope.map = map;
          thisScope.resultContent = variable;
          thisScope.formRes = formRes;
          if (parentForm) {
            //-- Récupérer le formulaire parent quand il est fourni.
            thisScope.parentForm = parentForm;
            parentForm.features.hide();
          }

          openSnapShotDialog();

          return thisScope.defer.promise;
        }
      };
    };

    this.$get.$inject = ['extendedNgDialog', '$q', '$rootScope',
      '$filter',];
  };
  return snapshotfunction;
});
