'use strict';
define(function() {
  var itvSoumission = function(ngTableParams, $compile) {
    return {
      templateUrl:
        'js/XG/widgets/utilities/itv/views/visualisation/itvVisualisationHeaders.html',
      restrict: 'A',
      scope: {
        headers: '=headers',
      },

      controller: [
        '$scope',
        '$element',
        '$attrs',
        function($scope, $element, $attrs) {},
      ],

      link: function(scope, elt, attrs, ctrl) {
        var s = ['alias', '_code', 'value'];
        function addColumn(s) {
          var str =
            '<table ng-table="HeaderParams" class="table table-stripped table-bordered table-hover" style="font-size:9px;">' +
            '<tr ng-repeat="partheader in $data" ng-repeat-end >';
          for (var i = 0; i < s.length; i++) {
            if (s[i] == 'matchedAutomatically' || s[i] == 'validated') {
              str =
                str +
                '<td title="\'itv.correspondance.matched\'| translate" style="text-align:center;" style="font-size:9px;">' +
                "<span ng-class=\"{'glyphicon glyphicon-ok btn-success': partheader.validated, 'glyphicon glyphicon-ok btn-warning'" +
                ": partheader.matchedAutomatically && !partheader.validated ,'glyphicon glyphicon-remove btn-danger':!partheader.matchedAutomatically && !partheader.validated }\"></span>" +
                '</td>';
            } else {
              str =
                str +
                '<td data-title="\'itv.correspondance.' +
                s[i] +
                '\' | translate" ' +
                ' style="font-size:9px;">' +
                '{{partheader.' +
                s[i] +
                '}}' +
                '</td>';
            }
          }
          str = str + '</tr></table>';
          angular.element('.Headers').append(str);
        }

        addColumn(s);

        var data = scope.headers;
        scope.HeaderParams = new ngTableParams(
          {
            page: 1,
            count: 5,
            //group : $filter('translate')('itv.correspondance.parts')
          },
          {
            total: data.length,
            counts: [5, 10, 20, 100],
            getData: function($defer, params) {
              data = scope.headers;
              params.total(data.length);
              $defer.resolve(
                data.slice(
                  (params.page() - 1) * params.count(),
                  params.page() * params.count()
                )
              );
            },
          }
        );
        try {
          $compile(angular.element('.Headers'))(scope);
        } catch (e) {
          console.info(e.message);
        }
      },
    };
  };

  itvSoumission.$inject = ['ngTableParams', '$compile'];
  return itvSoumission;
});
