'use strict';
define(function () {
  const itvsoumFactory = function (QueryFactory, FeatureTypeFactory, gaJsUtils,
    itvStylesFactory,ogcFactory, $q, $filter) {
    const itvoperationalLayers = new ol.Collection();

    const GEOJSON_FORMAT = new ol.format.GeoJSON();



    const addItvOperationalLayers = (layer) => {
      let layersAsArray = itvoperationalLayers.getArray();
      const layerName = layer.getProperties().name;
      for (let ind = layersAsArray.length-1;  ind>=0; ind--) {
        if (layersAsArray[ind].getProperties().name === layerName) {
          itvoperationalLayers.removeAt(ind);
        }
      }
      itvoperationalLayers.push(layer);
    };


    const clearitvoperationalLayers = (layerName) => {
      const layers = itvoperationalLayers.getArray();
      for (const layer of layers) {
        if (!layerName || layer.getProperties().name === layerName) {
          layer.getSource().clear();
        }
      }
      itvoperationalLayers.clear();
    };


    const getitvoperationalLayers = () => {
      return itvoperationalLayers.getArray();
    };



    const iconmatch = (d, color) => {
      switch (color) {
        case 'color':
          if (d.matched) {
            return 'green';
          } else if (!d.matched && d.matchedAuto) {
            return 'orange';
          } else {
            return 'red';
          }
        case 'text':
          if (d.matched) {
            return '\uf00c';
          } else if (!d.matched && d.matchedAuto) {
            return '\uf00c';
          } else {
            return '\uf00d';
          }
      }
    };





    const originSourceCANAL = new ol.source.Vector({
      //create empty vector
    });

    const originSourceRegard = new ol.source.Vector({
      //create empty vector
    });


    let originCanaLayer;
    const clearoriginsourcecanal = () => {
      originSourceCANAL.clear();
      originCanaLayer = undefined;
    };


    const clearOriginSourceRegard = () => {
      originSourceRegard.clear();
    };


    const clearAllSources = () => {
      clearoriginsourcecanal();
      clearOriginSourceRegard();
    };

    /**
     * Créé des features openlayers à partir de features geojson et insère ces objets dans une source donnée avec un stylea
     * @param {[]} features tableau de features en geojson à insérer dans la source
     * @param {ol.source.Vector} source source d'une layer openlayers
     * @param {ol.style.Style} style style openlayers à attribuer aux features du tableau
     * @param {string} name nom de la feature à ajouter
     * @param {string|number|null} id id de la feature à ajouter
     */
    const addGeometriesToSource = (features, source, style, names, ids) => {
      for (let i = 0; i < features.length; i++) {
        const olGeometry = GEOJSON_FORMAT.readGeometry(
          features[i].geometry
        );
        let name;
        if (Array.isArray(names) && i < names.length) {
          name = names[i];
        } else {
          name = '';
        }
        const olFeature = new ol.Feature({ name: name, geometry: olGeometry });
        if (Array.isArray(ids) && i < ids.length) {
          olFeature.setId(ids[i]);
        }
        olFeature.setStyle(style);
        source.addFeature(olFeature);
      }
    };


    const defineLayer = (style, res, name) => {
      if (res.data.features.length == 0) return;

      let originSource;
      let originLayer;
      if (name == 'canal') {
        originSource = originSourceCANAL;
        originLayer = originCanaLayer;
        if (originLayer) {
          //-- Cas de requête qui a récupére un ou des tronçons supplémentaires.
          originLayer.getProperties().features.push(res.data.features[0]);
        }
      }
      else {
        originSource = originSourceRegard;
      }

      addGeometriesToSource(res.data.features, originSource, style, null, null);

      //-- Mettre les ponctuels par dessus les traits.
      const priority = name === 'canal' ? 10001 : 10002;
      if (!originLayer) {
        originLayer = new ol.layer.Vector({
          source: originSource,
          style: style,
          name: name,
          feature: res.data.features[0],
          features: res.data.features,
          zIndex: priority
        });
        addItvOperationalLayers(originLayer);
        if (name === 'canal') {
          originCanaLayer = originLayer;
        }
      }
    };


    /**
     * Dessine sur la carte un des objets mis en correspondance.
     *
     * @param {*} featUID   UID du composant contenant les objets à chercher
     * @param {*} objectID  id GeoTools des objets à récupérer
     *                      (donc OBJECTID pour ArcGIS quelque soit le cas)
     * @param {*} crs       Coordinate Reference System pour le query
     * @param {*} position  Permet de définir le style du dessin de l'objet
     *                      sur la carte, valeurs possibles: 'amont, 'aval',
     *                      'canal', 'center' et 'alone'.
     * @returns promesse qui se résoud une fois le dessin fait
     */
    function drawFeature(featUID, objectID, crs, position) {
      var promise = QueryFactory.get(featUID, objectID, crs);
      promise.then((res) => {
        switch(position) {
          case 'amont':
            defineLayer(itvStylesFactory.NODE_AMONT, res, 'amont');
            break;
          case 'aval':
            defineLayer(itvStylesFactory.NODE_AVAL, res, 'aval');
            break;
          case 'center':
            defineLayer(itvStylesFactory.CANALISATION_STYLE, res, 'canal');
            break;
          case 'centerBranchement':
            defineLayer(itvStylesFactory.BRANCHEMENT_STYLE, res, 'canal');
            break;
          default:
            defineLayer(itvStylesFactory.NODE_ALONE, res, 'alone');
        }
      });
      return promise;
    }


    /**
     * Efface les références aux ouvrages du header
     * ITV référençant un ouvrage (AAB, AAD, AAA, AAF, ou CAA).
     */
    const clearHeaderIds = (header) => {
      const partHeader = header.partHeader;
      partHeader.values.splice(0,partHeader.values.length);
      partHeader.featUids.splice(0,partHeader.featUids.length);
      partHeader.value = partHeader.featUid = undefined;
      if (partHeader.featIds4Net) {
        partHeader.featIds4Net.splice(0,partHeader.featIds4Net.length);
      }
      partHeader.featId4Net = undefined;
    };


    /**
     * Change l'entête afin qu'elle désigne la feaature voulue.
     *
     * @param {boolean} id4Net Si VRAI, il faut affecter
     *                         les propriétés de l'entête suffixées "4Net".
     * @param {object} header Entête à traiter
     * @param {object} feature Feature désigéne (identifiée) par l'entête
     */
    const setId4Net = (id4Net, header, feature) => {
      if (id4Net) {
        if (!header.featIds4Net) {
          header.featIds4Net = [];
        }
        header.featIds4Net.splice(0, header.featIds4Net.length);
        header.featIds4Net.push(feature.id);
        header.featId4Net = feature.id;
      }
    };


    /**
     * Met dans le champ "value" d'un header AAA, AAB, AAD, ou AAF
     * la valeur du champ identifiant. Dans le cas d'ArcGIS avec
     * un champ identifiant configuré sur le portail, on utilise celui-ci.
     * Mais comme on a besoin de l'objectid par ailleurs, on le stocke
     * dans featId4Net.
     */
    const setHeaderId = (ftiUid, feature, header, ind, id4Net) => {
      const fti = FeatureTypeFactory.getFeatureByUid(ftiUid);

      header.featUid = ftiUid;
      const idVal = gaJsUtils.getIdInCaseEsriId(feature, fti);
      if (ind!=undefined) {
        header.values.push(idVal);
        setId4Net(id4Net, header, feature);
      }
      else {
        header.value = idVal;
        if (header.values) {
          //-- Quand la liste des valeurs existe,
          //-- elle doit etre synchrone avec la valeur
          //-- (cas des regards, pas des tronçons)
          header.values.splice(0, header.values.length);
          header.values.push(idVal);
          setId4Net(id4Net, header, feature);
        }
      }
      if ((fti.type === 'esri' && fti.esriIdField !== 'objectid')
             || fti.type !== 'esri') {
        if (ind!=undefined) {

          if (!header.featIds4Net) {
            header.featIds4Net = [];
          }
          header.featIds4Net.push(feature.id);
        }
        else {
          header.featId4Net = feature.id;
        }
      }
    };

    // Fonction pour regrouper les IDs par composant
    const groupIdsByComponent = (headersUid) => {
      return headersUid.reduce((obj, item) => {
        const [table, id] = item.split('.');
        if (!obj[table]) {
          obj[table] = [];
        }
        obj[table].push(id);
        return obj;
      }, {});
    }
    /** ZoomOnList */
    //Visualiser les éléments en correspondance
    const zoomOnList = (scope,noMatchWarning = true) => {
      const defer = $q.defer();
      const filteredCodes = ['AAA', 'AAD', 'AAF', 'AAT', '@01'];
      scope.partsOfCurrentItv
        = scope.partsOfCurrentItv ? scope.partsOfCurrentItv : scope.$parent.partsOfCurrentItv;
      const filteredParts = scope.partsOfCurrentItv.filter(
        part => (part.matchedAutomatically || part.validated ) && !part.ignorePortion);
      const headersUid = [];
      let allPromises = [];
      // extraire les headers qui ont un matchedAutomatically ou validated true
      filteredParts.forEach(part => {
        /* Sélection des codes à filtrer en fonction du type d’équipement.
          Si c’est un branchement, on ne garde que le code '@01' afin d’éviter
          les effets de bord causés par des éléments qui peuvent aussi appartenir
          au collecteur lié au branchement.
        */
        const codesToFilter
          = part.natureEquipement === 'Branchement' ? ['@01','AAT'] : filteredCodes;
        part.partHeaders
          .filter(header => codesToFilter.includes(header.code))
          .forEach(item => {
            if (item && item.featId4Net) {
              headersUid.push(item.featId4Net);
            } else if (item && item.featIds4Net && item.featIds4Net.length > 0) {
              for(let featId of item.featIds4Net) {
                headersUid.push(featId);
              }
            }
          });
      });
      // coustruire un json qui regroupe chaque composant avec ses ids
      const groupedIds = groupIdsByComponent(headersUid);
      for (let tableName in groupedIds) {
        // on construit un tableau des ids en supprimant les doublons en utilisant un Set
        let uniqueIds = Array.from(new Set(groupedIds[tableName]));
        let cql_filter = "IN('" + uniqueIds.join("','") + "')";
        let uid = FeatureTypeFactory.getFeatureUidByName(tableName);
        let projection = scope.map.getView().getProjection().getCode();
        let promise = ogcFactory.getfeatures(
          'GetFeature',
          'WFS',
          '1.0.0',
          uid,
          'json',
          projection,
          cql_filter
        );

        allPromises.push(promise.then((res) => {
          if (res.data.features && Array.isArray(res.data.features)) {
            return res.data.features;
          } else {
            return [];
          }
        }));
      }

      Promise.all(allPromises).then((promise) => {
        let features = promise.flat();
        if (features.length > 0) {
          scope.zoomOnFeatures(features);
        } else if (noMatchWarning) {
          require('toastr').warning(
            $filter('translate')('itv.correspondance.listMenu.warningMsg'));
        }
        defer.resolve(features);
      });
      return defer.promise;
    };


    return {
      getitvoperationalLayers: getitvoperationalLayers,
      clearitvoperationalLayers: clearitvoperationalLayers,
      iconmatch: iconmatch,
      drawFeature: drawFeature,
      clearoriginsourcecanal: clearoriginsourcecanal,
      clearAllSources: clearAllSources,
      setHeaderId: setHeaderId,
      defineLayer: defineLayer,
      clearHeaderIds: clearHeaderIds,
      originSourceCANAL: originSourceCANAL,
      addGeometriesToSource: addGeometriesToSource,
      zoomOnList: zoomOnList
    };
  };
  itvsoumFactory.$inject = [ 'QueryFactory', 'FeatureTypeFactory', 'gaJsUtils',
    'itvStylesFactory','ogcFactory', '$q','$filter'];
  return itvsoumFactory;
});
