'use strict';
define(function() {
  var gcelement = function(NetworkFactory, $timeout, gcInteractions, $rootScope, $filter, SelectManager, gaJsUtils, mapJsUtils) {
    var FEATURE_COLLECTION_TEMPLATE = {
      type: 'FeatureCollection',
      features: [],
    };

    var NOEUD_AMONT_STYLE = new ol.style.Style({
      image: new ol.style.Icon(
        /** @type {olx.style.IconOptions} */ ({
          anchor: [0.5, 46],
          anchorXUnits: 'fraction',
          anchorYUnits: 'pixels',
          opacity: 0.75,
          src: 'img/widget/network/noeudamont.png',
        })
      ),
    });



    var PATH_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        width: 10,
        color: 'rgba(255, 117, 26, 0.7)'
      }),
      zIndex: 10001,
    });

    var VALID_PATH_STYLE = new ol.style.Style({
      stroke: new ol.style.Stroke({
        width: 10,
        color: 'rgba(26, 140, 255, 0.7)'
      }),
      zIndex: 10002,
    });

    var GEOJSON_FORMAT = new ol.format.GeoJSON();

    var styles = {
      MultiPolygon: [
        new ol.style.Style({
          stroke: new ol.style.Stroke({
            color: 'yellow',
            width: 1,
          }),
          fill: new ol.style.Fill({
            color: 'rgba(255, 255, 0, 0.1)',
          }),
        }),
      ],
      Polygon: [
        new ol.style.Style({
          stroke: new ol.style.Stroke({
            color: 'blue',
            lineDash: [4],
            width: 3,
          }),
          fill: new ol.style.Fill({
            color: 'rgba(0, 0, 255, 0.7)',
          }),
        }),
      ],
      Point: [
        new ol.style.Style({
          image: new ol.style.Circle({
            radius: 6,
            fill: new ol.style.Fill({
              color: 'rgba(255,255,255,1)',
            }),
            stroke: new ol.style.Stroke({
              color: 'rgba(255,0,0,1)',
            }),
          }),
        }),
      ],
    };

    var styleFunction = function(feature) {
      return styles[feature.getGeometry().getType()];
    };

    var originSource = new ol.source.Vector({
      //create empty vector
    });

    var originLayer = new ol.layer.Vector({
      source: originSource,
      style: styleFunction,
      zIndex: 10001
    });

    var pathsSource = new ol.source.Vector({
      //create empty vector
    });

    var pathsLayer = new ol.layer.Vector({
      source: pathsSource,
      style: styleFunction,
      zIndex: 10001
    });

    var validPathSource = new ol.source.Vector({
      //create empty vector
    });

    var validPathLayer = new ol.layer.Vector({
      source: validPathSource,
      style: styleFunction,
      zIndex: 10001
    });

    var lastNodesSource = new ol.source.Vector({
      //create empty vector
    });
    var lastNodesLayer = new ol.layer.Vector({
      source: lastNodesSource,
      style: styleFunction,
      zIndex: 10001
    });

    // définit un id pour manipuler la layer depuis un composant parent
    validPathLayer.set('id', 'valid-path-layer');
    originLayer.set('id', 'origin-layer');
    pathsLayer.set('id', 'paths-layer');
    lastNodesLayer.set('id', 'last-nodes-layer');


    return {
      templateUrl: 'js/XG/widgets/utilities/network/views/gcpathselect.html',

      restrict: 'A',
      scope: {
        map: '=map',
        netname: '=netname',
        minNodesToParse: '=minnodes',
        maxNodesToParse: '=maxnodes',
        nodesIncrementWalk: '=nodesincr',
        pathprocessconfig: '=pathprocessconfig',
        result: '=res',
        featuresResult: '=?featuresres',
        nfeaturesResult: '=?netfeaturesres',
        toolBarWidget: '=?toolbarwidget',
        onfinish: '&?',
        field: '=?',
        finishDistance: '=?finishdistance', // le parcours se termine dès que la longueur cumulée du path est supérieure ou égale à cette distance
        ignoreGcTypeInteraction: '=?ignoregctypeinteraction', // évite de créer les intéraction avec la propriété 'gcType' = 'kis'
        startDisabled: '=?', // désactive le bouton de démarrage du parcours si true
        noPathValidation: '=?'
      },
      link: function(scope) {
        scope.resultIsNotReady = true;
        var startPathNode;
        scope.endPathNode = null;
        var allPaths = [];
        var map = scope.map;
        if (map==undefined && $rootScope.xgos && $rootScope.xgos.getMapAppMap)
          map = $rootScope.xgos.getMapAppMap();

        var networkName = scope.netname;
        let userDirectionPath = new ol.geom.MultiLineString();

        scope.$watch('netname', function() {
          networkName = scope.netname;
        });

        var pathProcessConfig = null;

        scope.nodesToParse = {
          value: scope.minNodesToParse,
          lastRequestValue: scope.minNodesToParse,
        };
        scope.$watch('minNodesToParse', function() {
          scope.nodesToParse = {
            value: scope.minNodesToParse,
            lastRequestValue: scope.minNodesToParse,
          };
        });

        if (scope.pathprocessconfig)
          pathProcessConfig = simplifyPathProcessConfig(
            scope.pathprocessconfig
          );

        if (map) {
          var inSrid = map
            .getView()
            .getProjection()
            .getCode();
        }

        function activate() {
          map.addLayer(pathsLayer);
          map.addLayer(originLayer);
          map.addLayer(validPathLayer);
          map.addLayer(lastNodesLayer);

          scope.resultIsNotReady = true;

          // Permet de détecter le démarrage d'une session de dessin d'un parcours réseau.
          scope.$emit('networkPathDrawActivation', true);
        }

        /**
         * Désactive les intéractions et
         * supprime les dessins du parcours réseau
         * @param {boolean} keepValidPath est true quand on souhaite garder le dessin du parcours validé
         */
        const deactivate = (keepValidPath = false) => {
          scope.isActive = false;
          if (scope.networkPathSelectInteraction) {
            scope.networkPathSelectInteraction.setActive(false);
            map.removeInteraction(scope.networkPathSelectInteraction);
            scope.networkPathSelectInteraction = null;
          }
          if (scope.networkNodeSelectInteraction) {
            scope.networkNodeSelectInteraction.setActive(false);
            map.removeInteraction(scope.networkNodeSelectInteraction);
            scope.networkNodeSelectInteraction = null;
          }

          map.removeLayer(pathsLayer);
          map.removeLayer(originLayer);
          if (!keepValidPath) {
            map.removeLayer(validPathLayer);
          }
          map.removeLayer(lastNodesLayer);

          pathsSource.clear();
          originSource.clear();
          if (!keepValidPath) {
            validPathSource.clear();
          }
          lastNodesSource.clear();

          startPathNode = null;
          scope.endPathNode = null;
          allPaths = [];
          userDirectionPath = new ol.geom.MultiLineString();

          scope.resultIsNotReady = true;
        };

        function networkPathSelectStart(evt) {
          /*sketchFeature = evt.feature;*/
        }

        function ftypeAttributeValuesToSavePartConfig(fTypeAttributeValues) {
          var elements = [];

          for (var ftiUID in fTypeAttributeValues) {
            var fTypeAttributeValues = fTypeAttributeValues[ftiUID];

            var ftiElements = [];

            angular.forEach(fTypeAttributeValues, function(attributeValue) {
              var attributeFilter = {
                attrName: attributeValue.attributeName,
                value: attributeValue.res[attributeValue.attributeName],
              };

              ftiElements.push(attributeFilter);
            });

            elements.push({
              ftiUID: ftiUID,
              attributesFilters: ftiElements,
            });
          }
          return elements;
        }

        function dataToSavePartConfig(data) {
          var fTypesUIDS = [];
          angular.forEach(data.leftData, function(choosedFType) {
            fTypesUIDS.push(choosedFType.uid);
          });

          return fTypesUIDS;
        }

        function simplifyPathProcessConfig(networkTool) {
          var networkToolConfig = {
            label: networkTool.label,
            toolType: networkTool.toolType,
            amontElements: [],
            avalElements: [],
            networkElements: [],
            amontElementsFilters: [],
            avalElementsFilters: [],
            networkElementsFilters: [],
            addPathAtEnd: false,
          };

          var amontElementsConfigPart = dataToSavePartConfig(
            networkTool.amontElementsData
          );
          var avalElementsConfigPart = dataToSavePartConfig(
            networkTool.avalElementsData
          );
          var networkElementsConfigPart = dataToSavePartConfig(
            networkTool.edgesAndNodesData
          );

          networkToolConfig.amontElements = amontElementsConfigPart;
          networkToolConfig.avalElements = avalElementsConfigPart;
          networkToolConfig.networkElements = networkElementsConfigPart;

          var amontElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAmontEditFTypeAttributeValues
          );
          var avalElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentAvalEditFTypeAttributeValues
          );
          var networkElementsFiltersConfigPart = ftypeAttributeValuesToSavePartConfig(
            networkTool.currentEditFTypeAttributeValues
          );

          networkToolConfig.amontElementsFilters = amontElementsFiltersConfigPart;
          networkToolConfig.avalElementsFilters = avalElementsFiltersConfigPart;
          networkToolConfig.networkElementsFilters = networkElementsFiltersConfigPart;

          return networkToolConfig;
        }

        function networkPathSelectEnd(evt) {
          //scope.features = evt.feature;
          var format = new ol.format.GeoJSON();

          var feature = format.writeFeatureObject(evt.feature);

          scope.resgeometry = feature.geometry;
          var coordX = scope.resgeometry.coordinates[0];
          var coordY = scope.resgeometry.coordinates[1];

          if (scope.pathprocessconfig)
            pathProcessConfig = simplifyPathProcessConfig(
              scope.pathprocessconfig
            );

          scope.nodesToParse.lastRequestValue = scope.nodesToParse.value;

          NetworkFactory.getconnectedelementsxy(
            pathProcessConfig,
            networkName,
            inSrid,
            scope.nodesToParse.lastRequestValue,
            coordX,
            coordY,
            'AMONT'
          ).then(function(res) {
            allPaths = [];
            handlePossiblePaths(res.data, true);
          });
        }

        function activateSelectNextElementsInteraction() {
          map.removeInteraction(scope.networkPathSelectInteraction);
          scope.networkPathSelectInteraction = null;

          scope.networkNodeSelectInteraction = new ol.interaction.Select({
            layers: [lastNodesLayer],
            style: new ol.style.Style({
              fill: new ol.style.Fill({
                color: 'rgba(255, 100, 50, 0.3)',
              }),
              stroke: new ol.style.Stroke({
                width: 2,
                color: 'rgba(255, 100, 50, 0.8)',
              }),
              image: new ol.style.Icon({
                scale: 0.7,
                rotateWithView: false,
                anchor: [0.5, 1],
                anchorXUnits: 'fraction',
                anchorYUnits: 'fraction',
                opacity: 1,
                src: 'img/widget/network/marker.png',
              }),
            }),
            toggleCondition: ol.events.condition.never,
          });

          if (!scope.ignoreGcTypeInteraction) {
            scope.networkNodeSelectInteraction.set('gctype', 'kis');
          }
          scope.networkNodeSelectInteraction.set('interaction', 'Select');
          scope.networkNodeSelectInteraction.set('widget', 'networkpathselect');
          scope.networkNodeSelectInteraction.set('id', 'network-node-select');
          scope.networkNodeSelectInteraction.setActive(true);
          gcInteractions.setCurrentToolBar(scope.toolBarWidget);
          map.addInteraction(scope.networkNodeSelectInteraction);

          scope.networkNodeSelectInteraction.on(
            'select',
            handleNodeSelectedEvent
          );
        }

        function confirmPreviousPathPortion(path) {
          allPaths.push(path);
          var olGeometry = GEOJSON_FORMAT.readGeometry(path.geometry);
          var confirmPath = new ol.Feature({
            name: '',
            geometry: olGeometry,
          });

          confirmPath.setStyle(VALID_PATH_STYLE);

          validPathSource.addFeature(confirmPath);

          // ajoute la portion validée à la géométrie du parcours
          // qui respecte le sens de saisie du parcours (i.e. sens de digit
          // ou inverse)
          addUserDirectionPortion(path);

          // si finishDistance est définie et si le parcours saisi
          // est plus long que la distance à atteindre
          // alors on exécute la validation
          if (scope.finishDistance && isPathContainingDistance()) {

            // lance la construction du résultat du parcours réseau
            // sans supprimer la layer du parcours validé
            handleValidatePath(true);

            scope.hasReachFinishDistance = true;

            // désactive le bouton "valider" (bouton vert avec coche)
            $timeout(()=>{
              scope.resultIsNotReady = true;
            },200);
          }
        }

        function handleNodeSelectedEvent(evt) {
          if (evt.selected.length > 0) {
            var selectedFeature = scope.networkNodeSelectInteraction
              .getFeatures()
              .item(0);
            if (selectedFeature) {
              var path = selectedFeature.get('path');
              scope.endPathNode = selectedFeature.get('node');

              if (scope.pathprocessconfig)
                pathProcessConfig = simplifyPathProcessConfig(
                  scope.pathprocessconfig
                );

              var data = {
                node: scope.endPathNode,
                path: path,
                processConfig: pathProcessConfig,
              };

              scope.nodesToParse.lastRequestValue = scope.nodesToParse.value;

              NetworkFactory.getconnectedelements(
                data,
                networkName,
                inSrid,
                scope.nodesToParse.lastRequestValue
              ).then(function(res) {
                confirmPreviousPathPortion(path);
                if (!scope.hasReachFinishDistance) {
                  handlePossiblePaths(res.data, false);
                }
              });
            }
          }
        }

        function featureAlreadyAdded(features, modelFeatureJSON) {
          for (var i = 0; i < features.length; i++) {
            var featureJSON = features[i];
            if (featureJSON.id == modelFeatureJSON.id) return true;
          }

          return false;
        }

        /**
         * Construit l'objet résultat (scope.result)
         * du parcours réseau comprenant la géométrie du parcours
         * (ol.geom.MultiLineString)
         * et les élements (arcs, noeuds) du parcours réseau.
         * Exécute la désctivation des intéractions sur la carte
         * @param {boolean} keepValidPath est true si on veut garder
         *      l'affichage du parcours réseau après construction du résultat
         */
        const handleValidatePath = (keepValidPath = false) => {
          var resultFeatureCollection = angular.copy(
            FEATURE_COLLECTION_TEMPLATE
          );
          var networkResultFeatureCollection = angular.copy(
            FEATURE_COLLECTION_TEMPLATE
          );
          var mergedPathElements = [];
          var mergedGeometry = new ol.geom.MultiLineString('');
          //var allGeometries = [];
          for (var i = 0; i < allPaths.length; i++) {
            var path = allPaths[i];
            if (mergedPathElements.length != 0) path.elements.shift();

            for (var j = 0; j < path.elements.length; j++) {
              var pathElement = path.elements[j];
              if (pathElement) {
                var modelFeatureJSON = angular.fromJson(
                  pathElement.modelFeature
                );
                if (
                  !featureAlreadyAdded(
                    resultFeatureCollection.features,
                    modelFeatureJSON
                  )
                ) {
                  resultFeatureCollection.features.push(modelFeatureJSON);
                  networkResultFeatureCollection.features.push(
                    angular.fromJson(pathElement.feature)
                  );
                  mergedPathElements.push(pathElement);
                }
              }
            }

            var pathGeometry = GEOJSON_FORMAT.readGeometry(path.geometry);
            if (pathGeometry.getType() == 'LineString')
              mergedGeometry.appendLineString(pathGeometry);
            else {
              for (var k = 0; k < pathGeometry.getLineStrings().length; k++)
                mergedGeometry.appendLineString(pathGeometry.getLineString(k));
            }
          }

          var finalPath = {
            elements: mergedPathElements,
            features: resultFeatureCollection,
            netFeatures: networkResultFeatureCollection,
            geometry: GEOJSON_FORMAT.writeGeometry(mergedGeometry),
            //olGeometry: mergedGeometry
          };

          // Dans le cas d'utilisation des formulaires
          if(scope.field) {
            scope.result[scope.field.config.res] = {
              path: finalPath,
              startPathNode: startPathNode,
              endPathNode: scope.endPathNode,
            };
          }
          else {
            scope.result = {
              path: finalPath,
              startPathNode: startPathNode,
              endPathNode: scope.endPathNode,
              userDirectionPath: userDirectionPath
            };
          }

          scope.featuresResult = resultFeatureCollection;
          scope.nfeaturesResult = networkResultFeatureCollection;

          // Execute l'équivalent de la fonction getElementsNetwork dans le cas d'un formulaire
          if(scope.field && scope.field.config.result) {
            if(scope.field.config.cumulateSelections === true
                && gaJsUtils.notNullAndDefined(scope.result[scope.field.config.result])
                && Array.isArray(scope.result[scope.field.config.result].features)) {

              // Add new features if not already in the featureCollection
              scope.result[scope.field.config.result].features =
                  gaJsUtils.mergeTwoFeatureArrays(
                    finalPath.features.features, scope.result[scope.field.config.result].features);
            }
            else {
              scope.result[scope.field.config.result] = finalPath.features;
            }
            SelectManager.addFeaturesFromGeojson(scope.result[scope.field.config.result]);
          }
          // onfinish n'est pas obligatoire
          if (scope.onfinish && typeof scope.onfinish === 'function') {
            $timeout(scope.onfinish, 100);
          }
          deactivate(keepValidPath);
        };

        function getNextNodeEl(path) {
          return path.elements[path.elements.length - 1];
        }

        function geometryStyle(feature) {
          var style = [],
            geometry_type = feature.getGeometry().getType(),
            white = [255, 255, 255, 1],
            blue = [0, 153, 255, 1],
            width = 3;

          (style['LineString'] = [
            new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: white,
                width: width + 2,
              }),
            }),
            new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: blue,
                width: width,
              }),
            }),
          ]),
          (style['Polygon'] = [
            new ol.style.Style({
              fill: new ol.style.Fill({
                color: [255, 255, 255, 0.5],
              }),
            }),
            new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: white,
                width: 3.5,
              }),
            }),
            new ol.style.Style({
              stroke: new ol.style.Stroke({
                color: blue,
                width: 2.5,
              }),
            }),
          ]),
          (style['Point'] = [
            new ol.style.Style({
              image: new ol.style.Icon({
                scale: 0.7,
                rotateWithView: false,
                anchor: [0.5, 1],
                anchorXUnits: 'fraction',
                anchorYUnits: 'fraction',
                opacity: 1,
                src: 'img/widget/network/marker.png',
              }),
              zIndex: 5,
            }),
          ]);

          return style[geometry_type];
        }


        const handlePossiblePaths = (nextNodePaths, initOrigin) => {
          //ap.un('pointermove', mapOnPointerMove);

          pathsSource.clear();
          lastNodesSource.clear();

          if (initOrigin) {
            if (nextNodePaths.origin == undefined) {
              swal({
                title: $filter('translate')('model.network.browsingError'),
                text: $filter('translate')(
                  'model.network.firstNodeNotSelected'
                ),
                timer: 2500,
              });
              return;
            }
            //-- Dessin du noeud de départ du parcours
            //-- (celui désigné à la souris par l'utilisateur).
            originSource.clear();
            startPathNode = nextNodePaths.origin;
            const olOriginFeature = GEOJSON_FORMAT.readFeature(
              startPathNode.feature
            );
            olOriginFeature.setStyle(NOEUD_AMONT_STYLE);
            originSource.addFeature(olOriginFeature);
          }

          for (const path of nextNodePaths.nextPaths) {
            var olGeometry = GEOJSON_FORMAT.readGeometry(path.geometry);
            var possibleNextPath = new ol.Feature({
              name: '',
              geometry: olGeometry,
            });
            possibleNextPath.setStyle(PATH_STYLE);
            pathsSource.addFeature(possibleNextPath);

            const nextNode = getNextNodeEl(path);
            var olNodeGeometry = GEOJSON_FORMAT.readGeometry(nextNode.projectedGeometry);
            var possibleNextNodeFeature = new ol.Feature({
              name: '',
              geometry: olNodeGeometry,
            });

            possibleNextNodeFeature.set('node', nextNode);
            possibleNextNodeFeature.set('path', path);

            lastNodesSource.addFeature(possibleNextNodeFeature);
          }

          scope.resultIsNotReady = initOrigin;

          if (scope.networkPathSelectInteraction)
            $timeout(activateSelectNextElementsInteraction, 100);
        };


        function compareCoordinates(coord1, coord2) {
          var lon1 = Math.round(coord1[0]);
          var lon2 = Math.round(coord2[0]);
          var lat1 = Math.round(coord1[1]);
          var lat2 = Math.round(coord2[1]);

          var percent_lon = Math.abs(lon1 / lon2 - 1).toFixed(4);
          var percent_lat = Math.abs(lat1 / lat2 - 1).toFixed(4);

          var percent = (Number(percent_lon) + Number(percent_lat) / 2).toFixed(
            4
          );

          return percent;
        }

        function between(number, min, max) {
          if (number >= min && number <= max) return true;
          else return false;
        }

        function toggleActionLaunch() {
          if (
            scope.isActive &&
            scope.networkPathSelectInteraction &&
            scope.networkPathSelectInteraction.getActive()
          ) {
            scope.isActive = false;
            //map.removeInteraction(scope.pointer);
            if (scope.networkPathSelectInteraction) {
              scope.networkPathSelectInteraction.setActive(false);
              map.removeInteraction(scope.networkPathSelectInteraction);
              scope.networkPathSelectInteraction = null;
            }
            if (scope.networkNodeSelectInteraction) {
              console.log('remove here toggle');
              scope.networkNodeSelectInteraction.setActive(false);
              map.removeInteraction(scope.networkNodeSelectInteraction);
              scope.networkNodeSelectInteraction = null;
            }
            //ajouter ce code si on veut enlever la sélection après la désactivation du tool
            //SelectManager.clear();
          }
          else {
            scope.isActive = true;
          }

          if (scope.isActive) {
            scope.networkPathSelectInteraction = new ol.interaction.Draw({
              type: 'Point',
            });

            if (!scope.ignoreGcTypeInteraction) {
              scope.networkPathSelectInteraction.set('gctype', 'kis');
            }
            scope.networkPathSelectInteraction.set('interaction', 'Draw');
            scope.networkPathSelectInteraction.set(
              'widget',
              'networkpathselect'
            );
            scope.networkPathSelectInteraction.set('id', 'network-path-select');
            scope.networkPathSelectInteraction.setActive(true);
            scope.networkPathSelectInteraction.set('id', 'network-path-select');
            gcInteractions.setCurrentToolBar(scope.toolBarWidget);
            map.addInteraction(scope.networkPathSelectInteraction);

            //on start
            scope.networkPathSelectInteraction.on(
              'drawstart',
              networkPathSelectStart
            );

            // on end
            scope.networkPathSelectInteraction.on(
              'drawend',
              networkPathSelectEnd
            );

            if (scope.hasReachFinishDistance) {
              scope.hasReachFinishDistance = false;
            }
            // vide et retire la layer du chemin validé de la carte
            // (au cas où le tracé d'un parcours précédent aurait été préservé)
            validPathCleanRemoval();

            activate();
          }
          else deactivate();
        }

        scope.selectPath = function() {
          toggleActionLaunch();
        };

        /**
         * Exécute la validation du parcours réseau
         */
        scope.validatePath = function() {
          handleValidatePath();
        };

        /**
         * Vérifie si le parcours effectué jusqu'à présent est supérieur à la longueur à atteindre
         * @return {boolean} true si la longueur cumulée des polylignes
         *     du parcours est supérieure à la longueur à atteindre
         */
        const isPathContainingDistance = () => {
          let totalLength = 0;
          for (const path of allPaths) {
            const pathGeometry = GEOJSON_FORMAT.readGeometry(path.geometry);
            if (pathGeometry.getType() === 'LineString') {
              totalLength += pathGeometry.getLength();
            }
            else {
              for (const lineString of pathGeometry.getLineStrings()) {
                totalLength += lineString.getLength();
              }
            }
          }
          console.log('distance accumulée du parcours réseau (m) : ', totalLength);
          return totalLength > scope.finishDistance;
        };

        /**
         * Supprime les features de la layer ol validPathLayer du chemin parcouru validé
         * puis enlève la couche de la carte.
         */
        const validPathCleanRemoval = () => {
          const hasValidPathLayer = scope.map.getLayers().getArray().some(
            layer => layer.get('id') == 'valid-path-layer');
          if (validPathLayer && hasValidPathLayer) {
            if (validPathLayer.getSource()) {
              validPathLayer.getSource().clear();
            }
            scope.map.removeLayer(validPathLayer);
          }
        };

        /**
         * Ajoute la portion de parcours réseau saisie par l'utilisateur
         * en tenant compte du sens de parcours:
         * ajoute la portion à la variable de directive stockant le parcours
         * dans une geométrie <code>ol.geom.MultiLineString</code>
         * pour être restitué à la directive parent:
         *                        <code>fullData.userDirectionPath</code><br>
         * Une portion correspond au tronçon avec ses extrémités cliquées (1 tronçon et 2 noeuds)
         * @param {object} path objet contenant les features de la portion
         *     au format geojson (1 tronçon et 2 noeuds)
         */
        const addUserDirectionPortion = (path) => {

          // méthode interne de addUserDirectionPortion:
          // vérifie si la portion a été parcouru dans le sens de digitalisation ou le sens inverse
          // retourne une géométrie linéaire dans le sens de saisie de l'utilisateur
          const getUserDirectionPathGeometry = (path) => {
            let userDirectionPortionGeometry;
            // path.elements est l'objet qui contient les features geojson
            // de la portion (le tronçon et les noeuds aux extrémités)
            if (gaJsUtils.notNullAndDefined(path, 'elements') && Array.isArray(path.elements)
                && path.elements.length === 3) {
              const elements = path.elements;

              // le 1er élement est toujours le noeud de départ de la saisie
              const startNode
                = GEOJSON_FORMAT.readGeometry(elements[0].projectedGeometry);

              // le 2ème élement est toujours le tronçon
              const pathLine
                = GEOJSON_FORMAT.readGeometry(elements[1].projectedGeometry);
              const firstVertex = pathLine.getFirstCoordinate();

              // On vérifie si le regard de départ de la portion correspond
              // au 1er sommet du tronçon.
              // Si non, alors la portion a été saisie dans le sens inverse
              // du sens de digitalisation du tronçon.
              const tol = 0.1;

              // Un noeud n'est pas toujours exactement à l'extrémité
              // d'un tronçon. On adopte une tolérance de 10 cm.
              const extent = [firstVertex[0] - tol, firstVertex[1] - tol,
                firstVertex[0] + tol, firstVertex[1] + tol];
              if (startNode.getType() === 'Point' || startNode.getType() === 'MultiPoint') {
                if (startNode.intersectsExtent(extent)) {
                  userDirectionPortionGeometry =  pathLine;
                }
                else {
                  userDirectionPortionGeometry = mapJsUtils.getReversedLinearGeometry(pathLine);
                }
              }
            }
            return userDirectionPortionGeometry;
          };

          // process de addUserDirectionPortion
          // ajoute la géométrie de la portion à la géométrie
          // du parcours réseau qui préserve le sens de saisie
          const pathLineGeometry = getUserDirectionPathGeometry(path);

          if (pathLineGeometry) {

            // pathLineGeometry peut être une géométrie simple ou multiple
            if (pathLineGeometry.getType() === 'LineString') {
              userDirectionPath.appendLineString(pathLineGeometry);
            }
            else if (pathLineGeometry.getType() === 'MultiLineString') {
              for (const lineString of pathLineGeometry.getLineStrings()) {
                userDirectionPath.appendLineString(lineString);
              }
            }
          }
        };
      },
    };
  };

  gcelement.$inject = ['NetworkFactory', '$timeout', 'gcInteractions',
    '$rootScope', '$filter', 'SelectManager', 'gaJsUtils', 'mapJsUtils'];

  return gcelement;
});
