'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    EditFactory,
    QueryFactory,
    gclayers,
    extendedNgDialog,
    $timeout,
    $q,
    $http,
    ngDialog,
    GoogleGeocodeFactory,
    DocumentFactory,
    gaDomUtils,
    $rootScope,
    $filter,
    kisGeocodageFactory,
    gcPopup,
    SelectManager,
    GeometryFactory,
    FeatureAttachmentFactory,
    $translate,
    UsersFactory,
    CalendarFactory,
    NominatimFactory,
    gceditsaveAttachmentFactory
  ) {
    return {
      templateUrl: 'js/XG/biz/aepInterventions/views/dossiers.html',
      restrict: 'A',

      controller: [
        '$scope',
        function($scope) {
          $scope.res = {};

          $scope.res['anomalie'] = {
            properties: {
              reference: $scope.$parent.refAuto,
              date_anomalie: $scope.$parent.dateAuto,
            },
          };
          $scope.res['int'] = {};
          $scope.res.int['intRep'] = {};
          $scope.feattree = {};
          // data de l'arbre
          var anomalie = {
            label: 'Anomalies',
            template:
              'js/XG/biz/aepInterventions/views/anomalies/incidentanomalie.html',
            children: [
              {
                label: $filter('translate')('aepintervention.incidentAno'),
                template:
                  'js/XG/biz/aepInterventions/views/anomalies/incidentanomalie.html',
              },
              {
                label: $filter('translate')('aepintervention.Emetteur'),
                template:
                  'js/XG/biz/aepInterventions/views/anomalies/emetteur.html',
              },
              {
                label: $filter('translate')('aepintervention.suiteDonnerAno'),
                template:
                  'js/XG/biz/aepInterventions/views/anomalies/suiteDonner.html',
              },
              {
                label: $filter('translate')('aepintervention.associatedDoc'),
                template:
                  'js/XG/biz/aepInterventions/views/anomalies/documents.html',
              },
            ],
          };
          $scope.featdata = [anomalie];

          $scope.ftis = {};
          //Récupération de la configuration du widget
          if ($scope.$parent.configuration) {
            $scope.config = $scope.$parent.configuration;
            $scope.geocoder = $scope.$parent.configuration.geocode;
            $scope.geocodeType = $scope.$parent.configuration.geocodeType;
            var canaUid = $scope.$parent.configuration['cana'][0].uid;
            var branchUid = $scope.$parent.configuration['branch'][0].uid;
            var comptUid = $scope.$parent.configuration['compt'][0].uid;
            $scope.ftis['canalisation'] = FeatureTypeFactory.getFeatureByUid(
              canaUid
            );
            $scope.ftis['branchement'] = FeatureTypeFactory.getFeatureByUid(
              branchUid
            );
            $scope.ftis['compteur'] = FeatureTypeFactory.getFeatureByUid(
              comptUid
            );
            var fonts = $scope.$parent.configuration['fonts'];
            $scope.fontUids = [];
            var i;
            for (i = 0; i < fonts.length; i++) {
              $scope.fontUids.push(fonts[i].uid);
            }
            var robs = $scope.$parent.configuration['robs'];
            $scope.robUids = [];
            for (i = 0; i < robs.length; i++) {
              $scope.robUids.push(robs[i].uid);
            }
          }

          $scope.ftis['anomalie'] = FeatureTypeFactory.getFeatureByUid(
            '55ca34fa-6804-44dd-b4f7-21446413dfa2'
          );
          $scope.ftis['emetteur'] = FeatureTypeFactory.getFeatureByUid(
            'c8b02420-dd65-42d5-a764-37691ad9871b'
          );
          $scope.ftis['intCana'] = FeatureTypeFactory.getFeatureByUid(
            'c9361a4d-2bf5-4b57-a357-c6dfd270acbf'
          );
          $scope.ftis['intRech'] = FeatureTypeFactory.getFeatureByUid(
            '90ef48ec-d433-46a9-96d6-459ff1961841'
          );
          $scope.ftis['intOuv'] = FeatureTypeFactory.getFeatureByUid(
            'f77ddfd7-c3fc-4725-baca-2081a7bff7d0'
          );
          $scope.ftis['intAbon'] = FeatureTypeFactory.getFeatureByUid(
            '2cced78b-e1f8-434b-81fc-21d1f436fc28'
          );
          $scope.ftis['intbranchement'] = FeatureTypeFactory.getFeatureByUid(
            'cc644764-2467-4092-af4d-13e663056a37'
          );
          $scope.ftis['intfont'] = FeatureTypeFactory.getFeatureByUid(
            'b4803baa-9e9c-4803-8b31-cc76c7948edd'
          );
          $scope.ftis['introb'] = FeatureTypeFactory.getFeatureByUid(
            '96a2b345-abad-4188-9f09-0b1797c74c09'
          );
          $scope.ftis['intAutre'] = FeatureTypeFactory.getFeatureByUid(
            '2fd59ec0-581f-4daa-a4b9-cb23f9981dd5'
          );
        },
      ],
      link: function(scope) {
        scope.uploadfile = {};
        var map = scope.map;

        scope.curtemplate =
          'js/XG/biz/aepInterventions/views/anomalies/incidentanomalie.html';

        scope.hasChildren = false;
        /**
         * [tree_handler select branch]
         * @param  {[type]} branch [description]
         * @return {[type]}        [description]
         */
        scope.tree_handler = function(branch) {
          scope.loadPictures(scope.ftis['anomalie'], scope.currentAnomalie);
          map.removeInteraction(draw);
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();
          scope.curtemplate = branch.template;
          if (
            branch.label ==
              $filter('translate')('aepintervention.reparationFuite') &&
            branch.children.length > 0
          ) {
            scope.hasChildren = true;
          } else {
            scope.hasChildren = false;
          }
        };
        //Get currentLanguage
        scope.translateToIso = {
          en: 'gb',
          de: 'de',
          fr: 'fr',
          es: 'es',
          pl: 'pl',
          km: 'kh',
          'zh-CN': 'cn',
          ar: false,
        };

        scope.currentLanguage =
          scope.translateToIso[$translate.preferredLanguage()];
        scope.changeLang = function(key) {
          $translate.use(key);
          localStorage.setItem('current_language', key);
          scope.currentLanguage = scope.translateToIso[key];
        };

        /**
         * [printReport fonction d'impresssion de la fiche d'intervention AEP]
         * @param  {[type]} fichier [Nom du fichier de la fiche d'intervention AEP]
         * @return {[type]}         [description]
         */
        scope.printReport = function() {
          var fichier =
            'fiche_aep_kis_' +
            localStorage.getItem('current_language') +
            '.docx';

          QueryFactory.relation(
            scope.ftis['anomalie'].uid,
            'Ano_Emetteur',
            scope.currentAnomalie.id,
            ''
          ).then(function(res) {
            if (res.data.features.length) {
              scope.currentEmetteur = res.data.features[0];
            }
            gaDomUtils.showGlobalLoader();
            var dateAnomalie;
            var dateUrgence;
            dateAnomalie = $filter('date')(new Date(), 'dd/MM/yyyy');
            dateUrgence = $filter('date')(new Date(), 'dd/MM/yyyy');
            var sendata = {
              anomalie: scope.currentAnomalie,
              date_anomalie: dateAnomalie,
              date_urgence: dateUrgence,
              emetteur: scope.currentEmetteur,
              urgence: scope.urgence.value,
            };

            DocumentFactory.generatedocx(
              sendata,
              fichier,
              scope.currentAnomalie.id,
              false,
              map
                .getView()
                .getProjection()
                .getCode()
            ).then(
              function(res) {
                window.open(
                  '/services/' +
                    res.data.portalid +
                    '/documents/downloaddocx?' +
                    '&name=' +
                    res.data.name
                );

                gaDomUtils.hideGlobalLoader();
                require('toastr').success('ok');
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error('error');
              }
            );
          });
        };

        //fonctions utiles
        /**
         * add relation
         * @param res
         * @param source
         * @returns {*}
         */
        scope.addRelation = function(senddata, fid, idd, relname) {
          var def = $q.defer();
          //sendata =  scope.featAnoUpdate //fid =scope.ftis['anomalie'].uid // idd =scope.currentEmetteur.id //relname ="Ano_Emetteur"
          EditFactory.r_add(senddata, fid, idd, relname).then(function(res) {
            console.log(res);
          });
          def.resolve();
          return def.promise;
        };
        /**
         * delete relation
         * @param res
         * @param source
         * @returns {*}
         */
        (scope.delRelation = function(fid, relname, idd, ida, delrobject) {
          var def = $q.defer();
          //fid =scope.ftis['anomalie'].uid // idd =scope.currentEmetteur.id // idd =scope.currentano.id//relname ="Ano_Emetteur"
          EditFactory.r_delete_1_nm(fid, relname, idd, ida, delrobject).then(
            function(res) {
              console.log(res);
            }
          );
          def.resolve();
          return def.promise;
        }),
          /****************************************FONCTIONS Localisation Adresse et Anomalie************************************************************************************/
          /**********************************************************************************************************************************************************************/
          /**
           * [openLocAdress open popup localisation adresse anomalie]
           * @return {[type]} [description]
           */
          (scope.openLocAdress = function() {
            if (scope.currentAnomalie && scope.currentAnomalie.id) {
              if (
                scope.currentAnomalie.properties.voierue == undefined &&
                scope.currentAnomalie.properties.cp == undefined &&
                scope.currentAnomalie.properties.commune == undefined
              ) {
                scope.inputAdress = ' ';
              } else {
                scope.inputAdress =
                  scope.currentAnomalie.properties.voierue +
                  ' ' +
                  scope.currentAnomalie.properties.cp +
                  ' ' +
                  scope.currentAnomalie.properties.commune;
              }
            } else {
              // scope.addAnomalie()
              scope.inputAdress = ' ';
            }
            ngDialog.open({
              template:
                'js/XG/biz/aepInterventions/views/anomalies/popoverLocAdress.html',
              className: 'ngdialog-theme-plain',
              closeByDocument: false,
              scope: scope,
            });
          });

        scope.adress = [];

        /**
         * Getting Coordinates Informations from GoogleMap api
         * @param address
         * @returns {*}
         */
        scope.getInformationsFromAddress = function(address) {
          if (address == '') return false;
          var params = { address: address, sensor: false };
          return $http
            .get('https://maps.googleapis.com/maps/api/geocode/json', {
              params: params,
            })
            .then(function(res) {
              return res.data.results;
            });
        };

        scope.activeAddress = {};
        /**
         * [getCoordsFromAdress recuperer les informations de l'adresse choisi et les appliquer aux propriétés et geometry de l'anomalie]
         * @param  {[type]} anAdress [description]
         * @param  {[type]} index    [description]
         * @return {[type]}          [description]
         */
        scope.getCoordsFromAdress = function(anAdress, index) {
          console.log(anAdress);
          var adressAno = anAdress.display_name;
          var tabAdressAno = adressAno.split(',');
          var voie = tabAdressAno[0].trim();
          var cpComm = tabAdressAno[1].trim();
          var cp = cpComm.substr(0, cpComm.indexOf(' '));
          var comm = cpComm.substr(cpComm.indexOf(' ') + 1);
          if (scope.currentAnomalie == undefined) {
            scope.res['anomalie'].properties.voierue = voie;
            scope.res['anomalie'].properties.cp = cp;
            scope.res['anomalie'].properties.commune = comm;
          } else {
            scope.currentAnomalie.properties.voierue = voie;
            scope.currentAnomalie.properties.cp = cp;
            scope.currentAnomalie.properties.commune = comm;
          }
          var myLong = Number(anAdress.lon);
          var lat = Number(anAdress.lat);
          var projection = map.getView().getProjection();
          var mapCode = projection.getCode();
          var projetedCoord = ol.proj.transform(
            [myLong, lat],
            'EPSG:4326',
            mapCode
          );
          if (scope.currentAnomalie) {
            if (scope.currentAnomalie.geometry == undefined) {
              scope.currentAnomalie.geometry = {
                coordinates: [],
                type: 'Point',
              };
            }
            scope.currentAnomalie.geometry.coordinates = projetedCoord;
            scope.updateAnomalie();
          } else {
            scope.res.anomalie.geometry = {
              coordinates: [],
              type: 'Point',
            };
            scope.res.anomalie.geometry.coordinates = projetedCoord;
            scope.addAnomalie();
          }
        };
        /**
         * [localiaseAno fonction de localisation de l'ano sur la carte]
         * @param  {[type]} obj [description]
         * @return {[type]}     [description]
         */
        scope.localiaseAno = function(obj) {
          var format = new ol.format.GeoJSON();
          var f = format.readFeature(obj);
          var extent = f.getGeometry().getExtent();
          map.getView().fit(extent, map.getSize());
          gclayers.clearhighLightFeatures();
          gclayers.addhighLightFeature(f);
        };

        scope.geocoderCfg = { value: scope.geocoder };
        /**
         * [geocodeInverse fonction geocodage inverse]
         * @param  {[type]} coords [description]
         * @return {[type]}        [description]
         */
        scope.geocodeInverse = function(coords) {
          var coords_4326 = ol.proj.transform(
            coords,
            map
              .getView()
              .getProjection()
              .getCode(),
            'EPSG:4326'
          );
          if (!scope.geocoderCfg.value) {
            require('toastr').error(
              $filter('translate')(
                'common.directives.position_autocomplete.service_vide'
              )
            );
          }
          gaDomUtils.showGlobalLoader();
          var promise = kisGeocodageFactory.reverse(
            kisGeocodageFactory.getGeocoderConfigFromId(scope.geocoderCfg.value)
              .url,
            coords_4326
          );

          promise.then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              if (
                res.data.features.length > 0 &&
                res.data.features[0].properties
              ) {
                if (scope.currentAnomalie) {
                  scope.currentAnomalie.properties.voierue =
                    res.data.features[0].properties.name;
                  scope.currentAnomalie.properties.cp =
                    res.data.features[0].properties.postcode;
                  scope.currentAnomalie.properties.commune =
                    res.data.features[0].properties.city;
                  scope.updateAnomalie();
                } else {
                  scope.res.anomalie.properties.voierue =
                    res.data.features[0].properties.name;
                  scope.res.anomalie.properties.cp =
                    res.data.features[0].properties.postcode;
                  scope.res.anomalie.properties.commune =
                    res.data.features[0].properties.city;
                  scope.addAnomalie();
                }
              } else {
                require('toastr').error('Rien trouvé !');
              }
            },
            function() {
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        /**
         * [geocodeInverse fonction geocodage inverse]
         * @param  {[type]} coords [description]
         * @return {[type]}        [description]
         */
        scope.geocodeInverseOSM = function(coords) {
          var coords_4326 = ol.proj.transform(
            coords,
            map
              .getView()
              .getProjection()
              .getCode(),
            'EPSG:4326'
          );
          var promise = NominatimFactory.reverse(coords_4326);

          promise.then(function(res) {
            if (res.data.address) {
              if (scope.currentAnomalie) {
                scope.currentAnomalie.properties.voierue =
                  res.data.address.road;
                scope.currentAnomalie.properties.cp = res.data.address.postcode;
                if (res.data.address.city) {
                  scope.currentAnomalie.properties.commune =
                    res.data.address.city;
                } else {
                  scope.currentAnomalie.properties.commune =
                    res.data.address.village;
                }
                scope.updateAnomalie();
              } else {
                scope.res.anomalie.properties.voierue = res.data.address.road;
                scope.res.anomalie.properties.cp = res.data.address.postcode;
                if (res.data.address.city) {
                  scope.res.anomalie.properties.commune = res.data.address.city;
                } else {
                  scope.res.anomalie.properties.commune =
                    res.data.address.village;
                }
                scope.addAnomalie();
              }
            } else {
              require('toastr').error('Rien trouvé !');
            }
          });
        };

        /**
         * [geocodeInverse fonction geocodage inverse]
         * @param  {[type]} coords [description]
         * @return {[type]}        [description]
         */
        scope.geocodeInverseGoogle = function(coords) {
          var coords_4326 = ol.proj.transform(
            coords,
            map
              .getView()
              .getProjection()
              .getCode(),
            'EPSG:4326'
          );

          var promise = GoogleGeocodeFactory.getAdresseFromCoordinate(
            coords_4326
          );

          promise.then(function(res) {
            if (res.data.address) {
              if (scope.currentAnomalie) {
                scope.currentAnomalie.properties.voierue =
                  res.data.address.road;
                scope.currentAnomalie.properties.cp = res.data.address.postcode;
                if (res.data.address.city) {
                  scope.currentAnomalie.properties.commune =
                    res.data.address.city;
                } else {
                  scope.currentAnomalie.properties.commune =
                    res.data.address.village;
                }
                scope.updateAnomalie();
              } else {
                scope.res.anomalie.properties.voierue = res.data.address.road;
                scope.res.anomalie.properties.cp = res.data.address.postcode;
                if (res.data.address.city) {
                  scope.res.anomalie.properties.commune = res.data.address.city;
                } else {
                  scope.res.anomalie.properties.commune =
                    res.data.address.village;
                }
                scope.addAnomalie();
              }
            } else {
              require('toastr').error('Rien trouvé !');
            }
          });
        };

        /****************************************FONCTIONS ANOMALIE (add, update, delete)*************************************************************************************/
        /**********************************************************************************************************************************************************************/
        /**
         * [verifyReference verifie si la reference dossier existe déja]
         * @param  {[type]} refs       [description]
         * @param  {[type]} currentRef [description]
         * @return {[type]}            [description]
         */
        scope.verifyReference = function(refs, currentRef) {
          for (var k = 0; k < refs.length; k++) {
            if (currentRef === refs[k]) {
              return true;
            }
          }
          return false;
        };

        /**
         * [addAnomalie ajout d'une nouvelle anomalie]
         */
        scope.addAnomalie = function() {
          QueryFactory.data(
            scope.ftis['anomalie'].uid,
            '1=1',
            undefined,
            undefined,
            undefined,
            undefined
          ).then(function(result) {
            scope.features = result.data.features;
            var refs = [];
            for (var i = 0; i < scope.features.length; i++) {
              refs.push(scope.features[i].properties.reference);
            }
            scope.featAnoCollection = {
              type: 'FeatureCollection',
              features: [],
            };

            scope.currentAnomalie = scope.res.anomalie;
            scope.featAnoCollection.features.push({
              type: 'Feature',
              geometry: scope.currentAnomalie.geometry,
              properties: scope.currentAnomalie.properties,
            });
            var srid = scope.map
              ? scope.map
                  .getView()
                  .getProjection()
                  .getCode()
              : '';
            if (
              scope.features.length > 0 &&
              scope.verifyReference(
                refs,
                scope.currentAnomalie.properties.reference
              )
            ) {
              require('toastr').error(
                $filter('translate')('aepintervention.messageRef')
              );
            } else {
              EditFactory.add(
                scope.ftis['anomalie'].uid,
                scope.featAnoCollection,
                srid
              ).then(function(res) {
                require('toastr').success('ok');
                scope.currentAnomalie.id = res.data.create[0].id;
                if (scope.currentAnomalie.properties.etat == undefined) {
                  scope.currentAnomalie.properties.etat =
                    'Intervention à faire';
                }
                gclayers.refreshlayerByid(
                  scope.ftis['anomalie'].uid,
                  scope.map
                );
              });
            }
          });
        };

        /**
         * [updateAnomalie mise à jour de l'anomalie ]
         * @return {[type]} [description]
         */
        scope.updateAnomalie = function() {
          console.log(scope);
          if (scope.currentAnomalie.id) {
            scope.featAnoUpdate = {
              type: 'FeatureCollection',
              features: [],
            };
            scope.featAnoUpdate.features.push({
              id: scope.currentAnomalie.id,
              type: 'Feature',
              geometry: scope.currentAnomalie.geometry,
              properties: scope.currentAnomalie.properties,
            });
            var srid = scope.map
              ? scope.map.getView().getProjection().getCode(): '';
            EditFactory.update(
              scope.ftis['anomalie'].uid,
              scope.featAnoUpdate,
              srid
            ).then(
              function(res) {
                if (scope.currentAnomalie.properties.etat == undefined) {
                  scope.currentAnomalie.properties.etat =
                    'Intervention à faire';
                }
                gceditsaveAttachmentFactory.uploadAttachmentFiles(
                  scope,
                  scope.ftis['anomalie'].name,
                  res.data.update[0]
                );
                scope.loadPictures(
                  scope.ftis['anomalie'],
                  scope.currentAnomalie
                );
                gclayers.refreshlayerByid(
                  scope.ftis['anomalie'].uid,
                  scope.map
                );

                require('toastr').success('ok');
              },
              function() {
                require('toastr').error('error');
              }
            );
          }
        };

        var promise = UsersFactory.getactiveusers();
        promise.then(function(res) {
          scope.users = res.data;
        });

        //GESTION AGENT
        scope.agents = [];

        /**
         * [addAgent Ajout d'un agent à l'anomalie]
         */
        scope.addAgent = function() {
          if (
            scope.agents.length > 0 &&
            scope.verifyReference(scope.agents, scope.res.selectedAgent)
          ) {
            require('toastr').error(
              $filter('translate')('aepintervention.messageAgent')
            );
          } else {
            scope.agents.push(scope.res.selectedAgent);

            if (scope.agents.length > 0) {
              scope.currentAnomalie.properties.agent = scope.agents.toString();
            }
          }
        };

        /**
         * [linkEmettToAno ajoute un emetteur à l'anomalie]
         * @return {[type]} [description]
         */
        scope.linkEmettToAno = function() {
          if (
            scope.currentAnomalie &&
            scope.currentAnomalie.id &&
            scope.selectedEmetteur
          ) {
            scope.featAnoUpdate = {
              type: 'FeatureCollection',
              features: [],
            };
            scope.featAnoUpdate.features.push({
              id: scope.currentAnomalie.id,
              type: 'Feature',
              geometry: scope.currentAnomalie.geometry,
              properties: scope.currentAnomalie.properties,
            });
            QueryFactory.relation(
              scope.ftis['anomalie'].uid,
              'Ano_Emetteur',
              scope.currentAnomalie.id,
              ''
            ).then(function(res) {
              if (res.data.features.length) {
                //suppression de l'emtteru en relation avec l'anomalie
                scope.delRelation(
                  scope.ftis['emetteur'].uid,
                  'Ano_Emetteur',
                  scope.currentAnomalie.id,
                  res.data.features[0].id,
                  true
                );
                scope.delRelation(
                  scope.ftis['anomalie'].uid,
                  'Ano_Emetteur',
                  res.data.features[0].id,
                  scope.currentAnomalie.id,
                  true
                );
                // ajout du nouveau emetteur à l'ano
                scope.addRelation(
                  scope.featAnoUpdate,
                  scope.ftis['anomalie'].uid,
                  scope.selectedEmetteur.data[0].id,
                  'Ano_Emetteur'
                );
              } else {
                //ajouter un emetteur à l'ano
                scope.addRelation(
                  scope.featAnoUpdate,
                  scope.ftis['anomalie'].uid,
                  scope.selectedEmetteur.data[0].id,
                  'Ano_Emetteur'
                );
              }
            });
          }
        };

        scope.modifOpt = false;
        var draw;
        /**
         * [drawGeomAno positionner et ajouter une gerometry à l'anomalie en cours]
         * @return {[type]} [description]
         */
        scope.drawGeomAno = function() {
          draw = new ol.interaction.Draw({
            source: gclayers.getDrawLayer().getSource(),
            type: 'Point',
          });
          draw.on('drawend', function(e) {
            var format = new ol.format.GeoJSON();
            var geom = JSON.parse(
              format.writeGeometry(e.feature.getGeometry())
            );
            scope.res.anomalie.geometry = geom;
            scope.modifOpt = true;
            var coords = e.feature.getGeometry().getCoordinates();
            var ans = confirm(
              $filter('translate')('aepintervention.applyAdress')
            );
            if (ans) {
              if (scope.geocodeType === 'OSM') {
                scope.geocodeInverseOSM(coords);
              }
              if (scope.geocodeType === 'GOOGLE') {
                scope.geocodeInverseGoogle(coords);
              }
              if (scope.geocodeType === 'KISGEOCODAGE') {
                scope.geocodeInverse(coords);
              }
            }
          });
          map.addInteraction(draw);
        };

        /**
         * [saveGeomAno mise à jour de l'anomalie en fonction de la geometry ajouté]
         * @return {[type]} [description]
         */
        scope.saveGeomAno = function() {
          scope.modifOpt = false;
          map.removeInteraction(draw);
          scope.updateAnomalie();
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();
        };

        /**
         * [removeAnaomalie supprimer l'anomalie]
         * @return {[type]} [description]
         */
        scope.removeAnomalie = function() {
          var ans = confirm($filter('translate')('aepintervention.deleteAno'));
          if (ans) {
            EditFactory.remove(
              scope.ftis['anomalie'].uid,
              scope.currentAnomalie.id
            ).then(function(res) {
              gclayers.refreshlayerByid(scope.ftis['anomalie'].uid, scope.map);
              QueryFactory.relation(
                scope.ftis['anomalie'].uid,
                'Ano_Emetteur',
                scope.currentAnomalie.id,
                ''
              ).then(function(res) {
                if (res.data.features.length) {
                  //A verifier
                  scope.delRelation(
                    scope.ftis['emetteur'].uid,
                    'Ano_Emetteur',
                    scope.currentAnomalie.id,
                    res.data.features[0].id,
                    true
                  );
                  scope.delRelation(
                    scope.ftis['anomalie'].uid,
                    'Ano_Emetteur',
                    res.data.features[0].id,
                    scope.currentAnomalie.id,
                    true
                  );
                }
              });
              require('toastr').success('ok');
              $rootScope.$broadcast('closeNgDialogAno');
            });
          }
        };

        /**
         * [diff difference de jours entre deux dates (saisie et urgence de l'ano)]
         * @param  {[type]} dateAno [description]
         * @param  {[type]} dateUrg [description]
         * @return {[type]}         [description]
         */
        scope.diff = function(dateAno, dateUrg) {
          var date1 = new Date(dateAno);
          var date2 = new Date(scope.currentAnomalie.properties.date_urgence);
          var timeDiff = Math.abs(date2.getTime() - date1.getTime());
          var diffs = Math.ceil(timeDiff / (1000 * 3600 * 24));
          return diffs;
        };

        function pad(n) {
          return n < 10 ? '0' + n : n;
        }
        scope.urgence = {
          value: '',
        };
        /**
         * [diffDate definir la date d'urgence en fonction de la date de saisie de l'ano]
         * @return {[type]} [description]
         */
        scope.diffDate = function() {
          var date1, date2;
          if (scope.currentAnomalie.properties.date_urgence == undefined) {
            date1 = new Date(scope.currentAnomalie.properties.date_anomalie);
            date2 = date1;
          } else {
            date1 = new Date(scope.currentAnomalie.properties.date_anomalie);
            date2 = new Date(scope.currentAnomalie.properties.date_urgence);
          }

          date2.setDate(date1.getDate() + parseInt(scope.urgence.value));
          var dd = pad(date2.getDate());
          var mm = pad(date2.getMonth() + 1);
          var yyyy = date1.getFullYear();
          var dateUrg = yyyy + '-' + mm + '-' + dd + 'T01:00:00.000+0100';
          scope.currentAnomalie.properties.date_urgence = dateUrg;
        };
        /****************************************FONCTIONS EMETTEUR***********************************************************************************************************/
        /**********************************************************************************************************************************************************************/
        //EMETTEUR
        //Fonction ajoute emetteur si on veut ouvrir une popup pour ça
        scope.addNewEmetteur = function() {
          if (scope.res.newEmetteur != undefined) {
            scope.res.newEmetteur.properties = {};
          }
          extendedNgDialog.open({
            template:
              'js/XG/biz/aepInterventions/views/anomalies/emetteurForm.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: true,
            title: $filter('translate')('aepintervention.nouvEmetteur'),
          });
        };
        /**
         * [addEmetteur Ajouter un nouveau emetteur]
         */
        scope.addEmetteur = function() {
          var featureEmetCollection = {
            type: 'FeatureCollection',
            features: [],
          };
          featureEmetCollection.features.push({
            type: 'Feature',
            properties: scope.res.newEmetteur.properties,
          });
          EditFactory.add(
            scope.ftis['emetteur'].uid,
            featureEmetCollection
          ).then(function(res) {
            require('toastr').success('ok');
          });
        };

        /**
         * [OpenDataEmetteur ouvrir la liste de emetteurs]
         */
        scope.OpenDataEmetteur = function() {
          scope.emetteurFti = scope.ftis['emetteur'];
          scope.selectedEmetteur = { data: [] };
          scope.emetteurCrud = {
            create: { func: scope.addNewEmetteur },
            remove: true,
          };

          extendedNgDialog.open({
            template:
              'js/XG/biz/aepInterventions/views/anomalies/popoverListEmetteur.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: true,
            title: $filter('translate')('aepintervention.Emetteurs'),
          });
        };
        /****************************************FONCTIONS INTERVENTIONS***********************************************************************************************************/
        /**********************************************************************************************************************************************************************/
        //Page principale pour l'ajout des interventions
        var intervention0 = {
          label: 'Interventions',
          template:
            'js/XG/biz/aepInterventions/views/interventions/intInfoGenerales.html',
          children: [
            {
              label: $filter('translate')('aepintervention.infoGenerale'),
              template:
                'js/XG/biz/aepInterventions/views/interventions/intInfoGenerales.html',
            },
          ],
        };

        var calendarEventTypes = [];
        var getEventTypes = function() {
          CalendarFactory.geteventtypes().then(
            function(res) {
              calendarEventTypes = CalendarFactory.resources.event_types;
              for (var i = 0; i < calendarEventTypes.length; i++) {
                if (calendarEventTypes[i].properties.type == 'intervention') {
                  scope.eventTypeId = calendarEventTypes[i].properties.type_id;
                }
              }
            },
            function() {}
          );
        };
        getEventTypes();

        /**
         * [openBranchInterventions ouverture de la branche intervention lorsqu'on renseigne le destinataire]
         * @return {[type]} [description]
         */
        scope.openBranchInterventions = function() {
          //console.log(scope.featdata.length)
          if (
            scope.currentAnomalie.properties.destinataire != null &&
            scope.featdata.length === 1
          ) {
            scope.updateAnomalie();

            scope.featdata.push(intervention0);
          } else {
            scope.updateAnomalie();
          }
        };

        /**
         * [openBranchInterventions ouvre la branche intervention lorsque l'anomalie est validé]
         * @return {[type]} [description]
         */
        //Si intervention RESEAUf
        // si choix intervention reseau recherche de fuite
        var interventionRecherche = {
          label: $filter('translate')('aepintervention.intervRecherche'),
          template:
            'js/XG/biz/aepInterventions/views/interventions/reseau/interventionRecherche.html',
        };
        scope.addInterventionRecherche = function() {
          // open ihm intervention recherche de fuite
          if (scope.res.interventionReseau == 'RECHERCHE') {
            scope.featdata[1].children.push(
              angular.copy(interventionRecherche)
            );
          }
        };

        // si choix intervention reseau reparation de fuite
        var interventionReparation = {
          label: $filter('translate')('aepintervention.reparationFuite'),
          template:
            'js/XG/biz/aepInterventions/views/interventions/reseau/interventionReparation.html',
        };
        /**
         * [addInterventionReparation ajout de la branche réparation de fuite]
         */
        scope.addInterventionReparation = function() {
          // open ihm intervention recherche de fuite
          if (scope.res.interventionReseau == 'REPARATION') {
            scope.featdata[1].children.push(
              angular.copy(interventionReparation)
            );
          }
        };
        var cana = {
          label: $filter('translate')('aepintervention.canalisation'),
          template:
            'js/XG/biz/aepInterventions/views/interventions/reseau/reparation/canalisation.html',
        };
        var interCana = {
          label: $filter('translate')('aepintervention.intervCanalisation'),
          template:
            'js/XG/biz/aepInterventions/views/interventions/reseau/reparation/interventionCanalisation.html',
        };
        var intBranchement = {
          label: $filter('translate')('aepintervention.intervBranchement'),
          template:
            'js/XG/biz/aepInterventions/views/interventions/reseau/reparation/interventionBranchement.html',
        };
        var intFontainerie = {
          label: $filter('translate')('aepintervention.intervFontainerie'),
          template:
            'js/XG/biz/aepInterventions/views/interventions/reseau/reparation/interventionFontainerie.html',
        };
        var intRobinetterie = {
          label: $filter('translate')('aepintervention.intervRobinetterie'),
          template:
            'js/XG/biz/aepInterventions/views/interventions/reseau/reparation/interventionRobinetterie.html',
        };
        /**
         * [selectReparationChange ajout de la branche intervention reparation de fuite en fonction du type]
         * @return {[type]} [description]
         */
        scope.selectReparationChange = function() {
          var selectedBranch = scope.feattree.get_selected_branch();
          if (
            selectedBranch.label ==
              $filter('translate')('aepintervention.reparationFuite') &&
            scope.res.reparationInt == 'CANALISATION'
          ) {
            //selectedBranch.children.push(angular.copy(cana),angular.copy(interCana));
            if (selectedBranch.children.length == 0) {
              selectedBranch.children.push(
                angular.copy(cana),
                angular.copy(interCana)
              );
            } else {
              selectedBranch.children = [];
              selectedBranch.children.push(
                angular.copy(cana),
                angular.copy(interCana)
              );
            }
          }
          if (
            selectedBranch.label ==
              $filter('translate')('aepintervention.reparationFuite') &&
            scope.res.reparationInt == 'FONTAINERIE'
          ) {
            if (selectedBranch.children.length == 0) {
              selectedBranch.children.push(angular.copy(intFontainerie));
            } else {
              selectedBranch.children = [];
              selectedBranch.children.push(angular.copy(intFontainerie));
            }
          }
          if (
            selectedBranch.label ==
              $filter('translate')('aepintervention.reparationFuite') &&
            scope.res.reparationInt == 'ROBINETERIE'
          ) {
            if (selectedBranch.children.length == 0) {
              selectedBranch.children.push(angular.copy(intRobinetterie));
            } else {
              selectedBranch.children = [];
              selectedBranch.children.push(angular.copy(intRobinetterie));
            }
          }
          if (
            selectedBranch.label ==
              $filter('translate')('aepintervention.reparationFuite') &&
            scope.res.reparationInt == 'BRANCHEMENT'
          ) {
            if (selectedBranch.children.length == 0) {
              selectedBranch.children.push(angular.copy(intBranchement));
            } else {
              selectedBranch.children = [];
              selectedBranch.children.push(angular.copy(intBranchement));
            }
          }
        };

        /**
         * [addIntRechAboOuv add intervention autre que reparation]
         * @param {[type]} resInt  [description]
         * @param {[type]} fidInt  [description]
         * @param {[type]} relname [description]
         */
        scope.addIntRechAboOuv = function(resInt, fidInt, relname) {
          //scope.currentIR = scope.res.int['intRech'];
          scope.currentIR = resInt;
          GeometryFactory.unionandbuffer(
            scope.currentAnomalie.geometry,
            'ROUND',
            1
          ).then(function(res) {
            scope.currentIR.geometry = res.data;

            scope.featureIRCollection = {
              type: 'FeatureCollection',
              features: [],
            };
            scope.featureIRCollection.features.push({
              type: 'Feature',
              geometry: scope.currentIR.geometry,
              properties: scope.currentIR.properties,
            });
            scope.featAnoUpdate = {
              type: 'FeatureCollection',
              features: [],
            };
            scope.featAnoUpdate.features.push({
              id: scope.currentAnomalie.id,
              type: 'Feature',
              geometry: scope.currentAnomalie.geometry,
              properties: scope.currentAnomalie.properties,
            });
            var srid = scope.map
              ? scope.map
                  .getView()
                  .getProjection()
                  .getCode()
              : '';
            EditFactory.add(fidInt, scope.featureIRCollection, srid).then(
              function(res) {
                require('toastr').success('ok');
                scope.currentIR.id = res.data.create[0].id;
                if (scope.currentIR.id) {
                  scope.addRelation(
                    scope.featAnoUpdate,
                    scope.ftis['anomalie'].uid,
                    scope.currentIR.id,
                    relname
                  );
                  gclayers.refreshlayerByid(fidInt, scope.map);
                  //Ajout d'un evenement si date debu de fin et agent sont renseignes
                  if (
                    scope.currentIR.properties.date_debut != undefined &&
                    scope.currentIR.properties.date_fin != undefined &&
                    scope.currentIR.properties.agent != undefined
                  ) {
                    var str = scope.currentIR.properties.agent;
                    var tabStr = str.split(' ');
                    var name = tabStr[1];
                    var surname = tabStr[2];
                    for (var i = 0; i < scope.users.length; i++) {
                      if (
                        scope.users[i].name == name &&
                        scope.users[i].vorname == surname
                      ) {
                        scope.userInterv = scope.users[i].login;
                      }
                    }
                    scope.addEventIntervention(fidInt);
                  }
                  //scope.addRelation(scope.featureIRCollection,fidInt, scope.currentAnomalie.id, relname );
                }
              }
            );
          });
        };

        function getTreeBranch(tree, branchNumber) {
          var selectedBranch;
          var goto = branchNumber.split('#');

          if (angular.isDefined(tree)) {
            selectedBranch = tree.get_first_branch();
            for (var g in goto) {
              for (var i = 0; i < goto[g]; i++) {
                selectedBranch = tree.get_next_sibling(selectedBranch);
              }
              // except for last element
              if (g < goto.length - 1) {
                selectedBranch = tree.get_next_branch(selectedBranch);
              }
            }
          }

          return selectedBranch;
        }
        function goToBranch(tree, branchNumber) {
          var treeBranch = getTreeBranch(tree, branchNumber);
          tree.select_branch(treeBranch);
        }
        /**
         * [removeIntRechAboOuv supprime intervention autre que reparation]
         * @param  {[type]} resInt  [objet intervention en cours]
         * @param  {[type]} relname [nom de la relation ano-interv]
         * @param  {[type]} fidInt  [fid du layer intervention en cours]
         * @param  {[type]} fidAno  [fid de l'ano en cours]
         * @return {[type]}              */
        scope.removeIntRechAboOuv = function(resInt, relname, fidInt, fidAno) {
          scope.currentIR = resInt;
          var ans = confirm($filter('translate')('aepintervention.deleteInt'));
          if (ans) {
            var selectBranch = scope.feattree.get_selected_branch();
            var tab = scope.featdata[1].children;
            for (var i = 0; i < tab.length; i++) {
              if (tab[i] === selectBranch) {
                tab.splice(i, 1);
              }
            }

            scope.featdata[1].children = tab;
            scope.featdata[1].selected = true;
            console.log(scope.featdata[1]);
            EditFactory.remove(fidInt, scope.currentIR.id).then(function(res) {
              QueryFactory.relation(
                fidInt,
                relname,
                scope.currentIR.id,
                ''
              ).then(function(res) {
                if (res.data.features.length) {
                  gclayers.refreshlayerByid(fidInt, scope.map);
                  scope.delRelation(
                    fidAno,
                    relname,
                    scope.currentIR.id,
                    res.data.features[0].id,
                    true
                  );
                  scope.delRelation(
                    fidInt,
                    relname,
                    res.data.features[0].id,
                    scope.currentIR.id,
                    true
                  );
                  //goToBranch (scope.feattree, '1');
                  //var branchRef = scope.feattree.get_next_branch()
                  //scope.feattree.get_selected_branch()= branchRef;
                  //console.log(scope.feattree.get_selected_branch());
                  //scope.delRelation(fidInt,relname,  res.data.features[0].id,scope.currentIR.id, true);
                  //scope.delRelation(fidAno,relname,  scope.currentIR.id, res.data.features[0].id,true);
                  CalendarFactory.getevents(
                    '',
                    '',
                    '',
                    '',
                    scope.currentIR.id
                  ).then(function(result1) {
                    scope.linkedEvents = result1.data.features;
                    if (scope.linkedEvents && scope.linkedEvents.length > 0) {
                      var id = scope.linkedEvents[0].id.split('.');
                      scope.removeEventIntervention(id[1]);
                      $rootScope.$broadcast('kis_calendar_event_refresh');
                    }
                  });
                }
              });
              require('toastr').success('ok');
            });
          }
          goToBranch(scope.feattree, '1');
        };

        /**
         * [addEventIntervention ajoute un evenement par type d'intervention]
         * @param {[type]} fidInt [description]
         */
        scope.addEventIntervention = function(fidInt, cond) {
          var calendarEventTypes = [];
          calendarEventTypes = CalendarFactory.resources.event_types;
          var idInt = scope.currentIR.id;
          var indx = idInt.lastIndexOf('.');
          var typeInt = idInt.substr(0, indx);
          var color = 'e74c3c';
          var type_evenement = 0;
          var title = 'intervention';
          calendarEventTypes.forEach(function(eventType) {
            if (
              typeInt == 'AEP_int_cana' ||
              typeInt == 'AEP_int_branch' ||
              typeInt == 'AEP_int_fontainerie' ||
              typeInt == 'AEP_int_robinetterie'
            ) {
              if (eventType.properties.type == 'intervention_reparation') {
                title = eventType.properties.type;
                color = eventType.properties.default_color;
                type_evenement = eventType.properties.type_id;
              }
            }
            if (typeInt == 'AEP_int_recherche') {
              if (eventType.properties.type == 'intervention_recherche') {
                title = eventType.properties.type;
                color = eventType.properties.default_color;
                type_evenement = eventType.properties.type_id;
              }
            }
            if (typeInt == 'AEP_int_ouvrage') {
              if (eventType.properties.type == 'intervention_ouvrage') {
                title = eventType.properties.type;
                color = eventType.properties.default_color;
                type_evenement = eventType.properties.type_id;
              }
            }
            if (typeInt == 'AEP_int_abonnee') {
              if (eventType.properties.type == 'intervention_abonnee') {
                title = eventType.properties.type;
                color = eventType.properties.default_color;
                type_evenement = eventType.properties.type_id;
              }
            }
            if (typeInt == 'AEP_int_autre') {
              if (eventType.properties.type == 'intervention_autre') {
                title = eventType.properties.type;
                color = eventType.properties.default_color;
                type_evenement = eventType.properties.type_id;
              }
            }
          });
          //traitement sur date de debut et fin pour un bon affichage dans le calendar. :
          //modifier heure debut de la date de debut (de 00h à 08h)
          //modifier heure fin de la date de fin (de 00h à 18h)
          var dateD = new Date(scope.currentIR.properties.date_debut);
          var dd1 = pad(dateD.getDate());
          var mm1 = pad(dateD.getMonth() + 1);
          var yyyy1 = dateD.getFullYear();
          var dateDebut = yyyy1 + '-' + mm1 + '-' + dd1 + 'T08:00:00.000+0100';
          var dateF = new Date(scope.currentIR.properties.date_fin);
          var dd2 = pad(dateF.getDate());
          var mm2 = pad(dateF.getMonth() + 1);
          var yyyy2 = dateF.getFullYear();
          var dateFin = yyyy2 + '-' + mm2 + '-' + dd2 + 'T18:00:00.000+0100';

          var newEvent = {
            collection: {
              type: 'FeatureCollection',
              features: [
                {
                  type: 'Feature',
                  properties: {
                    color: color,
                    title: title,
                    type_evenement: type_evenement,
                    start: dateDebut,
                    end: dateFin,
                    description: scope.currentAnomalie.properties.remarques,
                    place:
                      scope.currentAnomalie.properties.voierue +
                      ' ' +
                      scope.currentAnomalie.properties.commune +
                      ' ' +
                      scope.currentAnomalie.properties.cp,
                  },
                },
              ],
            },
            linked_objects: [
              {
                type: 'FeatureCollection',
                features: [
                  {
                    type: 'Feature',
                    properties: {
                      feature_id: scope.currentAnomalie.id,
                      feature_uid: scope.ftis['anomalie'].uid,
                    },
                  },
                  {
                    type: 'Feature',
                    properties: {
                      feature_id: scope.currentIR.id,
                      feature_uid: fidInt,
                    },
                  },
                ],
              },
            ],
            users: [
              [
                {
                  login: scope.userInterv,
                  type: 'concerne',
                },
              ],
            ],
          };

          CalendarFactory.addevent(newEvent).then(
            function(res) {
              require('toastr').success('ok');
            },
            function() {
              require('toastr').error('error');
            }
          );
        };

        scope.updateEventIntervention = function(fidInt) {
          ////traitement sur date de debut et fin pour un bon affichage dans le calendar. :
          //modifier heure debut de la date de debut (de 00h à 08h)
          //modifier heure fin de la date de fin (de 00h à 18h)
          var dateD = new Date(scope.currentIR.properties.date_debut);
          var dd1 = pad(dateD.getDate());
          var mm1 = pad(dateD.getMonth() + 1);
          var yyyy1 = dateD.getFullYear();
          var dateDebut = yyyy1 + '-' + mm1 + '-' + dd1 + 'T08:00:00.000+0100';
          var dateF = new Date(scope.currentIR.properties.date_fin);
          var dd2 = pad(dateF.getDate());
          var mm2 = pad(dateF.getMonth() + 1);
          var yyyy2 = dateF.getFullYear();
          var dateFin = yyyy2 + '-' + mm2 + '-' + dd2 + 'T18:00:00.000+0100';

          scope.currentEvent.properties.start = dateDebut;
          scope.currentEvent.properties.end = dateFin;
          //console.log(dateDebut, dateFin );

          var feature = {
            collection: {
              type: 'FeatureCollection',
              features: [scope.currentEvent],
            },
            linked_objects: [
              {
                type: 'FeatureCollection',
                features: [
                  {
                    type: 'Feature',
                    properties: {
                      feature_id: scope.currentAnomalie.id,
                      feature_uid: scope.ftis['anomalie'].uid,
                    },
                  },
                  {
                    type: 'Feature',
                    properties: {
                      feature_id: scope.currentIR.id,
                      feature_uid: fidInt,
                    },
                  },
                ],
              },
            ],
            users: [
              [
                {
                  login: scope.userInterv,
                  type: 'concerne',
                },
              ],
            ],
          };

          CalendarFactory.updateevent(feature).then(
            function(res) {
              //var eventid = res.data[0].id;
              require('toastr').success('ok');
            },
            function() {
              require('toastr').error('error');
            }
          );
        };

        scope.removeEventIntervention = function(id) {
          CalendarFactory.cancelevent(id).then(
            function(res) {
              //var eventid = res.data[0].id;
              require('toastr').success('ok');
            },
            function() {
              require('toastr').error('error');
            }
          );
        };

        /**
         * [saveIntervention add intervention reparation canalisation ou branchement]
         * @param  {[type]} resInt      [objet intervention en cours]
         * @param  {[type]} geomInt     [geometry de l'intervention]
         * @param  {[type]} selectedObj [objet selectionne (ex: cana)]
         * @param  {[type]} fidInt      [fid du layer intervention en cours]
         * @param  {[type]} fidObj      [fid du layer de lobjet selectionne]
         * @param  {[type]} relname1    [nom de la relation ano-interv]
         * @param  {[type]} relname2    [nom de la relation ano-selectedobj]
         * @param  {[type]} relname3    [nom de la relation interv-selectedobj]
         * @return {[type]}
         */
        scope.saveIntervention = function(
          resInt,
          geomInt,
          selectedObj,
          fidInt,
          fidObj,
          relname1,
          relname2,
          relname3
        ) {
          scope.currentIR = resInt;
          scope.currentIR.geometry = geomInt;
          scope.featAnoUpdate = {
            type: 'FeatureCollection',
            features: [],
          };
          scope.featAnoUpdate.features.push({
            id: scope.currentAnomalie.id,
            type: 'Feature',
            geometry: scope.currentAnomalie.geometry,
            properties: scope.currentAnomalie.properties,
          });
          scope.canaCollection = {
            type: 'FeatureCollection',
            features: [],
          };
          scope.canaCollection.features.push({
            id: selectedObj.id,
            type: 'Feature',
            geometry: selectedObj.geometry,
            properties: selectedObj.properties,
          });
          scope.featureIRCollection = {
            type: 'FeatureCollection',
            features: [],
          };
          scope.featureIRCollection.features.push({
            type: 'Feature',
            geometry: scope.currentIR.geometry,
            properties: scope.currentIR.properties,
          });
          var srid = scope.map
            ? scope.map
                .getView()
                .getProjection()
                .getCode()
            : '';
          EditFactory.add(fidInt, scope.featureIRCollection, srid).then(
            function(res) {
              require('toastr').success('ok');
              scope.currentIR.id = res.data.create[0].id;
              gclayers.refreshlayerByid(fidInt, scope.map);
              //scope.currentIR.geometry= scope.geomInter;
              if (scope.currentIR.id) {
                GeometryFactory.getcentroid(scope.currentIR.geometry).then(
                  function(res1) {
                    scope.currentAnomalie.geometry.coordinates =
                      res1.data.coordinates;
                    gclayers
                      .getDrawLayer()
                      .getSource()
                      .clear();
                    scope.updateAnomalie();
                    scope.addRelation(
                      scope.featAnoUpdate,
                      scope.ftis['anomalie'].uid,
                      scope.currentIR.id,
                      relname1
                    );
                    scope.addRelation(
                      scope.featAnoUpdate,
                      scope.ftis['anomalie'].uid,
                      selectedObj.id,
                      relname2
                    );
                    scope.addRelation(
                      scope.canaCollection,
                      fidObj,
                      scope.currentIR.id,
                      relname3
                    );

                    ///Ajout d'un evenement si date debu de fin et agent sont renseignes
                    if (
                      scope.currentIR.properties.date_debut != undefined &&
                      scope.currentIR.properties.date_fin != undefined &&
                      scope.currentIR.properties.agent != undefined
                    ) {
                      var str = scope.currentIR.properties.agent;
                      var tabStr = str.split(' ');
                      var name = tabStr[1];
                      var surname = tabStr[2];
                      for (var i = 0; i < scope.users.length; i++) {
                        if (
                          scope.users[i].name == name &&
                          scope.users[i].vorname == surname
                        ) {
                          scope.userInterv = scope.users[i].login;
                        }
                      }

                      scope.addEventIntervention(fidInt);
                    }
                    SelectManager.clear();
                  }
                );
              }
            }
          );
        };

        //[saveInterventionFontRob add intervention reparation robinetterie ou fontainerie]
        scope.saveInterventionFontRob = function(
          resInt,
          geomInt,
          selectedObj,
          fidInt,
          relname1
        ) {
          scope.currentIR = resInt;
          scope.currentIR.geometry = geomInt;
          scope.featAnoUpdate = {
            type: 'FeatureCollection',
            features: [],
          };
          scope.featAnoUpdate.features.push({
            id: scope.currentAnomalie.id,
            type: 'Feature',
            geometry: scope.currentAnomalie.geometry,
            properties: scope.currentAnomalie.properties,
          });
          scope.canaCollection = {
            type: 'FeatureCollection',
            features: [],
          };
          scope.canaCollection.features.push({
            id: selectedObj.id,
            type: 'Feature',
            geometry: selectedObj.geometry,
            properties: selectedObj.properties,
          });
          scope.featureIRCollection = {
            type: 'FeatureCollection',
            features: [],
          };
          scope.featureIRCollection.features.push({
            type: 'Feature',
            geometry: scope.currentIR.geometry,
            properties: scope.currentIR.properties,
          });
          var srid = scope.map
            ? scope.map
                .getView()
                .getProjection()
                .getCode()
            : '';
          EditFactory.add(fidInt, scope.featureIRCollection, srid).then(
            function(res) {
              require('toastr').success('ok');
              scope.currentIR.id = res.data.create[0].id;
              gclayers.refreshlayerByid(fidInt, scope.map);
              //scope.currentIR.geometry= scope.geomInter;
              if (scope.currentIR.id) {
                // if (selectedObj.geometry.type=="Point"){
                scope.currentAnomalie.geometry.coordinates =
                  selectedObj.geometry.coordinates;
                //}
                /*    if (selectedObj.geometry.type=="LineString"){
                  scope.currentAnomalie.geometry.coordinates= scope.centerGeom;
                  }*/
                gclayers
                  .getDrawLayer()
                  .getSource()
                  .clear();
                scope.updateAnomalie();
                scope.addRelation(
                  scope.featAnoUpdate,
                  scope.ftis['anomalie'].uid,
                  scope.currentIR.id,
                  relname1
                );
                //scope.addRelation(scope.featAnoUpdate,scope.ftis['anomalie'].uid, selectedObj.id, relname2 );
                //scope.addRelation(scope.canaCollection,fidObj, scope.currentIR.id, relname3 );
                ////Ajout d'un evenement si date debu de fin et agent sont renseignes
                if (
                  scope.currentIR.properties.date_debut != undefined &&
                  scope.currentIR.properties.date_fin != undefined &&
                  scope.currentIR.properties.agent != undefined
                ) {
                  var str = scope.currentIR.properties.agent;
                  var tabStr = str.split(' ');
                  var name = tabStr[1];
                  var surname = tabStr[2];
                  for (var i = 0; i < scope.users.length; i++) {
                    if (
                      scope.users[i].name == name &&
                      scope.users[i].vorname == surname
                    ) {
                      scope.userInterv = scope.users[i].login;
                    }
                  }
                  scope.addEventIntervention(fidInt);
                }
              }
            }
          );
        };

        /**
         * [updateIntervention update intervention (tout type)]
         * @param  {[type]} resInt [description]
         * @param  {[type]} fid    [description]
         * @return {[type]}        [description]
         */
        scope.updateIntervention = function(resInt, fid) {
          scope.currentIR = resInt;
          scope.fidInt = fid;
          CalendarFactory.getevents('', '', '', '', scope.currentIR.id).then(
            function(result1) {
              //console.log(result1.data);
              scope.linkedEvents = result1.data.features;
              if (scope.currentIR.id) {
                scope.featIUpdate = {
                  type: 'FeatureCollection',
                  features: [],
                };
                scope.featIUpdate.features.push({
                  id: scope.currentIR.id,
                  type: 'Feature',
                  geometry: scope.currentIR.geometry,
                  properties: scope.currentIR.properties,
                });
                var srid = scope.map
                  ? scope.map
                      .getView()
                      .getProjection()
                      .getCode()
                  : '';
                EditFactory.update(scope.fidInt, scope.featIUpdate, srid).then(
                  function() {
                    require('toastr').success('ok');

                    gclayers.refreshlayerByid(scope.fidInt, scope.map);
                    //ajout d'evenement selon le type d'intervention

                    if (
                      scope.currentIR.properties.date_debut != undefined &&
                      scope.currentIR.properties.date_fin != undefined &&
                      scope.currentIR.properties.agent != undefined
                    ) {
                      var str = scope.currentIR.properties.agent;
                      var tabStr = str.split(' ');
                      var name = tabStr[1];
                      var surname = tabStr[2];
                      for (var i = 0; i < scope.users.length; i++) {
                        if (
                          scope.users[i].name == name &&
                          scope.users[i].vorname == surname
                        ) {
                          scope.userInterv = scope.users[i].login;
                        }
                      }
                      if (scope.linkedEvents && scope.linkedEvents.length > 0) {
                        scope.currentEvent = scope.linkedEvents[0];
                        scope.updateEventIntervention(scope.fidInt);
                      } else {
                        scope.addEventIntervention(scope.fidInt);
                      }
                    }
                    //console.log(res.data);
                  },
                  function(res) {
                    require('toastr').error('error');
                  }
                );
              }
            }
          );
        };

        /**
         * [removeIntReparation supprime une intervention de type reparation canalisation ou branchement ]
         * @param  {[type]} resInt  [description]
         * @param  {[type]} relname [description]
         * @param  {[type]} fidInt  [description]
         * @param  {[type]} fidAno  [description]
         * @return {[type]}         [description]
         */
        scope.removeIntReparation = function(
          resInt,
          relname,
          fidInt,
          fidAno,
          relname2,
          relname3,
          idObj,
          fidObj
        ) {
          scope.currentIR = resInt;

          var ans = confirm($filter('translate')('aepintervention.deleteInt'));
          if (ans) {
            var selectBranch = scope.feattree.get_selected_branch();
            var parentUid = selectBranch.parent_uid;
            var tab = scope.featdata[1].children;
            for (var i = 0; i < tab.length; i++) {
              if (tab[i].uid === parentUid) {
                tab.splice(i, 1);
              }
            }
            scope.featdata[1].children = tab;
            EditFactory.remove(fidInt, scope.currentIR.id).then(function(res) {
              QueryFactory.relation(
                fidInt,
                relname,
                scope.currentIR.id,
                ''
              ).then(function(res) {
                if (res.data.features.length) {
                  gclayers.refreshlayerByid(fidInt, scope.map);
                  //scope.delRelation(fidInt,relname, scope.currentIR.id, res.data.features[0].id,true);
                  //scope.delRelation(fidAno,relname, res.data.features[0].id,scope.currentIR.id, true);
                  scope.delRelation(
                    fidInt,
                    relname,
                    res.data.features[0].id,
                    scope.currentIR.id,
                    true
                  );
                  scope.delRelation(
                    fidAno,
                    relname,
                    scope.currentIR.id,
                    res.data.features[0].id,
                    true
                  );
                  scope.delRelation(
                    fidInt,
                    relname2,
                    idObj,
                    scope.currentIR.id,
                    true
                  );
                  scope.delRelation(
                    fidObj,
                    relname2,
                    scope.currentIR.id,
                    idObj,
                    true
                  );
                  scope.delRelation(
                    fidAno,
                    relname3,
                    idObj,
                    res.data.features[0].id,
                    true
                  );
                  scope.delRelation(
                    fidObj,
                    relname3,
                    res.data.features[0].id,
                    idObj,
                    true
                  );

                  CalendarFactory.getevents(
                    '',
                    '',
                    '',
                    '',
                    scope.currentIR.id
                  ).then(function(result1) {
                    scope.linkedEvents = result1.data.features;
                    if (scope.linkedEvents && scope.linkedEvents.length > 0) {
                      var id = scope.linkedEvents[0].id.split('.');
                      scope.removeEventIntervention(id[1]);
                      $rootScope.$broadcast('kis_calendar_event_refresh');
                    }
                  });
                }
              });
              require('toastr').success('ok');
            });
          }
          goToBranch(scope.feattree, '1');
        };

        scope.removeIntReparationRobFont = function(
          resInt,
          relname,
          fidInt,
          fidAno
        ) {
          scope.currentIR = resInt;
          var ans = confirm($filter('translate')('aepintervention.deleteInt'));
          if (ans) {
            var selectBranch = scope.feattree.get_selected_branch();
            var parentUid = selectBranch.parent_uid;
            var tab = scope.featdata[1].children;
            for (var i = 0; i < tab.length; i++) {
              if (tab[i].uid === parentUid) {
                tab.splice(i, 1);
              }
            }
            scope.featdata[1].children = tab;
            EditFactory.remove(fidInt, scope.currentIR.id).then(function(res) {
              QueryFactory.relation(
                fidInt,
                relname,
                scope.currentIR.id,
                ''
              ).then(function(res) {
                if (res.data.features.length) {
                  gclayers.refreshlayerByid(fidInt, scope.map);
                  //scope.delRelation(fidInt,relname, scope.currentIR.id, res.data.features[0].id,true);
                  //scope.delRelation(fidAno,relname, res.data.features[0].id,scope.currentIR.id, true);
                  scope.delRelation(
                    fidInt,
                    relname,
                    res.data.features[0].id,
                    scope.currentIR.id,
                    true
                  );
                  scope.delRelation(
                    fidAno,
                    relname,
                    scope.currentIR.id,
                    res.data.features[0].id,
                    true
                  );

                  CalendarFactory.getevents(
                    '',
                    '',
                    '',
                    '',
                    scope.currentIR.id
                  ).then(function(result1) {
                    scope.linkedEvents = result1.data.features;
                    if (scope.linkedEvents && scope.linkedEvents.length > 0) {
                      var id = scope.linkedEvents[0].id.split('.');
                      scope.removeEventIntervention(id[1]);
                      $rootScope.$broadcast('kis_calendar_event_refresh');
                    }
                  });
                }
              });

              require('toastr').success('ok');
            });
          }
          goToBranch(scope.feattree, '1');
        };
        /**
         * [updateCana mise à jour des attrubut de la cana selectionné pour l'intervention]
         * @return {[type]} [description]
         */
        scope.updateCana = function() {
          if (scope.selectedCana.id) {
            scope.featCanaUpdate = {
              type: 'FeatureCollection',
              features: [],
            };
            scope.featCanaUpdate.features.push({
              id: scope.selectedCana.id,
              type: 'Feature',
              geometry: scope.selectedCana.geometry,
              properties: scope.selectedCana.properties,
            });
            var srid = scope.map
              ? scope.map
                  .getView()
                  .getProjection()
                  .getCode()
              : '';
            EditFactory.update(
              scope.ftis['canalisation'].uid,
              scope.featCanaUpdate,
              srid
            ).then(
              function(res) {
                console.log(res.data);

                require('toastr').success('ok');
              },
              function() {
                require('toastr').error('error');
              }
            );
          }
        };

        /**
         * Renvoie l'objet layer situé dans le tableau layers passé en second argument et
         * dont le nom correspond au premier argument layerName.
         * @param {type} layerName
         * @param {type} layers
         * @returns {unresolved}
         */
        function getLayerByName(layerName, layers) {
          var layer = undefined;
          for (var i = 0; i < layers.length; i++) {
            var l = layers[i];
            if (l.get('name') == undefined) continue;
            if (layerName == l.get('name')) {
              layer = l;
              break;
            }
          }
          return layer;
        }
        /**
         * [highLightFeature mide en evidence du feature survolé]
         * @param  {[type]} f [description]
         * @return {[type]}   [description]
         */
        scope.highLightFeature = function(f) {
          var featid = f.id;
          var featX = gclayers.getselectSource().getFeatureById(featid);
          gclayers.addhighLightFeature(featX);
        };
        /**
         * [removehighLightFeature ]
         * @param  {[type]} f [description]
         * @return {[type]}   [description]
         */
        scope.removehighLightFeature = function(f) {
          var featid = f.id;
          var featX = gclayers.getselectSource().getFeatureById(featid);
          gclayers.removehighLightFeatures(featX);
        };

        // si plusieurs cana selectionnés choisir seulement une
        scope.openPopupChoice = function(features) {
          scope.closeThisDialog = function(res) {
            SelectManager.clear();
            gclayers.clearhighLightFeatures();
            gclayers
              .getDrawLayer()
              .getSource()
              .clear();
            scope.p2.destroy();
          };
          scope.result = {};
          scope.confirm = function(featureChoosen) {
            if (featureChoosen == undefined) {
              return;
            } else {
              $timeout(function() {
                scope.selectedCana = featureChoosen;
                GeometryFactory.unionandbuffer(
                  scope.selectedCana.geometry,
                  'ROUND',
                  2
                ).then(function(res1) {
                  scope.geomBuff = res1.data;

                  var type = scope.res.selectGeom.getType();
                  var coords = scope.res.selectGeom.getCoordinates();
                  scope.geomSelect = {
                    coordinates: coords,
                    type: type,
                  };

                  var geoms = [scope.geomBuff, scope.geomSelect];
                  //GeometryFactory.intersect(scope.geomBuff,JSON.stringify(scope.geomSelect) ).then(function(res) {
                  GeometryFactory.intersectTwoGeoms(geoms).then(function(res) {
                    scope.geomInter = res.data;
                  });
                });
                scope.selectReparationChange();
              }, 1000);
            }
            if (scope.p2) scope.p2.destroy();
          };

          if (scope.p2 != undefined && scope.p2.element != null)
            scope.p2.destroy();

          gclayers.clearhighLightFeatures();
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();
          scope.feats = features;
          scope.p2 = gcPopup.open({
            scope: scope,
            title: $filter('translate')('gcimportfeatures.pick_feature'),
            template:
              'js/XG/biz/aepInterventions/views/interventions/reseau/reparation/popupChoiceObject.html',
            showClose: true,
          });
        };
        /**
         * [resultBufferCana resultat de selection d'une cana pour intervention]
         * @return {[type]} [description]
         */
        scope.resultBufferCana = function() {
          //console.log(scope.res.cana);
          if (scope.res.cana.features.length > 1) {
            SelectManager.addFeaturesFromGeojson(scope.res.cana);
            scope.openPopupChoice(scope.res.cana.features);
          } else {
            $timeout(function() {
              scope.selectedCana = scope.res.cana.features[0];
              scope.geomBuff = scope.res.buffGeom;
              var type = scope.res.selectGeom.getType();
              var coords = scope.res.selectGeom.getCoordinates();
              scope.geomSelect = {
                coordinates: coords,
                type: type,
              };
              var geoms = [scope.geomBuff, scope.geomSelect];
              //GeometryFactory.intersect(scope.geomBuff,JSON.stringify(scope.geomSelect) ).then(function(res) {
              GeometryFactory.intersectTwoGeoms(geoms).then(function(res) {
                scope.geomInter = res.data;
              });
              scope.selectReparationChange();
            }, 1000);
          }
        };
        /**
         * [resultBufferBranch resultat de selection d'un branchement pour selection]
         * @return {[type]} [description]
         */
        scope.resultBufferBranch = function() {
          if (scope.res.branch.features.length > 1) {
            //require('toastr').error("veuillez sélectionner un seul branchement");
            require('toastr').error(
              $filter('translate')('aepintervention.messageBranch')
            );
          } else {
            $timeout(function() {
              scope.selectedBranch = scope.res.branch.features[0];
              scope.geomBuffBranch = scope.res.buffGeomBranch;
              var type = scope.res.selectGeomBranch.getType();
              var coords = scope.res.selectGeomBranch.getCoordinates();
              scope.geomSelectBranch = {
                coordinates: coords,
                type: type,
              };
              var geoms = [scope.geomBuffBranch, scope.geomSelectBranch];
              //GeometryFactory.intersect(scope.geomBuffBranch,JSON.stringify(scope.geomSelectBranch) ).then(function(res) {
              GeometryFactory.intersectTwoGeoms(geoms).then(function(res) {
                scope.geomInterBranch = res.data;
              });
              scope.selectReparationChange();
            }, 1000);
          }
        };
        /**
         * [resultBufferFont selection d'un element de fontainerie pour intervention]
         * @return {[type]} [description]
         */
        scope.resultBufferFont = function() {
          $timeout(function() {
            scope.selectedFont = scope.res.font.features[0];
            scope.geomInterFont = scope.res.interGeomFont;
            scope.selectReparationChange();
          }, 1000);
        };
        /**
         * [resultBufferRob resultat de selection d'un element de robinetterie pour intervention]
         * @return {[type]} [description]
         */
        scope.resultBufferRob = function() {
          $timeout(function() {
            scope.selectedRob = scope.res.rob.features[0];
            scope.geomInterRob = scope.res.interGeomRob;
            scope.selectReparationChange();
          }, 1000);
        };

        // si choix intervention reseau autre
        var interventionAutre = {
          label: $filter('translate')('aepintervention.intervAutre'),
          template:
            'js/XG/biz/aepInterventions/views/interventions/reseau/interventionAutre.html',
        };
        scope.addInterventionAutre = function() {
          // add intervention
          // add intervention to anomalie
          // open ihm intervention recherche de fuite
          if (scope.res.interventionReseau == 'AUTRE') {
            scope.featdata[1].children.push(angular.copy(interventionAutre));
          }
        };

        // si intervention OUVRAGE
        var interventionOuvrage = {
          label: $filter('translate')('aepintervention.intervOuvrage'),
          template:
            'js/XG/biz/aepInterventions/views/interventions/interventionOuvrage.html',
        };
        scope.addInterventionOuvrage = function() {
          // add intervention
          // add intervention to anomalie
          // open ihm intervention recherche de fuite
          if (scope.res.selectedIntervention == 'OUVRAGE') {
            scope.featdata[1].children.push(angular.copy(interventionOuvrage));
          }
        };

        // si intervention ABONNEE
        var interventionAbonnee = {
          label: $filter('translate')('aepintervention.intervAbonnee'),
          template:
            'js/XG/biz/aepInterventions/views/interventions/interventionAbonnee.html',
        };
        scope.addInterventionAbonnee = function() {
          // add intervention
          // add intervention to anomalie
          // open ihm intervention recherche de fuite
          if (scope.res.selectedIntervention == 'ABONNEE') {
            scope.featdata[1].children.push(angular.copy(interventionAbonnee));
          }
        };
        /**
         * [openPopupCompteur choix d'un compteur pour intervention chez l'bonnee]
         * @param  {[type]} features [description]
         * @return {[type]}          [description]
         */
        scope.openPopupCompteur = function(features) {
          scope.closeThisDialog = function(res) {
            SelectManager.clear();
            gclayers.clearhighLightFeatures();
            gclayers
              .getDrawLayer()
              .getSource()
              .clear();
            scope.p3.destroy();
          };
          scope.result = {};
          scope.confirm = function(comptChoosen) {
            if (comptChoosen == undefined) {
              return;
            } else {
              $timeout(function() {
                scope.selectedCompteur = comptChoosen;
                scope.res.int['intAbon'].properties.num_compteur =
                  scope.selectedCompteur.properties.numero;
                scope.res.int['intAbon'].properties.index =
                  scope.selectedCompteur.properties.index;
                scope.res.int['intAbon'].properties.diametre_compt =
                  scope.selectedCompteur.properties.diametre;
                scope.res.int['intAbon'].properties.modele_compt =
                  scope.selectedCompteur.properties.modele;
                scope.res.int['intAbon'].properties.annee_compt =
                  scope.selectedCompteur.properties.annee;
                SelectManager.clear();
                gclayers.clearhighLightFeatures();
                gclayers
                  .getDrawLayer()
                  .getSource()
                  .clear();
              }, 1000);
            }
            if (scope.p3) scope.p3.destroy();
          };

          if (scope.p3 != undefined && scope.p3.element != null)
            scope.p3.destroy();

          gclayers.clearhighLightFeatures();
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();
          scope.feats = features;
          scope.p3 = gcPopup.open({
            scope: scope,
            title: $filter('translate')('aepintervention.choisirCompt'),
            template:
              'js/XG/biz/aepInterventions/views/interventions/popupChoiceCompteur.html',
            showClose: true,
          });
        };
        /**
         * [resultCompteur resultat de selection du compteur]
         * @return {[type]} [description]
         */
        scope.resultCompteur = function() {
          if (scope.res.compt.features.length > 0) {
            SelectManager.addFeaturesFromGeojson(scope.res.compt);
            scope.openPopupCompteur(scope.res.compt.features);
          }
        };
        // ajout de la branche intervention reseau en fonction du type
        scope.addIntReseau = function() {
          switch (scope.res.interventionReseau) {
            case 'RECHERCHE':
              scope.addInterventionRecherche();
              break;
            case 'REPARATION':
              scope.addInterventionReparation();
              break;
            case 'AUTRE':
              scope.addInterventionAutre();
              break;
          }
        };
        // ajout d'une intervention en fonction du type
        scope.addIntervention = function() {
          switch (scope.res.selectedIntervention) {
            case 'RESEAU':
              scope.addIntReseau();
              break;
            case 'OUVRAGE':
              scope.addInterventionOuvrage();
              break;
            case 'ABONNEE':
              scope.addInterventionAbonnee();
              break;
          }
        };

        /****************************************Recuperation des informations de l'anomalie en cours ansi que les informations des objets en relation************************************************************************************/
        /**********************************************************************************************************************************************************************/
        if (scope.currentAnomalie && scope.currentAnomalie.id) {
          scope.res['anomalie'] = scope.currentAnomalie;
          scope.$watch('res.anomalie.properties.date_urgence', function(
            newValue,
            oldValue
          ) {
            if (newValue !== oldValue) {
              var dateA = scope.currentAnomalie.properties.date_anomalie;
              var dateU = scope.res['anomalie'].properties.date_urgence;
              scope.urgence.value = scope.diff(dateA, dateU) - 1;
            }
          });
          if (scope.currentAnomalie.properties.date_urgence == undefined) {
            scope.urgence.value = '';
          } else {
            var dateA = scope.currentAnomalie.properties.date_anomalie;
            var dateU = scope.res['anomalie'].properties.date_urgence;
            scope.urgence.value = scope.diff(dateA, dateU) - 1;
          }
          if (scope.currentAnomalie.properties.agent != undefined) {
            var str = scope.currentAnomalie.properties.agent;
            scope.agents = str.split(',');
          }
          QueryFactory.relation(
            scope.ftis['anomalie'].uid,
            'Ano_Emetteur',
            scope.currentAnomalie.id,
            ''
          ).then(function(res) {
            if (res.data.features.length) {
              scope.currentEmetteur = res.data.features[0];
            }
          });
          if (
            scope.currentAnomalie.properties.etat == 'Intervention à faire' ||
            scope.currentAnomalie.properties.etat == 'Dossier clos'
          ) {
            scope.featdata.push(intervention0);
            QueryFactory.relationReprojected(
              scope.ftis['anomalie'].uid,
              'Ano_IR',
              scope.currentAnomalie.id,
              '',
              scope.map
                .getView()
                .getProjection()
                .getCode()
            ).then(function(res) {
              if (res.data.features.length) {
                scope.tabRech = res.data.features;
                for (var i = 0; i < scope.tabRech.length; i++) {
                  scope.featdata[1].children.push(
                    angular.copy(interventionRecherche)
                  );
                  scope.res.int['intRech'] = scope.tabRech[i];
                }
              }
            });
            // si intervention sur cana
            QueryFactory.relationReprojected(
              scope.ftis['anomalie'].uid,
              'Ano_RepCana',
              scope.currentAnomalie.id,
              '',
              scope.map
                .getView()
                .getProjection()
                .getCode()
            ).then(function(res) {
              if (res.data.features.length) {
                var intRepCana = {
                  label: $filter('translate')(
                    'aepintervention.reparationFuite'
                  ),
                  template:
                    'js/XG/biz/aepInterventions/views/interventions/reseau/interventionReparation.html',
                };

                intRepCana['children'] = [cana, interCana];
                console.log(interventionReparation);
                scope.feattree.add_branch(
                  scope.featdata[1],
                  angular.copy(intRepCana)
                );
                scope.res.reparationInt = 'CANALISATION';
                scope.res.int.intRep['intCana'] = res.data.features[0];
                interCana = res.data.features[0];
                // cana en relation
                QueryFactory.relationReprojected(
                  scope.ftis['anomalie'].uid,
                  'Ano_Cana',
                  scope.currentAnomalie.id,
                  '',
                  scope.map
                    .getView()
                    .getProjection()
                    .getCode()
                ).then(function(res) {
                  if (res.data.features.length) {
                    scope.selectedCana = res.data.features[0];
                    scope.res.int.intRep['canalisation'] = res.data.features[0];
                  }
                });
              }
            });
            // si intervention dur branchement
            QueryFactory.relationReprojected(
              scope.ftis['anomalie'].uid,
              'Ano_RepBranch',
              scope.currentAnomalie.id,
              '',
              scope.map
                .getView()
                .getProjection()
                .getCode()
            ).then(function(res) {
              if (res.data.features.length) {
                var intRepBranch = {
                  label: $filter('translate')(
                    'aepintervention.reparationFuite'
                  ),
                  template:
                    'js/XG/biz/aepInterventions/views/interventions/reseau/interventionReparation.html',
                };
                intRepBranch['children'] = [intBranchement];
                scope.feattree.add_branch(
                  scope.featdata[1],
                  angular.copy(intRepBranch)
                );
                scope.res.reparationInt = 'BRANCHEMENT';
                scope.res.int.intRep['intbranchement'] = res.data.features[0];
                QueryFactory.relationReprojected(
                  scope.ftis['anomalie'].uid,
                  'Ano_Branch',
                  scope.currentAnomalie.id,
                  '',
                  scope.map
                    .getView()
                    .getProjection()
                    .getCode()
                ).then(function(res) {
                  if (res.data.features.length) {
                    scope.selectedBranch = res.data.features[0];
                    scope.res.int.intRep['branchement'] = res.data.features[0];
                  }
                });
              }
            });
            //si intervention sur fontainerie
            QueryFactory.relationReprojected(
              scope.ftis['anomalie'].uid,
              'Ano_RepFont',
              scope.currentAnomalie.id,
              '',
              scope.map
                .getView()
                .getProjection()
                .getCode()
            ).then(function(res) {
              if (res.data.features.length) {
                var intRepFont = {
                  label: $filter('translate')(
                    'aepintervention.reparationFuite'
                  ),
                  template:
                    'js/XG/biz/aepInterventions/views/interventions/reseau/interventionReparation.html',
                };
                intRepFont['children'] = [intFontainerie];
                scope.feattree.add_branch(
                  scope.featdata[1],
                  angular.copy(intRepFont)
                );
                scope.res.int.intRep['intfont'] = res.data.features[0];
                scope.res.reparationInt = 'FONTAINERIE';
                QueryFactory.relationReprojected(
                  scope.ftis['anomalie'].uid,
                  'Ano_Font',
                  scope.currentAnomalie.id,
                  '',
                  scope.map
                    .getView()
                    .getProjection()
                    .getCode()
                ).then(function(res) {
                  if (res.data.features.length) {
                    scope.selectedFont = res.data.features[0];
                    // scope.res.int.intRep['fontainerie']= res.data.features[0];
                  }
                });
              }
            });
            // si intervention sur robinetterie
            QueryFactory.relationReprojected(
              scope.ftis['anomalie'].uid,
              'Ano_RepRob',
              scope.currentAnomalie.id,
              '',
              scope.map
                .getView()
                .getProjection()
                .getCode()
            ).then(function(res) {
              if (res.data.features.length) {
                var intRepRob = {
                  label: $filter('translate')(
                    'aepintervention.reparationFuite'
                  ),
                  template:
                    'js/XG/biz/aepInterventions/views/interventions/reseau/interventionReparation.html',
                };
                intRepRob['children'] = [intRobinetterie];
                scope.feattree.add_branch(
                  scope.featdata[1],
                  angular.copy(intRepRob)
                );
                scope.res.int.intRep['intRob'] = res.data.features[0];
                scope.res.reparationInt = 'ROBINETERIE';
                QueryFactory.relationReprojected(
                  scope.ftis['anomalie'].uid,
                  'Ano_RepRob',
                  scope.currentAnomalie.id,
                  '',
                  scope.map
                    .getView()
                    .getProjection()
                    .getCode()
                ).then(function(res) {
                  if (res.data.features.length) {
                    scope.selectedRob = res.data.features[0];
                    //scope.res.int.intRep['fontainerie']= res.data.features[0];
                  }
                });
              }
            });
            //si intervention sur ouvrage
            QueryFactory.relationReprojected(
              scope.ftis['anomalie'].uid,
              'Ano_Ouvr',
              scope.currentAnomalie.id,
              '',
              scope.map
                .getView()
                .getProjection()
                .getCode()
            ).then(function(res) {
              if (res.data.features.length) {
                scope.tabRech = res.data.features;
                for (var i = 0; i < scope.tabRech.length; i++) {
                  scope.featdata[1].children.push(
                    angular.copy(interventionOuvrage)
                  );
                  scope.res.int['intOuv'] = scope.tabRech[i];
                }
              }
            });
            // si intervention chez l'abonnee
            QueryFactory.relationReprojected(
              scope.ftis['anomalie'].uid,
              'Ano_Abo',
              scope.currentAnomalie.id,
              '',
              scope.map
                .getView()
                .getProjection()
                .getCode()
            ).then(function(res) {
              if (res.data.features.length) {
                scope.tabRech = res.data.features;
                for (var i = 0; i < scope.tabRech.length; i++) {
                  scope.featdata[1].children.push(
                    angular.copy(interventionAbonnee)
                  );
                  scope.res.int['intAbon'] = scope.tabRech[i];
                }
              }
            });
            // si autre intervention
            QueryFactory.relationReprojected(
              scope.ftis['anomalie'].uid,
              'Ano_Autre',
              scope.currentAnomalie.id,
              '',
              scope.map
                .getView()
                .getProjection()
                .getCode()
            ).then(function(res) {
              if (res.data.features.length) {
                scope.tabRech = res.data.features;
                for (var i = 0; i < scope.tabRech.length; i++) {
                  scope.featdata[1].children.push(
                    angular.copy(interventionAutre)
                  );
                  scope.res.int['intAutre'] = scope.tabRech[i];
                }
              }
            });
          }
          //scope.updateAnomalie();
        }

        /**
         * [saveAllInterventions save or update anomalie and intervention when close the current anomalie folder]
         * @return {[type]} [description]
         */
        scope.saveAllInterventions = function() {
          var resInts = scope.res.int;
          //sauvegarde ou update de l'intervention canalisation
          if (resInts && resInts.intRep.intCana) {
            if (resInts.intRep.intCana.id == undefined) {
              scope.saveIntervention(
                resInts.intRep['intCana'],
                scope.geomInter,
                scope.selectedCana,
                scope.ftis['intCana'].uid,
                scope.ftis['canalisation'].uid,
                'Ano_RepCana',
                'Ano_Cana',
                'RepCana_Cana'
              );
              scope.updateCana();
            } else {
              scope.updateIntervention(
                resInts.intRep['intCana'],
                scope.ftis['intCana'].uid
              );
              scope.updateCana();
            }
          }
          //sauvegarde ou update de l'intervention branchement
          if (resInts && resInts.intRep.intbranchement) {
            if (resInts.intRep.intbranchement.id == undefined) {
              scope.saveIntervention(
                resInts.intRep['intbranchement'],
                scope.geomInterBranch,
                scope.selectedBranch,
                scope.ftis['intbranchement'].uid,
                scope.ftis['branchement'].uid,
                'Ano_RepBranch',
                'Ano_Branch',
                'IntBranch_Branch'
              );
            } else {
              scope.updateIntervention(
                resInts.intRep['intbranchement'],
                scope.ftis['intbranchement'].uid
              );
            }
          }
          // sauvegarde ou update de l'intervention robinettterie
          if (resInts && resInts.intRep.intRob) {
            if (resInts.intRep.intRob.id == undefined) {
              scope.saveInterventionFontRob(
                scope.res.int.intRep['intRob'],
                scope.geomInterRob,
                scope.selectedRob,
                scope.ftis['introb'].uid,
                'Ano_RepRob'
              );
            } else {
              scope.updateIntervention(
                scope.res.int.intRep['intRob'],
                scope.ftis['introb'].uid
              );
            }
          }
          // sauvegarde ou update de l'intervention fontainerie
          if (resInts && resInts.intRep.intfont) {
            if (resInts.intRep.intfont.id == undefined) {
              scope.saveInterventionFontRob(
                scope.res.int.intRep['intfont'],
                scope.geomInterFont,
                scope.selectedFont,
                scope.ftis['intfont'].uid,
                'Ano_RepFont'
              );
            } else {
              scope.updateIntervention(
                scope.res.int.intRep['intfont'],
                scope.ftis['intfont'].uid
              );
            }
          }

          // to do sauvegarde ses interventions robinetterie et fontainerie
          if (resInts && resInts.intRech) {
            if (resInts.intRech.id == undefined) {
              scope.addIntRechAboOuv(
                scope.res.int['intRech'],
                scope.ftis['intRech'].uid,
                'Ano_IR'
              );
            } else {
              scope.updateIntervention(
                scope.res.int['intRech'],
                scope.ftis['intRech'].uid
              );
            }
          }
          if (resInts && resInts.intAutre) {
            if (resInts.intAutre.id == undefined) {
              scope.addIntRechAboOuv(
                scope.res.int['intAutre'],
                scope.ftis['intAutre'].uid,
                'Ano_Autre'
              );
            } else {
              scope.updateIntervention(
                scope.res.int['intAutre'],
                scope.ftis['intAutre'].uid
              );
            }
          }
          if (resInts && resInts.intOuv) {
            if (resInts.intOuv.id == undefined) {
              scope.addIntRechAboOuv(
                scope.res.int['intOuv'],
                scope.ftis['intOuv'].uid,
                'Ano_Ouvr'
              );
            } else {
              scope.updateIntervention(
                scope.res.int['intOuv'],
                scope.ftis['intOuv'].uid
              );
            }
          }
          if (resInts && resInts.intAbon) {
            if (resInts.intAutre.id == undefined) {
              scope.addIntRechAboOuv(
                scope.res.int['intAbon'],
                scope.ftis['intAbon'].uid,
                'Ano_Abo'
              );
            } else {
              scope.updateIntervention(
                scope.res.int['intAbon'],
                scope.ftis['intAbon'].uid
              );
            }
          }
        };
        /****************************************FONCTIONS DOCUMENTS ASSOCIES************************************************************************************/
        /**********************************************************************************************************************************************************************/
        //Load pictures
        scope.attachmentIsImage = function(fn) {
          if (fn == undefined) return false;
          var fnlc = fn.toLowerCase();
          if (fnlc.endsWith('.jpeg')) return true;
          if (fnlc.endsWith('.jpg')) return true;
          if (fnlc.endsWith('.png')) return true;
          if (fnlc.endsWith('.gif')) return true;
          return false;
        };

        /**
         *     Si le nom de fichier en paramètre a une extension connue
         *  de fichier ilmage, on télécharge l'image afin d'en afficher uneminiature.
         *
         */
        scope.loadPicture = function(fti, feat, fn) {
          if (fn != undefined && fn != '' && scope.attachmentIsImage(fn)) {
            FeatureAttachmentFactory.getcontent(
              fn,
              fti.name,
              feat.id,
              'base64;thumbnail'
            ).then(function(res) {
              if (res.data != 'fichier inexistant')
                scope.pictures[fn] = 'data:image/jpeg;base64,' + res.data;
            });
          }
        };

        /**
         *  Récupération des images afin de pouvoir
         *  les afficher en tant que miniature.
         */
        scope.loadPictures = function(fti, feat) {
          var iatt, att, picNames, ipicname;

          if (scope.pictures != undefined) delete scope.pictures;
          scope.pictures = {};

          for (iatt = 0; iatt < fti.attributes.length; iatt++) {
            att = fti.attributes[iatt];
            if (feat.properties[att.name] != undefined) {
              if (att.type == 'g2c.attachment')
                scope.loadPicture(fti, feat, feat.properties[att.name]);
              else if (att.type == 'g2c.attachments') {
                picNames = feat.properties[att.name].split(',');
                for (ipicname = 0; ipicname < picNames.length; ipicname++) {
                  if (picNames[ipicname] != '')
                    scope.loadPicture(fti, feat, picNames[ipicname]);
                }
              }
            }
          }
        };

        scope.viewsattachement = function(name, ftid, id) {
          // var fn = ""+$scope.selected_filename.name;
          FeatureAttachmentFactory.getdownloadurl(name, ftid, id).then(function(
            res
          ) {
            console.log(res);
            window.open(escape(res.data));
          });
        };

        scope.$on('getAepIntervention', function(event) {
          scope.updateAnomalie();
          map.removeInteraction(draw);
          scope.saveAllInterventions();
          //console.log(scope.res);
        });

        scope.$on('desactiveDrawAno', function(event) {
          map.removeInteraction(draw);
        });
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    'EditFactory',
    'QueryFactory',
    'gclayers',
    'extendedNgDialog',
    '$timeout',
    '$q',
    '$http',
    'ngDialog',
    'GoogleGeocodeFactory',
    'DocumentFactory',
    'gaDomUtils',
    '$rootScope',
    '$filter',
    'kisGeocodageFactory',
    'gcPopup',
    'SelectManager',
    'GeometryFactory',
    'FeatureAttachmentFactory',
    '$translate',
    'UsersFactory',
    'CalendarFactory',
    'NominatimFactory',
    'gceditsaveAttachmentFactory',
  ];
  return gcelement;
});
