/**
 *
 */
'use strict';
define(function() {
  var fftable4updl2Ctrl = function(
    $scope,
    QueryFactory,
    FeatureTypeFactory,
    EditFactory,
    ngDialog,
    GlobalServices,
    UnitsFactory,
    gaJsUtils
  ) {
    $scope.attributes = [];
    $scope.listsOfValues = {};
    $scope.objects = [];
    if ($scope.theField01.mode == 'readonly') $scope.enabled = false;
    else $scope.enabled = true;

    $scope.dialogDelConfirm = '<div>Confirmez vous la suppresion ?</div>';
    $scope.dialogDelConfirm += '<div>';
    $scope.dialogDelConfirm +=
      "  <button ng-click='delRecordYes()'>Oui</button>";
    $scope.dialogDelConfirm +=
      "  <button ng-click='delRecordNo()'>Non</button>";
    $scope.dialogDelConfirm += '</div>';

    $scope.getThisObjFeatureDesc = function() {
      if ($scope.thisObjFeatureDesc == undefined)
        $scope.thisObjFeatureDesc = FeatureTypeFactory.getFeatureTypeDesc(
          $scope.theField01.config.datastoreName,
          $scope.theField01.config.featureName
        );
      if ($scope.thisObjFeatureDesc == null)
        gaJsUtils.errorMessage(
          'La table [' +
            $scope.theField01.config.featureName +
            "] n'a pas été trouvée !",
          ''
        );

      return $scope.thisObjFeatureDesc;
    };

    $scope.executeNextAction = function(nextAction) {
      if (nextAction.name == 'enableCommands') $scope.enableCommands();
      else if (nextAction.name == 'buildObjectList') $scope.buildObjectList();
      else if (nextAction.name == 'buildObjectListAndManageEnabledWhen') {
        $scope.buildObjectList();
        if ($scope.theField01.config.enabledWhen != undefined)
          $scope.manageEnabledWhen(
            nextAction.data,
            $scope.theField01.config.enabledWhen
          );
      }
    };

    $scope.prepareRelationMgt = function(featureName, object, nextAction) {
      var indPt = featureName.indexOf('.');

      if (indPt == -1) {
        $scope.relationDesc = {};
        $scope.relationDesc.featureName = featureName;
        if (object != undefined)
          $scope.relationDesc.mainObjectId = QueryFactory.getFeatureId(object);
        $scope.relationDesc.parentRelations = $scope.lastParentRelations;
        if (nextAction != undefined) $scope.executeNextAction(nextAction);
      } else {
        var newFeatureName = featureName.substr(indPt + 1);
        var tableName = featureName.substr(0, indPt);
        var ftDesc = FeatureTypeFactory.getFeatureTypeDesc(
          $scope.theField01.config.datastoreName,
          tableName
        );

        if (object != undefined && object.id != null) {
          var where;
          rel = $scope.getRelation($scope.lastParentRelations, tableName);
          $scope.lastParentObjectId = QueryFactory.getFeatureId(object);
          if (rel.fieldStart == 'id')
            where = rel.fieldEnd + '=' + $scope.lastParentObjectId;
          else where = rel.fieldEnd + '=' + object.properties[rel.fieldStart];
          $scope.lastParentRelations = ftDesc.relations;
          $scope.lastParentTableName = tableName;
          QueryFactory.data(ftDesc.uid, where).then(function(res) {
            if (res.data.features.length != 0)
              $scope.prepareRelationMgt(
                newFeatureName,
                res.data.features[0],
                nextAction
              );
            else
              gaJsUtils.errorMessage(
                'La relation avec la table [' +
                  tableName +
                  "] n'a pas été trouvée !",
                ''
              );
          });
        } else {
          $scope.lastParentRelations = ftDesc.relations;
          $scope.prepareRelationMgt(newFeatureName, undefined);
        }
      }
    };

    /**
     *     Get relation description from main table description which concerns
     *  the child table managed in this component.
     */
    $scope.getRelation = function(relations, featureName, startField) {
      var ind;
      /*
            for (ind=0; ind<$scope.theField01.relations.length;ind++)
                {
                 if ($scope.theField01.relations[ind].componentEnd==$scope.theField01.config.featureName)
                     return $scope.theField01.relations[ind];
                }
                */
      if (featureName != undefined)
        for (ind = 0; ind < relations.length; ind++) {
          if (relations[ind].componentEnd == featureName) return relations[ind];
        }
      if (startField != undefined)
        for (ind = 0; ind < relations.length; ind++) {
          if (relations[ind].fieldStart == startField) return relations[ind];
        }
      return null;
    };

    $scope.manageUnitField = function(att) {
      if (att.unit == undefined || att.unit.type == undefined) {
        att.fieldHasUnit = false;
      } else {
        var unitName, unitDesc;
        att.fieldHasUnit = true;
        unitName = att.unit.type;
        att.currentUnitFactor = {};
        att.numericValue = {};
        //-- Initial value (in case there is one)
        //att.numericValue.value = $scope.theField01.objectField.value;
        UnitsFactory.getUnitDescription(unitName).then(function(res) {
          att.unitDesc = res;
          if (att.unitDesc != undefined && att.unitDesc.multiple.length != 0) {
            //$scope.$watch("currentUnitFactor.value",$scope.unitChanged);
            //-- Next watch is useful once because theField01.objectField.value
            //-- changes out of this directive only when the query from parent (relation form field)
            //-- get the value after this directive be created.
            //$scope.$watch("theField01.objectField.value",$scope.objectValueChanged);
            for (var ind = 0; ind < att.unitDesc.multiple.length; ind++)
              if (att.unitDesc.multiple[ind].factor == att.unit.defaultFactor) {
                att.dbUnit = att.unitDesc.multiple[ind].symbol;
                att.currentUnitFactor.value = att.unitDesc.multiple[ind].factor;
                break;
              }
          }
        });
      }
    };

    $scope.getListOfValuesFor = function(att) {
      $scope.waitingForListOfValuesFromTable = true;
      if ($scope.listsOfValues[att.name] !== undefined)
        att.listOfValues = $scope.listsOfValues[att.name];
      //-- Get the existing related objects in order to display them.
      var objDesc = $scope.getThisObjFeatureDesc();
      var rel = $scope.getRelation(objDesc.relations, undefined, att.name);
      if (rel == null) {
        gaJsUtils.errorMessage(
          'La relation sur le champ [' + att.name + "] n'a pas été trouvée !",
          ''
        );
        return;
      }

      att.tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.theField01.config.datastoreName,
        rel.componentEnd
      );
      QueryFactory.data(att.tableDesc.uid, '').then(function(res) {
        //alert(res);
        var listItem, feat, fCode, fValue;
        att.listOfValues = [];
        fCode =
          $scope.theField01.config.relationListOfValueFieldCfg[att.name].code;
        fValue =
          $scope.theField01.config.relationListOfValueFieldCfg[att.name].value;
        for (var ind = 0; ind < res.data.features.length; ind++) {
          listItem = {};
          feat = res.data.features[ind];
          if (fCode == 'id') listItem.code = QueryFactory.getFeatureId(feat);
          else listItem.code = '' + feat[fCode];
          listItem.value = feat.properties[fValue];
          att.listOfValues.push(listItem);
        }
        $scope.listsOfValues[att.name] = att.listOfValues;
        $scope.waitingForListOfValuesFromTable = false;
      });
    };

    $scope.getInterValdescForAtt = function(att) {
      var intervDescs;

      if ($scope.theField01.config == undefined) return undefined;

      if ($scope.theField01.config.intervalDescs == undefined) return undefined;

      intervDescs = $scope.theField01.config.intervalDescs;

      for (var iDesc = 0; iDesc < intervDescs.length; iDesc++) {
        if (att.name == intervDescs[iDesc].fieldName) return intervDescs[iDesc];
      }
      return undefined;
    };

    $scope.setIntervalForField = function(restriction, att) {
      att.fieldHasInterval = true;
      att.fieldDesc = {};
      att.fieldDesc.restrictions = restriction;
      var intervDesc = $scope.getInterValdescForAtt(att);
      if (intervDesc != undefined)
        att.filedTypeIsInterval = interDesc.useIntervalField;
      else att.fieldTypeIsInterval = true;
      if (att.fieldTypeIsInterval) {
        att.fieldTypeIsInterval = true;
        att.fieldTypeIsDate = att.fieldTypeIsNumber = att.fieldTypeIsString = att.fieldTypeIsComment = att.fieldTypeIsBoolean = false;
      }
    };

    /**
     *     Add attribute description to the list of attribute to display and manage
     *  in this table component.
     *  The attributes are copied, so that an eventual modification of the alias
     *  does not affect the shared feature type description.
     */
    $scope.addAttribute = function(ftDesc, indAtt) {
      var att, ind, val, restr, prop;

      //-- Instanciate new attribute and set basic information.
      att = {};
      att.name = ftDesc.attributes[indAtt].name;
      att.alias = ftDesc.attributes[indAtt].alias;
      att.type = ftDesc.attributes[indAtt].type;
      att.unit = ftDesc.attributes[indAtt].unit;
      att.fieldTypeIsDomain = false;
      att.size = ftDesc.attributes[indAtt].size;

      //-- Is it a readonly field ?
      if ($scope.theField01.config.readonlyFields != undefined)
        att.readonly =
          $scope.theField01.config.readonlyFields.indexOf(att.name) != -1;
      if ($scope.theField01.config.readonlyWhenSetFields != undefined)
        att.readonlyWhenSet =
          $scope.theField01.config.readonlyWhenSetFields.indexOf(att.name) !=
          -1;

      //-- If there is a list of value restriction on this attribute
      //-- store it on the attribute in order to be able to feed angularks with it.
      restr = ftDesc.attributes[indAtt].restrictions;
      for (ind = 0; ind < restr.length; ind++) {
        if (restr[ind].type == 'Domain') {
          att.fieldTypeIsDomain = true;
          att.listOfValues = [];
          for (prop in restr[ind].listofValues) {
            val = {};
            val.code = prop;
            val.value = restr[ind].listofValues[prop];
            att.listOfValues.push(val);
          }
        } else if (restr[ind].type == 'Interval') {
          $scope.setIntervalForField(restr[ind], att);
        }
      }

      //-- Is the field an attachment field
      var fieldType = att.type.toLowerCase();
      att.fieldTypeIsMultipleAttachments =
        fieldType.indexOf('g2c.attachments') != -1;
      if (!att.fieldTypeIsMultipleAttachments)
        att.fieldTypeIsSingleAttachment =
          fieldType.indexOf('g2c.attachment') != -1;
      //--
      $scope.manageUnitField(att);

      //-- Other field types
      att.fieldTypeIsBoolean = fieldType.indexOf('.boolean') != -1;
      att.fieldTypeIsDate = fieldType.indexOf('.date') != -1;
      att.fieldTypeIsString = fieldType.indexOf('.string') != -1;

      if (
        $scope.theField01.config.relationListOfValueFields != undefined &&
        $scope.theField01.config.relationListOfValueFields.indexOf(att.name) !=
          -1
      ) {
        att.type = 'relationListOfValue';
        $scope.getListOfValuesFor(att);
      }
      //-- Add the attribute description into the list of attributes to manage.
      $scope.attributes.push(att);
    };

    /**
     *
     */
    $scope.defineAttributeList = function(ftDesc) {
      var ind, indAtt, att;

      //-- If the attribute list is already defined don't do it again.
      if ($scope.attributes.length != 0) return;

      if ($scope.theField01.config.fieldOrder != undefined) {
        //-- An ordered list of field names is provided,
        //-- so build the list of attributes to display in the table
        //-- having controlled the configured field exists.
        for (ind = 0; ind < $scope.theField01.config.fieldOrder.length; ind++)
          for (indAtt = 0; indAtt < ftDesc.attributes.length; indAtt++)
            if (
              $scope.theField01.config.fieldOrder[ind] ==
              ftDesc.attributes[indAtt].name
            ) {
              $scope.addAttribute(ftDesc, indAtt);
            }
      } else if ($scope.theField01.config.excludedFields != undefined) {
        //-- An excluded list of field names is provided,
        for (indAtt = 0; indAtt < ftDesc.attributes.length; indAtt++) {
          for (
            ind = 0;
            ind < $scope.theField01.config.excludedFields.length;
            ind++
          )
            if (
              $scope.theField01.config.excludedFields[ind] ==
              ftDesc.attributes[indAtt].name
            )
              break;
          if (ind == $scope.theField01.config.excludedFields.length) {
            //-- The field is not an excluded one.
            $scope.addAttribute(ftDesc, indAtt);
          }
        }
      }
      //-- No configuration for fields so the table attributes
      //-- is the list of attributes to display in the table.
      else
        for (indAtt = 0; indAtt < ftDesc.attributes.length; indAtt++)
          $scope.addAttribute(ftDesc, indAtt);

      if ($scope.theField01.config.fieldAliases != undefined) {
        var aliases = $scope.theField01.config.fieldAliases;
        for (ind = 0; ind < aliases.length; ind++)
          for (indAtt = 0; indAtt < $scope.attributes.length; indAtt++) {
            if ($scope.attributes[indAtt].name == aliases[ind].name) {
              $scope.attributes[indAtt].alias = aliases[ind].alias;
              break;
            }
          }
      }
    };

    /**     Date values are really messy. Here we convert String value
     *   gotten from service to a Date object to feed correctly the date component.
     *
     */
    $scope.setDate = function(obj, attName) {
      var strDate, dDate, ms;

      //-- If trim function exists the field value is a String
      if (
        obj.properties[attName] != null &&
        obj.properties[attName].trim != undefined
      ) {
        //-- Actually the date is a string ...
        //-- Betting the date has the expected JAVA GEoJSson format
        //-- convert it into a Date (format example: 2015-02-03T23:00:00.000+0000)
        strDate = obj.properties[attName];
        dDate = new Date();
        dDate.setFullYear(strDate.substr(0, 4));
        dDate.setMonth(strDate.substr(5, 2) - 1);
        dDate.setDate(strDate.substr(8, 2));
        dDate.setHours(strDate.substr(11, 2));
        dDate.setMinutes(strDate.substr(14, 2));
        dDate.setSeconds(strDate.substr(17, 2));
        //----- TODO Modify server side after better DATE managemen
        //-- Date returned is day-1 23H00 so we add 2 hours
        //-- (one should be enough ...) to display correct date.
        //-- In the DB the displayed date is OK.
        //-- When date will be better managed we'll get rid of this.
        ms = dDate.getTime() + 7200000; //  = 60 secondes x 1000 x 60 minutes x 2 heures
        dDate.setTime(ms);
        obj.properties[attName] = dDate;
      }
    };

    $scope.removeGroupsFromFeatureList = function() {
      var ii;

      for (ii = $scope.objects.length - 1; ii >= 0; ii--) {
        if ($scope.objects[ii].group != undefined) $scope.objects.splice(ii, 1);
      }
    };

    $scope.sortFeatures = function() {
      var cfg = $scope.theField01.config;
      var sortField;
      if (cfg.orderingField != null || cfg.groupingField != null) {
        if (cfg.groupingField != null) sortField = cfg.groupingField;
        else sortField = cfg.orderingField;
        $scope.manageOrder = cfg.manageOrder;
        //-- IF A SORT FIELD IS GIVEN
        //-- Sort objects on ordering field.
        $scope.maxOrder = 0;
        $scope.removeGroupsFromFeatureList();
        $scope.objects.sort(function(a, b) {
          var v1, v2;
          if (cfg.orderingAsc != false) {
            v1 = a;
            v2 = b;
          } else {
            v1 = b;
            v2 = a;
          }

          if (v1.properties[sortField] == null) return -1;
          if (v2.properties[sortField] == null) return 1;

          v1 = v1.properties[sortField];
          v2 = v2.properties[sortField];

          if (cfg.orderingFielType == 'date') {
            if (v1.trim != undefined)
              v1 = GlobalServices.getDateFromDbString(v1);
            if (v2.trim != undefined)
              v2 = GlobalServices.getDateFromDbString(v2);
          }
          if (v1 > v2) return 1;
          if (v1 < v2) return -1;
          // a doit etre egale a b
          return 0;
        });
      }
    };

    $scope.unitChanged = function(obj, att) {
      for (var ind = 0; ind < $scope.objects.length; ind++)
        if ($scope.objects[ind].id == obj.id) {
          var fac =
            $scope.objects[ind].objAttCfg[att.name].currentUnitFactor.value;
          obj.properties[att.name] =
            $scope.objects[ind].displayProperties[att.name] * fac;
          $scope.objects[ind].properties[att.name] = obj.properties[att.name];
          $scope.valueChanged(obj);
          break;
        }
    };

    $scope.isMyGroupVisible = function(obj) {
      if ($scope.groups['__xx__'] != undefined)
        return $scope.groups['__xx__'].visible;
      else if (
        $scope.groups[obj.properties[$scope.theField01.config.groupingField]] !=
        undefined
      )
        return $scope.groups[
          obj.properties[$scope.theField01.config.groupingField]
        ].visible;
    };

    $scope.buildGroups = function() {
      var unicValues = ';',
        val,
        cc;
      var cfg = $scope.theField01.config;

      if ($scope.groups == undefined) $scope.groups = [];
      cc = $scope.attributes.length + 1;
      if (cfg.groupingField == null) {
        val = '__xx__';
        $scope.objects.splice(0, 0, {
          group: true,
          val: val,
          colcount: cc,
          visible: true,
        });
        $scope.groups = [];
        $scope.groups[val] = { visible: true };
      } else {
        var grpadded = true,
          ind,
          visible;
        $scope.groupingField = cfg.groupingField;
        while (grpadded) {
          grpadded = false;
          for (ind = 0; ind < $scope.objects.length; ind++) {
            if ($scope.objects[ind].group === undefined) {
              val = $scope.objects[ind].properties[cfg.groupingField];
              if (unicValues.indexOf(';' + val + ';') == -1) {
                //-- val==null <=> nouvelle ligne à renseigner (création)
                if ($scope.groups[val] == undefined) {
                  visible = val == null;
                  $scope.groups[val] = { visible: visible };
                } else visible = $scope.groups[val].visible;
                $scope.objects.splice(ind, 0, {
                  group: true,
                  val: val,
                  colcount: cc,
                  visible: visible,
                });
                unicValues += val + ';';
                grpadded = true;
                break;
              }
            }
          }
        }
      }
    };

    $scope.showGroup = function(obj, visible) {
      $scope.groups[obj.val].visible = obj.visible = visible;
    };

    /**
     * TODO commenter
     */
    $scope.buildObjectList = function() {
      var rel, ftDesc, where;

      //-- Get the existing related objects in order to display them.
      rel = $scope.getRelation(
        $scope.relationDesc.parentRelations,
        $scope.relationDesc.featureName
      );
      if (rel == null) {
        gaJsUtils.errorMessage(
          'La relation avec la table [' +
            $scope.relationDesc.featureName +
            "] n'a pas été trouvée !",
          ''
        );
        return;
      }
      ftDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.theField01.config.datastoreName,
        $scope.relationDesc.featureName
      );
      $scope.defineAttributeList(ftDesc);

      where = rel.fieldEnd + '=' + $scope.relationDesc.mainObjectId;
      QueryFactory.data(ftDesc.uid, where).then(function(res) {
        var ind, indAtt, roWhen, value, obj, objProp, att;

        if ($scope.objects.length != 0)
          $scope.objects.splice(0, $scope.objects.length);
        if ($scope.theField01.config.rows != undefined) {
          if ($scope.theField01.config.rows.readonlyWhen != undefined) {
            roWhen = $scope.theField01.config.rows.readonlyWhen;
            value = GlobalServices.getValueForKeyWord(roWhen.value);
            value = value.newValue;
          }
        }
        for (ind = 0; ind < res.data.features.length; ind++) {
          obj = res.data.features[ind];
          $scope.objects.push(obj);
          if (roWhen != undefined && obj.properties[roWhen.field] != null) {
            objProp = obj.properties[roWhen.field];
            if (roWhen.type == 'date')
              objProp = GlobalServices.getDateFromDbString(objProp);
            switch (roWhen.operator) {
              case '=':
                if (objProp == value) obj.readonly = 'true';
                break;
              case '>':
                if (objProp > value) obj.readonly = 'true';
                break;
              case '<':
                if (objProp < value) obj.readonly = 'true';
                break;
            }
          }
          //-- Set date values as a date class instanciation
          obj.objAttCfg = {};
          obj.displayProperties = {};
          for (indAtt = 0; indAtt < $scope.attributes.length; indAtt++) {
            att = $scope.attributes[indAtt];
            if (att.fieldTypeIsString)
              $scope.setDate($scope.objects[$scope.objects.length - 1], att);
            //$scope.$watch('$scope.objects[$scope.objects.length-1].properties["'+$scope.attributes[indAtt].name+'"]', $scope.valueChanged());
            if (att.unit != undefined && att.unitDesc != undefined) {
              obj.objAttCfg[att.name] = {};
              obj.displayProperties[att.name] = obj.properties[att.name];
              obj.objAttCfg[att.name].currentUnitFactor = {};
              for (
                var indUnit = 0;
                indUnit < att.unitDesc.multiple.length;
                indUnit++
              )
                if (
                  att.unitDesc.multiple[indUnit].factor ==
                  att.unit.defaultFactor
                ) {
                  obj.objAttCfg[att.name].currentUnitFactor.value =
                    att.unitDesc.multiple[indUnit].factor;
                  obj.displayProperties[att.name] =
                    obj.properties[att.name] /
                    att.unitDesc.multiple[indUnit].factor;
                  break;
                }
            }
          }
        }

        $scope.sortFeatures();
        $scope.buildGroups();
      });
    };

    /**
     *     Extract readable value of the given attribute from given object
     *  in order to display
     */
    $scope.getValueFor = function(object, attribute) {
      var retValue = object.properties[attribute.name];

      if (attribute.listOfValues != undefined) {
        for (var ind1 = 0; ind1 < attribute.listOfValues.length; ind1++) {
          for (var ind2 = 0; ind2 < attribute.listOfValues.length; ind2++) {
            if (retValue == attribute.listOfValues[ind2].code)
              return attribute.listOfValues[ind2].value;
          }
        }
      }
      return retValue;
    };

    $scope.enableCommands = function() {
      if ($scope.theField01.mode == 'readonly') $scope.enabled = false;
      else $scope.enabled = $scope.relationDesc.mainObjectId != null;
    };

    /**
     *       RelationFormField got the related objects and send a message
     *   to inform children amongst them this panel form field catch the message
     *   in order to store the existing/current value in the objectField.value attribute.
     */
    $scope.$on('gotRelatedObjects', function(event, data) {
      //-- There should always be a feature, but who knows ...
      if (
        data.objects != undefined &&
        data.objects.features.length != 0 &&
        ($scope.theField01.config.parentFeatureName == undefined ||
          $scope.theField01.config.parentFeatureName ==
            QueryFactory.getFeatureName(data.objects.features[0]))
      ) {
        $scope.mainObjectId = QueryFactory.getFeatureId(
          data.objects.features[0]
        );
        $scope.buildObjectList();
      }
    });

    $scope.setMainObjectId = function(objectId, nextAction) {
      if ($scope.relationDesc === undefined) $scope.relationDesc = {};
      $scope.relationDesc.mainObjectId = objectId;
      $scope.lastParentRelations = $scope.theField01.relations;
      $scope.prepareRelationMgt(
        $scope.theField01.config.featureName,
        { properties: $scope.objectFields, id: objectId },
        nextAction
      );
    };

    $scope.getMainObjectId = function(objectId) {
      if ($scope.relationDesc === undefined) return undefined;
      return $scope.relationDesc.mainObjectId;
    };

    $scope.$on('gotObjectId', function(event, data) {
      $scope.setMainObjectId(data.objectId, { name: 'enableCommands' });
      $scope.enableCommands();
    });

    $scope.manageEnabledWhen = function(data, enabledWhen) {
      var val,
        enabled = false;
      for (var ind = 0; ind < enabledWhen.length; ind++) {
        val = data.properties[enabledWhen[ind].eventProperty];
        switch (enabledWhen[ind].eventOp) {
          case '==':
            if (val == enabledWhen[ind].eventValue) enabled = true;
            break;
        }
      }
      $scope.enabled = enabled;
    };

    $scope.$on('oneFieldHasChanged', function(event, data) {
      if (data.targetField == $scope.theField01.field) {
        $scope.setMainObjectId(data.mainObjectId, {
          name: 'buildObjectListAndManageEnabledWhen',
          data: data,
        });
        $scope.buildObjectList();
        if ($scope.theField01.config.enabledWhen != undefined)
          $scope.manageEnabledWhen(data, $scope.theField01.config.enabledWhen);
      }
    });

    $scope.getEmptyProperties = function(ftDesc) {
      var prop = {},
        ind,
        attName;

      for (ind = 0; ind < ftDesc.attributes.length; ind++) {
        var fieldType = ftDesc.attributes[ind].type.toLowerCase();
        attName = ftDesc.attributes[ind].name;
        if (
          $scope.theField01.config.initialValues != undefined &&
          $scope.theField01.config.initialValues[attName] != undefined
        )
          prop[attName] = $scope.theField01.config.initialValues[attName];
        else if (fieldType.indexOf('.date') != -1)
          prop[attName] = GlobalServices.getValueForDB(
            ftDesc,
            attName,
            GlobalServices.getCurrentDate(),
            ind
          );
        else prop[attName] = null;
      }

      var rel = $scope.getRelation(
        $scope.relationDesc.parentRelations,
        $scope.relationDesc.featureName
      );
      if ($scope.getMainObjectId() != undefined) {
        if (rel != null) prop[rel.fieldEnd] = $scope.getMainObjectId();
      } else if ($scope.theField01 != undefined) {
        //-- If the original value of theField01.objectId has not been changed it contains the main object's id
        if (rel != null) {
          prop[rel.fieldEnd] = $scope.theField01.objectId;
        }
        $scope.setMainObjectId($scope.theField01.objectId);
      }

      return prop;
    };

    /**
     *     Function triggered on add new record command activation.
     *  The function create a new empty record that will be updated
     *  when the user will change value in the input fields.
     */
    $scope.addNewRecord = function() {
      var ftDesc;
      var features;

      ftDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.theField01.config.datastoreName,
        $scope.relationDesc.featureName
      );

      //-- Build GeoJSON object describing the object we want  to insert
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = {};
      features.features[0].type = 'feature';
      features.features[0].properties = $scope.getEmptyProperties(ftDesc);
      features.features[0].geometry = {};

      EditFactory.add(ftDesc.uid, features).then(function(res) {
        var errorMsg;

        if (
          (res.data.errors.length != 0 && res.data.errors[0] != null) ||
          res.statusText != 'OK' ||
          res.data.errors.ERROR != undefined
        ) {
          //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
          var iErr;
          errorMsg = '<h4>Erreur</h4> ';
          errorMsg +=
            "<br/><h4>Details</h4>  Echec de l'ajout d'un objet en base !";
          for (iErr = 0; iErr < res.data.errors.length; iErr++)
            errorMsg += '<br/>' + res.data.errors[iErr];
          require('toastr').error(errorMsg);
        } else $scope.buildObjectList();
      });
    };

    /**
     *       Inform parent scopes that this child list has been modified.
     */
    $scope.objectListHasChanged = function() {
      //-- FeatureName as parameter in order the parent recognize which child
      //-- has been modified.
      $scope.$emit('childListChanged', $scope.theField01.config.featureName);
      $scope.sortFeatures();
      $scope.buildGroups();
    };

    $scope.delRecordYes = function() {
      var ftDesc = $scope.getThisObjFeatureDesc();
      EditFactory.remove(
        ftDesc.uid,
        QueryFactory.getFeatureId($scope.objectToDelete)
      );
      $scope.buildObjectList();
      $scope.deletionDone();
      $scope.objectListHasChanged();
    };

    $scope.delRecordNo = function() {
      $scope.deletionDone();
    };

    $scope.deletionDone = function() {
      $scope.objectToDelete = undefined;
      ngDialog.closeAll();
    };

    $scope.delRecord = function(object) {
      $scope.objectToDelete = object;
      ngDialog.open({
        template: $scope.dialogDelConfirm,
        plain: true,
        scope: $scope,
      });
    };

    /**
     *
     */
    $scope.stringDateCorrectlyFormatted = function(value) {
      var indPos, year, month, day;

      indPos = value.indexOf('-');
      if (indPos == -1) indPos = value.indexOf('/');

      if (indPos == 4) {
        year = value.substr(0, 4);
        month = value.substr(5, 2);
        day = value.substr(8, 2);
      } else if (indPos == 2) {
        year = value.substr(6, 4);
        month = value.substr(3, 2);
        day = value.substr(0, 2);
      }

      if (parseInt(month) > 12) {
        indPos = month;
        month = day;
        day = indPos;
      }
      return year + '-' + month + '-' + day + 'T12:00:00.000-0300';
    };

    /**
     *     Modify value so that it can be inserted into the database field.
     *  What is managed until now is the date format.
     */
    $scope.getValueForDb = function(obj, att) {
      var fieldType = att.type.toLowerCase();
      var value = obj.properties[att.name];

      if (!fieldType.indexOf('.string') != -1 && value == '') return null;

      if (fieldType.indexOf('.date') != -1) {
        if (value == undefined) return null;
        if (value.trim == undefined)
          //-- Date value is not a string so we assume it is a Date object.
          return (
            '' +
            value.getFullYear() +
            '-' +
            (1 + value.getMonth()) +
            '-' +
            value.getDate() +
            'T12:00:00.000+0000'
          );
        return $scope.stringDateCorrectlyFormatted(value);
        //return "2016-01-02T12:00:00.000+0000";
      }

      if (value == undefined) return null;
      return value;
    };

    /**
     *     As we cannot directly send the object to the update service,
     *  because there is a discrepancy with the date format,
     *  we use this function to build the object property list
     *  where the values (the date values) are correctly set.
     */
    $scope.getPropertiesFromObject = function(indObj, ftDesc) {
      var indAtt,
        prop = {},
        att;

      for (indAtt = 0; indAtt < ftDesc.attributes.length; indAtt++) {
        att = ftDesc.attributes[indAtt];
        prop[att.name] = $scope.getValueForDb($scope.objects[indObj], att);
      }

      return prop;
    };

    $scope.hasNoNullField = function(props, ftDesc) {
      var indAtt, att, gf;

      gf = $scope.theField01.config.groupingField;
      for (indAtt = 0; indAtt < ftDesc.attributes.length; indAtt++) {
        att = ftDesc.attributes[indAtt];
        if (att.name == gf && props[att.name] != null) return true;
      }
      return false;
    };

    $scope.$parent.valueChangedFunction = true;
    $scope.valueChanged = function(modifiedObject, udpatedFromUpDownActions) {
      var ret = {};
      //-- A value has changed so we update the object.
      //-- The modified values are directly those which
      //-- are in the $scope.objects list so we don't have much to do,
      //-- only send it to the update service.
      var ftDesc, features, ind;

      //-- MAy be called with different parameters from ffl2attachment
      //-- the interesting one (here) is the one identifying the object to update (not the other).
      if (modifiedObject.id == undefined) return;

      ftDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.theField01.config.datastoreName,
        $scope.relationDesc.featureName
      );

      //-- Build GeoJSON object describing the object we want to update
      for (ind = 0; ind < $scope.objects.length; ind++)
        if ($scope.objects[ind].id == modifiedObject.id) break;

      if (
        !GlobalServices.controlsOk(
          $scope.objects[ind],
          $scope.theField01.config,
          ret
        )
      )
        gaJsUtils.errorMessage('Valeur incorrecte non prise en compte !');

      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = {};
      features.features[0].id = modifiedObject.id;
      features.features[0].type = 'feature';
      features.features[0].properties = $scope.getPropertiesFromObject(
        ind,
        ftDesc
      );
      features.features[0].geometry = {};

      //-- Call update service
      EditFactory.update(ftDesc.uid, features).then(function(res) {
        var errorMsg;

        if (res.statusText != 'OK' || res.data.errors.ERROR != undefined) {
          //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
          errorMsg = '<h4>Erreur</h4> ';
          errorMsg +=
            "<br/><h4>Details</h4>  Echec de la modification d'un objet en base !";
          errorMsg += '<br/>' + res.data.errors.ERROR;
          require('toastr').error(errorMsg);
        } else if (
          $scope.hasNoNullField(features.features[0].properties, ftDesc)
        )
          $scope.objectListHasChanged();
        else if (
          $scope.theField01.config.orderingField != undefined &&
          !udpatedFromUpDownActions
        )
          $scope.buildObjectList();
      });
    };

    $scope.openCommentInput = function(obj, attName) {
      var template;
      var childScope = $scope.$new(false, $scope);
      $scope.commentObj = obj;
      $scope.commentAttName = attName;
      if ($scope.theField01.mode == 'readonly')
        template =
          "<textarea ng-model='commentObj.properties[commentAttName]' ng-model-options='{ debounce: 500 }' readonly style='width:500px;height:450px;'><textarea>";
      else
        template =
          "<textarea ng-model='commentObj.properties[commentAttName]' ng-model-options='{ debounce: 500 }' ng-change='valueChanged(commentObj)' style='width:500px;height:450px;'><textarea>";

      ngDialog.open({
        template: template,
        plain: true,
        scope: childScope,
        className: 'ngdialog-theme-plain width800',
      });
    };

    $scope.cleanOrder = function() {
      var ind;
      var cfg = $scope.theField01.config;

      for (ind = 2; ind < $scope.objects.length; ind++) {
        if (
          $scope.objects[ind - 1].properties[cfg.orderingField] >=
          $scope.objects[ind].properties[cfg.orderingField]
        ) {
          $scope.objects[ind - 1].properties[cfg.orderingField] =
            $scope.objects[ind].properties[cfg.orderingField];
          $scope.objects[ind].properties[cfg.orderingField] =
            $scope.objects[ind - 1].properties[cfg.orderingField] + 1;
          $scope.valueChanged($scope.objects[ind - 1], true);
          $scope.valueChanged($scope.objects[ind], true);
        }
      }
    };

    $scope.up = function(obj) {
      var ind, tmp;
      var cfg = $scope.theField01.config;
      if (cfg.setOrderField != undefined) {
        if (cfg.setOrderField.method == 'setOrderingFieldValue') {
          for (ind = 0; ind < $scope.objects.length; ind++)
            if ($scope.objects[ind] == obj) {
              $scope.objects[ind].properties[cfg.orderingField]--;
              $scope.objects[ind - 1].properties[cfg.orderingField]++;
              tmp = $scope.objects[ind];
              $scope.objects[ind] = $scope.objects[ind - 1];
              $scope.objects[ind - 1] = tmp;
              $scope.valueChanged($scope.objects[ind], true);
              $scope.valueChanged($scope.objects[ind - 1], true);
              $scope.cleanOrder();
              break;
            }
        }
      }
    };
    $scope.down = function(obj) {
      var ind, tmp;
      var cfg = $scope.theField01.config;
      if (cfg.setOrderField != undefined) {
        if (cfg.setOrderField.method == 'setOrderingFieldValue') {
          for (ind = 0; ind < $scope.objects.length; ind++)
            if ($scope.objects[ind] == obj) {
              $scope.objects[ind].properties[cfg.orderingField]++;
              $scope.objects[ind + 1].properties[cfg.orderingField]--;
              tmp = $scope.objects[ind];
              $scope.objects[ind] = $scope.objects[ind + 1];
              $scope.objects[ind + 1] = tmp;
              $scope.valueChanged($scope.objects[ind], true);
              $scope.valueChanged($scope.objects[ind + 1], true);
              $scope.cleanOrder();
              break;
            }
        }
      }
    };

    //---------   BEGINNING
    $scope.lastParentObjectId = $scope.mainObjectId;
    $scope.lastParentRelations = $scope.theField01.relations;
    if ($scope.mainObjectId != undefined) {
      $scope.prepareRelationMgt(
        $scope.theField01.config.featureName,
        { properties: $scope.objectFields, id: $scope.mainObjectId },
        { name: 'buildObjectList' }
      );
    } else {
      $scope.prepareRelationMgt($scope.theField01.config.featureName, {
        properties: $scope.objectFields,
        id: $scope.mainObjectId,
      });
      var rel = $scope.getRelation(
        $scope.relationDesc.parentRelations,
        $scope.relationDesc.featureName
      );
      if (rel != null) {
        var ftDesc = FeatureTypeFactory.getFeatureTypeDesc(
          $scope.theField01.config.datastoreName,
          $scope.relationDesc.featureName
        );
        $scope.defineAttributeList(ftDesc);
      }
      $scope.enabled = false;
    }
  };

  fftable4updl2Ctrl.$inject = [
    '$scope',
    'QueryFactory',
    'FeatureTypeFactory',
    'EditFactory',
    'ngDialog',
    'GlobalServices',
    'UnitsFactory',
    'gaJsUtils',
  ];
  return fftable4updl2Ctrl;
});
