/**
 *
 */
'use strict';
define(function() {
  var RelationFormFieldCtrl = function(
    $scope,
    FeatureTypeFactory,
    RelationFormFieldFactory,
    QueryFactory,
    ngDialog,
    EditFactory,
    GlobalServices,
    gclayers
  ) {
    //-- Initialize some variables.
    $scope.panel = {};
    $scope.relatedObjects = {};
    $scope.relatedObjects.features = [];
    $scope.relatedObjectsScopeId = $scope.$id;
    $scope.thisId = $scope.$id;
    $scope.thisSelectId = 'select_' + $scope.$id;
    $scope.showTable = false;
    $scope.useTableSelect = false;
    $scope.selectedObject = {};
    $scope.options = [];
    $scope.radioMode = {};
    $scope.radioMode.value = 'create';

    $scope.dialogContent =
      "<div ChercherModSupDirective my-config='config_chercher_arguments'></div>";

    $scope.objectGeometry = undefined;

    $scope.g2c_widname = 'RelationFormField';

    if ($scope.theField01.field == 'day_rel_marche_signatue') var abc = 'eee';
    $scope.getMap = function(aScope) {
      if (aScope == null) return undefined;
      if (aScope.map != undefined) return aScope.map;
      else return $scope.getMap(aScope.$parent);
    };

    //-- Get field description.
    if ($scope.theField01 == null) {
      if ($scope.cont != undefined) $scope.theField01 = $scope.cont;
      else if ($scope.$parent != null) {
        if ($scope.$parent.theField01 != null)
          $scope.theField01 = $scope.$parent.theField01;
        else if ($scope.$parent.$parent != null)
          $scope.theField01 = $scope.$parent.$parent.theField01;
      }
    }

    //-- Get map reference in order to be able to get its coordinate reference system.
    $scope.map = $scope.getMap($scope);
    $scope.mode = $scope.theField01.mode;

    $scope.manageRemoveCommand = function(params, removeCmdCfg) {
      if (removeCmdCfg.disabledWhen != undefined) {
        var newParams = {};
        newParams.objectFields = params.selectedFeature.properties;
        newParams.extraValues = {};
        newParams.extraValues.rowCount = $scope.relatedObjects.features.length;
        $scope.removeCmdIsDisabled = GlobalServices.evaluateSimpleExpression(
          removeCmdCfg.disabledWhen,
          newParams
        );
      }
    };

    $scope.manageCommands = function(params) {
      if ($scope.theField01.commandConfig != undefined) {
        if ($scope.theField01.commandConfig.remove != undefined)
          $scope.manageRemoveCommand(
            params,
            $scope.theField01.commandConfig.remove
          );
      }
    };

    /**
     *    Inform children that an object has been selected.
     *  From  relation directive a selected object cannot be modified,
     *  so we ask the fields to be readonly.
     */
    $scope.objectHasBeenSelected = function() {
      var id,
        mode = 'readonly',
        sfm;

      if ($scope.theField01.showList) sfm = { fieldType: 'ffl2', mode: mode };
      //-- Look for the selected object using its ID.
      for (var ind = 0; ind < $scope.relatedObjects.features.length; ind++) {
        id = QueryFactory.getFeatureId($scope.relatedObjects.features[ind]);
        if (id == $scope.selectedObject.code) {
          // The selected object is found.
          var objects = {};
          objects.features = [];
          objects.features.push($scope.relatedObjects.features[ind]);
          //-- Inform children of the selected object identification
          //-- and by the way let them know they have to switch to readonly mode.
          if (
            !$scope.showTable &&
            ($scope.confList != undefined ||
              !(
                $scope.theField01.fieldDesc.inlineInput &&
                $scope.theField01.inlineConfig.contentType == 'panelContainer'
              ) ||
              $scope.theField01.refreshPanelContainer)
          )
            $scope.$broadcast('gotRelatedObjects', {
              objects: objects,
              etapeId: $scope.theField01.objectId,
              setFieldMode: sfm,
              scopeId: $scope.$id,
            });
          //-- The relations of the selected object also have to be updated.
          $scope.$broadcast('gotObjectId', {
            objectId: QueryFactory.getFeatureId(
              $scope.relatedObjects.features[ind]
            ),
            layerName: $scope.layerName,
          });
          $scope.radioMode.value = 'view';
          $scope.manageCommands({
            selectedFeature: $scope.relatedObjects.features[ind],
          });
          break;
        }
      }
    };

    $scope.$on('askForRelatedTableDesc', function(event, data) {
      if ($scope.theField01.tableDesc != undefined)
        $scope.$broadcast('gotTableDesc', {
          tableDesc: $scope.theField01.tableDesc,
          config: $scope.theField01.inlineConfig,
        });
    });

    $scope.refreshObjectsListFromDBCallback = function(res) {
      $scope.emptyRelatedObjectList();
      $scope.addResObjectsToRelObjects(res.data.features);
      setTimeout($scope.refreshList, 1500);
    };

    /**
     *     Get related objects then clear and load related objects
     *  in this module list (HTML select element).
     */
    $scope.refreshObjectsListFromDB = function() {
      $scope.refreshObjectsListFromDB01(
        $scope.panel.fieldDesc.uid,
        $scope.refreshObjectsListFromDBCallback
      );
    };

    /**
     *     Get related objects then clear and load related objects
     *  in this module list (HTML select element).
     */
    $scope.refreshObjectsListFromDB01 = function(tableUid, callback, where) {
      var where;

      where =
        $scope.theField01.relation.fieldEnd + '=' + $scope.theField01.objectId;
      if ($scope.theField01.where != undefined)
        where += ' and ' + $scope.theField01.where;
      QueryFactory.data(tableUid, where).then(
        function(res) {
          callback(res);
        },
        function(res) {
          var reltable;
          where =
            '"IDD"' +
            "='" +
            $scope.theField01.relation.componentStart +
            '.' +
            $scope.theField01.objectId +
            "'";
          where +=
            ' and ' +
            '"REL_NAME"' +
            "='" +
            $scope.theField01.relation.name +
            "'";
          reltable = FeatureTypeFactory.getFeatureTypeDesc(
            $scope.theField01.datastoreName,
            'CAJ_REL_AR'
          );
          QueryFactory.data(reltable.uid, where).then(function(res) {
            var ii;
            if (res.data.features.length != 0) {
              where = 'id in (';
              for (ii = 0; ii < res.data.features.length; ii++) {
                if (ii != 0) where += ',';
                where += GlobalServices.getIdFromFullIdValue(
                  res.data.features[ii].properties.IDA
                );
              }
              where += ')';
              QueryFactory.data(tableUid, where).then(function(res) {
                callback(res);
              });
            }
          });
        }
      );
    };

    $scope.gotRelatedObject = function(pRes) {
      var res = pRes;

      if (res == undefined) res = $scope.getRelatedObjectRes;
      $scope.emptyRelatedObjectList();
      $scope.addResObjectsToRelObjects(res.data.features);
      if ($scope.relatedObjects.features.length != 0) {
        $scope.theField01.featureName = QueryFactory.getFeatureName(
          res.data.features[0]
        );
        //-- Get input values (set from input fields)
        if ($scope.panel != null && $scope.relatedObjects.features != 0) {
          for (var propertyName in $scope.relatedObjects.features[0].properties)
            if ($scope.panel.objectFields != undefined)
              $scope.panel.objectFields[propertyName] =
                $scope.relatedObjects.features[0].properties[propertyName];
        }
        if ($scope.relatedObjects.features.length != 0)
          $scope.$broadcast('gotRelatedObjects', {
            objects: $scope.relatedObjects,
            etapeId: $scope.theField01.objectId,
          });
      }
      $scope.refreshList();
    };

    $scope.getRelatedObjectCallBack01 = function(res) {
      $scope.getRelatedObjectRes = res;
      setTimeout($scope.gotRelatedObject, 1750);
    };

    $scope.getRelatedObject = function() {
      $scope.$broadcast('gotTableDesc', {
        tableDesc: $scope.theField01.tableDesc,
        config: $scope.theField01.inlineConfig,
      });
      if ($scope.theField01.relation.fieldEnd != 'id') {
        //-- Relation where the ID is stored on the related object so the other object
        //-- refers the main object.
        var where;
        if ($scope.theRelatedObject != undefined)
          //-- Appel depuis ObjListContainer
          //-- where = "id="+QueryFactory.getFeatureId($scope.theRelatedObject);
          QueryFactory.get(
            $scope.theField01.tableDesc.uid,
            QueryFactory.getFeatureId($scope.theRelatedObject)
          ).then(function(res) {
            $scope.getRelatedObjectRes = res;
            setTimeout($scope.gotRelatedObject, 1750);
          });
        else {
          //-- Appel depuis formfield
          $scope.refreshObjectsListFromDB01(
            $scope.theField01.tableDesc.uid,
            $scope.getRelatedObjectCallBack01,
            $scope.theField01.where
          );
        }
      } else {
        //-- Relation where the ID is stored on the main object so the other object
        //-- is refered by the main object.
        if (
          $scope.objectFields != undefined &&
          $scope.objectFields[$scope.theField01.relation.fieldStart] != null
        )
          QueryFactory.get(
            $scope.theField01.tableDesc.uid,
            $scope.objectFields[$scope.theField01.relation.fieldStart]
          ).then(function(res) {
            $scope.gotRelatedObject(res);
          });
      }
    };

    //-- If ID is provided then get related objects
    if (
      $scope.theField01.objectId != null &&
      $scope.theField01.relation.occurence != 'N-M'
    ) {
      //-- Get table description
      $scope.theField01.tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.theField01.datastoreName,
        $scope.theField01.relation.componentEnd
      );
      //-- Get related object
      $scope.getRelatedObject();
    }

    //-- Only one object in the relation so line number for the list is 1.
    //-- If 1-N or M-N relation then list may have many lines
    //-- and the line number may be configured.

    //-- On a besoin d un angular.copy car on ecrase cette variable
    //-- par l'intermediaire de la commande $scope.theField01.inlineConfig = {}; un peu plus bas.
    var conf = angular.copy($scope.theField01.inlineConfig);
    if ($scope.theField01.relation.occurence == '1-1') {
      $scope.theField01.lineNumber = 1;
      //-- With 1 to 1 relation no list needed if related information
      //-- has to be input directly in the "widget".
      $scope.theField01.showList = !$scope.theField01.fieldDesc.inlineInput;
    } else {
      if (conf != null && conf.displayAs == 'table') {
        $scope.showTable = true;
      } else {
        $scope.theField01.showList = true;
        if (conf == null || conf.list == null || conf.list.lineNumber == null)
          $scope.theField01.lineNumber = 5;
        else $scope.theField01.lineNumber = conf.list.lineNumber;
        if (
          conf == undefined ||
          conf.list == null ||
          conf.list.refreshPanelContainer == undefined
        )
          $scope.theField01.refreshPanelContainer = false;
        else $scope.theField01.refreshPanelContainer = true;
        if ($scope.theField01.fieldDesc.inlineInput == undefined)
          $scope.theField01.fieldDesc.inlineInput = true;
        $scope.theField01.inlineConfig = {};
        $scope.theField01.inlineConfig.contentType = 'panelContainer';
        if (conf != undefined && conf.list != undefined)
          $scope.confList = conf.list;
        if (
          conf != undefined &&
          conf.list == undefined &&
          (conf.panelFields == undefined || conf.panelFields.length == 0)
        )
          $scope.showTable = true;
      }
    }

    //-- Select list default width will be 200px unless defined in configuration.
    if (conf == null || conf.list == null || conf.list.width == null)
      $scope.theField01.width = '200px';
    else $scope.theField01.width = conf.list.width;

    if (
      $scope.theField01.inlineConfig != null &&
      $scope.theField01.inlineConfig.contentType == 'panelContainer'
    ) {
      $scope.panel.fieldDesc = $scope.theField01.relation.componentEndDescField;
      $scope.panel.objectFields = [];
      if (conf == undefined || conf.excludedFields == null)
        $scope.panel.excludedFields = [];
      else $scope.panel.excludedFields = conf.excludedFields;
      if ($scope.theField01.inlineConfig.fieldOrder != undefined)
        $scope.panel.fieldOrder = $scope.theField01.inlineConfig.fieldOrder;
      if ($scope.theField01.inlineConfig.specialFields != undefined)
        $scope.panel.specialFields =
          $scope.theField01.inlineConfig.specialFields;
      if ($scope.theField01.inlineConfig.tableMainFields != undefined)
        $scope.panel.tableMainFields =
          $scope.theField01.inlineConfig.tableMainFields;
      if ($scope.theField01.inlineConfig.config != undefined)
        $scope.panel.config = $scope.theField01.inlineConfig.config;

      if ($scope.theField01.inlineConfig.moreInputs != undefined)
        $scope.panel.moreInputsConfig =
          $scope.theField01.inlineConfig.moreInputs;
      if ($scope.theField01.inlineConfig.panelFields != undefined)
        $scope.panel.panelFields = $scope.theField01.inlineConfig.panelFields;
      if ($scope.theField01.mode != undefined)
        $scope.panel.mode = $scope.theField01.mode;

      if (
        $scope.theField01.config != undefined &&
        $scope.theField01.config.reportFields != undefined
      ) {
        if ($scope.panel.config == undefined) $scope.panel.config = {};
        $scope.panel.config.reportFields =
          $scope.theField01.config.reportFields;
      }
    }

    if ($scope.theField01.inlineConfig != null)
      $scope.orderingField = $scope.theField01.inlineConfig.orderingField;
    $scope.maxOrder = 0;

    /**
     *  TODO: open object form with some link in order to be informed
     *        of newly created object(s).
     *        yyyyyyyyyyyyyyyyyyyyyyyyyyy
     */
    $scope.openRelatedForm = function() {};

    $scope.emptyRelatedObjectList = function() {
      $scope.relatedObjects.features.splice(
        0,
        $scope.relatedObjects.features.length
      );
    };

    $scope.addResObjectsToRelObjects = function(features) {
      for (var ind = 0; ind < features.length; ind++)
        $scope.relatedObjects.features.push(features[ind]);
      if (features.length == 1) {
        $scope.$broadcast('gotObjectId', {
          objectId: QueryFactory.getFeatureId(features[0]),
          layerName: QueryFactory.getFeatureName(features[0]),
        });
      }
    };

    $scope.getRelatedObjectForObjIdMnGetEndObject = function(
      tableDesc,
      idValue
    ) {
      //QueryFactory.get(tableDesc.uid, idValue).then
      //-- Si on essaye d'exécuter une deuxième fois la même requête sur le même scope
      //-- alors que la deuxième n'est pas finie d'être traitée, on l'oublie.
      if (idValue == '' || $scope.queryRunning == idValue) return;
      $scope.queryRunning = idValue;
      QueryFactory.data(tableDesc.uid, 'in (' + idValue + ')').then(function(
        res
      ) {
        var val;

        $scope.addResObjectsToRelObjects(res.data.features);
        if (res.data.features.length != 0) {
          if ($scope.panel.objectFields == undefined)
            $scope.panel.objectFields = [];
          //-- Get input values (set from input fields)
          for (var propertyName in $scope.panel.objectFields) {
            val = res.data.features[0].properties[propertyName];
            if (val != undefined) $scope.panel.objectFields[propertyName] = val;
          }

          //-- Store first feature Id in case it is needed later.
          $scope.panel.objectId = QueryFactory.getFeatureId(
            $scope.relatedObjects.features[0]
          );
        }
        $scope.refreshList();
        //-- La requête est finie d'être traitée.'
        $scope.queryRunning = '';
      });
    };

    /**
     *     This function goes through the relation table to the end table
     *  in order to get the related objects.
     *  When M-N relation by default we add a command to open a useTableSelect component.
     */
    $scope.getRelatedObjectForObjIdMn = function(objId) {
      $scope.relatedObjects.features.splice(
        0,
        $scope.relatedObjects.features.length
      );
      var tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.theField01.datastoreName,
        $scope.theField01.relation.componentEnd
      );
      $scope.relMnRelationTableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.theField01.datastoreName,
        $scope.theField01.relation.name
      );
      var where;
      if (
        $scope.theField01.relation.componentEnd == $scope.theField01.featureName
      )
        where = $scope.theField01.relation.fieldEnd + '=' + objId;
      else where = $scope.theField01.relation.fieldStart + '=' + objId;
      $scope.useTableSelect = true;
      $scope.theField01.showList = true;
      $scope.theField01.objectId00 = objId;
      if (objId != null) {
        QueryFactory.data($scope.relMnRelationTableDesc.uid, where).then(
          function(res) {
            var ind,
              relations = [],
              idEndComponent = [],
              fn;

            if (
              $scope.theField01.featureName ==
              $scope.theField01.relation.componentStart
            )
              fn = $scope.theField01.relation.fieldEnd;
            else fn = $scope.theField01.relation.fieldStart;
            $scope.theField01.objectId = $scope.theField01.objectId00;
            $scope.emptyRelatedObjectList();
            for (ind = 0; ind < res.data.features.length; ind++)
              relations.push(res.data.features[ind]);

            for (ind = 0; ind < relations.length; ind++) {
              idEndComponent.push(relations[ind].properties[fn]);
              //--						 $scope.getRelatedObjectForObjIdMnGetEndObject (tableDesc,idEndComponent);
            }
            $scope.getRelatedObjectForObjIdMnGetEndObject(
              tableDesc,
              idEndComponent.join()
            );
            if (relations.length == 0) $scope.refreshList();
          }
        );
      }
    };

    $scope.getRelatedObjectForObjId11ou1N = function(objId, whereParam) {
      var where, uid;

      if (whereParam == undefined || whereParam == '')
        where = $scope.theField01.relation.fieldEnd + '=' + objId;
      else if (whereParam == 'id') where = whereParam;
      $scope.theField01.objectId00 = objId;

      if (objId == null) {
        $scope.emptyRelatedObjectList();
        $scope.refreshList();
      } else {
        if ($scope.panel != undefined && $scope.panel.uid != undefined)
          uid = $scope.panel.fieldDesc.uid;
        else if (
          $scope.theField01.relation != undefined &&
          $scope.theField01.relation.componentEndDescField != undefined
        ) {
          uid = $scope.theField01.relation.componentEndDescField.uid;
        }
        var promise;
        if (whereParam == 'id') promise = QueryFactory.get(uid, objId);
        else promise = QueryFactory.data(uid, whereParam);
        promise.then(function(res) {
          $scope.theField01.objectId = $scope.theField01.objectId00;
          $scope.emptyRelatedObjectList();
          $scope.addResObjectsToRelObjects(res.data.features);
          if ($scope.relatedObjects.features.length != 0) {
            //-- Get input values (set from input fields)
            for (var propertyName in $scope.panel.objectFields)
              $scope.panel.objectFields[propertyName] =
                $scope.relatedObjects.features[0].properties[propertyName];

            //-- Store first feature Id in case it is needed later.
            //-- One later case we need it is when we use table4updl2.
            //-- This case suppose only one object is gotten at this level
            //-- anyway it's not possible to use table4updl2 when
            //-- in this place we get more than one child.
            $scope.panel.objectId = QueryFactory.getFeatureId(
              $scope.relatedObjects.features[0]
            );

            $scope.$broadcast('gotRelatedObjects', {
              objects: $scope.relatedObjects,
            });
          }
          $scope.refreshList();
        });
      }
    };

    $scope.getRelatedObjectForObjId = function(objId, where) {
      if ($scope.theField01.relation.occurence == 'N-M')
        $scope.getRelatedObjectForObjIdMn(objId);
      else $scope.getRelatedObjectForObjId11ou1N(objId, where);
    };

    $scope.getIdFieldName = function(data) {
      if ($scope.theField01.inlineConfig != undefined) {
        if ($scope.theField01.inlineConfig.fieldEndIsRelField == true)
          return $scope.theField01.relation.fieldEnd;
        else if ($scope.theField01.inlineConfig.fieldStartIsRelField == true)
          return $scope.theField01.relation.fieldstart;
      }

      if ($scope.theField01.relation.componentEnd == data.layerName)
        return $scope.theField01.relation.fieldEnd;
      else return $scope.theField01.relation.fieldStart;
    };

    /**
     *     Called when broadcast from main container says the parent object
     *  has been created in the DataBase.
     *  As a parameter the object id of the new object is received.
     */
    $scope.$on('gotObjectId', function(event, data) {
      //-- No sense to send this event to myself.
      if ($scope.$id == event.targetScope.$id) return;
      //-- In case this relation is in a step container it is not directly
      //-- in relation with the main object, so we have to ignore the objectId.
      if (
        $scope.theField01.relation.componentEnd == data.layerName ||
        $scope.theField01.relation.componentStart == data.layerName
      ) {
        var fieldName = '',
          where;
        fieldName = $scope.getIdFieldName(data);
        $scope.theField01.objectId00 = data.objectId;
        if (fieldName == 'id') {
          $scope.getRelatedObjectForObjId($scope.theField01.objectId00, 'id');
        } else {
          where = fieldName + '=' + $scope.theField01.objectId00;
          $scope.getRelatedObjectForObjId($scope.theField01.objectId00, where);
        }
      }
    });

    if ($scope.theField01.field.indexOf('signat') != -1) var abcd = 'e';
    if (
      $scope.objectId != undefined &&
      ($scope.theField01.objectId == undefined ||
        $scope.theField01.relation.occurence == 'N-M')
    )
      $scope.getRelatedObjectForObjId($scope.objectId);

    /**
     *       Retrieve layer from OpenLayer map.
     */
    $scope.getLayer = function() {
      var layers = gclayers.getOperationalLayer();
      if ($scope.theLayer != undefined) return;
      for (var ind = 0; ind < layers.length; ind++)
        if (
          $scope.panel.fieldDesc.storeName == layers[ind].fti.storeName &&
          $scope.panel.fieldDesc.name == layers[ind].fti.name
        )
          $scope.theLayer = layers[ind];
    };

    /**
     *     Refresh map layer by modifying the URL.
     *  "params" is the URL param list.
     */
    $scope.refreshMap = function() {
      $scope.getLayer();
      if ($scope.theLayer != undefined) {
        var params = $scope.theLayer.getSource().getParams();
        params.t = new Date().getMilliseconds();
        $scope.theLayer.getSource().updateParams(params);
      }
    };

    /**
     *
     */
    $scope.stringDateCorrectlyFormatted = function(value) {
      var indPos, year, month, day;

      indPos = value.indexOf('-');
      if (indPos == -1) indPos = value.indexOf('/');

      if (indPos == 4) {
        year = value.substr(0, 4);
        if (value.substr(6, 1) == '-') {
          month = value.substr(5, 1);
          indPos = 7;
        } else {
          month = value.substr(5, 2);
          indPos = 8;
        }
        if (value.substr(indPos + 1, 1) == '-') day = value.substr(indPos, 1);
        else day = value.substr(indPos, 2);
      } else if (indPos == 2) {
        year = value.substr(6, 4);
        month = value.substr(3, 2);
        day = value.substr(0, 2);
      }

      if (parseInt(month) > 12) {
        indPos = month;
        month = day;
        day = indPos;
      }
      return year + '-' + month + '-' + day + 'T12:00:00.000-0300';
    };

    /**
     *
     */
    $scope.getValueFor = function(desc, fieldName, value) {
      for (var ind1 = 0; ind1 < desc.attributes.length; ind1++)
        if (desc.attributes[ind1].name == fieldName) {
          if (typeof value == 'boolean') return value;
          if (!desc.attributes[ind1].fieldTypeIsString && value == '')
            return null;
          if (desc.attributes[ind1].fieldTypeIsDate) {
            if (value == undefined) return null;
            if (value.trim == undefined) {
              //-- Date value is not a string so we assume it is a Date object.
              //-- year+"-"+month+"-"+day+"T12:00:00.000-0300"
              var vDay = '' + value.getDate();
              if (vDay.length == 1) vDay = '0' + vDay;
              var vMonth = '' + (1 + value.getMonth());
              if (vMonth.length == 1) vMonth = '0' + vMonth;
              return (
                '' +
                value.getFullYear() +
                '-' +
                vMonth +
                '-' +
                vDay +
                'T12:00:00.000-0300'
              );
            }

            return $scope.stringDateCorrectlyFormatted(value);
            //return "2016-01-02T12:00:00.000+0000";
          }
        }

      return value;
    };

    /**
     *
     */
    $scope.showErrorMessage = function(message) {
      //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
      var errorMsg = '<h4>Erreur</h4> ';
      errorMsg += '<br/><h4>Details</h4> ' + message;
      require('toastr').error(errorMsg);
    };

    $scope.getStepindex = function() {
      var iStep;
      for (iStep = 0; iStep < $scope.steps.length; iStep++) {
        if ($scope.steps[iStep].featureName == $scope.panel.fieldDesc.name)
          return iStep;
      }
    };

    /**
     *       Update the related object with information stored on the fields.
     *    This is available only for 1-1 relation.
     *    For a 1-N relation, there is no update in the inline management
     *    (only add or delete).
     */
    $scope.updateRelatedObject = function() {
      var propertyName,
        allValuesAreNull = true;
      //-- There must be an object but we avoid to be in an non understandable situation.
      //-- 30/01/2015 In case of a 1-n or M-N relation the related object list may be empty.
      if ($scope.relatedObjects.features.length == 0) {
        if ($scope.theField01.relation.occurence == '1-1')
          $scope.showErrorMessage('Objet en relation absent');
      } else {
        //-- Get input values (set from input fields)
        for (propertyName in $scope.panel.objectFields) {
          if (
            $scope.relatedObjects.features[0].properties.hasOwnProperty(
              propertyName
            )
          ) {
            $scope.relatedObjects.features[0].properties[
              propertyName
            ] = $scope.getValueFor(
              $scope.panel.fieldDesc,
              propertyName,
              $scope.panel.objectFields[propertyName]
            );
            if (
              $scope.relatedObjects.features[0].properties[propertyName] != null
            )
              allValuesAreNull = false;
          }
        }
        if ($scope.theStep != undefined) {
          var iStep = $scope.getStepindex();
          if (iStep != undefined)
            $scope.setTheStepParam($scope.steps[iStep], {
              allValuesAreNull: allValuesAreNull,
            });
        }
        if ($scope.panel.fieldDesc != undefined)
          RelationFormFieldFactory.updateObjects(
            $scope.panel.fieldDesc.uid,
            $scope.relatedObjects.features
          ).then(function() {});
      }
    };

    /**
     *     Called when broadcast from main container because the user asked to commit
     *  his modifications.  This is called only when update mode is global.
     */
    $scope.$on('updateAsked', function(event, data) {
      $scope.updateRelatedObject();
    });

    /**
     * An empty function i needed, else the "valueChanged" function will do something
     * as it is inherited from parent.
     */
    $scope.valueChanged = function() {
      //-- If the object ID is set then we are updating an existing object.
      //-- Furthermore if the update mode is not "global" which means
      //-- it is "inline" set or at least by default we have to update the record.
      if (
        $scope.objectId != null &&
        $scope.theField01.updateMode != 'global' &&
        $scope.theField01.relation.occurence == '1-1'
      ) {
        $scope.updateRelatedObject();
      }
    };

    $scope.thisapply = function() {
      if ($scope.$$childHead == undefined) setTimeout($scope.thisapply, 250);
      else $scope.$$childHead.$digest();
    };
    /**
     *
     */
    $scope.refreshList = function() {
      var ind;

      if ($scope.orderingField != null) {
        //-- IF A SORT FIELD IS GIVEN
        //-- Sort the related objects on ordering field.
        //-- Get max value for ordering field.
        $scope.maxOrder = 0;
        $scope.relatedObjects.features.sort(function(a, b) {
          if (a.properties[$scope.orderingField] == null) return -1;
          if (b.properties[$scope.orderingField] == null) return 1;
          if (
            a.properties[$scope.orderingField] >
            b.properties[$scope.orderingField]
          )
            return 1;
          if (
            a.properties[$scope.orderingField] <
            b.properties[$scope.orderingField]
          )
            return -1;
          // a doit etre egale a b
          return 0;
        });
        if (
          $scope.relatedObjects.features[
            $scope.relatedObjects.features.length - 1
          ] != null
        )
          $scope.maxOrder =
            $scope.relatedObjects.features[
              $scope.relatedObjects.features.length - 1
            ].properties[$scope.orderingField];
      }

      var nonNull = false;
      $scope.options.splice(0, $scope.options.length);
      for (ind = 0; ind < $scope.relatedObjects.features.length; ind++) {
        var option = {};
        option.code = QueryFactory.getFeatureId(
          $scope.relatedObjects.features[ind]
        );
        if ($scope.theField01.relatedObjectFields == null)
          option.value = option.code;
        else {
          option.value = '';
          for (
            var indField = 0;
            indField < $scope.theField01.relatedObjectFields.length;
            indField++
          ) {
            var attDesc =
              $scope.theField01.relation.componentEndDescField.attributes;
            var fn = $scope.theField01.relatedObjectFields[indField].field;
            var value = $scope.relatedObjects.features[ind].properties[fn];
            if (value != undefined) {
              option.value +=
                GlobalServices.formatFieldValueToStringForDisplaying(
                  value,
                  attDesc,
                  fn
                ) + '   ';
              nonNull = true;
            } else option.value += '[Non défini]   ';
            // option.value = $scope.relatedObjects.features[ind].properties[$scope.theField01.relatedObjectField.field];
          }
        }
        if (!nonNull) option.value = '[' + (1 + ind) + ']  ' + option.value;
        $scope.options.push(option);
      }
      if ($scope.options.length != 0) {
        $scope.layerName = QueryFactory.getFeatureName(
          $scope.relatedObjects.features[0]
        );
        $scope.selectedObject.code = $scope.options[0].code;
        $scope.radioMode.value = 'view';
        $scope.objectHasBeenSelected(true);
      } else $scope.radioMode.value = 'create';

      setTimeout($scope.thisapply, 250);
    };

    /**
     *      Method called on button click event in order to remove a related object from the database.
     */
    $scope.delRelatedObject = function() {
      RelationFormFieldFactory.delRelatedObject(
        $scope.panel.fieldDesc.uid,
        $scope.selectedObject.code
      ).then(
        //-- After removing get the list of related objects to display the list
        //-- of related object which really are in the database.
        function() {
          $scope.refreshObjectsListFromDB();
          $scope.refreshMap();
        }
      );
    };

    /**
     *      Method called on button click event in order to create an object in the database.
     */
    $scope.addRelatedObject = function() {
      var ind,
        ind2,
        fkExists = false;
      var newObj, fn;
      var attributes;
      newObj = {};

      //-- Build a clean object with only physical fields (no relation).
      attributes = $scope.theField01.relation.componentEndDescField.attributes;
      for (ind = 0; ind < attributes.length; ind++) {
        fn = attributes[ind].name;
        newObj[fn] = GlobalServices.getValueForDB(
          $scope.panel.fieldDesc,
          fn,
          $scope.panel.objectFields[fn],
          ind
        );
        if (fn == $scope.theField01.relation.fieldEnd) fkExists = true;
      }
      if ($scope.orderingField != null)
        newObj[$scope.orderingField] = ++$scope.maxOrder;
      var crs = $scope.map
        .getView()
        .getProjection()
        .getCode();

      if (fkExists) {
        newObj[$scope.theField01.relation.fieldEnd] =
          $scope.theField01.objectId;

        //-- Insert the object into the database.
        RelationFormFieldFactory.addRelatedObject(
          $scope.panel.fieldDesc.uid,
          newObj,
          $scope.theField01.relation.componentEnd,
          $scope.panel.objectFields['__geom__'],
          crs
        ).then(function() {
          $scope.refreshObjectsListFromDB();
          $scope.refreshMap();
        });
      } else {
        //-- Pas de champs identifiant clef etrangere sur l'objet,
        //-- on présume donc que la reation est une n-M dans CAJ_REL_AR
        var features = {};
        features.type = 'FeatureCollection';
        features.features = [];
        features.features[0] = {};
        features.features[0].type = 'feature';
        features.features[0].properties = newObj;
        features.features[0].geometry = {};
        features.features[0].geometry = {};

        EditFactory.add($scope.panel.fieldDesc.uid, features).then(function(
          res
        ) {
          var created = res.data.create[0];
          var reltable = FeatureTypeFactory.getFeatureTypeDesc(
            $scope.theField01.datastoreName,
            'CAJ_REL_AR'
          );
          //-- Build GeoJSON object describing the objects we want to insert
          features = {};
          features.type = 'FeatureCollection';
          features.features = [];
          var ind1 = 0;
          {
            features.features[ind1] = {};
            features.features[ind1].type = 'feature';
            features.features[ind1].properties = {};
            features.features[ind1].properties.REL_NAME =
              $scope.theField01.relation.name;
            features.features[ind1].properties.IDD =
              $scope.theField01.relation.componentStart +
              '.' +
              $scope.theField01.objectId;
            features.features[ind1].properties.IDA = created.id;
            features.features[ind1].properties.FEATD =
              $scope.theField01.relation.idStart;
            features.features[ind1].properties.FEATA =
              $scope.theField01.relation.idEnd;
            features.features[ind1].geometry = {};
          }

          //-- Do the insert
          EditFactory.add(reltable.uid, features).then(function() {
            $scope.refreshObjectsListFromDB();
            $scope.refreshMap();
          });
        });
      }
    };

    /**
     *      Method called on button click event in order
     *   to change the position of an object in a list.
     *   Depending on the step parameter value, the object will be moved up or down.
     */
    $scope.moveObject = function(step) {
      var ind1, ind2, ordre, d, id;

      for (ind1 = 0; ind1 < $scope.relatedObjects.features.length; ind1++) {
        id = QueryFactory.getFeatureId($scope.relatedObjects.features[ind1]);
        if (id == $scope.selectedObject.code) {
          ind2 = ind1 + step;
          if (ind2 >= 0 && ind2 < $scope.relatedObjects.features.length) {
            ordre =
              $scope.relatedObjects.features[ind1].properties[
                $scope.orderingField
              ];
            $scope.relatedObjects.features[ind1].properties[
              $scope.orderingField
            ] =
              $scope.relatedObjects.features[ind2].properties[
                $scope.orderingField
              ];
            $scope.relatedObjects.features[ind2].properties[
              $scope.orderingField
            ] = ordre;
            $scope.refreshList();
            d = new Date();
            $scope.lastOrderingACtionTime = d.getTime();
            setTimeout($scope.updateObjects, 750);
            break;
          }
        }
      }
    };

    $scope.updateObjects = function() {
      var d = new Date();

      if (d.getTime() - $scope.lastOrderingACtionTime > 749) {
        RelationFormFieldFactory.updateObjects(
          $scope.panel.fieldDesc.uid,
          $scope.relatedObjects.features
        ).then(function() {
          $scope.refreshObjectsListFromDB();
        });
      }
    };

    $scope.relatedNotAlreadySelected = function(objectId) {
      //-- Look for object amongst the listed ones.
      for (var ind = 0; ind < $scope.relatedObjects.features.length; ind++)
        //-- Object found so return FALSE (already selected)
        if ($scope.relatedObjects.features[ind].id == objectId) return false;
      //-- Object not found so return TRUE (not already selected)
      return true;
    };

    /**
     *      Called by ngDialog opened for child object selection (related objects).
     *   When called it creates the relations between the current object
     *   and the selected ones.
     *
     *   @param {Object} objectIds
     */
    $scope.tableSelectSelectionDone = function(objectIds) {
      var ind, indPt;
      var features, fn01, fn02;

      //-- Get good field name depending on relation description
      if (
        $scope.theField01.featureName ==
        $scope.theField01.relation.componentStart
      ) {
        fn01 = $scope.theField01.relation.fieldEnd;
        fn02 = $scope.theField01.relation.fieldStart;
      } else {
        fn02 = $scope.theField01.relation.fieldEnd;
        fn01 = $scope.theField01.relation.fieldStart;
      }
      //-- Build GeoJSON object describing the objects we want to insert
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      for (ind = 0; ind < objectIds.length; ind++) {
        if ($scope.relatedNotAlreadySelected(objectIds[ind])) {
          features.features[ind] = {};
          features.features[ind].type = 'feature';
          features.features[ind].properties = {};
          indPt = objectIds[ind].indexOf('.');
          if (indPt != -1)
            features.features[ind].properties[fn01] = objectIds[ind].substr(
              indPt + 1
            );
          else features.features[ind].properties[fn01] = objectIds[ind];
          features.features[ind].properties[fn02] = $scope.theField01.objectId;
          features.features[ind].geometry = {};
        }
      }

      EditFactory.add($scope.relMnRelationTableDesc.uid, features).then(
        function(res) {
          var errorMsg;

          if (res.statusText != 'OK' || res.data.errors.ERROR != undefined) {
            //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
            var errorMsg = '<h4>Erreur</h4> ';
            errorMsg +=
              "<br/><h4>Details</h4>  Echec de l'ajout d'un objet en base !";
            errorMsg += '<br/>' + res.data.errors.ERROR;
            require('toastr').error(errorMsg);
          } else {
            $scope.getRelatedObjectForObjId($scope.objectId);
          }
        }
      );
    };

    /**
     *       Function triggerd by user add command click.
     *  This add functionn open the list of possible related objects.
     *  It is opened as a ngDialog, which may have the add object
     *  possibility depending on the content of the configuration file.
     */
    $scope.openTableSelect = function() {
      var template;
      var childScope = $scope.$new(true, $scope);

      childScope.ConfigName = $scope.theField01.configName;
      childScope.tableSelectSelectionDone = $scope.tableSelectSelectionDone;
      childScope.meAsNgDialog = ngDialog;
      template =
        "<div TableSelectAndUpdateDirective style='width:100%;overflow-x:scroll;'></div>";
      ngDialog.open({
        template: template,
        plain: true,
        scope: childScope,
        className: 'ngdialog-theme-plain width800',
      });
    };

    $scope.removeSelectedObjFromRelation = function() {
      var id = $scope.selectedObject.code;
      if (id != undefined) {
        //-- A related object has been selected so we have to remove the relation
        //-- -1- Get the record in the relation table
        var where, fn01, fn02;

        //-- Get good field name depending on relation description
        if (
          $scope.theField01.featureName ==
          $scope.theField01.relation.componentStart
        ) {
          fn01 = $scope.theField01.relation.fieldEnd;
          fn02 = $scope.theField01.relation.fieldStart;
        } else {
          fn02 = $scope.theField01.relation.fieldEnd;
          fn01 = $scope.theField01.relation.fieldStart;
        }
        where =
          fn01 + '=' + id + ' and ' + fn02 + '=' + $scope.theField01.objectId;
        QueryFactory.data($scope.relMnRelationTableDesc.uid, where).then(
          function(res) {
            //-- There should only be one record for a relation between 2 objects
            //-- so the result should be the feature we want to remove.
            if (res.data.features.length != 0)
              EditFactory.remove(
                $scope.relMnRelationTableDesc.uid,
                QueryFactory.getFeatureId(res.data.features[0])
              ).then(function() {
                $scope.getRelatedObjectForObjId($scope.objectId);
                //$scope.refreshList();
              });
          }
        );
      }
    };

    $scope.modeHasChanged = function() {
      if ($scope.radioMode.value == 'create') {
        $scope.objectId = null;
        $scope.$broadcast('gotObjectId', {
          objectId: null,
          layerName: $scope.layerName,
        });
        $scope.$broadcast('setFieldMode', {
          setFieldMode: { fieldType: 'ffl2', mode: 'initial' },
        });
      } else if ($scope.options.length != 0) {
        $scope.selectedObject.code = $scope.options[0].code;
        $scope.objectHasBeenSelected(true);
      }
    };
  };

  RelationFormFieldCtrl.$inject = [
    '$scope',
    'FeatureTypeFactory',
    'RelationFormFieldFactory',
    'QueryFactory',
    'ngDialog',
    'EditFactory',
    'GlobalServices',
    'gclayers',
  ];
  return RelationFormFieldCtrl;
});
