'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    $translate,
    EditTypesFactory,
    RuleCfgFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.moveObjectsOnLine.html',
      restrict: 'E',

      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope) {
        //scope.result = {};
        scope.rule.name = 'MoveObjectsOnLine';
        scope.rule.type = 'OnEnd';

        var editTypesSource = [EditTypesFactory.editTypes.update];

        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        var shareObjectDesc = '';
        $translate('rulecfg.getAllintersectingline.shareObjectDesc').then(
          function(res) {
            shareObjectDesc = res;
          }
        );

        //Si phase de creation
        if (scope.rule.parameters == undefined) {
          scope.rule.parameters = {};
        }
        //Objets partagés destinés au partage avec les autres config de règles
        if (scope.rule.parameters.sharedObjects == undefined) {
          scope.rule.parameters.sharedObjects = {};
        }

        if (scope.rule.parameters.shareObjects == undefined) {
          scope.rule.parameters.shareObjects = [];
        }

        if (FeatureTypeFactory.resources.featuretypes.length == 0) {
          FeatureTypeFactory.get().then(function() {
            scope.featureTypes = angular.copy(
              FeatureTypeFactory.resources.featuretypes
            );
          });
        } else {
          scope.featureTypes = angular.copy(
            FeatureTypeFactory.resources.featuretypes
          );
        }

        scope.onLayerChange = function(f) {
          scope.selectedlayer = f;
        };

        function isLayerNamePresent(shareObjects, layerName) {
          var isPresent = false;
          for (var i = 0; i < shareObjects.length; i++) {
            if (shareObjects[i].layerName == layerName) {
              isPresent = true;
            }
          }
          return isPresent;
        }

        scope.addShareObject = function() {
          if (scope.selectedlayer == null) return;
          var sourceArray = undefined;
          sourceArray = scope.rule.parameters['shareObjects'];

          if (isLayerNamePresent(sourceArray, scope.selectedlayer.name)) {
          } else {
            sourceArray.push({
              layerName: scope.selectedlayer.name,
              desc: shareObjectDesc
            });
          }
        };

        /**
         * Méthode appelée à chaque changement de nom de l'objet partagé, par l'utilisateur.
         * Permet d'enregistrer l'objet partagé dans un tableau utilisable par d'autres configuration de règles qui récupérent les objets partagés existants.
         * @param {type} shareObject
         * @returns {undefined}
         */
        //                scope.updateSharedObjects = function (shareObject){
        //                    //Affectation d'un hashKey à shareObject à sa creation seulement. C'est ce premier hashKey qui sera ensuite utilisé tout le cycle de vie de ce shareObject.
        //                    //Si on remarque des problemes d'unicité, on pourra utiliser Math.random() à la place.
        //                    if (shareObject.hashKey == undefined ){
        //                        shareObject.hashKey = shareObject.$$hashKey;
        //                    }
        //                    scope.rule.parameters.sharedObjects[shareObject.hashKey] = shareObject;
        //
        //                    //Mise à jour du composant de visualisation de tous les objets partagés par les cfg de règles.
        //                    //element html correspondant à la directive de visualisation des objets partagés.
        //                    var CfgRulesInfosElem = document.querySelector('#updateCfgRulesInfos');
        //                    if (CfgRulesInfosElem){
        //                        CfgRulesInfosElem.dispatchEvent(new Event('updateCfgRulesInfos'));
        //                    }
        //                };

        scope.removeShareObject = function(sourceIndex) {
          var sourceArray = scope.rule.parameters['shareObjects'];
          var deleted = sourceArray.splice(sourceIndex, 1);

          //Suppression de l'objet partagé des sharedObjects (composant de visualisation des objets partagés par les config de règles)
          var shareObject = deleted[0];
          if (shareObject == undefined) return;

          if (shareObject.hashKey) {
            delete scope.rule.parameters.sharedObjects[shareObject.hashKey];
            //Mise à jour du composant de visualisation de tous les objets partagés par les cfg de règles.
            //element html correspondant à la directive de visualisation des objets partagés.
            var CfgRulesInfosElem = document.querySelector(
              '#updateCfgRulesInfos'
            );
            if (CfgRulesInfosElem) {
              CfgRulesInfosElem.dispatchEvent(new Event('updateCfgRulesInfos'));
            }
          }
        };

        scope.allSharedObjectsNames = [];
        angular.forEach(scope.currentfeaturetype.rules, function(rule, key) {
          if (rule.parameters.sharedObjects) {
            angular.forEach(rule.parameters.sharedObjects, function(
              shareObj,
              key
            ) {
              scope.allSharedObjectsNames.push(shareObj.name);
            });
          }
        });
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    '$translate',
    'EditTypesFactory',
    'RuleCfgFactory',
  ];
  return gcelement;
});
