'use strict';
define(function() {
  var gcelement = function(
    EditRuleSnappedOnFeature
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.startLineSnappedOnPoint.html',
      restrict: 'E',

      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope) {
        const LAYER_TYPE_TO_SNAP_ON = "POINT";
        const RULE_NAME = 'StartLineSnappedOnPoint';

        scope.addLayer = layerToSnapOn => {
          EditRuleSnappedOnFeature.configAddLayer(scope.rule, layerToSnapOn);
        };

        scope.removeLayer = index => {
          EditRuleSnappedOnFeature.configRemoveLayer(scope.rule, index);
        };

        // config initalisation
        EditRuleSnappedOnFeature.configInitRule(scope, RULE_NAME, LAYER_TYPE_TO_SNAP_ON);
      },
    };
  };

  gcelement.$inject = [
    'EditRuleSnappedOnFeature'
  ];
  return gcelement;
});
