"use strict";
define(function () {
  var EditRuleObjectNotAllowedAtIntersection = {

    $get: function (
        $q,
        $filter
    ) {

      /**
       * On vérifie que l'objet ne soit pas en contact avec plus d'un linéaire,
       * Si c'est le cas, l'objet n'a pas le droit d'être créé
       * @param editdescription
       * @param ruleConf
       * @returns {*}
       */
      const checkIfObjectIsAllowedAtIntersection = (editdescription, ruleConf) => {
        const defer = $q.defer();
        let numberOfIntersecting = 0;

        // Pour chaque type configuré,
        // on cherche si une feature a été trouvée par une autre règle
        for(let shareObjectsType of ruleConf.parameters.sharedObjects) {
          // Pour chaque objet partagé avec les autres règles
          for (let shareObject of editdescription.shareObjects) {
            if (shareObject.shareObject === shareObjectsType.name) {
              numberOfIntersecting++;
              // Si on a plus d'un linéaire connecté à notre ponctuelle, celui-ci n'a pas le droit d'être créé
              if (numberOfIntersecting > 1) {
                // Toaster d'erreur
                require('toastr').error($filter('translate')('rulecfg.objectNotAllowedAtIntersection.onErrorMessage'));
                // Sortie de la règle en rejet
                defer.reject();
                return defer.promise;
              }
            }
          }
        }
        // Fin de la règle
        defer.resolve();
        return defer.promise;
      }

      return {
        checkIfObjectIsAllowedAtIntersection: checkIfObjectIsAllowedAtIntersection
      };
    }
  };

  EditRuleObjectNotAllowedAtIntersection.$get.$inject = [
    '$q',
    '$filter'
  ];
  return EditRuleObjectNotAllowedAtIntersection;
});