'use strict';
define(function() {
  var OmegaFactory = function($http) {
    var OmegaFactory = {};
    /**
     * Function : getOmegaTemplates
     */
    function getOmegaTemplates() {
      var promise = $http.post('/services/{portalid}/omega/getOmegaTemplates');
      return promise;
    }

    /**
     * Function: omegarecherchepointconsommation
     */
    function omegarecherchepointconsommation(senddata) {
      var promise = $http.post(
        '/services/{portalid}/omega/omegaRecherchePointConsommation',
        senddata
      );
      return promise;
    }
    /**
      * Function: getDataFromJsonFile
      */
    const getDataFromFileJson = () => {
      return $http.get(
        '/services/{portalid}/omega/getDataFromFileJson?f=json');
    }
    /**
     * Function: updateJsonFile
     */
    const updateJsonFile = (senddata)=>{
      return $http.post('/services/{portalid}/omega/updateJsonFile?f=json',senddata);
    }
    /**
     * Function: getAndCheckStatusFactureOmega
     */
    function getAndCheckStatusFactureOmega(senddata) {
      var promise = $http.post(
        '/services/{portalid}/omega/getAndCheckStatusFactureOmega',
        senddata
      );
      return promise;
    }

    /**
     * Function: getListOfFacturationOrganisations : récupère la liste des organisation de facturation lié au client
     */
    function getListOfFacturationOrganisations() {
      var promise = $http.get(
        '/services/{portalid}/omega/omegaRechercheOrgaFacturation?f=json'
      );
      return promise;
    }

    /**
    * Function: sendRealOrganisationFact : informe le backend de l'organisme de facturation à utiliser (choisi par l utulisateur s'il y en a plusieurs)
    */
    function sendRealOrganisationFact(senddata) {
      var promise = $http.post(
        '/services/{portalid}/omega/sendRealOrganisationFact',
        senddata
      );
      return promise;
    }
  
    /**
     * Function: generateBillOmega
     */
    function generateBillOmega(senddata) {
      var promise = $http.post(
        '/services/{portalid}/omega/generateBillOmega',
        senddata
      );
      return promise;
    }

    /**
     * Function: getlistearticles
     */
    function getlistearticles() {
      var promise = $http.get(
        '/services/{portalid}/omega/getListArticles?f=json'
      );
      return promise;
    }
    /**
     * Function: getlisteorganismesfactureurs
     */
    function getlisteorganismesfactureurs() {
      var promise = $http.get(
        '/services/{portalid}/omega/getListeOrganismesFactureurs?f=json'
      );
      return promise;
    }

    /**
     * Function: updatePersonneDebiteur
     */
    function updatePersonneDebiteur(senddata) {
      var promise = $http.get(
        '/services/{portalid}/omega/updatePersonneDebiteur?f=json',
        senddata
      );
      return promise;
    }

    /**
     * Function: getZipDocumentsTypes
     */
    function getZipDocumentsTypes(senddata) {
      var promise = $http.post(
        '/services/{portalid}/omega/getZipDocumentsTypes?f=json',
        senddata
      );
      return promise;
    }

    return {
      OmegaFactory: OmegaFactory,
      getOmegaTemplates: getOmegaTemplates,
      omegarecherchepointconsommation: omegarecherchepointconsommation,
      generateBillOmega: generateBillOmega,
      getAndCheckStatusFactureOmega: getAndCheckStatusFactureOmega,
      getlistearticles: getlistearticles,
      getlisteorganismesfactureurs: getlisteorganismesfactureurs,
      updatePersonneDebiteur: updatePersonneDebiteur,
      getZipDocumentsTypes: getZipDocumentsTypes,
      getListOfFacturationOrganisations: getListOfFacturationOrganisations,
      sendRealOrganisationFact: sendRealOrganisationFact,
      getDataFromFileJson: getDataFromFileJson,
      updateJsonFile: updateJsonFile
    };
  };
  OmegaFactory.$inject = ['$http'];
  return OmegaFactory;
});
