'use strict';

define(function() {
  /**
   * @ngdoc controller
   * @name modules.model.controller:FeatureTypeCtrl
   * @description
   * The FeatureTypeCtrl controller
   */
  var FeatureTypeCtrl = function(
    $scope,
    $filter,
    DataStoreFactory,
    FeatureTypeFactory,
    UnitFactory,
    CalculFactory,
    ngDialog,
    StyleFactory,
    gaDomUtils,
    gaJsUtils,
    SridFactory,
    ElasticFactory,
    $timeout,
    ngProgressFactory,
    $compile,
    $interval,
    $rootScope,
    OdkFactory,
    InitProvider,
    AlertHpoFactory,
    $q,
    EditRulesFactory,
    ApplicationFactory,
    extendedNgDialog
  ) {
    $scope.currstyle = {};
    $scope.remove_multiple = {remove_table: false};
    let specialHpoUID;
    if (
      InitProvider.getHpoConfig &&
      InitProvider.getHpoConfig() &&
      InitProvider.getHpoConfig().datastoreuid
    )
      specialHpoUID = InitProvider.getHpoConfig().datastoreuid;

    /**
     * @ngdoc method
     * @name $scope.editFeatureType
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * Save or edit a FeatureType
     */
    $scope.editFeatureType = function() {
      gaDomUtils.showGlobalLoader();
      if (
        $scope.edit_resource.geographic === true &&
        !$scope.isEsriFeature &&
        !$scope.readonlystructure &&
        !$scope.edit_resource.srid
      ) {
        require('toastr').error(
          $filter('translate')('model.featuretypes.srid_mandatory')
        );
        return false;
      }

      const rulesVariablesErrorMessages
        = EditRulesFactory.getRulesVariablesErrors(
          angular.copy($scope.currentFeatureType.rules));

      if (rulesVariablesErrorMessages.length) {
        require('toastr').error(
          $filter('translate')(rulesVariablesErrorMessages.join('<br />'))
        );
        return false;
      }
      gaDomUtils.showGlobalLoader();

      if (!$scope.edit_resource.bboxselection) {
        $scope.edit_resource.bbox = null;
      }

      // cleaning
      delete $scope.edit_resource.bboxselection;

      if ($scope.isNewResource) {
        $scope.edit_resource.simpleFeatureType = null;

        FeatureTypeFactory.add($scope.edit_resource).then(function() {
          $scope.isNewResource = false;
        }).finally( () => {
          gaDomUtils.hideGlobalLoader();
        });
      }
      else {
        FeatureTypeFactory.update($scope.edit_resource).then(function(res) {
          if (!res.data) return;

          if (res.data.ftiToPublish) {
            if (res.data.alert &&
              (!res.data.alert.status || !res.data.published) &&
              res.data.alert.messageColonne) {
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')(
                  'model.featuretypes.checkAttributes.autopublish'
                ),
                $filter('translate')(res.data.alert.messageColonne),
                true,
                'warning'
              );
            }
            else if (
              res.data.alert &&
              res.data.alert.status &&
              res.data.alert.messageAttributes) {
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')(
                  'model.featuretypes.checkAttributes.autopublish'
                ),
                $filter('translate')(res.data.alert.messageAttributes),
                true,
                'success'
              );
            }
          }
        }).finally( () => {
          gaDomUtils.hideGlobalLoader();
        });
      }
      ngDialog.close();
    };

    /**
     * @ngdoc method
     * @name $scope.removeFeatureType
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * Delete a FeatureType
     */
    $scope.removeFeatureType = () => {
      gaDomUtils.showGlobalLoader();
      FeatureTypeFactory.remove($scope.edit_resource.uid, $scope.edit_resource.remove_table)
        .finally(() => {
          gaDomUtils.hideGlobalLoader();
          $scope.selected_resource = null;
          $scope.toggleSearchMode();
          $scope.searchMode = false;
        });
    };

    /**
     * @ngdoc method
     * @name $scope.removeFeatureType
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * Delete a FeatureType
     */
    $scope.removeFeatureTypes = () => {
      const idsToRemove = Object.keys($scope.multiResourceSelection);
      if (idsToRemove.length > 0) {
        gaDomUtils.showGlobalLoader();
        FeatureTypeFactory.removemultiple(idsToRemove,$scope.remove_multiple.remove_table)
          .finally(()=> {
            gaDomUtils.hideGlobalLoader();
            $scope.toggleSearchMode();
            $scope.searchMode = false;
            $scope.isFeaturesInDatabase = false;
          });
      }
    };

    /**
     * FeatureType loading
     * Also loads Datastores if not previously loaded
     */
    $scope.currentResources = FeatureTypeFactory.resources.featuretypes;
    DataStoreFactory.get().then(function() {
      $scope.dataStores = DataStoreFactory.resources.datastores;
      $scope.oracleDatabasesNames = [];
      if (Array.isArray($scope.dataStores)) {
        $scope.dataStores.map(function(x) {
          if (x.type === 'oracle') $scope.oracleDatabasesNames.push(x.name);
        });
      }
    });

    //$scope.$watch('currentResources', function(w){
    //console.clear();
    // console.log(w);
    // },1)

    UnitFactory.get().then(function() {
      $scope.units = UnitFactory.resources.units;
    });

    /**
     * Load Automatic calculs
     */
    CalculFactory.get().then(function() {
      $scope.calculs = [];

      for (var i = 0; i < CalculFactory.resources.calculs.length; i++) {
        var loopCalcul = CalculFactory.resources.calculs[i];

        var calcItem = {
          code: loopCalcul.code,
          alias: loopCalcul.alias,
        };

        $scope.calculs.push(calcItem);
      }

      var noCalcul = {
        code: 'none',
        alias: 'Aucun',
      };

      $scope.calculs.push(noCalcul);

      $scope.currentCalcul = {
        selected: 'none',
      };
    });

    /**
     * @ngdoc method
     * @name getCalculFromCode
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * getCalculFromCode
     */
    var getCalculFromCode = function(calcCode) {
      for (var i = 0; i < CalculFactory.resources.calculs.length; i++) {
        var loopCalcul = CalculFactory.resources.calculs[i];

        if (loopCalcul.code == calcCode) {
          return loopCalcul;
        }
      }

      return null;
    };

    /**
     * @ngdoc method
     * @name getFiltredCalculs
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * getFiltredCalculs
     */
    var getFiltredCalculs = function(ftiType, attrType) {
      var resultCalculs = [];

      var noCalcul = {
        code: 'none',
        alias: 'model.featuretypes.attributes.no_calcul',
      };

      resultCalculs.push(noCalcul);

      for (var i = 0; i < CalculFactory.resources.calculs.length; i++) {
        var loopCalcul = CalculFactory.resources.calculs[i];

        if (
          (loopCalcul.ftiType == 'ALL' || loopCalcul.ftiType == ftiType) &&
          (loopCalcul.fieldType == 'ALL' || loopCalcul.fieldType == attrType)
        ) {
          var calcItem = {
            code: loopCalcul.code,
            alias: loopCalcul.alias,
          };

          resultCalculs.push(calcItem);
        }
      }

      return resultCalculs;
    };

    /**
     * @ngdoc method
     * @name $scope.setAttributeCalcul
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * setAttributeCalcul
     */
    $scope.setAttributeCalcul = function() {
      var selectedCalcul = getCalculFromCode($scope.currentCalcul.selected);

      $scope.currentFeatureTypeAttribute.autoCalcul = selectedCalcul;
    };

    $scope.newtheme = {};
    $scope.addThemeDisplay = { v: false };

    /**
     * @ngdoc method
     * @name $scope.addTheme
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * addTheme
     */
    $scope.addTheme = function() {
      if (!$scope.newtheme.name || $scope.newtheme.name == '') return;
      if ($scope.themesList.indexOf($scope.newtheme.name) != -1) return;

      $scope.addThemeDisplay.v = false;

      $scope.themesList.push($scope.newtheme.name);
      $scope.edit_resource.theme = $scope.newtheme.name;
      $scope.newtheme = {};
    };

    /**
     * Internal loading function
     */
    $scope.themesList = ['Default'];

    /**
     * @ngdoc method
     * @name $scope.loadFeatureTypes
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * loadFeatureTypes
     */

    let loadFeatureTypes = () => {
      $scope.mainWarning = false;

      FeatureTypeFactory.get().then(() => {
        $scope.currentResources = FeatureTypeFactory.resources.featuretypes;

        let featuresWithIdAttribute = $scope.currentResources.filter((
          x
        ) => {
          return x.type == 'esri'
            ? 0
            : x.attributes.filter((att) => {
              return att.name == 'id';
            }).length;
        });

        if (featuresWithIdAttribute.length) {
          $scope.mainWarning = {
            title: 'warning_id_attribute',
            detail:
              featuresWithIdAttribute
                .map((x) => {
                  return x.name;
                })
                .join(', ') + '.',
          };
          $scope.featuresWarning = angular.copy($scope.mainWarning);
        }

        $scope.currentResources.forEach((fType) => {
          if (
            fType.theme != 'undefined' &&
            fType.theme != 'Default' &&
            $scope.themesList.indexOf(fType.theme) == -1
          ) {
            $scope.themesList.push(fType.theme);
          }

          if (fType.name === 'kis_anc_listes_deroulantes_controles') {
            fType.attributes = fType.attributes.filter(
              attribute => attribute.name !== 'civilite'
            );
          }
        });
      });
    };

    $scope.$watch('edit_resource', () => {
      if (
        $scope.edit_resource &&
        (!$scope.edit_resource.theme || $scope.edit_resource.theme === 'undefined') &&
        $scope.themesList
      ) {
        $scope.edit_resource.theme = $scope.themesList[0];
      }
    });

    // init, always reload datastores and featuretypes
    DataStoreFactory.get().then(() => {
      $scope.dataStores = DataStoreFactory.resources.datastores;
      loadFeatureTypes();
    });

    /**
     * @ngdoc method
     * @name $scope.sridModal
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * Load the modal allowing to select an srid
     */
    $scope.sridModal = () => {
      $scope.srids = SridFactory.sridsList;
      $scope.selectedsrid = {};

      if (angular.isDefined($scope.edit_resource.srid)) {
        $scope.selectedsrid.name == $scope.edit_resource.srid;
      }

      ngDialog.open({
        template:
          'js/XG/widgets/mapapp/mouseposition/views/gcmouseposition_edit.html',
        className: 'ngdialog-theme-plain',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.selectedsrid = {};
    $scope.getandsave = () => {
      $scope.edit_resource.srid = $scope.selectedsrid.name;
      $('[ng-click=\'getandsave()\']')
        .closest('.ngdialog-content')
        .children('.ngdialog-close')
        .click();
    };

    /**
     * @ngdoc method
     * @name $scope.setDefaultStyle
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * Set the defaultStyle for the current FeatureType
     * @param {object} style style object
     */
    $scope.setDefaultStyle = (style)=> {
      $scope.currentFeatureType.defaultStyle = style;
      // Set the defaultStyle for FeatureType in json file
      FeatureTypeFactory.setdefaultstyle(
        $scope.currentFeatureType.uid,
        $scope.currentFeatureType.defaultStyle
      ).then(
        () => {
          require('toastr').success(
            $filter('translate')('model.featuretypes.defaultstyle_update_ok')
          );
          gaDomUtils.hideGlobalLoader();
        },
        () => {
          require('toastr').error(
            $filter('translate')('model.featuretypes.defaultstyle_update_ko')
          );
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    /**
     * @ngdoc method
     * @name $scope.delinkStyle
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * Unlink the style for the current FeatureType
     * @param {object} style style object
     */
    $scope.delinkStyle = (style) => {
      let ans = confirm(
        $filter('translate')('model.featuretypes.styles.confirm_delink')
      );
      if (ans) {
        // reset defaultstyle if defaultstyle = style
        let delinkIndex = $scope.currentFeatureType.styles
          .map((x) => {
            return x;
          })
          .indexOf(style);
        $scope.currentFeatureType.styles.splice(delinkIndex, 1);
        if ($scope.currentFeatureType.defaultStyle == style) {
          $scope.currentFeatureType.defaultStyle = '';
        }
      }
    };

    /**
     * @ngdoc method
     * @name $scope.saveStyle
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * Save Style
     */
    $scope.saveStyle = () => {
      StyleFactory.add($scope.currstyle.sld, $scope.currstyle.name).then(
        (res) => {
          console.log(res);
        }
      );
      FeatureTypeFactory.addstyle(
        $scope.edit_resource.uid,
        $scope.currstyle.name
      ).then((res) => {
        console.log(res);
      });
      $scope.edit_resource.styles.push($scope.currstyle.name);
    };

    /**
     * @ngdoc method
     * @name $scope.selectSrid
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * Srid selection from the sridModal
     * @param {object} srid srid object
     */
    $scope.selectSrid = (srid) => {
      $scope.edit_resource.srid = srid.srid;
    };

    $scope.inprogress = false;
    /**
     * @ngdoc method
     * @name $scope.indexFeatureType
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * FeatureType indexation
     * @param {object} srid srid object
     */
    $scope.currentEditedElasticFeatures = [];
    $scope.indexFeatureType = () => {
      let ans = confirm(
        $filter('translate')('model.featuretypes.index_period')
      );
      if (ans) {
        gaDomUtils.showGlobalLoader();
        $scope.currentEditedElasticFeatures.push($scope.edit_resource.uid);
        ElasticFactory.createCompleteType(
          $scope.edit_resource.name,
          $scope.edit_resource.srid
        ).then(
          () => {
            gaDomUtils.hideGlobalLoader();
            $scope.currentResources.map(function(x) {
              x.indexEnCours = false;
            });
            $scope.edit_resource.inElasticSearch = false;
            $scope.progressbar = ngProgressFactory.createInstance();
            let alias = 'index ' + $scope.edit_resource.alias;
            $('body.admin').append(
              '<div id="progression" ng-show="inprogress" '
              + 'style="position:fixed;bottom:0px;right:0px;width:300px">'
              + '<center style="padding-top:5px;z-index:999999;">' +
                alias +
                '</center></div>'
            );
            $scope.progressbar.setParent(
              document.getElementById('progression')
            );
            $scope.progressbar.setHeight('34px');
            $scope.progressbar.setColor('#339999');
            $compile($('#progression'))($scope);
            $scope.inprogress = true;
          },
          () => {
            require('toastr').error(
              $filter('translate')('model.featuretypes.index_nok')
            );
            gaDomUtils.hideGlobalLoader();
            let publishIndex = $scope.currentResources
              .map(function(x) {
                return x.uid;
              })
              .indexOf($scope.currentEditedElasticFeatures[0]);
            $scope.currentResources[publishIndex].inElasticSearch = false;
            $scope.currentEditedElasticFeatures.splice(0, 1);
          }
        );
      }
    };

    $scope.$watch('inprogress', (newval) => {
      if (newval) {
        $scope.progressbar.set(0);
        let stop = $interval(() => {
          ElasticFactory.getProgression().then(
            (res) => {
              if (res.data < 100) {
                let p = res.data;
                $scope.progressbar.set(p);
              }
              else if (res.data == 100) {
                for (let idx = 0; idx < $scope.currentResources.length; idx++) {
                  $scope.currentResources[idx].indexEnCours = true;
                  delete $scope.currentResources[idx].indexEnCours;
                }
                $interval.cancel(stop);
                require('toastr').success(
                  $filter('translate')('model.featuretypes.index_ok')
                );
                $scope.progressbar.complete();
                $scope.inprogress = false;
                gaDomUtils.hideGlobalLoader();
                $('#progression').remove();
                let publishIndex = $scope.currentResources
                  .map((x) => {
                    return x.uid;
                  })
                  .indexOf($scope.currentEditedElasticFeatures[0]);
                $scope.currentResources[publishIndex].inElasticSearch = true;
                $scope.currentEditedElasticFeatures.splice(0, 1);
              }
            },
            function() {
              for (var idx = 0; idx < $scope.currentResources.length; idx++) {
                $scope.currentResources[idx].indexEnCours = true;
                delete $scope.currentResources[idx].indexEnCours;
              }
              $interval.cancel(stop);
              require('toastr').error(
                $filter('translate')('model.featuretypes.index_nok')
              );
              $scope.progressbar.complete();
              $scope.inprogress = false;
              gaDomUtils.hideGlobalLoader();
              $('#progression').remove();
              var publishIndex = $scope.currentResources
                .map(function(x) {
                  return x.uid;
                })
                .indexOf($scope.currentEditedElasticFeatures[0]);
              $scope.currentResources[publishIndex].inElasticSearch = false;
              $scope.currentEditedElasticFeatures.splice(0, 1);
            }
          );
        }, 2000);
      }
    });

    $scope.downloadWfsReport = () => {
      window.open(
        '/services/' +
          $rootScope.xgos.portal.uid +
          '/file/getFilesFromRepoByPath?path=/ATTACHMENTS/' +
          $scope.edit_resource.name +
          '/wfs_report_' +
          $scope.edit_resource.name +
          '.txt' +
          '&token=' + localStorage.getItem('auth_token')
      );
    };


    /**
     * @ngdoc method
     * @name $scope.publishFeatureType
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * FeatureType publication
     * @param {object} srid srid object
     */
    $scope.publishFeatureType = function() {
      var ans = confirm(
        $filter('translate')('model.featuretypes.confirm_publish')
      );
      if (ans) {
        gaDomUtils.showGlobalLoader();

        FeatureTypeFactory.publish($scope.edit_resource.uid).then(
          (res) => {
            if (!res.data.geographic) {
              require('toastr').success(
                $filter('translate')('model.featuretypes.cannotpublishnongeographic')
              );

            }
            else {
              require('toastr').success(
                $filter('translate')('model.featuretypes.publish_ok')
              );
              // on verfie seulement dans le cas ou la couche
              // n'était pas publié avant (nouvelle couche)
              if(!$scope.edit_resource.published){
                isFilterCatalogActivated();
              }
            }

            gaDomUtils.hideGlobalLoader();
            $scope.edit_resource.published = true;
          },
          function() {
            require('toastr').error(
              $filter('translate')('model.featuretypes.publish_nok')
            );
            gaDomUtils.hideGlobalLoader();
          }
        );
      }
    };

    /**
     * verifié s'il existe un gestionnaire de filtre de geocatalogue activé
     * si c'est le cas on affiche une seule fois un msg pour informer l'utilisateur
     */
    let isFilterCatalogActivated = () => {
      ApplicationFactory.get(false).then((applications)=>{
        for(const app of applications.data){
          if(app.type === 'MapApp' && app.filterLayers && app.filterLayers.useFilter){
            swal({
              title: $filter('translate')('hpo.common.warning'),
              text: $filter('translate')('model.featuretypes.checkFilterLayers'),
              type: 'warning',
              showCancelButton: false,
            });
            break;
          }
        }
      });
    };

    /**
     * @ngdoc method
     * @name $scope.publishFeatureType
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * FeatureType publication
     * @param {object} srid srid object
     */
    $scope.downloadAttachement = function() {
      ngDialog.open({
        template:
          'js/XG/modules/model/views/modals/modal.featuretypes.attachements.html',
        className: 'ngdialog-theme-plain width600',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.attachementcond = {
      onlypicture: false,
      name: undefined,
    };

    $scope.getAttachement = function() {
      window.open(
        '/services/' +
          $rootScope.xgos.portal.uid +
          '/attachement/admin/get?uid=' +
          $scope.edit_resource.uid +
          '&onlypicture=' +
          $scope.attachementcond.onlypicture +
          '&name=' +
          $scope.attachementcond.name
      );
    };

    /* **********************************************
         FEATURETYPE ATTRIBUTES RESTRICTION
         */

    /**
     * Removes a restriction from a featureTypeAttribute
     */
    $scope.removeRestrictionFromFeatureTypeAttribute = function(toDelete) {
      $scope.currentFeatureTypeAttribute.restrictions.splice(toDelete, 1);
    };

    /**
     * Adds a restriction to a featureType attribute
     */
    $scope.addRestrictionToFeatureTypeAttribute = function() {
      if ($scope.currentFeatureTypeAttrRestrictionIndex == -1) {
        $scope.currentFeatureTypeAttribute.restrictions.push(
          $scope.currentFeatureTypeAttrRestriction
        );
      }
      else {
        $scope.currentFeatureTypeAttribute.restrictions[
          $scope.currentFeatureTypeAttrRestrictionIndex
        ] = $scope.currentFeatureTypeAttrRestriction;
      }
    };

    $scope.fillDomainEntryValueIfEmpty = function(obj) {
      if (obj.k && !obj.v) {
        obj.v = obj.k;
      }
    };
    /**
     * Adds a value to a domain restriction on an attribute
     */
    $scope.addFeatureTypeAttrRestrictionDomainValue = function(newValue) {
      if (!angular.isDefined(newValue) || !angular.isDefined(newValue.k))
        return;

      if (
        !angular.isDefined(
          $scope.currentFeatureTypeAttrRestriction.listofValues
        )
      )
        $scope.currentFeatureTypeAttrRestriction.listofValues = {};
      // if key already exists
      if (
        angular.isDefined(
          $scope.currentFeatureTypeAttrRestriction.listofValues[newValue.k]
        )
      ) {
        require('toastr').error(
          $filter('translate')(
            'model.featuretypes.attributes.restrictions.domain.cant_add'
          )
        );
        return;
      }
      if (!angular.isDefined($scope.fTisEditable)) $scope.fTisEditable = [];
      $scope.currentFeatureTypeAttrRestriction.listofValues[newValue.k] =
        newValue.v;

      return {};
    };

    $scope.fTisEditable = [];
    $scope.isEditable = (key) => {
      return $scope.fTisEditable.indexOf(key) !== -1;
    };
    $scope.EnableFeatureTypeAttrRestrictionDomainValue = function(key) {
      if($scope.fTisEditable.indexOf(key) === -1) {
        $scope.fTisEditable.push(key);
      }
    };

    $scope.EditFeatureTypeAttrRestrictionDomainValue = function(key, newKey) {
      if (key != newKey) {
        // if key already exists
        if (
          angular.isDefined(
            $scope.currentFeatureTypeAttrRestriction.listofValues[newKey]
          )
        ) {
          require('toastr').error(
            $filter('translate')(
              'model.featuretypes.attributes.restrictions.domain.cant_add'
            )
          );
          return;
        }

        $scope.currentFeatureTypeAttrRestriction.listofValues[newKey] =
          $scope.currentFeatureTypeAttrRestriction.listofValues[key];
        delete $scope.currentFeatureTypeAttrRestriction.listofValues[key];
      }
      $scope.fTisEditable.splice($scope.fTisEditable.indexOf(key), 1);
    };

    $scope.DeleteFeatureTypeAttrRestrictionDomainValue = function(key) {
      delete $scope.currentFeatureTypeAttrRestriction.listofValues[key];
      $scope.fTisEditable.splice($scope.fTisEditable.indexOf(key), 1);
    };

    /* **********************************************
         FEATURETYPE RELATIONS
         */
    /**
     * Removes a relation from a FeatureType
     */
    $scope.removeRelationFromFeatureType = function() {
      for (var i = 0; i < $scope.currentFeatureType.relations.length; i++) {
        if (
          gaJsUtils.isObjectValueEqual(
            currentRemoveRelation,
            $scope.currentFeatureType.relations[i]
          )
        ) {
          $scope.currentFeatureType.relations.splice(i, 1);
        }
      }
    };

    /**
     * Adds a relation to a FeatureType
     */
    $scope.addRelationToFeatureType = function() {
      if ($scope.currentFeatureTypeRelationIndex == -1) {
        $scope.currentFeatureType.relations.push(
          $scope.currentFeatureTypeRelation
        );
      }
      else {
        $scope.currentFeatureType.relations[
          $scope.currentFeatureTypeRelationIndex
        ] = $scope.currentFeatureTypeRelation;
      }
    };

    $scope.filterAttribute = function(attribute) {
      if (attribute.name !== 'Identifiant') return attribute.name;
    };

    var currentRemoveAtt;
    var currentRemoveRelation;
    var saveCurrentFeatureTypeRelation;

    function getDsOfFeatureType(ft) {
      var iDs;
      for (iDs = 0; iDs < $scope.dataStores.length; iDs++) {
        if ($scope.dataStores[iDs].name == ft.storeName)
          return $scope.dataStores[iDs];
      }
    }


    /**
     * Si la propriété "cascadeDelete" de la relation n'est pas définie,
     * on la positionne à VRAI. Cette propriété n'est exploitée que dans
     * le cas d'une relation simple, on peut donc la positionner
     * sans se préocuper du type de relation choisie (l'appel à
     * cette fonction est fait aavant le choix du type de relation).
     */
    const setDefaultCascadeDelete = () => {
      if ($scope.currentFeatureTypeRelation.cascadeDelete===undefined) {
        $scope.currentFeatureTypeRelation.cascadeDelete = true;
      }
    };

    /**
     * Apellé quand on change de composant de fin de relation,
     * ou quand on sélectionne la relation dans la liste des relations
     * du composant, cette fonction stocke dans la propriété "endAttributes"
     * du scope la liste des attributs du composant de fin de relation
     * qui alimente la liste de choix.
     * Par le truchement du watch pour le cas de changement de comopsant,
     * cette fonction est également appelé dans le cas de la suppression
     * de relation.
     */
    const refreshEndAttributes =  () => {
      if (!$scope.currentFeatureTypeRelation
        || !$scope.currentFeatureTypeRelation.idEnd) {
        //-- En suppression de relation,
        //-- currentFeatureTypeRelation n'est pas défini
        return;
      }
      const feat = FeatureTypeFactory.getFeatureByUid(
        $scope.currentFeatureTypeRelation.idEnd
      );
      $scope.endAttributes = feat.attributes;
    };


    /* FeatureType attributes */
    /**
     * Edit modal is loaded
     */
    $scope.$on('data_modal', function(event, args) {
      $scope.editFeatureTypeDialog = args.dialogObject;
      // extra modals (attributes, restrictions...)
      if (args.editObject.name) {
        /*
                 instatiates a new scope variable as $scope[editObjectname] (ex: featureTypeAttr)
                 which can be used in edit/remove methods
                 */
        $scope[args.editObject.name] = args.editObject.obj;

        if (args.editObject.name == 'featureTypeAttr') {
          currentRemoveAtt = args.editObject.obj;
        }
        else if (args.editObject.name == 'featureTypeRelation') {
          currentRemoveRelation = args.editObject.obj;
        }

        /**************************************
         * FEATURETYPE RULES EDITION
         */
        if (args.editObject.name == 'featureTypeRules') {
          $scope.currentFeatureTypeRule = $scope['featureTypeRules'];
        }
        /**************************************
         * FEATURETYPE ATTRIBUTE EDITION
         */
        if (args.editObject.name == 'featureTypeAttr') {
          /*$scope.attributeTypes = {
                     "Double"        :"java.lang.Double",
                     "Date"          :"java.util.Date",
                     "String"        :"java.lang.String",
                     "Boolean"       :"java.lang.Boolean",
                     "Integer"       :"java.lang.Integer",
                     "Timestamp"     :"java.sql.Timestamp",
                     "Attachement"     :"g2c.attachment",
                     "Attachement-multi"     :"g2c.attachments"
                     };*/

          if (
            $scope.oracleDatabasesNames &&
            $scope.oracleDatabasesNames.length > 0 &&
            $scope.currentFeatureType &&
            $scope.currentFeatureType.storeName &&
            $scope.oracleDatabasesNames.indexOf(
              $scope.currentFeatureType.storeName
            ) !== -1
          ) {
            $scope.attributeTypes = [
              {
                id: 'java.lang.Double',
                label: 'java.lang.Double',
              },
              {
                id: 'java.util.Date',
                label: 'java.util.Date',
              },
              {
                id: 'java.lang.String',
                label: 'java.lang.String',
              },
              {
                id: 'java.lang.Integer',
                label: 'java.lang.Integer',
              },
              {
                id: 'java.sql.Timestamp',
                label: 'java.sql.Timestamp',
              },
              {
                id: 'g2c.attachment',
                label: 'g2c.attachment',
              },
              {
                id: 'g2c.attachments',
                label: 'g2c.attachments',
              },
              {
                id: 'g2c.hyperlink',
                label: 'g2c.hyperlink',
              },
            ];
          }
          else {
            $scope.attributeTypes = [
              {
                id: 'java.lang.Double',
                label: 'java.lang.Double',
              },
              {
                id: 'java.util.Date',
                label: 'java.util.Date',
              },
              {
                id: 'java.lang.String',
                label: 'java.lang.String',
              },
              {
                id: 'java.lang.Boolean',
                label: 'java.lang.Boolean',
              },
              {
                id: 'java.lang.Integer',
                label: 'java.lang.Integer',
              },
              {
                id: 'java.sql.Timestamp',
                label: 'java.sql.Timestamp',
              },
              {
                id: 'g2c.attachment',
                label: 'Attachement',
              },
              {
                id: 'g2c.attachments',
                label: 'Attachement-multi',
              },
              {
                id: 'g2c.hyperlink',
                label: 'g2c.hyperlink',
              },
            ];
          }

          /*
                     Store the edited FeatureType so we can use in further directives
                     (ie: FeatureTypeAttributes edition)
                     */

          $scope.currentFeatureTypeAttribute = $scope['featureTypeAttr'];
          $scope.isNewFeatureTypeAttribute = args.isNew == 1;
          $scope.currentFeatureTypeAttributeIndex = $scope.currentFeatureType.attributes
            .map(function(x) {
              return x.name;
            })
            .indexOf(args.editObject.obj.name);

          $scope.attributeTabs.activeTab = 0;

          if (
            !angular.isDefined($scope.currentFeatureTypeAttribute.restrictions)
          ) {
            $scope.currentFeatureTypeAttribute.restrictions = [];
          }

          /* var forbiddenNames = $scope.currentFeatureType.attributes.map(function(r){
                        if(r.name!=$scope.currentFeatureTypeAttribute.name){
                            return r.name;
                        }
                    });

                    $scope.$watch('currentFeatureTypeAttribute.name',function(x){
                        $scope.invalidName = forbiddenNames.indexOf(x)!=-1;
                    }, true);*/

          $scope.$watch(
            'currentFeatureTypeAttribute.type',
            function(type) {
              if (!angular.isDefined(type)) return;
              $scope.calculs = getFiltredCalculs(
                $scope.currentFeatureType.typeInfo,
                type
              );
            },
            true
          );


          // switch between String and Attachment/-multi types in attribute edition mode

          // array of allowed types to switch between each other
          $scope.allowedToSwitchBetweenTypes
            = ['java.lang.String','g2c.attachment','g2c.attachments','g2c.hyperlink'];
          // boolean to manage ng-switch between the two select tags creation|edition mode
          $scope.isStringOrAttachementType
            = $scope.allowedToSwitchBetweenTypes.includes($scope.currentFeatureTypeAttribute.type);

          // filter the select dropdown
          $scope.filterAttributeTypes = () =>{
            return function (item) {
              return $scope.allowedToSwitchBetweenTypes.includes(item.id);
            };
          };

          //récupérer type fti , type attribut

          if (
            angular.isDefined($scope.currentFeatureTypeAttribute.autoCalcul) &&
            $scope.currentFeatureTypeAttribute.autoCalcul != null
          ) {
            var currentCalculCode =
              $scope.currentFeatureTypeAttribute.autoCalcul.code;

            $scope.currentCalcul = {
              selected: currentCalculCode,
            };
          }
          else {
            $scope.currentCalcul = {
              selected: 'none',
            };
          }

          /*
           * FeatureTypeRestriction Attributes EditList
           */
          $scope.FeatureAttributesRestrictionsListCfg = {
            dataModule: 'model',
            resource_type: 'featuretypes.attributes.restrictions',
            resource_name: 'featureTypeAttrRestriction',
            cols: ['type'],
            noFilter: true,
            currentResources: $scope.featureTypeAttr.restrictions,
            removeFunction: $scope.removeRestrictionFromFeatureTypeAttribute,
          };
        }

        /**************************************
         * FEATURETYPE RELATIONS EDITION
         */
        if (args.editObject.name == 'featureTypeRelation') {
          $scope.featureTypesList = FeatureTypeFactory.resources.featuretypes;

          $scope.currentFeatureTypeRelation = $scope['featureTypeRelation'];
          refreshEndAttributes();
          setDefaultCascadeDelete();
          $scope.currentFeatureTypeRelationIndex = $scope.currentFeatureType.relations
            .map(function(x) {
              return x.name;
            })
            .indexOf(args.editObject.obj.name);

          saveCurrentFeatureTypeRelation = angular.copy(
            $scope.currentFeatureTypeRelation
          );

          $scope.currentFeatureTypeRelation.componentStart =
            $scope.currentFeatureType.name;
          $scope.currentFeatureTypeRelation.idStart =
            $scope.currentFeatureType.uid;
          $scope.componentEndSelect = {
            uid: $scope.currentFeatureTypeRelation.idEnd,
          };

          $scope.relationsTypes = {
            REL_NM: 'REL_NM',
            REL_SIMPLE: 'REL_SIMPLE',
            REL_WS: 'REL_WS',
          };
        }

        /**************************************
         * FEATURETYPE ATTRIBUTE RESTRICTION EDITION
         */
        if (args.editObject.name == 'featureTypeAttrRestriction') {
          $scope.currentFeatureTypeAttrRestriction =
            $scope['featureTypeAttrRestriction'];
          $scope.currentFeatureTypeAttrRestrictionIndex = args.editObject.index;
          $scope.featureTypesList = FeatureTypeFactory.resources.featuretypes;

          $scope.isNewFeatureTypeAttributeRestriction = args.isNew == 1;
          if (!args.isNew) {
            var restrictedComponent = FeatureTypeFactory.getFeatureByUid(
              $scope.currentFeatureTypeAttrRestriction.ftid
            );
            if (
              restrictedComponent &&
              restrictedComponent.attributes &&
              restrictedComponent.attributes
                .map(function(x) {
                  return x.name;
                })
                .indexOf('Identifiant') === -1
            )
              restrictedComponent.attributes.unshift({
                name: 'Identifiant',
                alias: 'Identifiant',
                type: 'java.lang.Integer',
                isNillable: true,
                size: 500,
                restrictions: [],
                popup: false,
                autoCalcul: null,
              });
            $scope.afeatureTypeAttrRestriction = {
              table: restrictedComponent,
              keyField: {},
              valueField: {},
              allowMultipleSelection: false,
              filterDefinition: '',
              applyFilter: false
            };
            if (restrictedComponent && restrictedComponent.attributes) {
              restrictedComponent.attributes.forEach(function(attr) {
                if (
                  attr.name == $scope.currentFeatureTypeAttrRestriction.keyField
                ) {
                  $scope.afeatureTypeAttrRestriction.keyField = attr;
                }
                if (
                  attr.name ==
                  $scope.currentFeatureTypeAttrRestriction.valueField
                ) {
                  $scope.afeatureTypeAttrRestriction.valueField = attr;
                }
              });

              if($scope.currentFeatureTypeAttrRestriction.allowMultipleSelection) {
                $scope.afeatureTypeAttrRestriction.allowMultipleSelection = true;
              }
              if($scope.currentFeatureTypeAttrRestriction.filterDefinition) {
                $scope.afeatureTypeAttrRestriction.filterDefinition
                  = $scope.currentFeatureTypeAttrRestriction.filterDefinition;
              }
              if($scope.currentFeatureTypeAttrRestriction.applyFilter) {
                $scope.afeatureTypeAttrRestriction.applyFilter
                  = $scope.currentFeatureTypeAttrRestriction.applyFilter;
              }
            }
          }
          else {
            // set default values
            $scope.currentFeatureTypeAttrRestriction.isLoginKey = true;
            $scope.afeatureTypeAttrRestriction = {
              table: undefined,
              keyField: {},
              valueField: {},
              allowMultipleSelection: false,
              filterDefinition: '',
              applyFilter: false
            };
          }

          $scope.restrictionsTypes = {
            Interval: $filter('translate')(
              'model.featuretypes.attributes.restrictions.interval.option'
            ),
            inputSize: $filter('translate')(
              'model.featuretypes.attributes.restrictions.inputsize.option'
            ),
            Tables: $filter('translate')(
              'model.featuretypes.attributes.restrictions.table.option'
            ),
            Domain: $filter('translate')(
              'model.featuretypes.attributes.restrictions.domain.option'
            ),
            User: $filter('translate')(
              'model.featuretypes.attributes.restrictions.user.option'
            ),
          };

          $scope.setfeatureTypeAttrRestriction = function(feat) {
            $scope.currentFeatureTypeAttrRestriction.table = feat.name;
            $scope.currentFeatureTypeAttrRestriction.ftid = feat.uid;
            var restrictedComponent = feat;
            if (
              restrictedComponent &&
              restrictedComponent.attributes &&
              restrictedComponent.attributes
                .map(function(x) {
                  return x.name;
                })
                .indexOf('Identifiant') === -1
            )
              restrictedComponent.attributes.unshift({
                name: 'Identifiant',
                alias: 'Identifiant',
                type: 'java.lang.Integer',
                isNillable: true,
                size: 500,
                restrictions: [],
                popup: false,
                autoCalcul: null,
              });
            $scope.afeatureTypeAttrRestriction = {
              table: restrictedComponent,
              keyField: {},
              valueField: {},
              allowMultipleSelection: false,
              filterDefinition: '',
              applyFilter: false
            };
          };


          $scope.setfeatureTypeAttrRestrictionKey = function(att) {
            $scope.currentFeatureTypeAttrRestriction.keyField = att.name;
          };
          $scope.setfeatureTypeAttrRestrictionValue = function(att) {
            $scope.currentFeatureTypeAttrRestriction.valueField = att.name;
          };
          $scope.setfeatureTypeAttrRestrictionMultiple = (att) => {
            $scope.currentFeatureTypeAttrRestriction.allowMultipleSelection = att;
          };
          $scope.setfeatureTypeAttrFilterDefinition = (filterDefinition) => {
            $scope.currentFeatureTypeAttrRestriction.filterDefinition = filterDefinition;
          };
          $scope.setfeatureTypeAttrApplyFilter = (applyFilter) => {
            $scope.currentFeatureTypeAttrRestriction.applyFilter = applyFilter;
          };
        }
        /*
         * Editing the main resource (featureTypes)
         */
      }
      else {
        $scope.tabs.activeTab = 0;

        if ($scope.edit_resource.storeName)
          DataStoreFactory.tablesget($scope.edit_resource.storeName).then(
            function(res) {
              $scope.featuresInDatabase = res.data;
            }
          );

        /**
         * Only in edition mode
         */
        if (args.action == 'edit') {
          /*
            Store the edited FeatureType so we can use it in further directives
            (ie: FeatureTypeAttributes edition)
          */
          $scope.currentFeatureType = $scope.edit_resource;
          $scope.isNewFeatureType = !$scope.currentFeatureType.published;
          $scope.isEsriFeature = $scope.currentFeatureType.type == 'esri';
          $scope.isPostgisAndExistInDB = false;
          if($scope.edit_resource.storeName &&
            DataStoreFactory.getDataStoreByName($scope.edit_resource.storeName).type === 'postgis'){
            FeatureTypeFactory.isfeatureindatabase(
              $scope.edit_resource.uid
            ).then(res => {
              $scope.isPostgisAndExistInDB = res.data;
            });
          }
          var ds = getDsOfFeatureType($scope.currentFeatureType);
          $scope.readonlystructure
            = ds && ds.readonlystructure ||  $scope.currentFeatureType.readOnly;

          /*
           *  Bbox selection checkbox
           *  True for new resources
           */
          $scope.edit_resource.bboxselection = $scope.isNewResource
            ? false
            : $scope.edit_resource.bbox !== null;


          // Prepare restrictionType in attribute for his use in the displayed tab in EditList
          for (const attribute of $scope.currentFeatureType.attributes) {
            if (attribute.restrictions && attribute.restrictions.length > 0) {
              attribute.restrictionType = $filter('translate')(
                'model.featuretypes.attributes.restrictions.'
                  + attribute.restrictions[0].type);
            }
          }

          /*
           * FeatureType Attributes EditList
           */
          $scope.FeatureAttributesListCfg = {
            dataModule: 'model',
            resource_type: 'featuretypes.attributes',
            resource_name: 'featureTypeAttr',
            cols: ['name', 'alias', 'size', 'type', 'mandatory', 'restrictionType', 'updateField'],
            colsFunction: {
              type: 'translateColumn',
            },
            currentResources: $scope.currentFeatureType.attributes,
            removeFunction: $scope.removeAttributeFromFeatureType,
            defautValues: [
              { k: 'size', v: 500 },
              { k: 'type', v: 'java.lang.String' },
            ],
            allowReorder: true,
            saveChangedOrder: $scope.saveChangedAttributeOrder,
            addResourceButton:
              !$scope.isEsriFeature && !$scope.readonlystructure,
            deleteResourceButton:
              !$scope.isEsriFeature && !$scope.readonlystructure,
            skipSelectAfterAdding: true,
            specialSizeCondition: true,
            allowMultipleSelectionAttribute: {
              uniqueKey: 'name',
            }
          };

          /*
           * FeatureType Relations EditList
           */
          $scope.FeatureRelationsListCfg = {
            dataModule: 'model',
            resource_type: 'featuretypes.relations',
            resource_name: 'featureTypeRelation',
            cols: [
              'name',
              'type',
              'componentStart',
              'componentEnd',
              'fieldStart',
              'fieldEnd',
            ],
            currentResources: $scope.currentFeatureType.relations,
            removeFunction: $scope.removeRelationFromFeatureType
          };
          /*
           * FeatureType Rules EditList
           */
          //                    $scope.currentFeatureType.rules = [];
          //                    $scope.FeatureRulesListCfg = {
          //                        dataModule : 'model',
          //                        resource_type : 'featuretypes.rules',
          //                        resource_name : 'featureTypeRules',
          //                        cols : ['name','type'],
          //                        rulesNamesList : $scope.rulesNamesList,
          //                        currentResources: $scope.currentFeatureType.rules,
          //                        currentFeatureTypeRule: undefined,
          //                        selected_FeatureType: $scope.selected_resource,
          //                        removeFunction : $scope.removeRulesFromFeatureType
          //                    };
        }

        /**
         * Only in delete mode
         */
        if (args.action == 'delete') {
          $scope.isEsriFeature = $scope.edit_resource.type == 'esri';
          $scope.edit_resource.remove_table = false;
        }
      }

      /*
        When the typeInfo changes, updates geographic
      */
      $scope.$watch('edit_resource.typeInfo',
        (data) => {
          if ($scope.edit_resource !== null) {
          // init or update config
            $scope.edit_resource.geographic = data != undefined && data !== 'NG';
            // Reset the SRID and save it in case typeInfo is change again
            if (data == 'NG') {
              $scope.saveSrid = $scope.edit_resource.srid;
              $scope.edit_resource.srid = '';
            }
            else {
              if ($scope.saveSrid) {
                $scope.edit_resource.srid = $scope.saveSrid;
              }
            }
          }
        },
        true
      );
    });

    $scope.componentEndSelect = {};
    $scope.updateEndComponent = function() {
      const feat = FeatureTypeFactory.getFeatureByUid(
        $scope.componentEndSelect.uid
      );
      $scope.currentFeatureTypeRelation.componentEnd = feat.name;
      $scope.currentFeatureTypeRelation.idEnd = feat.uid;
    };


    $scope.$watch('currentFeatureTypeRelation.componentEnd', () => {
      refreshEndAttributes();
    });

    /**
     * Adds an attribute to featuretype
     */
    $scope.addAttributeToFeatureType = () => {
      // Ajout du type de restriction pour l'attribut
      if ($scope.currentFeatureTypeAttribute.restrictions
          && $scope.currentFeatureTypeAttribute.restrictions.length > 0) {
        $scope.currentFeatureTypeAttribute.restrictionType = $filter('translate')(
          'model.featuretypes.attributes.restrictions.'
            + $scope.currentFeatureTypeAttribute.restrictions[0].type);
      } else {
        $scope.currentFeatureTypeAttribute.restrictionType = undefined;
      }
      if ($scope.currentFeatureTypeAttributeIndex == -1) {
        $scope.currentFeatureType.attributes.push(
          $scope.currentFeatureTypeAttribute
        );
      }
      else {
        $scope.currentFeatureType.attributes[
          $scope.currentFeatureTypeAttributeIndex
        ] = $scope.currentFeatureTypeAttribute;
      }
    };

    let remove = (selectionMultiple) => {
      for(let attribut of selectionMultiple){
        let index = $scope.currentFeatureType.attributes.findIndex(at => at.name === attribut);
        $scope.currentFeatureType.attributes.splice(index, 1);
      }
      if($scope.FeatureAttributesListCfg.allowMultipleSelectionAttribute.multiResourceSelection != null){
        $scope.FeatureAttributesListCfg.allowMultipleSelectionAttribute.multiResourceSelection = {};
      }
      $scope.$emit('reloadEditList');
    };

    $scope.removeAttributeFromFeatureType = () => {
      let selectionMultiple = [];
      let multiResourceSelection = $scope.FeatureAttributesListCfg
        && $scope.FeatureAttributesListCfg.allowMultipleSelectionAttribute
        ? $scope.FeatureAttributesListCfg.allowMultipleSelectionAttribute.multiResourceSelection
        : null;
      if(multiResourceSelection != null && Object.keys(multiResourceSelection).length > 0 ){
        selectionMultiple = Object.keys(multiResourceSelection).
          filter(key => multiResourceSelection[key]);
      } else {
        //Si la selection multiple est null, on ajoute à la liste l'attribut séléctioné
        selectionMultiple.push(currentRemoveAtt.name);
      }
      if(selectionMultiple.length > 0){
        // -- Ne rendre l'accés à l'utilisateur qu'une fois que
        // -- getFeatureTypeFromDataBase a terminé
        gaDomUtils.showLocalLoader('#ftiManagerForm');
        // verifié si l'un des attributs séléctionnés  n'existe pas dans la base de données
        FeatureTypeFactory.getFeatureTypeFromDataBase($scope.currentFeatureType.uid).then(res =>{
          if(res && res.data && res.data.attributes){
            const selectionMultipleNotInDB = selectionMultiple.filter(
              name => !res.data.attributes.some(at => at.name == name));
            if(selectionMultipleNotInDB.length>0){
              let noFoundMsg = (selectionMultipleNotInDB.length == 1)
                ? 'model.featuretypes.attributNoFoundDb' : 'model.featuretypes.attributesNoFoundDb';
              swal(
                {
                  title: selectionMultipleNotInDB + $filter('translate')(noFoundMsg),
                  type: 'warning',
                  showCancelButton: true,
                  confirmButtonColor: '#DD6B55',
                  confirmButtonText: $filter('translate')('common.yes'),
                  cancelButtonText: $filter('translate')('common.no'),
                  closeOnConfirm: true,
                  closeOnCancel: true,
                },
                function (res) {
                  if(res){
                    remove(selectionMultiple);
                  }
                }
              );
            }
            else{
              remove(selectionMultiple);
            }
          }
          else {
            remove(selectionMultiple);

          }
        },() =>{
          remove(selectionMultiple);
        })
          .finally( () => {
            gaDomUtils.removeLocalLoader('#ftiManagerForm');
          });
      }
    };

    $scope.interpretAsBoolean = () => {
      if($scope.currentFeatureTypeAttribute.interpretAsBoolean
        && $scope.currentFeatureTypeAttribute.restrictions &&
         $scope.currentFeatureTypeAttribute.restrictions.length>0){
        require('toastr').error(
          $filter('translate')('model.featuretypes.attributes.interpretAsBooleanNoRestriction')
        );
        $scope.currentFeatureTypeAttribute.interpretAsBoolean
          = !$scope.currentFeatureTypeAttribute.interpretAsBoolean;
      }
    };


    /**
     * Set the list of available multiples to select from
     * during attribute unit edition
     */

    $scope.setAvailableMultiples = function() {
      if (!$scope.currentFeatureTypeAttribute.unit) return;
      $scope.availableMultiples = [];

      if ($scope.currentFeatureTypeAttribute.unit.type == null) {
        $scope.currentFeatureTypeAttribute.unit = '';
        return;
      }

      $scope.units.forEach(function(unit) {
        if (unit.unit == $scope.currentFeatureTypeAttribute.unit.type) {
          //$scope.availableMultiples = unit.multiple;
          $scope.availableMultiples = unit.multiple.map(function(x) {
            x.factor = parseFloat(x.factor);
            return x;
          });
        }
      });
    };
    /**
     * [showMap description]
     * @return {[type]} [description]
     */
    $scope.mapping = function() {
      //$scope.previewfti = $scope.edit_resource;

      gaDomUtils.showGlobalLoader();
      console.log($scope.edit_resource);
      FeatureTypeFactory.mapping($scope.edit_resource.uid).then(
        function(res) {
          gaDomUtils.hideGlobalLoader();
          require('toastr').success(
            $filter('translate')('model.featuretypes.mapping_ok')
          );
          console.log(res);
        },
        function() {
          require('toastr').error(
            $filter('translate')('model.featuretypes.mapping_nok')
          );
          gaDomUtils.hideGlobalLoader();
        }
      );
    };
    /**
     *  Displays a map
     */
    $scope.showMap = function() {
      $scope.previewfti = $scope.edit_resource;

      ngDialog.open({
        template:
          'js/XG/modules/model/views/modals/modal.featuretypes.preview.html',
        className: 'ngdialog-theme-plain fullScreen nopadding miniclose',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /** Style Editor Light **/

    $scope.openSldEditor = function() {
      $scope.sldEditorData = {
        ngDialogType: 'sldEditor',
        isClosed: false,
      };

      $scope.sldEditor = ngDialog.open({
        template:
          'js/XG/modules/model/views/modals/modal.featuretypes.styleeditor.html',
        className: 'ngdialog-theme-plain width800 nopadding miniclose styleeditor',
        closeByDocument: false,
        scope: $scope,
        data: $scope.sldEditorData,
      });
    };

    $scope.$on('ngDialog.closed', function(e, dialog) {
      if ($scope.sldEditor && dialog[0].id == $scope.sldEditor.id)
        $scope.sldEditorData.isClosed = true;
    });

    /**
     * ---------------------------
     * jsonEdition
     */

    $scope.jsonEditionOnChange = function () {
      // try {
      //   // get() thows an error if JSON is not valid
      //   $scope.JSONEditor.get();
      //   $scope.isJsonValid = true;
      // } catch {
      //   $scope.isJsonValid = false;
      // }
    };

    $scope.isJsonValid = true;
    $scope.jsonEdition = {
      data: {},
      options: {
        onChange: $scope.jsonEditionOnChange,
        mode: 'code'
      }
    };

    $scope.openFeatureTypeEditionJson = function () {
      $scope.jsonEdition.data = angular.copy($scope.edit_resource);
      ngDialog.open({
        template:
          'js/XG/modules/model/views/modals/modal.edition_json.html',
        className: 'ngdialog-theme-plain large',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.jsonEditionChangeMode = function () {
      $scope.jsonEdition.options.mode
        = ($scope.jsonEdition.options.mode === 'code') ? 'tree' : 'code';
    };

    $scope.editFeatureTypeJSON = function () {
      if ($scope.jsonEdition.data != {}) {
        gaDomUtils.showGlobalLoader();
        FeatureTypeFactory.update($scope.jsonEdition.data).then((res) => {
          if (res.data) {
            require('toastr').success(
              $filter('translate')('model.featuretypes.editionjson_ok')
            );
            gaDomUtils.hideGlobalLoader();
            ngDialog.close();
          }
        }, (error) => {
          require('toastr').error(
            $filter('translate')('model.featuretypes.editionjson_nok')
          );
          console.log(error);
          gaDomUtils.hideGlobalLoader();
        });
      }
    };
    // -------------------------

    /**
     *  showData
     */
    $scope.showData = function() {
      FeatureTypeFactory.isfeatureindatabase($scope.edit_resource.uid).then((res)=>{
        if(res && res.data){
          $scope.dataTableFeaturesCrud = {
            remove: true,
          };
          ngDialog.open({
            template:
              'js/XG/modules/model/views/modals/modal.featuretypes.data.html',
            className: 'ngdialog-theme-plain large',
            closeByDocument: false,
            scope: $scope,
          });
        }
        else{
          require('toastr').error($filter('translate')('model.featuretypes.featureNotInBd'));
        }
      },() =>{
        require('toastr').error($filter('translate')('model.featuretypes.featureNotInBd'));
      });
    };

    /**
     * Open the importFeatureTypesModal
     */
    $scope.importFeatureTypesModal = function() {
      $scope.importData = {};
      $scope.importFilter = {};

      ngDialog.open({
        template:
          'js/XG/modules/model/views/modals/modal.featuretypes.import.html',
        className: 'ngdialog-theme-plain width600',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     * verifyFeatures
     */
    $scope.verifyFeatures = function() {
      gaDomUtils.showGlobalLoader();
      FeatureTypeFactory.verify().then(
        function() {
          FeatureTypeFactory.get().then(function() {
            gaDomUtils.hideGlobalLoader();
            require('toastr').success(
              $filter('translate')('model.featuretypes.verification_ok')
            );
            loadFeatureTypes();
          });
        },
        function() {
          require('toastr').error(
            $filter('translate')('model.featuretypes.verification_nok')
          );
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    /**
     * publishall
     */
    $scope.publishAll= function(){
      $scope.publishComponents(true);
    };
    /**
     * republish
     */
    $scope.republish= function(){
      $scope.publishComponents(false);
    };

    /**
     * publishAll and republish
     */
    $scope.publishComponents = function(publishAll) {
      gaDomUtils.showGlobalLoader();
      FeatureTypeFactory.publishComponents(publishAll).then(
        function() {
          require('toastr').success(
            $filter('translate')('model.featuretypes.publish_ok')
          );
          gaDomUtils.hideGlobalLoader();
          loadFeatureTypes();
        },
        function() {
          require('toastr').error(
            $filter('translate')('model.featuretypes.publish_nok')
          );
          gaDomUtils.hideGlobalLoader();
          loadFeatureTypes();
        }
      );
    };

    /**
     * publishall
     */
    $scope.indexall = function() {
      var ans = confirm(
        $filter('translate')('model.featuretypes.index_all_period')
      );
      if (ans) {
        gaDomUtils.showGlobalLoader();
        ElasticFactory.indexall().then(
          function() {
            require('toastr').info(
              $filter('translate')('model.featuretypes.index_encours')
            );
            gaDomUtils.hideGlobalLoader();
          },
          function() {
            require('toastr').error(
              $filter('translate')('model.featuretypes.index_nok')
            );
            gaDomUtils.hideGlobalLoader();
          }
        );
      }
    };

    /**
     * index all elements
     */
    $scope.checkall = { v: false };
    $scope.checkAllImportFeaturetypes = function() {
      $scope.importData.features.forEach(function(ft) {
        if (ft.imported == false) {
          if (
            !$scope.importFilter.val ||
            ft.name.indexOf($scope.importFilter.val) != -1
          ) {
            $scope.featuresToImport[ft.name] = !$scope.checkall.v;
          }
        }
      });
    };

    /**
     * Open the dataDictionary
     */
    $scope.dataDictionary = function() {
      ngDialog.open({
        template:
            'js/XG/modules/model/views/modals/modal.featuretypes.dataDictionary.html',
        className: 'ngdialog-theme-plain width800',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     * Open the importShapeFeatureTypesModal
     */
    $scope.importShapeFeatureTypesModal = function() {
      ngDialog.open({
        template:
          'js/XG/modules/model/views/modals/modal.featuretypes.import_shape.html',
        className: 'ngdialog-theme-plain width800',
        closeByDocument: false,
        scope: $scope,
      });
    };

    /**
     * List all the tables available for import from the selected datastore
     * @param importDataStore
     */
    $scope.getDatastoreTablesListForImport = function() {
      if (!angular.isDefined($scope.importData.store)) {
        $scope.importData.features = false;
        return;
      }

      DataStoreFactory.tablesget($scope.importData.store.name).then(function(
        res
      ) {
        $scope.importData.features = res.data;
        // compare with the already loaded featuretypes
        // and add a imported flags
        $scope.importData.features.forEach(function(name, index) {
          // already loaded (only if same datastore)
          console.log($scope.importData.store.name);

          var idx = $scope.currentResources
            .filter(function() {
              return 1;
              // @RB vu avec FRT
              // on n'applique pas cette correction car on n'est pas sur
              // que des composants ayant le meme nom
              // meme is issus de bases différentes ne posent pas de pb
              // return x.storeName == $scope.importData.store.name;
            })
            .map(function(x) {
              return x.name;
            })
            .indexOf(name);

          $scope.importData.features[index] = {
            name: name,
            imported: idx >= 0,
          };
        });
        $scope.featuresToImport = {};
      });
    };
    $scope.$watch(
      'featuresToImport',
      function(fi) {
        if (!angular.isDefined(fi)) return;
        var allowFtImport = 0;
        for (var i in fi) {
          if (fi[i] == true) allowFtImport += 1;
        }
        $scope.allowFtImport = allowFtImport;
      },
      1
    );

    /**
     * import checked FeatureTypes
     */

    $scope.importFeatureTypesSubmit = function() {
      var toImport = [];
      $scope.importData.features.forEach(function(ft, index) {
        if (
          Object.prototype.hasOwnProperty.call($scope.featuresToImport, ft.name) &&
          $scope.featuresToImport[ft.name] == true
        ) {
          toImport.push({
            name: ft.name,
            index: index,
          });
        }
      });

      $scope.geomTypeAndSridSelected = function() {
        gaDomUtils.showGlobalLoader();
        ngDialog.close($scope.selectGeomTypeAndSrid.id);
        $scope.checkFtiDefer.resolve($scope.newFeatureTypeInfo);
      };
      $scope.geomTypeAndSridCanceled = function() {
        ngDialog.close($scope.selectGeomTypeAndSrid.id);
        // destroys the property
        delete $scope.featuresToImport[$scope.componentImportFt.name];
        $scope.importData.features[
          $scope.componentImportFt.index
        ].imported = false;

        gaDomUtils.setGlobalLoaderScaleValue($scope.componentImportIndex + 1);
        importFeature($scope.componentImportIndex + 1);

        if ($scope.componentImportIsLast) {
          gaDomUtils.hideGlobalLoader();
        }
      };

      function checkFti(newFeatureTypeInfo) {
        $scope.checkFtiDefer = $q.defer();

        $scope.haveToSelect = '';
        if (newFeatureTypeInfo.typeInfo == 'GEOMETRY') {
          $scope.haveToSelect = '_geometry_';
        }
        if (newFeatureTypeInfo.srid == 'NONE') {
          newFeatureTypeInfo.srid = 'EPSG:';
          $scope.haveToSelect += '_srid_';
        }
        if ($scope.haveToSelect == '') {
          $scope.checkFtiDefer.resolve(newFeatureTypeInfo);
        }
        else {
          gaDomUtils.hideGlobalLoader();
          if ($scope.pointLabel == undefined) {
            $scope.pointLabel = $filter('translate')(
              'model.featuretypes.types.point'
            );
            $scope.lineLabel = $filter('translate')(
              'model.featuretypes.types.line'
            );
            $scope.polygonLabel = $filter('translate')(
              'model.featuretypes.types.polygon'
            );
            $scope.tableLabel = $filter('translate')(
              'model.featuretypes.types.ng'
            );
          }
          $scope.srids = SridFactory.sridsList;
          $scope.newFeatureTypeInfo = newFeatureTypeInfo;
          $scope.selectGeomTypeAndSrid = ngDialog.open({
            template:
              'js/XG/modules/model/views/dialog/selectGeomTypeAndSrid.html',
            className: 'ngdialog-theme-plain width800',
            closeByDocument: false,
            scope: $scope,
            showClose: false,
          });
        }

        return $scope.checkFtiDefer.promise;
      }

      function addFeatureTypeInfo(fti, index, ft) {
        FeatureTypeFactory.add(fti).then(function(res) {
          if (res.data && res.data.uid) {
            FeatureTypeFactory.postupdate(res.data.uid).then(function() {
              // destroys the property
              delete $scope.featuresToImport[ft.name];
              $scope.importData.features[ft.index].imported = true;

              gaDomUtils.setGlobalLoaderScaleValue(index + 1);
              importFeature(index + 1);

              if ($scope.componentImportIsLast) {
                gaDomUtils.hideGlobalLoader();
              }
            });
          }
        });
      }

      /**
       * Inner import function to be sure the import is asynchronous
       * @param index
       */
      let importFeature = (index) => {
        if (index < toImport.length) {
          var ft = toImport[index];
          DataStoreFactory.tablesgetfinfo(
            $scope.importData.store.name,
            ft.name
          ).then((res) => {
            // create the new featuretypeinfo
            let newFeatureTypeInfo = res.data;
            $scope.componentImportIsLast = index == toImport.length - 1;
            // Si la couche n'a pas de géometrie ou bien de type esri,
            // on peut l'importer même si elle commence par un nombre
            if (newFeatureTypeInfo.type == 'esri' || !newFeatureTypeInfo.geographic
              || !/^[0-9]/.test(newFeatureTypeInfo.name)) {
              if(newFeatureTypeInfo.primaryKey || newFeatureTypeInfo.readOnly){
                $scope.componentImportFt = ft;
                $scope.componentImportIndex = index;
                checkFti(newFeatureTypeInfo).then((fti) =>{
                  addFeatureTypeInfo(fti, index, ft);
                });
              } else {
                $scope.noPrimaryKey.push(newFeatureTypeInfo.alias);
                $scope.featuresToImport[ft.name] = false;
                if($scope.componentImportIsLast){
                  $scope.noPrimaryKeyIsLast = true;
                }
              }
              if($scope.noPrimaryKey.length>0 && $scope.componentImportIsLast){
                if($scope.noPrimaryKeyIsLast){
                  gaDomUtils.hideGlobalLoader();
                }
                require('toastr').error(
                  $filter('translate')('model.featuretypes.noPrimaryKey')
                    + $scope.noPrimaryKey.join(', ')
                );
              }
            } else {
              require('toastr').error(
                $filter('translate')(
                  'model.featuretypes.importErrorMessage'
                )
              );
              gaDomUtils.hideGlobalLoader();
            }
          });
        }
      };

      if (toImport.length > 0) {
        gaDomUtils.showGlobalLoader();
        gaDomUtils.setGlobalLoaderScale(0, toImport.length);
        $scope.noPrimaryKey = [];
        importFeature(0);
      }
      else {
        alert(
          $filter('translate')('model.featuretypes.importData.none_selected')
        );
      }
    };

    /**
     * import data to FeatureTypes
     */
    $scope.importNewFeaturesRows = function() {
      ngDialog.open({
        template:
          'js/XG/modules/model/views/modals/modal.featuretypes.import_data.html',
        className: 'ngdialog-theme-plain',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $scope.reloadFeatureTypeData = function() {
      var myRandom = Math.floor(Math.random() * 1000);
      $scope.editresourcewhere = myRandom + '=' + myRandom;
    };

    $scope.tabs = [
      {
        title: 'common.general',
        content:
          'js/XG/modules/model/views/modals/modal.featuretypes_general.html',
      },
      {
        title: 'model.featuretypes.attributes.title',
        content:
          'js/XG/modules/model/views/modals/modal.featuretypes_attributes.html',
      },
      {
        title: 'common.relations',
        content:
          'js/XG/modules/model/views/modals/modal.featuretypes_relations.html',
      },
      {
        title: 'model.styles.title',
        content:
          'js/XG/modules/model/views/modals/modal.featuretypes_style.html',
      },
      {
        title: 'model.featuretypes.rules.title',
        content:
          'js/XG/modules/model/views/modals/modal.featuretypes_rules.html',
      },
      {
        title: 'model.featuretypes.miscellaneous.title',
        content:
          'js/XG/modules/model/views/modals/modal.featuretypes_miscellaneous.html',
      },
      {
        title: 'model.featuretypes.esri.title',
        content:
          'js/XG/modules/model/views/modals/modal.featuretypes_esri.html',
      },
      {
        title: 'model.featuretypes.actions.title',
        content:
          'js/XG/modules/model/views/modals/modal.featuretypes_actions.html',
      },
      {
        title: 'model.featuretypes.fid.title',
        content: 'js/XG/modules/model/views/modals/modal.featuretypes_fid.html',
      },
      {
        title: 'model.featuretypes.triggers.title',
        content:
          'js/XG/modules/model/views/modals/modal.featuretypes_triggers.html',
      }
    ];
    $scope.tabs.activeTab = 0;
    // KIS-3725: Suppression du '1' pour éviter un deep watch, ce qui
    // permet de ne surveiller que les changements de référence de `currentFeatureType`,
    // et n'affiche les numéros d'onglets que lorsque `currentFeatureType` change.
    $scope.$watch('currentFeatureType',
      (x) => {
        if (x) {
          addCountButton(null, x, 'currentFeatureType');
          // -- kis-3768 : si l'attribut est vide, on le supprime pour
          // -- que le sélecteur n'affiche pas une chaîne vide comme étant choisie.
          if (x.wfsConfig && x.wfsConfig.historicAttributeName===''){
            delete x.wfsConfig.historicAttributeName;
          }
        }
      });

    /**
     * Ajoute le compteur d'éléments dans le titre de certains onglets
     * @param {HTMLFormElement} form formulaire de la popup
     * @param {object} element composant ou attribut
     * @param {string} elementType 'currentFeatureType' ou 'currentFeatureTypeAttribute'
     */
    const addCountButton = (form, element, elementType) => {

      const mapCount = {
        'currentFeatureType': {
          1: 'attributes',
          2: 'relations',
          3: 'styles',
          4: 'rules',
          7: 'actions',
          9: 'triggers'
        },
        'currentFeatureTypeAttribute': {
          1: 'restrictions'
        }
      };

      // sous-méthode
      const addButton = (tabIndex, titleTabNodeList) => {
        const tab = element[mapCount[elementType][tabIndex]];
        if(tab){
          let count = tab.length;
          const nbclass = count > 0 ? 'primary' : 'default dimmed';
          const countElement
            = `<button type="button" class="label label-${nbclass}">${count}</button>`;
          const titleTab = Array.from(titleTabNodeList).find(
            aEl => aEl.innerText === $filter('translate')($scope.tabs[tabIndex].title));
          if (titleTab) {
            titleTab.insertAdjacentHTML('beforeend', countElement);
          }
        }
      };

      if (!form) {
        form = document.getElementById('ftiManagerForm');
      }
      const tabs = form.querySelector('.nav.nav-tabs');
      if (tabs) {
        const titleTabNodeList = tabs.querySelectorAll('a');
        if (titleTabNodeList) {
          for (const tabindex of Object.keys(mapCount[elementType])) {
            const index = Number.parseInt(tabindex);
            addButton(index, titleTabNodeList);
          }
        }
      } else {
        // attend que les onglets apparaissent
        $timeout(() => {
          addCountButton(form, element, elementType);
        });
      }
    };

    // Edit the number displayed beside the tab titles
    var tabNbHtml = function(nb) {
      var nbclass = nb > 0 ? 'primary' : 'default dimmed';
      return '<span class=\'label label-' + nbclass + '\'>' + nb + '</span>';
    };
    $scope.$watch(
      'currentFeatureType',
      function(x) {
        if (x) {
          $scope.tabs[1].nb = tabNbHtml(x.attributes.length);
          $scope.tabs[2].nb = tabNbHtml(x.relations.length);
          $scope.tabs[3].nb = tabNbHtml(x.styles.length);
          $scope.tabs[4].nb = tabNbHtml(x.rules.length);
          if (angular.isUndefined(x.actions)) x.actions = [];
          $scope.tabs[7].nb = tabNbHtml(x.actions.length);
        }
      },
      1
    );

    $scope.launchUpdateEsriFeature = () =>{
      swal(
        {
          title: 'Voulez vous récupérer les alias définis dans ArcGIS ?',
          type: 'info',
          showCancelButton: true,
          confirmButtonColor: '#DD6B55',
          confirmButtonText: $filter('translate')('common.yes'),
          cancelButtonText: $filter('translate')('common.no'),
          closeOnConfirm: true,
          closeOnCancel: true,
        },
        function (resetAliasFromArcGIS) {
          // resetAliasFromArcGIS est true quand l'utilisateur
          // a choisi de récupérer les alias ArcGIS
          $scope.updateEsriFeature(resetAliasFromArcGIS);
        }
      );
    };


    /**
     * update Esri Feature from datastore
     */
    $scope.updateEsriFeature = function(resetAliasFromArcgis) {
      var ans = confirm(
        $filter('translate')('model.featuretypes.esri.confirm')
      );
      if (ans) {
        gaDomUtils.showGlobalLoader();
        DataStoreFactory.tablesgetreloadedFinfo(
          $scope.currentFeatureType.storeName,
          $scope.currentFeatureType.name,
          $scope.edit_resource.uid,
          resetAliasFromArcgis
        ).then(function(res) {
          var svgUid = $scope.edit_resource.uid;
          $scope.edit_resource = angular.copy(res.data);
          $scope.edit_resource.uid = svgUid;

          FeatureTypeFactory.update($scope.edit_resource).then(
            function() {
              FeatureTypeFactory.postupdate($scope.edit_resource.uid).then(
                function() {
                  require('toastr').success(
                    $filter('translate')('model.featuretypes.esri.ok')
                  );
                  $scope.editFeatureTypeDialog.close();
                  gaDomUtils.hideGlobalLoader();
                }
              );
            },
            function() {
              require('toastr').error(
                $filter('translate')('model.featuretypes.esri.error')
              );
              gaDomUtils.hideGlobalLoader();
            }
          );
        },
        (error)=>{
          require('toastr').error(
            $filter('translate')('model.featuretypes.esri.error')
          );
          console.log(error);
          gaDomUtils.hideGlobalLoader();
        });
      }
    };

    // Edit Featuretype Attrbute Tabs
    $scope.attributeTabs = [
      {
        title: 'common.general',
        content:
          'js/XG/modules/model/views/modals/modal.featuretypes.attributes_general.html',
      },
      {
        title: 'model.featuretypes.attributes.restrictions.list',
        content:
          'js/XG/modules/model/views/modals/modal.featuretypes.attributes_restrictions.html',
      },
      {
        title: 'model.featuretypes.attributes.precisions.tab',
        content:
            'js/XG/modules/model/views/modals/modal.featuretypes.attributes_precisions.html',
      },
    ];
    $scope.attributeTabs.activeTab = 0;
    $scope.$watch('currentFeatureTypeAttribute', x => {
      if (x) {
        $scope.attributeTabs[1].nb = tabNbHtml(x.restrictions.length);
        if (!x.showHelpTooltip) {
          x.showHelpTooltip = false;
        }
        addCountButton(null, x, 'currentFeatureTypeAttribute');

        // Construction de la liste pour le paramètre updateField
        $scope.updateFieldAttributeList = $scope.currentFeatureType.attributes;
        // Filtre pour ne garder que les attributs possedant une restriction de table
        // et suppression de l'attribut en cours d'édition
        $scope.updateFieldAttributeList = $scope.updateFieldAttributeList
          .filter(attribute => (attribute.restrictions.some(
            restriction => restriction.type === 'Tables')
                                  && attribute.name !== x.name));
        // Ajout d'une valeur vide
        $scope.updateFieldAttributeList.unshift(
          {alias:  $filter('translate')('model.featuretypes.attributes.noAttribute'), name: ''});
      }
    },
    1
    );

    /***
     * dupliquer un composant
     */
    $scope.disableCopy = function() {
      var b = false;
      if (
        !$scope.selected_resource ||
        ($scope.selected_resource && $scope.selected_resource.type === 'esri')
      )
        b = true;
      return b;
    };
    $scope.specialCase = true;
    $scope.duplicateComponent = function() {
      $scope.isNewResource = true;
      $scope.edit_resource.name += '_copy';
      $scope.edit_resource.alias += ' copy';
      $scope.edit_resource.published = false;
      $scope.edit_resource.inElasticSearch = false;
      //KIS-3714:le trigger est propre à chaque composant et il ne doit pas être récupérer lors de la duplication d’un composant.
      $scope.edit_resource.triggers = [];
      delete $scope.edit_resource.uid;
      $scope.edit_modal(0, 0, true);
    };

    $scope.$watch('choosenAttributes', function(attributes) {
      if (angular.isArray(attributes)) {
        var tmp = {};
        attributes.forEach(function(attr) {
          tmp[attr] = true;
        });
        $scope.choosedAttributes = tmp;
      }
    });

    function parseFti(fti) {
      /* $filter('translate')('features.'+layer.name+'.alias').indexOf("features.") === -1 ?
                    $filter('translate')('features.'+layer.name+'.alias') :
                        layer.label*/
      var obj = {
        fti: fti,
        name: fti.name,
        alias: fti.alias,
        nameT:
          $filter('translate')('features.' + fti.name + '.alias').indexOf(
            'features.'
          ) === -1
            ? $filter('translate')('features.' + fti.name + '.alias')
            : fti.alias,
        attributes: fti.attributes,
        relations: [],
      };

      var relations = [];
      for (var i = 0; i < fti.relations.length; i++) {
        var relation = fti.relations[i];
        if (relation.type === 'REL_NM') {
          var ftirel = FeatureTypeFactory.getFeatureByUid(relation.idEnd);
          var rel = {
            attributes: ftirel.attributes,
            relname: relation.name,
            relalias: relation.alias,
            fti: ftirel,
            name: ftirel.name,
            alias:
              $filter('translate')(
                'features.' + ftirel.name + '.alias'
              ).indexOf('features.') === -1
                ? $filter('translate')('features.' + ftirel.name + '.alias')
                : ftirel.alias,
            relation: relation,
          };
          relations.push(rel);
        }
      }

      obj.relations = relations;
      return obj;
    }

    $scope.selectAllElements = function(ar) {
      ar.map(function(x) {
        x.selected = true;
      });
    };

    $scope.unselectAllElements = function(ar) {
      ar.map(function(x) {
        x.selected = false;
      });
    };

    var relsAttsChoose;
    $scope.chooseAttsRels = function() {
      $scope.atts = $scope.edit_resource.attributes;
      $scope.rels = $scope.edit_resource.relations;
      $scope.allAttributs = false;
      $scope.allRelations = false;
      $scope.formulaireObj = parseFti($scope.edit_resource);
      relsAttsChoose = ngDialog.open({
        template: 'js/XG/modules/model/views/attsRelsForm.html',
        className: 'ngdialog-theme-plain width600',
        closeByDocument: false,
        scope: $scope,
      });
    };

    var translateDirectValueFunc = function(v) {
      if (v) {
        return $filter('translate')(v);
      }
      else {
        return v;
      }
    };

    $scope.attrstotranslate = {
      groupe: translateDirectValueFunc,
      name: translateDirectValueFunc,
      type: translateDirectValueFunc,
      description: translateDirectValueFunc,
      solution: translateDirectValueFunc,
    };

    $scope.checkattributesconf = function() {
      FeatureTypeFactory.checkAttributes($scope.edit_resource.uid).then(
        function(res) {
          if (res.data) {
            if (res.data.totalFeatures === 0) {
              AlertHpoFactory.getSimpleSuccess(
                $filter('translate')(
                  'model.featuretypes.checkAttributes.verif'
                ) +
                  ' ' +
                  $scope.edit_resource.alias,
                $filter('translate')(
                  'model.featuretypes.checkAttributes.verifok'
                ),
                true,
                'success'
              );
            }
            else {
              $scope.geoj = res.data;
              $scope.attributestouseindatatable = FeatureTypeFactory.getCheckAttributesReponse();
              ngDialog.openConfirm({
                template:
                  'js/XG/modules/model/views/dialog/check_attributes_reponse.html',
                scope: $scope,
                className: 'ngdialog-theme-plain width1000 nopadding miniclose',
              });
            }
          }
          else {
            AlertHpoFactory.showErrorMessage(res);
          }
        },
        function(res) {
          AlertHpoFactory.showErrorMessage(res);
        }
      );
    };

    /*$scope.selectAllAtts= function(){
        $scope.allAttributs=true;
        for (var i = 0; i < $scope.atts.length; i++) {
        var item = $scope.atts[i];
        $scope.choosedAttributes[item.name] = true;
        }
     };
     $scope.unselectAllAtts= function(){
        $scope.allAttributs=false;
        for (var i = 0; i < $scope.atts.length; i++) {
        var item = $scope.atts[i];
        $scope.choosedAttributes[item.name] = false;
        }
     };

    $scope.selectAllRels= function(){
        $scope.allRelations=true;
        for (var i = 0; i < $scope.rels.length; i++) {
        var item = $scope.rels[i];
        $scope.choosedRelations[item.name] = true;
        }
     };
     $scope.unselectAllRels= function(){
        $scope.allRelations=false;
        for (var i = 0; i < $scope.rels.length; i++) {
        var item = $scope.rels[i];
        $scope.choosedRelations[item.name] = false;
        }

     };
     $scope.getAttsforRels= function(){
        $scope.relComponents =[];
        for(var i in $scope.rels){
             $scope.choosenRelations.forEach(function(rel){
                if(rel==$scope.rels[i].name) {
                    var uid = $scope.rels[i].idEnd
                    var component= FeatureTypeFactory.getFeatureByUid(uid);
                    $scope.relComponents.push(component);
                }
             });
        }
    }*/
    $scope.getFormMobile = function() {
      $scope.attsForm = [];
      $scope.formulaireObj.attributes.map(function(attr) {
        if (attr.selected) {
          var obj = angular.copy(attr);
          delete obj.selected;
          $scope.attsForm.push(obj);
        }
      });

      $scope.relAttributes = {};
      $scope.relsForm = [];
      $scope.formulaireObj.relations.map(function(relation) {
        if (relation.selected) {
          $scope.relsForm.push(relation.relation);
          var attrib = [];
          relation.attributes.map(function(attr) {
            if (attr.selected) {
              var obj = angular.copy(attr);
              delete obj.selected;
              attrib.push(obj);
            }
          });
          $scope.relAttributes[relation.relation.name] = attrib;
        }
      }); //if we want to add agent to form mobile //console.log($scope.formulaireObj)
      /* var user = $rootScope.xgos.user;
        var agentName = user.name ;
        if ($scope.formulaireObj.agent && $scope.formulaireObj.agent.name != undefined ){
            agentName = $scope.formulaireObj.agent.name;
        }*/ var id =
        $scope.edit_resource.uid;
      if (
        (!$scope.edit_resource.geographic && $scope.attsForm.length == 0) ||
        !$scope.formulaireObj.formname
      ) {
        require('toastr').error(
          $filter('translate')('model.featuretypes.chooseAtt')
        );
      }
      else {
        var sendata = {
          ID: id,
          ATTS: $scope.attsForm,
          RELS: $scope.relsForm,
          name: $scope.formulaireObj.formname,
          relattributes: $scope.relAttributes,
          //"agent":agentName
        };
        /// open page to choose attributs end relations
        gaDomUtils.showGlobalLoader();
        OdkFactory.getformmobile(sendata).then(
          function() {
            gaDomUtils.hideGlobalLoader();
            require('toastr').success(
              $filter('translate')('model.featuretypes.formok')
            );
          },
          function() {
            gaDomUtils.hideGlobalLoader();
            require('toastr').error('error');
          }
        );
        relsAttsChoose.close();
      }
    };
    $scope.disableGeonetwork = function() {
      var b = false;
      if (
        !$scope.selected_resource ||
        ($scope.selected_resource &&
          $scope.selected_resource.type === 'esri') ||
        $rootScope.xgos.portal.parameters.geonetwork == undefined ||
        !$rootScope.xgos.portal.parameters.geonetwork.active
      )
        b = true;
      return b;
    };
    $scope.getGeonetwork = function() {
      console.log($rootScope.xgos.portal.parameters.geonetwork.active);
      $scope.baseUrlGeonetWork =
        $rootScope.xgos.portal.parameters.geonetwork.url;
      $scope.codeGeonetworkPortal =
        $rootScope.xgos.portal.parameters.geonetwork.code;
      var getJSON = function(url, callback) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'json';
        xhr.onload = function() {
          var status = xhr.status;
          if (status == 200) {
            callback(null, xhr.response);
          }
          else {
            callback(status);
          }
        };
        xhr.send();
      };
      getJSON(
        $scope.baseUrlGeonetWork +
          'xml.search?title=' +
          $scope.edit_resource.name +
          '&_content_type=json',
        function(err, data) {
          if ($scope.baseUrlGeonetWork) {
            var uid = data.metadata['geonet:info'].uuid;
            window.open(
              $scope.baseUrlGeonetWork + 'catalog.search#/metadata/' + uid
            );
          }
          else {
            require('toastr').error('error');
          }
        }
      );
    };

    /**
     * Lance la synchronisation des index (et uniquement les index)
     * entre les composants KIS issus de mapservices et les couches
     * des mapservices
     * @see FeatureTypeFactory.updateEsriComponentIndexes
     */
    $scope.updateEsriComponentIndexes = () => {
      gaDomUtils.showGlobalLoader();
      FeatureTypeFactory.updateEsriComponentIndexes().then(
        res => {
          gaDomUtils.hideGlobalLoader();
          // Si un composant KIS issu d’Arcgis n’est pas retrouvé dans
          // le mapservice alors un message popup indique à l’utilisateur
          // tous les composants en erreur
          // L'alias et l'ogcid du composant en erreur sont contenus dans
          // les items de la liste d'erreur (errorList) du ItvRet renvoyé par le back
          if (res.data.errorList && res.data.errorList.length > 0) {
            $scope.esriIndexesWarnings = res.data.errorList;
            let avoidDuplicateToastr = false;
            ngDialog.open({
              template:
                    'js/XG/modules/model/views/modals/modal.featuretypes_esri.index.html',
              className: 'ngdialog-theme-plain width800 miniclose',
              closeByDocument: false,
              scope: $scope,
              preCloseCallback: () =>{
                if (!avoidDuplicateToastr){
                  require('toastr').info(
                    $filter('translate')('model.featuretypes.esri.index.info')
                    + $scope.esriIndexesWarnings.map(e => e.composant).join(', ')
                  );
                  avoidDuplicateToastr = true;
                }
              },
            });
          }
          else {
            require('toastr').success(
              $filter('translate')('model.featuretypes.esri.index.success')
            );
          }
        },
        () => {
          gaDomUtils.hideGlobalLoader();
          require('toastr').error(
            $filter('translate')('model.featuretypes.esri.index.error')
          );
        }
      );
    };

    /**
     * Ouvre le suivi des processus en arrière plan des mises à jour par un lien WFS externe
     */
    $scope.wfsMonitor = () => {
      if (!$scope.wfsPopup) {
        $scope.wfsPopup = extendedNgDialog.open({
          template: 'js/XG/modules/model/views/modals/modal.featuretypes.wfs.monitor.html',
          className: 'ngdialog-theme-plain miniclose wfsMonitor-container',
          closeByDocument: false,
          scope: $scope,
          draggable: true,
          resizable: true,
          minWidth: '500px',
          minimizeMaximize: true,
          title: $filter('translate')('model.featuretypes.wfsMonitor.title'),
          preCloseCallback: () => $scope.wfsPopup = null,
        });
      }
    };

    /**
     * Méthode gérant l'activation du bouton WFS d'action globale
     * @return {boolean} true si la table n'est pas chargée
     */
    $scope.disableWfsMonitor = () => {
      return !Array.isArray($scope.currentResources) || $scope.currentResources.length === 0;
    };

    /**
     * @ngdoc property
     * @name $scope.editListCfg
     * @propertyOf modules.model.controller:FeatureTypeCtrl
     * @description
     * editListCfg for the editList directive of features
     */
    $scope.editListCfg = {
      dataModule: 'model',
      resource_type: 'featuretypes',
      cols: specialHpoUID
        ? ['typeInfo', 'name', 'alias', 'published', 'geographic']
        : [
          'typeInfo',
          'name',
          'alias',
          'storeName',
          'published',
          'geographic',
          'uid',
        ],
      defaultSort: 'name',
      colsFunction: {
        typeInfo: 'layerTypeToIcon',
        published: 'booleanToCheck',
        geographic: 'booleanToCheck',
      },
      defautValues: [
        { k: 'typeInfo', v: 'NG' },
        { k: 'primaryKey', v: 'fid' },
        { k: 'attributes', v: [] },
        { k: 'relations', v: [] },
        { k: 'styles', v: [] },
        { k: 'rules', v: [] },
        { k: 'bbox', v: [0, 1, 1, 0] },
        { k: 'sharedWithArcGIS', v: false }
      ],
      removeTemplate:
        'js/XG/modules/model/views/modals/modal.featuretypes.remove.html',
      extraGlobalActions: [
        // disableWfsMonitor inséré ici
        // importShapeFeatureTypesModal inséré ici (cf. insertExtrawithDataSourceCondition)
        {
          icon: '<i class=\'fa fa-cloud-download\'></i>',
          label: 'model.featuretypes.import.title',
          fn: $scope.importFeatureTypesModal,
        },
        {
          label: 'model.featuretypes.dataDictionary.title',
          fn: $scope.dataDictionary,
        },
        // updateEsriComponentIndexes inséré ici (cf. insertExtrawithDataSourceCondition)
        // publishAll inséré ici (cf. insertExtrawithDataSourceCondition)
        // verifyFeatures inséré ici (cf. insertExtrawithDataSourceCondition)
        // republish inséré ici (cf. insertExtrawithDataSourceCondition)
        {
          icon: '<i class=\'fa fa-files-o\'></i>',
          label: 'model.featuretypes.import.copy',
          fn: $scope.duplicateComponent,
          disablefn: $scope.disableCopy,
        },
        {
          icon: '<i class=\'fa fa-mobile\'></i>',
          label: 'model.featuretypes.formmobile',
          fn: $scope.chooseAttsRels,
          disablefn: $scope.disableCopy,
        },
        {
          icon: '<i class=\'glyphicon glyphicon-certificate\'></i>',
          label: 'portals.geonetwork.title',
          fn: $scope.getGeonetwork,
          disablefn: $scope.disableGeonetwork,
        },
        {
          label: 'model.featuretypes.checkattributesconf',
          fn: $scope.checkattributesconf,
          disablefn: $scope.disableCopy,
        },
      ],
      extraActions: [
        {
          icon: '<i class=\'fa fa-list\'></i>',
          label: 'common.featuretypes.list',
          fn: $scope.showData,
        },
        {
          icon: '<i class=\'fa fa-map\'></i>',
          label: 'common.featuretypes.view',
          fn: $scope.showMap,
          disableCondition: 'published',
        },
        {
          icon: '<i class=\'fa fa-refresh\'></i>',
          label: 'common.featuretypes.unpublish',
          fn: $scope.mapping,
          disableFn: function(x) {
            return x.type === 'esri';
          },
        },
        {
          icon: '<i class=\'fa fa-google-wallet\'></i>',
          label: 'common.featuretypes.publish',
          fn: $scope.publishFeatureType,
          disableCondition: 'geographic',
          hideFn: function(x) {
            return x.type == 'esri';
          },
        },
        {
          icon: '<i class=\'fa fa-cloud-download\'></i>',
          label: 'common.featuretypes.getattachement',
          fn: $scope.downloadAttachement,
        },
      ],
      warning: 'featuresWarning',
      width: 'width1100',
      allowMultipleSelection: {
        uniqueKey: 'uid',
        deleteTemplate:
          'js/XG/modules/model/views/modals/modal.featuretypes.remove.multiple.html',
      },
    };

    const insertExtrawithDataSourceCondition = () => {
      const labelsrc = $rootScope.xgos && $rootScope.xgos.currentTheme === 'dark'
        ? 'img/common/layers-32_dark.png' : 'img/common/layers-32.png';

      // le rang du bouton du dictionnaire sert de base
      const dicoBtnIndex = () => $scope.editListCfg.extraGlobalActions.findIndex(
        ea => ea.fn === $scope.dataDictionary);

      const isWfsBtnExists = $scope.editListCfg.extraGlobalActions.some(
        ea => ea.fn === $scope.wfsMonitor);
      $scope.editListCfg.extraGlobalActions.splice(0, isWfsBtnExists ? 1:0,
        {
          icon: '<i class="fa fa-cloud" aria-hidden="true"></i>'
          + '<i class="fa fa-long-arrow-right" aria-hidden="true"></i>'
          + '<i class="fa fa-database" aria-hidden="true"></i>',
          label: 'model.featuretypes.wfsMonitor.tooltip',
          fn: $scope.wfsMonitor,
          disablefn: $scope.disableWfsMonitor,
          hideFn: () => !$scope.hasPostGisDataStore
        });

      // l'import SHP est toujours au rang 1
      const isShpBtnExists = $scope.editListCfg.extraGlobalActions.some(
        ea => ea.fn === $scope.importShapeFeatureTypesModal);
      $scope.editListCfg.extraGlobalActions.splice(1, isShpBtnExists ? 1:0,
        {
          icon: '<i class="fa fa-shapes-solid"></i>',
          label: 'model.featuretypes.import_shape.title',
          fn: $scope.importShapeFeatureTypesModal,
          hideFn: () => {
            return !$scope.hasPostGisDataStore;
          }
        });

      // le bouton "Mise à jour index arcGIS" après le bouton du dictionnaire
      let esriBtnIndex = $scope.editListCfg.extraGlobalActions.findIndex(
        ea => ea.fn === $scope.updateEsriComponentIndexes);
      const esriBtnExists = esriBtnIndex > -1;
      if (!esriBtnExists) {
        esriBtnIndex = dicoBtnIndex() + 1;
      }
      $scope.editListCfg.extraGlobalActions.splice(esriBtnIndex, esriBtnExists ? 1:0,
        {
          icon: `<img alt="ico" src="${labelsrc}" width="16" height="16"/>`,
          label: 'model.featuretypes.esri.index.title',
          fn: $scope.updateEsriComponentIndexes,
          hideFn: () => {
            return !$scope.hasEsriDataStore;
          }
        });

      // le bouton "Publier tout" après le bouton du dictionnaire ou "Mise à jour index arcGIS"
      let pubAllBtnIndex = $scope.editListCfg.extraGlobalActions.findIndex(
        ea => ea.fn === $scope.publishAll);
      const pubAllBtnExists = pubAllBtnIndex > -1;
      if (!pubAllBtnExists) {
        pubAllBtnIndex = dicoBtnIndex() + 2;
      }
      $scope.editListCfg.extraGlobalActions.splice(pubAllBtnIndex, pubAllBtnExists ? 1:0,
        {
          icon: '<i class=\'fa fa-google-wallet\'></i>',
          label: 'model.featuretypes.import.publishall',
          fn: $scope.publishAll,
          hideFn: () => {
            return !$scope.hasPostGisDataStore;
          }
        });
      // le bouton "Republier" après le bouton "Publier tout"
      let repubBtnIndex = $scope.editListCfg.extraGlobalActions.findIndex(
        ea => ea.fn === $scope.republish);
      const repubBtnExists = repubBtnIndex > -1;
      if (!repubBtnExists) {
        repubBtnIndex = dicoBtnIndex() + 3;
      }
      $scope.editListCfg.extraGlobalActions.splice(repubBtnIndex, repubBtnExists ? 1:0,
        {
          icon: '<i class=\'fa fa-kis-republish\'></i>',
          label: 'model.featuretypes.import.republish',
          fn: $scope.republish,
          hideFn: () => {
            return !$scope.hasPostGisDataStore;
          }
        });

      // le bouton "Dupliquer" après le bouton "Republier"
      let duplicBtnIndex = $scope.editListCfg.extraGlobalActions.findIndex(
        ea => ea.fn === $scope.verifyFeatures);
      const duplicBtnExists = duplicBtnIndex > -1;
      if (!duplicBtnExists) {
        duplicBtnIndex = dicoBtnIndex() + 4;
      }
      $scope.editListCfg.extraGlobalActions.splice(duplicBtnIndex, duplicBtnExists >= 0 ? 1:0,
        {
          icon: '<i class=\'fa fa-files-o\'></i>',
          label: 'model.featuretypes.import.copy',
          fn: $scope.duplicateComponent,
          disablefn: $scope.disableCopy,
          hidefn: () => {
            return !$scope.hasPostGisDataStore;
          }
        });

      // le bouton "Vérifier" après le bouton "Republier"
      let verifBtnIndex = $scope.editListCfg.extraGlobalActions.findIndex(
        ea => ea.fn === $scope.verifyFeatures);
      const verifBtnExists = verifBtnIndex > -1;
      if (!verifBtnExists) {
        verifBtnIndex = dicoBtnIndex() + 5;
      }
      $scope.editListCfg.extraGlobalActions.splice(verifBtnIndex, verifBtnExists >= 0 ? 1:0,
        {
          icon: '<i class=\'glyphicon glyphicon-check\'></i>',
          label: 'model.featuretypes.import.verify',
          fn: $scope.verifyFeatures,
          hideFn: () => {
            return !$scope.hasPostGisDataStore;
          }
        });
    };

    $scope.$watch('xgos.portal', () =>{
      if($rootScope.xgos && $rootScope.xgos.portal){
        const portalId = $rootScope.xgos.portal.uid;
        DataStoreFactory.oneEsriDatasourceExists(portalId).then(
          res => {
            $scope.hasEsriDataStore = res;
            const postGisTypes = ['postgis', 'safepostgis'];
            $scope.hasPostGisDataStore = DataStoreFactory.resources.datastores.some(
              ds=> postGisTypes.includes(ds.type));
            insertExtrawithDataSourceCondition();
          },
          () => {
            $scope.hasEsriDataStore = false;
            $scope.hasPostGisDataStore = false;
            insertExtrawithDataSourceCondition();
          }
        );

        if($scope.editListCfg.extraActions.findIndex(
          ea => ea.fn === $scope.openFeatureTypeEditionJson)==-1
            && ($rootScope.xgos.isroot || $rootScope.xgos.isSuperAdmin)) {
          //add json edition at the beginning of the array
          $scope.editListCfg.extraActions.unshift({
            icon: '<i class=\'fa fa-code\'></i>',
            label: 'common.featuretypes.editionjson',
            fn: $scope.openFeatureTypeEditionJson,
          });
        }
      }
      else{
        $scope.hasEsriDataStore = false;
        $scope.hasPostGisDataStore = false;
        insertExtrawithDataSourceCondition();
      }
    });

    var dereg = $scope.$watch('xgos.portal.parameters', function(params) {
      if (angular.isDefined(params)) {
        $scope.inElasticSearch = $rootScope.xgos.portal.parameters.inElastic;
        if ($scope.inElasticSearch) {
          $scope.editListCfg.cols.splice(
            $scope.editListCfg.cols.length - 1,
            0,
            'inElasticSearch'
          );
          $scope.editListCfg.colsFunction.inElasticSearch = 'booleanToCheck';
          $scope.editListCfg.extraActions.push({
            icon: '<i class=\'fa fa-italic\'></i>',
            label: 'common.featuretypes.index',
            fn: $scope.indexFeatureType,
            disableCondition: 'indexEnCours',
            // @RB TMP MAKE IT Configurable somewhere
            hideFn: function(x) {
              // ajout kis_anc_ef
              return (
                ~[
                  'kis_anc_dossier',
                  'kis_anc_dossier_controle',
                  'kis_anc_dossier_filiere',
                  'kis_anc_dossier_filiere_element',
                ].indexOf(x.name) || x.name.indexOf('kis_anc_ef_') == 0
              );
            },
          });
        }
        dereg();
      }
    });

    $scope.validForm = { name: 1 };
    $scope.validFields = {};

    $scope.validateName = function() {
      var actualName = $scope.edit_resource.name;

      $scope.$watch('edit_resource.name',(name) => {
        $timeout(() => {
          if (name &&
              $scope.oracleDatabasesNames.indexOf($scope.currentFeatureType.storeName) !== -1) {
            $scope.edit_resource.name = $scope.edit_resource.name.toUpperCase();
          }
          $scope.nameExists =$scope.currentResources.map((r) => {
            return r.name;
          }).indexOf(name) !== -1;
          if (!$scope.isNewResource && $scope.edit_resource.name === actualName){
            $scope.nameExists = false;
          }
          //Vérifie si le nom commence par un chiffre
          $scope.verifyStartWithNumber = /^[0-9]/.test($scope.edit_resource.name);
          $scope.validForm.name = !$scope.nameExists && $scope.validFields.name
            && !$scope.verifyStartWithNumber;
        });
      },1);
    };

    $scope.validAttributeForm = { name: 1 };
    $scope.validAttributeFields = {};

    $scope.fillAliasWithNameIfEmpty = function(obj) {
      if (obj.name && !obj.alias) {
        obj.alias = obj.name;
      }
    };
    $scope.validateAttributeName = function() {
      var actualName = $scope.currentFeatureTypeAttribute.name;
      $scope.$watch(
        'currentFeatureTypeAttribute.name',
        function(name) {
          $timeout(function() {
            // Les espaces et les caractères spéciaux ne sont pas autorisés. Ticket Jira KIS-2630
            if (!gaJsUtils.checkCustomRegex(name)){
              $scope.validAttributeFields.name = null;
            }
            if (
              name &&
              $scope.oracleDatabasesNames.indexOf(
                $scope.currentFeatureType.storeName
              ) !== -1
            ) {
              $scope.currentFeatureTypeAttribute.name
                = $scope.currentFeatureTypeAttribute.name.toUpperCase();
            }
            $scope.attributeNameExists =
              $scope.currentFeatureType.attributes
                .map(function(r) {
                  return r.name;
                })
                .indexOf(name) !== -1;
            if (
              !$scope.isNewFeatureTypeAttribute &&
              $scope.currentFeatureTypeAttribute.name === actualName
            )
              $scope.attributeNameExists = false;
            $scope.validAttributeForm.name =
              !$scope.attributeNameExists && $scope.validAttributeFields.name;
          });
        },
        1
      );
    };


    /////////////////////////////////////////////////////////////
    //
    // ESRI logic
    //
    ////////////////////////////////////////////////////////////
    // do not allow esri datastores for new featuretypes
    $scope.noEsriDataStoreForNewFeature = function(item) {
      return item.type !== 'ArcGis' || !$scope.isNewFeatureType;
    };


    /**
     * Détermine si un onglet spécifique doit être affiché pour le composant courant.
     *
     * Pour les composants ArcGIS, certains onglets liés aux styles et aux déclencheurs
     * ne sont pas affichés car ils sont gérés dans ArcGIS via le MXD ou non accessbles en direct.
     *
     * Pour les autres types de fonctionnalités :
     * - L'onglet Esri n'est pas affiché.
     * - L'onglet de style n'est pas affiché si le composant est une table de type 'NG'.
     * - L'onglet des déclencheurs n'est pas affiché si (la source n'est pas PostGIS)
     *   la table n'existe pas dans la base de données.
     *
     * @param {Object} tab - L'onglet à évaluer.
     * @returns {boolean} - VRAI si l'onglet doit être affiché, FAUX sinon.
     */
    $scope.showFeatureTypeTab = function(tab) {
      if ($scope.isEsriFeature) {
        //-- Les styles ArcGIS sont gérés côté ArcGIS dans le MXD
        //-- qui sert à publier le service.
        return !(tab.content.includes('featuretypes_style.html')
        || tab.content.includes('featuretypes_triggers.html'));
      }
      else {
        if (~tab.content.indexOf('featuretypes_esri.html')) return false;
        //-- Si le composant est une table, l'onglet style ne sert à rien.
        if (tab.content.includes('modal.featuretypes_style.html')
          && $scope.edit_resource.typeInfo == 'NG') {
          return false;
        }

        if(tab.content.includes('modal.featuretypes_triggers.html')
          && !$scope.isPostgisAndExistInDB){
          return false;
        }
      }
      return true;
    };

    // ///////////////////////////////////////////////////
    //
    // Onglet DIVERS
    //
    ////////////////////////////////////////////////////////////

    /**
     * Initialisation de la couche d'historique à partir de son uid issu des paramètres
     * du present featureType.
     * @param {type} layerName
     * @returns {scope.featureTypes|args.editObject.obj.initSourceLayer.selectedFti|@var;undefined}
     */
    $scope.initHistoricLayer = function() {
      //            if ($scope.currentFeatureType.parameters == undefined){
      //                $scope.currentFeatureType.parameters = {};
      //            }

      //var historicUid = $scope.currentFeatureType.parameters['historicFtiUid'];

      var historicUid = $scope.currentFeatureType['historicFtiUid'];

      //            $scope.currentFeatureType.parameters.test = {};
      //            $scope.currentFeatureType.parameters.test2 = "test2Value";
      //
      if (historicUid) {
        for (var i = 0; i < $scope.currentResources.length; i++) {
          if ($scope.currentResources[i].uid == historicUid) {
            $scope.temp = $scope.currentResources[i];
            break;
          }
        }
      }
      else {
        $scope.temp = undefined;
      }
      return;
    };

    /**
     * cleanFeatureTypeRelation
     * remove useless attributes when relation type is changed
     */
    $scope.cleanFeatureTypeRelation = function() {
      if ($scope.currentFeatureTypeRelationIndex == -1) return;

      var type = $scope.currentFeatureTypeRelation.type;

      // if type != REL_WS
      // delete 4 champs url htmlview attributeview link
      if (type != 'REL_WS') {
        delete $scope.currentFeatureTypeRelation.url;
        delete $scope.currentFeatureTypeRelation.htmlview;
        delete $scope.currentFeatureTypeRelation.attributeview;
        delete $scope.currentFeatureTypeRelation.link;
      }
      // if type !=  REL_SIMPLE
      // delete fieldStart et fieldEnd
      if (type != 'REL_SIMPLE') {
        delete $scope.currentFeatureTypeRelation.fieldStart;
        delete $scope.currentFeatureTypeRelation.fieldEnd;
      }

      if (type == saveCurrentFeatureTypeRelation.type) {
        $scope.currentFeatureTypeRelation = angular.copy(
          saveCurrentFeatureTypeRelation
        );
      }
    };

    $scope.$watch('currentFeatureTypeAttribute.size', function() {
      if (($scope.currentFeatureTypeAttribute) &&
        ($scope.currentFeatureTypeAttribute.type == 'java.lang.Double') &&
          ($scope.currentFeatureTypeAttribute.size > 10)) {
        $scope.currentFeatureTypeAttribute.size = 10;
      }
    });

    $scope.showAlertTypes = function(temp) {
      if (
        temp &&
        temp.uid &&
        $scope.currentFeatureType &&
        $scope.currentFeatureType.uid
      ) {
        var noattribute = [];
        var differenttypeattribute = [];
        if (noattribute.length > 0 || differenttypeattribute.length > 0) {
          var message = $filter('translate')('common.featuretypes.anomalies');
          if (noattribute.length > 0)
            message +=
              '<li>' +
              $filter('translate')(
                'common.featuretypes.anomaliesnoattributes'
              ) +
              noattribute.join(', ') +
              '</li>';
          if (differenttypeattribute.length > 0)
            message +=
              '<li>' +
              $filter('translate')(
                'common.featuretypes.anomaliesdifferentetype'
              ) +
              differenttypeattribute.join(', ') +
              '</li>';
          message += '</ul>';
          return message;
        }
        else {
          return undefined;
        }
      }
      else {
        return undefined;
      }
    };

    /**
     * Créé / met à jour la liste des datasources non-ArcGis transmise au composant gcshapeimport
     * pour l'import de shp dans un nouveau composant.
     * En effet, il ne doit pas être permis d'importer un shape dans un nouveau composant
     * dans le cadre d'une source ArcGis
     * @see gcshapeimport
     */
    $scope.$watch('dataStores', () => {
      $scope.notEsriDataStores = [];
      if ($scope.dataStores && $scope.dataStores.length > 0){
        $scope.notEsriDataStores = $scope.dataStores.filter(ds => ds.type !== 'ArcGis');
      }
    });

    $scope.$watch('edit_resource.useDifferentFID', (newVal, oldVal) => {
      if (oldVal && (!newVal || newVal === '')) {
        $scope.edit_resource.attributeFid = null;
      }
    });

    $scope.$watch('edit_resource.bboxselection',() => {
      if ($scope.edit_resource && $scope.edit_resource.bboxselection){
        const id = $scope.edit_resource.uid;
        const srid = $scope.edit_resource.srid;
        FeatureTypeFactory.getExtent(id,srid).then(
          res=>{
            $scope.edit_resource.bbox = res.data;
          },
          ()=>{
            require('toastr').error(
              $filter('translate')('model.featuretypes.bbox.bbox_nok')
            );
          }
        );
      }
    });

    $scope.saveChangedAttributeOrder = () => {
      /*      FeatureTypeFactory.update($scope.currentFeatureType).then(
          () => {
            const index = FeatureTypeFactory.resources.featuretypes.findIndex(
                ft => ft.uid === $scope.currentFeatureType.uid);
            if (index > -1){
              $scope.currentFeatureType = FeatureTypeFactory.resources.featuretypes[index];
            }
          },
          () => {
            require('toastr').error(
                $filter('translate')('model.featuretypes.update_nok')
            );
          });*/
    };

    /**
     * Au changement du type d'un nouvel attribut lors de l'édition d'un composant.<br>
     * KIS-3414: prévoir par défaut la valeur de précision = 2 dès qu’on choisit le type DOUBLE
     */
    $scope.initSizeOnAttrTypeChange = (newValue, oldValue) => {
      const stringTypes = ['java.lang.String', 'g2c.attachment', 'g2c.attachments'];
      const numTypes = ['java.lang.Double'];

      // un type d'attribut peut varier entre numérique<->texte uniquement à la création
      if ($scope.isNewFeatureTypeAttribute) {
        if (stringTypes.includes(newValue) && numTypes.includes(oldValue)) {
          $scope.currentFeatureTypeAttribute.size = 500;
        } else if (stringTypes.includes(oldValue) && numTypes.includes(newValue)) {
          $scope.currentFeatureTypeAttribute.size = 2;
        }
      }
    };


    /**
     * Vérifie que la source de données du composant courant
     * est de type PostGIS.
     *
     * @returns VRAI si le FTI courant (celui en cours d'édition)
     *          est un composant PostGIS, FAUX sinon.
     */
    $scope.ftiSourceIsPostGIS = () => {
      return DataStoreFactory.resources.datastores.filter(
        ds => ds.type === 'postgis'
          && ds.name === $scope.edit_resource.storeName).length > 0;
    };


    /**
     * @ngdoc method
     * @name $scope.getTextBooleanIntegerAttributes
     * @methodOf modules.model.controller:FeatureTypeCtrl
     * @description
     * Filtre les attributs du composant courant pour ne retourner que ceux
     * de type Texte, Booléen et Entier.
     * Utilisé pour la sélection des attributs dans la section d'historisation
     * des objets hors service.
     * @return {Array} Liste des attributs de type Texte, Booléen et Entier.
     */
    $scope.getTextBooleanIntegerAttributes = () => {
    // Types d'attributs à inclure
      const allowedTypes = [
        'java.lang.String',  // Texte
        'java.lang.Boolean', // Booléen
        'java.lang.Integer'  // Entier
      ];

      // Si aucun attribut n'est défini, retourner un tableau vide
      if (!$scope.edit_resource || !$scope.edit_resource.attributes) {
        return [];
      }

      // Filtrer les attributs par type
      return $scope.edit_resource.attributes.filter(attr => {
        return allowedTypes.includes(attr.type);
      });
    };
  };


  FeatureTypeCtrl.$inject = [
    '$scope',
    '$filter',
    'DataStoreFactory',
    'FeatureTypeFactory',
    'UnitFactory',
    'CalculFactory',
    'ngDialog',
    'StyleFactory',
    'gaDomUtils',
    'gaJsUtils',
    'SridFactory',
    'ElasticFactory',
    '$timeout',
    'ngProgressFactory',
    '$compile',
    '$interval',
    '$rootScope',
    'OdkFactory',
    'InitProvider',
    'AlertHpoFactory',
    '$q',
    'EditRulesFactory',
    'ApplicationFactory',
    'extendedNgDialog'
  ];
  return FeatureTypeCtrl;
});