'use strict';

define([
  'angular',
  'modules/root/services/RootFactory',
  'modules/root/controllers/LogsCtrl',
  'modules/root/controllers/ConfigurationCtrl',
], function(angular, RootFactory, LogsCtrl, ConfigurationCtrl) {
  // Module
  var mod = angular.module('rootdebug', []);

  // Services
  mod.factory('RootFactory', RootFactory);

  // Controllers
  mod.controller('LogsCtrl', LogsCtrl);
  mod.controller('ConfigurationCtrl', ConfigurationCtrl);

  // Configuration
  mod.config([
    '$routeProvider',
    function($routeProvider) {
      // Routes
      $routeProvider.when('/logs/', {
        controller: LogsCtrl,
        templateUrl: 'js/XG/modules/root/views/logs.html',
      });

      $routeProvider.when('/configuration/', {
        controller: ConfigurationCtrl,
        templateUrl: 'js/XG/modules/root/views/configuration.html',
      });
    },
  ]);

  return mod;
});
