'use strict';

/**
 * @ngdoc controller
 * @name modules.authentication.controller:MajicEdigeoCtrl
 * @description
 * The MajicEdigeoCtrl controller
 */
define(function() {
  var MajicEdigeoCtrl = function($scope, ngDialog, $filter, $timeout) {
    $scope.showTabContent = function(idContent) {
      var elt;

      elt = document.getElementById(idContent);
      if (elt != undefined) {
        if ($scope.curTab != undefined) $scope.curTab.style.display = 'none';
        elt.style.display = 'block';
        $scope.curTab = elt;
      }
    };

    $scope.showTab1 = function(event, tabId) {
      var idContent, reg;

      reg = new RegExp('tab_', 'g');
      idContent = event.currentTarget.id.replace(reg, 'tabContent_');
      $scope.showTabContent(idContent);
    };

    $scope.showTab = function(event, tabId) {
      $scope.selectedTabLbl = event.currentTarget.id;
      $timeout(function() {
        $scope.showTab1(event, tabId);
      }, 200);
    };

    $scope.setTabHeadersHeight = function() {
      var elt;
      elt = document.getElementById('tabHeaders_' + $scope.thisId);
      if (elt != undefined)
        elt.style.height = '' + (elt.offsetHeight - 1) + 'px';
    };

    $scope.init = function() {
      $scope.thisId = $scope.$id;

      $scope.tabs = [
        {
          title: 'tools.majicedigeo.edigeo.title',
          contentType: 'edigeo',
        },
        {
          title: 'tools.majicedigeo.majic.title',
          contentType: 'majic',
        },
      ];
      $scope.selectedTabLbl = 'tab_' + $scope.$id + '_' + 0;
      $timeout(function() {
        $scope.setTabHeadersHeight();
      }, 250);
      $timeout(function() {
        $scope.showTabContent('tabContent_' + $scope.$id + '_' + 0);
      }, 450);
    };

    $scope.init();
  };

  MajicEdigeoCtrl.$inject = ['$scope', 'ngDialog', '$filter', '$timeout'];
  return MajicEdigeoCtrl;
});
