'use strict';
define(function() {
  var TaskFactory = function($http) {
    var TaskFactory = {};
    var resources = { tasks: [] };
    /**
     * Class : TaskFactory
     * Factory WebServices
     */

    /**
     * Function: gettasks
     */
    function gettasks(fuid, fid) {
      var promise = $http.get(
        '/services/{portalid}/task/getTasks?f=json' +
          '&fuid=' +
          fuid +
          '&fid=' +
          fid
      );
      promise.then(function(res) {
        resources.tasks = res.data.features;
      });
      return promise;
    }
    /**
     * Function: addtask
     */
    function addtask(senddata) {
      var promise = $http.post(
        '/services/{portalid}/task/addTask?f=json',
        senddata
      );

      return promise;
    }

    /**
     * Function: updatetask
     */
    function updatetask(senddata) {
      var promise = $http.post(
        '/services/{portalid}/task/updateTask?f=json',
        senddata
      );

      return promise;
    }

    /**
     * Function: addeventtotask
     */
    function addeventtotask(senddata) {
      if (!angular.isArray(senddata)) senddata = [senddata];
      var promise = $http.post(
        '/services/{portalid}/task/addEventToTask?f=json',
        senddata
      );

      return promise;
    }

    /**
     * Function: gettaskevents
     */
    function gettaskevents(id_task) {
      var promise = $http.get(
        '/services/{portalid}/task/getTaskEvents?f=json' + '&id_task=' + id_task
      );

      return promise;
    }

    /**
     * Function: edittaskstatus
     */
    function updatetaskstatus(senddata) {
      var promise = $http.post(
        '/services/{portalid}/task/updateTaskStatus?f=json',
        senddata
      );

      return promise;
    }

    return {
      TaskFactory: TaskFactory,
      resources: resources,
      gettasks: gettasks,
      addtask: addtask,
      addeventtotask: addeventtotask,
      gettaskevents: gettaskevents,
      updatetaskstatus: updatetaskstatus,
      updatetask: updatetask,
    };
  };
  TaskFactory.$inject = ['$http'];
  return TaskFactory;
});
