'use strict';
define(function() {
  var ancEditDessinFiliere = function(gaJsUtils, $timeout, QueryFactory) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/directives/anc_edit_dessin_filiere.html',
      restrict: 'AE',
      scope: {
        modele: '=?',
        modeleName: '=?',
        editable: '=?',
        addGraticule: '=?', // display graticule
        zoomOnFeature: '=?', // zoomOnFeature
        addMeasureTool: '=?',
        noControls: '=?', // pas de controles
        noBasemap: '=?', // pas de basemap
      },
      link: function(scope, elt, attrs, ctrl) {
        if (angular.isDefined(scope.modeleName)) {
          // charge la geometrie depuis le modeleName
          updateModelFromModelName(scope.modeleName, null);
        }
        scope.guid = 'ancefmap_' + gaJsUtils.guid();

        var image = new ol.style.Circle({
          radius: 5,
          fill: null,
          stroke: new ol.style.Stroke({ color: 'red', width: 1 }),
        });

        var styles = {
          Point: new ol.style.Style({
            image: image,
          }),
          LineString: new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: '#444',
              width: 1,
            }),
          }),
          MultiLineString: new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: '#444',
              width: 1,
            }),
          }),
          MultiPoint: new ol.style.Style({
            image: image,
          }),
          MultiPolygon: new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: '#444',
              width: 1,
            }),
            fill: new ol.style.Fill({
              color: '#000',
            }),
          }),
          Polygon: new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: '#444',
              lineDash: [4],
              width: 3,
            }),
            fill: new ol.style.Fill({
              color: '#000',
            }),
          }),
          GeometryCollection: new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: '#444',
              width: 2,
            }),
            // fill: new ol.style.Fill({
            //     color: '#000'
            // }),
            image: new ol.style.Circle({
              radius: 10,
              fill: null,
              stroke: new ol.style.Stroke({
                color: '#444',
              }),
            }),
          }),
          Circle: new ol.style.Style({
            stroke: new ol.style.Stroke({
              color: '#444',
              width: 2,
            }),
            fill: new ol.style.Fill({
              color: '#000',
            }),
          }),
        };

        var styleFunction = function(feature) {
          //console.log('Apply style for ' + feature.getGeometry().getType());
          return styles[feature.getGeometry().getType()];
        };

        var map, vectorLayer, vectorSource;
        vectorSource = new ol.source.Vector({
          features: [],
        });
        vectorLayer = new ol.layer.Vector({
          source: vectorSource,
          style: styleFunction,
        });
        var mapCenter = [610520.907715, 5401686.848967];
        scope.loadMeasureTool = false;
        $timeout(function() {
          // avec ou sans fond de plan
          var baseLayers = scope.noBasemap
            ? [vectorLayer]
            : [
                new ol.layer.Tile({
                  source: new ol.source.OSM(),
                }),
                vectorLayer,
              ];

          map = new ol.Map({
            layers: baseLayers,
            target: scope.guid,
            view: new ol.View({
              center: mapCenter,
              zoom: 22,
              // minZoom: 19,
              // maxZoom: 23,
              projection: 'EPSG:3857',
            }),
            //interactions: [],
            ol3Logo: false,
          });

          // sans controles
          if (scope.noControls) {
            map.getControls().forEach(function(control) {
              map.removeControl(control);
            });
          }

          document.getElementById(scope.guid).data = map;
          scope.loadMeasureTool = true;

          var g;
          function setGraticule() {
            if (g) map.removeControl(g);
            g = new ol.control.Graticule({
              step: 1,
              stepCoord: 5,
              projection: 'EPSG:3857',
              graticule3857Kis: true,
              formatCoord: function(c, distance, axe) {
                if (axe == 'haut' || axe == 'droite') return '';

                // format
                var ret;
                distance = Math.abs(distance);
                if (distance == 0) {
                  ret = distance;
                } else if (distance < 10) {
                  ret = Math.round(distance * 10) / 10 + 'm';
                } else if (distance < 1000) {
                  ret = Math.round(distance) + 'm';
                } else {
                  ret = Math.round((distance / 1000) * 100) / 100 + 'km';
                }
                return ret;
              },
            });
            var style = new ol.style.Style();
            style.setStroke(new ol.style.Stroke({ color: '#bbb', width: 1 }));
            style.setText(
              new ol.style.Text({
                stroke: new ol.style.Stroke({
                  color: '#fff',
                  width: 1,
                }),
                fill: new ol.style.Fill({ color: '#222' }),
              })
            );
            g.setStyle(style);
            map.addControl(g);
          }
          if (scope.addGraticule) setGraticule(1);
        });

        // var   f =  (new ol.format.GeoJSON()).readFeature(mEf)

        // var extent = f.getGeometry().getExtent();
        // map.getView().fit(extent, map.getSize());

        // var fitMapExtent = function () {

        //     var ft = vectorSource.getFeatures()[0];
        //     var extent = ft.getGeometry().getExtent();
        //     map.getView().fit(extent, map.getSize());

        // }
        function getCenterOfExtent(Extent) {
          var X = Extent[0] + (Extent[2] - Extent[0]) / 2;
          var Y = Extent[1] + (Extent[3] - Extent[1]) / 2;
          return [X, Y];
        }

        var refreshDessin = function(x) {
          // clear features
          vectorSource.clear();

          // deplace la feature au centre de la carte
          var f = new ol.format.GeoJSON().readFeature(angular.copy(x));
          var featureCenter = getCenterOfExtent(f.getGeometry().getExtent());

          f.getGeometry().translate(
            mapCenter[0] - featureCenter[0],
            mapCenter[1] - featureCenter[1]
          );

          vectorSource.addFeature(f);
          if (angular.isDefined(map)) {
            map
              .getView()
              .setCenter(getCenterOfExtent(f.getGeometry().getExtent()));
            if (scope.zoomOnFeature) {
              map.getView().fit(f.getGeometry().getExtent(), map.getSize());
            }
          }

          //fitMapExtent();
        };

        function updateModelFromModelName(modeleName, doAfter) {
          if (angular.isDefined(modeleName)) {
            // get model from modelName
            QueryFactory.data(
              "kis_anc_bibliotheque_ef",
              "identifiant = '" + modeleName + "'"
            ).then(
              function (res) {
                scope.modele = res.data.features[0];
                if (doAfter != null) {
                  doAfter.apply();
                }
              },
              function () {
                console.error("error updateModelFromModelName. no model was found");
              }
            );
          }
        }

        /**
         * Changement de modele dans la liste
         */
        scope.$watch('modele', function(x) {
          if (angular.isDefined(x)) {
            $timeout(function() {
              refreshDessin(x);
            });
          }
        });

        scope.$watch('modeleName', function (modeleName) {
          if (angular.isDefined(modeleName)) {
            updateModelFromModelName(modeleName, () => {
              refreshDessin(scope.modele);
            });
          }
        });

        // redraw apres update d' un modele
        scope.$on('refreshCurrentDessinEf', function(event, data) {
          console.log(data);
          refreshDessin(data.modele);
        });

        /*****************
         * logic
         */
        scope.editorMode = false;

        var _interactions = [
          new ol.interaction.DragRotate(),
          new ol.interaction.DoubleClickZoom(),
          new ol.interaction.DragPan(),
          new ol.interaction.PinchRotate(),
          new ol.interaction.PinchZoom(),
          new ol.interaction.KeyboardPan(),
          new ol.interaction.KeyboardZoom(),
          new ol.interaction.MouseWheelZoom(),
          new ol.interaction.DragZoom(),
        ];

        scope.toggleEfEditor = function() {
          scope.editorMode = !scope.editorMode;
          if (scope.editorMode) {
            _interactions.map(function(x) {
              map.addInteraction(x);
            });
          } else {
            _interactions.map(function(x) {
              map.removeInteraction(x);
            });
          }
          $timeout(function() {
            map.updateSize();
            map.render();
            map.renderSync();
            //fitMapExtent();
          });
        };
      },
    };
  };

  ancEditDessinFiliere.$inject = ['gaJsUtils', '$timeout', 'QueryFactory'];
  return ancEditDessinFiliere;
});
