'use strict';
define(function() {
  var ancBacBureauPicker = function(
    BacAppFactory,
    AncAppFactory,
    gaDomUtils,
    ngDialog,
    FeatureTypeFactory,
    EditFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_bureau_picker.html',
      restrict: 'EA',
      scope: {
        apptype: '=?',
        cdata: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;
        scope.entreprisesCfg = CurrentAppFactory.appCfg.main.entreprisesCfg;

        scope.labelToShow = "Bureau d'études";
        scope.listeEnterpriseModalTitle = "Bureau d'études";
        scope.enterpriseModalTitle = "Ajouter bureau d'études";
        scope.bureauEtudeId = 5;
        let pickBureauModal = null;
        let addBureauModal = null;

        scope.expanded = false;
        scope.toggleDisplay = function() {
          scope.expanded = !scope.expanded;
          scope.$emit('toggleDisplayBureau', scope.expanded);
        };

        // LISTE ENTREPRISE
        scope.entreprisesFti = FeatureTypeFactory.getFeatureByNameAndDatastore(
          CurrentAppFactory.appCfg.main.datastore,
          'kis_anc_entreprise'
        );

        scope.getInfosEntreprise = function() {
          var bureau = scope.selected.entreprise[0];

          let type = 'bureau';
          scope.cdata.general[type] = Object.assign({}, bureau.properties);

          if (angular.isDefined(pickBureauModal)) {
            pickBureauModal.close();
          }
        };

        scope.openSearchBureauModal = function() {
          if (typeof userAndroid !== 'undefined') {
            scope.selectEntrepriseFilter =
              "actif = 'true' AND nom <> '' AND nom IS NOT NULL AND type ILIKE '%" +
              scope.bureauEtudeId +
              "%' ";
          } else {
            scope.selectEntrepriseFilter =
              "actif = true AND nom <> '' AND nom IS NOT NULL AND type ILIKE '%" +
              scope.bureauEtudeId +
              "%' ";
          }

          scope.selected = { entreprise: [] };
          pickBureauModal = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/controle/modals/modal.pick.entreprise.html',
            className: 'ngdialog-theme-plain width600 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.openAddBureauModal = function() {
          scope.currentEntreprise = {
            properties: {
              type: scope.bureauEtudeId,
              actif: true,
            },
          };
          scope.forceType = true;
          scope.forceActif = true;

          addBureauModal = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.entreprise.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.saveEntreprise = function() {
          var featureCollection = {
            type: 'FeatureCollection',
            features: [],
          };

          featureCollection.features.push({
            type: 'Feature',
            properties: scope.currentEntreprise.properties,
          });
          EditFactory.add(scope.entreprisesFti.uid, featureCollection).then(
            function(res) {
              require('toastr').success('Enregistré');
              addBureauModal.close();
            }
          );
          scope.cdata.general.bureau = scope.currentEntreprise.properties;
        };

        scope.unlinkBureau = function() {
          delete scope.cdata.general.bureau;
        };

        scope.bureauNotSet = function() {
          return !scope.cdata.general.bureau;
        };
      },
    };
  };

  ancBacBureauPicker.$inject = [
    'BacAppFactory',
    'AncAppFactory',
    'gaDomUtils',
    'ngDialog',
    'FeatureTypeFactory',
    'EditFactory',
  ];

  return ancBacBureauPicker;
});
