'use strict';
define(function() {
  var ancBacDossierConfiguration = function(
    BacAppFactory,
    AncAppFactory,
    DocumentFactory,
    ConfigFactory,
    gaDomUtils,
    ngDialog,
    $rootScope,
    $window,
    gaJsUtils,
    ancBacTools, PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_dossier_configuration.html',
      restrict: 'EA',
      scope: {
        apptype: '=',
        dossiersCfg: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.xgos = $rootScope.xgos;

        var CurrentAppFactory =
          scope.apptype == 'bac' ? BacAppFactory : AncAppFactory;
        /*
                 Dossier Doc Cfg
                 */
        var loadConfig = function() {
          scope.dossiersCfg = angular.copy(
            CurrentAppFactory.appCfg.main.dossierCfg
          );
          ConfigFactory.checkTemplates(scope.dossiersCfg.templates).then(
            function(res) {
              scope.dossiersCfg.templates = res.data;
            }
          );
        };

        loadConfig();

        scope.$on('checkIfDirtyDossierCfg', function() {
          scope.enregistrerDossierCfg(true);
        });

        if (!scope.dossiersCfg) {
          scope.dossiersCfg = {};
        }

        scope.goToGestionModeles = function() {
          $window.open('#/documents/');
        };

        scope.moveNumerotationpart = function(direction, index) {
          if (
            (index == 0 && direction == 'up') ||
            (index == scope.dossiersCfg.numerotation.parts.length - 1 &&
              direction == 'down')
          )
            return false;
          var newIndex = direction == 'up' ? index - 1 : index + 1;
          scope.dossiersCfg.numerotation.parts.splice(
            index,
            0,
            scope.dossiersCfg.numerotation.parts.splice(newIndex, 1)[0]
          );
        };

        scope.removePartFromNumerotationCfg = function(index) {
          scope.dossiersCfg.numerotation.parts.splice(index, 1);
        };

        scope.partsPreview = '';

        scope.addNumerotationPart = function() {
          scope.dossiersCfg.numerotation.parts.push({
            key: 'string',
            format: '',
          });
        };

        scope.$watch(
          'dossiersCfg.numerotation',
          function(num) {
            if (angular.isDefined(num.parts)) {
              scope.partsPreview = CurrentAppFactory.getNumeroAuto(1, num);
            }
          },
          1
        );

        scope.possibleNumerotationParts = [
          {
            key: 'date',
            label: 'Date',
          },
          {
            key: 'index',
            label: 'index automatique',
          },
          {
            key: 'string',
            label: 'Chaine de caractère',
          },
        ];

        scope.enregistrerDossierCfg = function(checkDirty) {
          if (angular.isDefined(checkDirty) && checkDirty) {
            if (
              !angular.equals(
                scope.dossiersCfg,
                CurrentAppFactory.appCfg.main.dossierCfg
              )
            )
              var ans = confirm(
                'Des données ne sont pas sauvegardées. Voulez-vous les enregistrer ?'
              );
          }

          if (angular.isUndefined(checkDirty) || (checkDirty && ans)) {
            CurrentAppFactory.appCfg.main.dossierCfg = scope.dossiersCfg;
            CurrentAppFactory.updateAppCfg().then(function() {});
          } else if (checkDirty && !ans) {
            loadConfig();
          }
        };

        /*
                 GET LIST FILES
                 */
        scope.refreshTemplatesList = function(loader) {
          if (loader) gaDomUtils.showGlobalLoader();
          DocumentFactory.getlisttemplate().then(function(res) {
            scope.listTemplates = res.data;
            if (loader) gaDomUtils.hideGlobalLoader();
          });
        };
        scope.refreshTemplatesList(0);

        var dossierDocumentationDialog;
        scope.ouvrirDossierDialog = function() {
          dossierDocumentationDialog = ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.dossierDocDialog.html',
            className: 'ngdialog-theme-plain width800 miniclose nopadding',
            closeByDocument: false,
            scope: scope,
          });
        };

        //add
        scope.ajouterNouveauDossierDoc = function(nouveauDossierDoc) {
          scope.dossiersCfg.templates.push(nouveauDossierDoc);
          dossierDocumentationDialog.close();
        };
        //remove
        scope.supprimerDossierDoc = function(index) {
          var r = confirm('Êtes-vous sûr de vouloir supprimer ce document ?');
          if (r == true) {
            scope.dossiersCfg.templates.splice(index, 1);
          }
        };

        /**
         * docfeeder
         * prefill docfeeder data so it can be displayed
         * @param type
         * @param mode
         */
        scope.docfeeder = function(type, mode) {
          var label_dossier_feeder = 'Dossiers ANC';
          var label_autre_feeder = 'Autres données ANC';

          var kisfeeder = {
            branches: [],
            mode: mode,
            appname: CurrentAppFactory.appCfg.appname,
          };

          if (scope.apptype == 'bac') {
            label_dossier_feeder = 'Dossiers BAC';
            label_autre_feeder = 'Autres données BAC';
          }

          if (type == 'dossier') {
            kisfeeder.branches.push({
              label: label_dossier_feeder,
              jsonurl: scope.apptype + '/dossiers.json',
              extraFields: ancBacTools.getDossierExtraFields(
                CurrentAppFactory.appCfg.main.datastore,
                scope.apptype
              ),
            });
          }

          if (mode == 'feeder') {
            kisfeeder.branches.push({
              label: label_autre_feeder,
              jsonurl: scope.apptype + '/general_dossier.json',
            });
          }

          localStorage.setItem('kisfeeder', JSON.stringify(kisfeeder));
          gaJsUtils.openNewWindowDS(
            'js/XG/modules/common/docxfeeder/feeder.html?portalId=' + PortalsFactory.getPortalId(),
            'KIS ANC',
            500,
            window.innerHeight
          );
        };

        /**
         * moveModele
         * @param {*} modeles
         * @param {*} index
         * @param {*} direction
         */
        scope.moveModele = function(modeles, index, direction) {
          gaJsUtils.moveElementInArray(modeles, index, direction);
        };

        scope.templateChosen = function(index) {
          scope.dossiersCfg.templates[index].fileExists = true;
        };
      },
    };
  };

  ancBacDossierConfiguration.$inject = [
    'BacAppFactory',
    'AncAppFactory',
    'DocumentFactory',
    'ConfigFactory',
    'gaDomUtils',
    'ngDialog',
    '$rootScope',
    '$window',
    'gaJsUtils',
    'ancBacTools', 'PortalsFactory'
  ];
  return ancBacDossierConfiguration;
});
