'use strict';
define(function() {
  var ancBacGestionCivilites = function(
    BacAppFactory,
    AncAppFactory,
    gaDomUtils,
    gaJsUtils,
    ngDialog,
    $timeout,
    EditFactory,
    $q,
    QueryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/ancapp/main/views/anc_bac/anc_bac_gestion_civilites.html',
      restrict: 'EA',
      scope: {
        apptype: '=?',
        civilites: '=',
      },
      link: function(scope, elt, attrs, ctrl) {
        var civiliteModal, civiliteIndex, editCiviliteExistanteModal;
        var CurrentAppFactory =
          scope.apptype == 'anc' ? AncAppFactory : BacAppFactory;

        if (scope.apptype == 'anc')
          var listeDesVilles =
            CurrentAppFactory.appCfg.main.infosSpancListeVillesCfg;
        else
          var listeDesVilles =
            CurrentAppFactory.appCfg.main.extra.infosSassListeVillesCfg;

        scope.indexListeVilles = [];

        var openEditCivModal = function() {
          return ngDialog.open({
            template:
              'js/XG/widgets/ancapp/main/views/modals/modal.edit.civilite.html',
            className: 'ngdialog-theme-plain width600 miniclose nopadding',
            closeByDocument: false,
            showClose: false,
            scope: scope,
          });
        };

        scope.enregistrerCivilites = () => {
          CurrentAppFactory.appCfg.main.properties.civilites.liste =
            scope.civilites.liste;
          CurrentAppFactory.updateAppCfg().then(function() {});
        };

        // edit civilite
        scope.editCiviliteModal = function(index, civilite, suppression) {
          scope.civEdit = {};
          scope.editionEncours = false;
          scope.editionFinie = false;
          civiliteIndex = index;
          scope.currCivilite = civilite ? { value: civilite } : {};
          scope.isNewCivilite = civiliteIndex === false;
          scope.isSuppression = suppression == true;
          scope.previousCivilite = angular.copy(civilite);
          if (suppression) {
            scope.availableCivilitesForTransfert = angular.copy(
              scope.civilites.liste.filter(function(x) {
                return x != civilite;
              })
            );
          }

          // verification des données qui vont être impactées
          if (!scope.isNewCivilite) {
            gaDomUtils.showGlobalLoader();

            $q.all([
              QueryFactory.data(
                'kis_anc_personne',
                "civilite = '" + civilite + "'"
              ),
              QueryFactory.data(
                'kis_anc_demandeur',
                "civilite = '" + civilite + "'"
              ),
            ]).then(
              function(res) {
                var nbMaires = 0;
                listeDesVilles.map(function(x, i) {
                  if (x.maire && x.maire.civilite) {
                    if (x.maire.civilite.trim() == civilite) {
                      nbMaires++;
                      scope.indexListeVilles.push(i);
                    }
                  }
                });

                scope.donnesImpactees = {
                  personnes: res[0].data.totalFeatures,
                  demandeurs: res[1].data.totalFeatures,
                  maires: nbMaires,
                  total:
                    res[0].data.totalFeatures +
                    res[0].data.totalFeatures +
                    nbMaires,
                };
                civiliteModal = openEditCivModal();
                gaDomUtils.hideGlobalLoader();
              },
              function() {
                require('toastr').error(
                  'Erreur lors de la récupération des civilités à modifier.'
                );
                gaDomUtils.hideGlobalLoader();
              }
            );
          } else {
            civiliteModal = openEditCivModal();
          }
        };

        var saveCivilitesCfg = function() {
          CurrentAppFactory.appCfg.main[
            scope.apptype == 'anc'
              ? 'infosSpancListeVillesCfg'
              : 'infosSassListeVillesCfg'
          ] = listeDesVilles;
          CurrentAppFactory.appCfg.main.properties.civilites = angular.copy(
            scope.civilites
          );
          console.log(CurrentAppFactory.appCfg.main.properties.civilites);

          CurrentAppFactory.updateAppCfg();
        };

        /**
         * moveCivilite
         * @param {*} index
         * @param {*} direction
         */
        scope.moveCivilite = function(index, direction) {
          gaJsUtils.moveElementInArray(scope.civilites.liste, index, direction);
        };

        scope.sortCivilites = direction => {
          scope.alphabetically = direction === 'up';
          scope.civilites.liste.sort();

          if (!scope.alphabetically) {
            scope.civilites.liste.reverse();
          }
        };

        scope.civiliteChanged = function() {
          return (
            scope.isNewCivilite ||
            scope.currCivilite.value != scope.civilites.liste[civiliteIndex]
          );
        };

        scope.startEditCivilite = function() {
          scope.editionEncours = true;
          scope.civEdit.personnes = 'running';

          var previousValue = scope.civilites.liste[civiliteIndex],
            updateCivBase = {
              attribute: 'civilite',
              expression: "'" + scope.currCivilite.value + "'",
              where: "civilite = '" + previousValue + "'",
            };

          // PERSONNES
          EditFactory.updateexpression(updateCivBase, 'kis_anc_personne').then(
            function(res) {
              // PERSONNES OK

              scope.civEdit.demandeurs = 'running';
              scope.civEdit.personnes = 'done';

              // DEMANDEURS
              EditFactory.updateexpression(
                updateCivBase,
                'kis_anc_demandeur'
              ).then(
                function(res) {
                  // DEMANDEURS OK
                  scope.civEdit.maires = 'running';
                  scope.civEdit.demandeurs = 'done';

                  scope.indexListeVilles.forEach(function(index) {
                    listeDesVilles[index].maire.civilite =
                      scope.currCivilite.value;
                  });

                  scope.civEdit.maires = 'done';

                  // update maires dans la cfg
                  scope.editionFinie = true;
                  // update liste des personnes et svg
                  if (scope.isSuppression) {
                    scope.civilites.liste.splice(civiliteIndex, 1);
                  } else {
                    scope.civilites.liste[civiliteIndex] =
                      scope.currCivilite.value;
                  }

                  saveCivilitesCfg();
                },
                function() {
                  // DEMANDEURS ERR
                  scope.civEdit.demandeurs = 'error';
                  console.log('err');
                  scope.editionFinie = true;
                }
              );
            },
            function() {
              // PERSONNES ERR
              scope.civEdit.personnes = 'error';
              console.log('err');
              scope.editionFinie = true;
            }
          );
        };

        /**
         * getStatusIcon
         * @param {*} type
         */
        scope.getStatusIcon = function(type) {
          var icon = '';
          if (angular.isDefined(scope.civEdit[type])) {
            if (scope.civEdit[type] == 'wait') icon = 'fa-clock-o';
            if (scope.civEdit[type] == 'running') icon = 'fa-spinner fa-spin';
            if (scope.civEdit[type] == 'done') icon = 'fa-check';
            if (scope.civEdit[type] == 'error') icon = 'fa-times';
          }

          return 'fa ' + icon;
        };

        /**
         * civiliteExisteDeja
         * @param {*} civ
         */
        var civiliteExisteDeja = function() {
          return (
            scope.civilites.liste.filter(function(x) {
              return (
                x == scope.currCivilite.value && x != scope.previousCivilite
              );
            }).length > 0
          );
        };
        scope.$watch('currCivilite.value', function(x) {
          if (angular.isDefined(x)) {
            scope.civiliteExisteDeja =
              !scope.isSuppression && civiliteExisteDeja();
            console.log(scope.civiliteExisteDeja);
          }
        });

        /**
         * editCivilite
         * @param {*} civilite
         */
        scope.editCivilite = function() {
          var ans = !scope.isNewCivilite
            ? confirm(
                'Êtes-vous certain de vouloir effectuer cette modification ?'
              )
            : 1;

          if (ans) {
            if (scope.isNewCivilite) {
              scope.civilites.liste.push(scope.currCivilite.value);
              saveCivilitesCfg();
              civiliteModal.close();
            } else {
              if (
                scope.isSuppression &&
                scope.donnesImpactees.total == 0 &&
                scope.currCivilite.value == 'suppression_directe'
              ) {
                scope.civilites.liste.splice(civiliteIndex, 1);
                saveCivilitesCfg();
                civiliteModal.close();
              } else {
                scope.civEdit = {
                  personnes: 'wait',
                  demandeurs: 'wait',
                  maires: 'wait',
                };
                scope.startEditCivilite();
              }
            }
          }
        };
      },
    };
  };

  ancBacGestionCivilites.$inject = [
    'BacAppFactory',
    'AncAppFactory',
    'gaDomUtils',
    'gaJsUtils',
    'ngDialog',
    '$timeout',
    'EditFactory',
    '$q',
    'QueryFactory',
  ];
  return ancBacGestionCivilites;
});
