'use strict';
define(function() {
  var eft = function(ConfigFactory, $q, CalendarFactory, $rootScope) {
    return {
      templateUrl: 'js/XG/widgets/ancapp/main/views/admin/admin.calendar.html',
      restrict: 'EA',
      /*scope:{},*/
      link: function(scope) {
        /**
         *    Définition des onglets contenant les paramètres de l'agenda.
         */
        function defineTabs() {
          scope.calAdminTabs = [
            {
              title: "Options d'affichage",
            },
            {
              title: "Types d'événement",
            },
          ];
          scope.calAdminTabs.activeTab = 0;
        }

        function initConfig() {
          var defer = $q.defer();
          scope.config = {};
          scope.config.details = {
            withProp: true,
            withOccupant: true,
          };
          scope.config.eventTypes = [];
          ConfigFactory.get('ANC', 'calendar').then(
            function(res) {
              if (res.data != '') {
                scope.config = res.data;
                scope.config.eventTypes = getMatchedEventTypes(
                  res.data.eventTypes
                );
              }
              defer.resolve();
            },
            function() {
              defer.resolve();
            }
          );
          return defer.promise;
        }

        function getMatchedEventTypes(configEventTypes) {
          return configEventTypes.map(configEventType => {
            const foundeventType = scope.eventTypes.find(
              eventType =>
                eventType.properties &&
                eventType.properties.type_id === configEventType.type_id
            );
            if (foundeventType) {
              configEventType.alias = foundeventType.properties.alias;
              configEventType.type = foundeventType.properties.type;
            }
            return configEventType;
          });
        }

        scope.saveConfig = function() {
          if (scope.config != undefined)
            ConfigFactory.add(scope.config, 'ANC', 'calendar');
        };

        /**
         *    Vérifie la présence d'un type d'événement dans une liste.
         *
         * @param {Object} event: un type d'événement à chercher
         * @param {Array} list: liste de type d'événements
         */
        function eventInList(event, list) {
          var iEt, propTypeId;
          if (list.length != 0) {
            if (list[0].properties != null) {
              for (iEt = 0; iEt < list.length; iEt++) {
                if (list[iEt].properties.type_id == event.type_id) {
                  return true;
                }
              }
            } else {
              for (iEt = 0; iEt < list.length; iEt++) {
                if (list[iEt].type_id == event.properties.type_id) {
                  return true;
                }
              }
            }
          }
          return false;
        }

        /**
         *     Vérifie que les types d'événements listés
         * dans la configuration correspondent aux types d'événements en cours.
         * Les types d'événements qui n'existent plus sont enlevés,
         * ceux qui manquent sont ajoutés.
         */
        function checkConfigEventTypes() {
          var iEt, types;
          //-- Si des événements configuré
          //-- n'existent plus dans l'ANC, on les supprime.
          types = scope.config.eventTypes;
          for (iEt = types.length - 1; iEt >= 0; iEt--) {
            if (!eventInList(types[iEt], scope.eventTypes)) {
              types.splice(iEt, 1);
            }
          }
          //-- Si des événements de l'ANC ont été ajouté et ne sont pas présent
          //-- dans la configuration, on les y ajoute.
          types = scope.eventTypes;
          for (iEt = 0; iEt < types.length; iEt++) {
            if (!eventInList(types[iEt], scope.config.eventTypes)) {
              scope.config.eventTypes.push({
                type_id: types[iEt].properties.type_id,
                alias: types[iEt].properties.alias,
                rdvIsPossible: true,
                color: '#ffa662',
              });
            }
          }
        }

        function getEventTypes() {
          var defer = $q.defer();
          if (scope.eventTypes == undefined) {
            scope.eventTypes = CalendarFactory.resources.event_types.filter(
              eventType => {
                return (
                  eventType &&
                  eventType.properties.type &&
                  ((!isAnc() && !isBac()) ||
                    (isAnc() &&
                      eventType.properties.type
                        .toLowerCase()
                        .indexOf('kis_bac') === -1) ||
                    (isBac() &&
                      eventType.properties.type
                        .toLowerCase()
                        .indexOf('kis_anc') === -1))
                );
              }
            );
            //-- Si on n'a pas encore récupérés les event types dans
            //-- CalendarFactory, on le fait maintenant.
            if (scope.eventTypes.length != 0) {
              defer.resolve();
            } else {
              CalendarFactory.geteventtypes().then(function(res) {
                scope.eventTypes = CalendarFactory.resources.event_types.filter(
                  eventType => {
                    return (
                      eventType &&
                      eventType.properties.type &&
                      ((!isAnc() && !isBac()) ||
                        (isAnc() &&
                          eventType.properties.type
                            .toLowerCase()
                            .indexOf('kis_bac') === -1) ||
                        (isBac() &&
                          eventType.properties.type
                            .toLowerCase()
                            .indexOf('kis_anc') === -1))
                    );
                  }
                );
                defer.resolve();
              });
            }
          }
          return defer.promise;
        }

        function isAnc() {
          return $rootScope.xgos.sector === 'anc';
        }
        function isBac() {
          return $rootScope.xgos.sector === 'bac';
        }

        scope.$on('xgoscolorchanged', scope.saveConfig);

        //-- "MAIN": phase initiale
        defineTabs();
        getEventTypes().then(function() {
          initConfig().then(checkConfigEventTypes);
        });
      },
    };
  };

  eft.$inject = ['ConfigFactory', '$q', 'CalendarFactory', '$rootScope'];
  return eft;
});
