'use strict';
define(function() {
  var historicAnalyseHpo = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory,
    HpoAppServices,
    ngProgressFactory,
    $location
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/historic_analyse_hpo.html',
      restrict: 'EA',
      link: function(scope, elt, attrs, ctrl) {
        scope.configName =
          HpoCarteAppFactory.getAppFactory().getAppname() +
          '_' +
          'HpoHistoricAnalyseDataConfig';
        scope.datatableHeightHistoric =
          angular.element('.xgos_content').height() -
          angular.element('#xgos_nav').height() -
          110 +
          'px';

        scope.currentheight = ($window.innerHeight * 1.2) / 2 + 'px';
        scope.ftihistory = HpoCarteAppFactory.getAppFactory().getFeatureTypes(
          'stat_hist'
        )[0];
        scope.ftihistoryattributes = scope.ftihistory.attributes.filter(
          function(x) {
            if (
              x &&
              ((HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                scope.ftihistory.name
              ) &&
                HpoCarteAppFactory.getAppFactory()
                  .getExcludedAttributes(scope.ftihistory.name)
                  .indexOf(x.name) === -1) ||
                !HpoCarteAppFactory.getAppFactory().getExcludedAttributes(
                  scope.ftihistory.name
                ))
            )
              return x;
          }
        );

        scope.buttonEditIcon = [
          {
            type: 'component',
            config: {
              name: 'button',
              click: ['crud_update'],
            },
            cfg: {
              icon: { name: 'pencil-square-o' },
              iconOrLabel: 'icon',
              size: 'btn-xs',
              style: 'btn-default cursorHelp',
              title: 'Editer le dossier',
            },
          },
        ];

        scope.editDashboard = function(obj) {
          if (obj) {
            scope.currentObj = obj;
            var data = {
              type: 'FeatureCollection',
              features: [obj],
            };
            gaDomUtils.showGlobalLoader();
            HpoAppServices.getDashboards(scope.ftihistory.uid, data).then(
              function(res) {
                gaDomUtils.hideGlobalLoader();
                if (res && res.data) {
                  for (var key in res.data) {
                    if (key && res.data.hasOwnProperty(key)) {
                      scope.currentDashboard = res.data[key];
                      scope.authorisedAttributes = HpoCarteAppFactory.getAppFactory().getAuthorizedAttributes(
                        scope.currentDashboard.tableselected
                      );
                      break;
                    }
                  }
                  var dialog = ngDialog.openConfirm({
                    template:
                      'js/XG/widgets/hpoapp/home_admin_data/views/dialog/hpo.data.dashboard.html',
                    className:
                      'ngdialog-theme-plain width1100 minheight500 nopadding miniclose',
                    scope: scope,
                  });
                  dialog.then(function(data) {
                    if (data) {
                      gaDomUtils.showGlobalLoader();
                      HpoAppServices.updateDashboard(
                        scope.ftihistory.uid,
                        scope.currentObj.id,
                        data
                      ).then(
                        function(res) {
                          gaDomUtils.hideGlobalLoader();
                          if (res.data && JSON.parse(res.data)) {
                            AlertHpoFactory.getSimpleSuccess(
                              $filter('translate')('hpo.common.info'),
                              $filter('translate')('hpo.data.analyse.updated'),
                              false,
                              'success'
                            );
                            $rootScope.$broadcast(
                              'reloadDatatable',
                              scope.ftihistory.uid
                            );
                          } else {
                            AlertHpoFactory.getSimpleSuccess(
                              $filter('translate')('hpo.common.info'),
                              $filter('translate')(
                                'hpo.error.data.updatedashboard'
                              ),
                              true,
                              'error'
                            );
                            $rootScope.$broadcast(
                              'reloadDatatable',
                              scope.ftihistory.uid
                            );
                          }
                        },
                        function(res) {
                          gaDomUtils.hideGlobalLoader();
                          AlertHpoFactory.showErrorMessage(res);
                        }
                      );
                    }
                  });
                }
              },
              function(res) {
                gaDomUtils.hideGlobalLoader();
                AlertHpoFactory.showErrorMessage(res);
              }
            );
          }
        };

        scope.filter =
          '"USER" = \'' +
          HpoCarteAppFactory.getInitProvider().getUser().login +
          "'";
        if (
          HpoCarteAppFactory.getInitProvider().getUser() &&
          HpoCarteAppFactory.getInitProvider().getUser().uid
        ) {
          scope.filter +=
            ' AND "USERID" = \'' +
            HpoCarteAppFactory.getInitProvider().getUser().uid +
            "'";
        }

        scope.datatableCrudHpo = {
          update: { func: scope.editDashboard },
          remove: true,
        };
      },
    };
  };

  historicAnalyseHpo.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
    'HpoAppServices',
    'ngProgressFactory',
    '$location',
  ];
  return historicAnalyseHpo;
});
