'use strict';
define(function() {
  var countsGroup = function(QueryFactory, gaJsUtils) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/directives/hpo_statistics_counts.html',
      restrict: 'EA',
      scope: {
        res: '=?',
        counts: '=',
      },
      link: function(scope) {
        //-- Récupération des valeurs à calculer.
        QueryFactory.getCount(scope.counts).then(function(res) {
          if (res.data.etat == 'erreur')
            require('toastr').error(
              gaJsUtils.errorListToOneString(res.data.errorList)
            );
          else scope.counts = res.data.objValeur;
        });
      },
    };
  };

  countsGroup.$inject = ['QueryFactory', 'gaJsUtils'];
  return countsGroup;
});
