'use strict';
define(function() {
  var changeAttributeType = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/change_attribute_type.html',
      restrict: 'EA',
      scope: {
        attr: '=',
        fti: '=',
        res: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.attributeTypes = [
          {
            id: 'java.lang.Double',
            label: 'java.lang.Double',
          },
          {
            id: 'java.util.Date',
            label: 'java.util.Date',
          },
          {
            id: 'java.lang.String',
            label: 'java.lang.String',
          },
          {
            id: 'java.lang.Integer',
            label: 'java.lang.Integer',
          },
          {
            id: 'java.sql.Timestamp',
            label: 'java.sql.Timestamp',
          },
          {
            id: 'g2c.attachment',
            label: 'g2c.attachment',
          },
          {
            id: 'g2c.attachments',
            label: 'g2c.attachments',
          },
          {
            id: 'g2c.hyperlink',
            label: 'g2c.hyperlink',
          }
        ];

        scope.annuler = function() {
          var idx = scope.attributeTypes
            .map(function(x) {
              return x.id;
            })
            .indexOf(scope.attr.type);
          if (idx !== -1) scope.res = scope.attributeTypes[idx];
          else {
            scope.res = {
              id: scope.attr.type,
              label: scope.attr.type,
            };
            scope.attributeTypes.push(scope.res);
          }
        };

        var getExistingValue = function() {
          var idx = scope.attributeTypes
            .map(function(x) {
              return x.id;
            })
            .indexOf(scope.res.id);
          if (idx !== -1) scope.res = scope.attributeTypes[idx];
          else {
            scope.res = {
              id: scope.attr.type,
              label: scope.attr.type,
            };
            scope.attributeTypes.push(scope.res);
          }
        };

        var checkRes = function() {
          if (!scope.res) scope.annuler();
          else {
            getExistingValue();
          }
        };

        checkRes();

        scope.translateType = function(x) {
          return $filter('translate')(x.label);
        };
      },
    };
  };

  changeAttributeType.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
  ];
  return changeAttributeType;
});
