'use strict';
define(function() {
  var setRuleHpoRegroupement = function(
    AlertHpoFactory,
    FeatureTypeFactory,
    HpoCarteAppFactory,
    $window,
    ImportExportFactory,
    ngDialog,
    $q,
    $filter,
    $rootScope,
    $timeout,
    gaUrlUtils,
    ParametersFactory,
    ngTableParams,
    gaDomUtils,
    EditFactory,
    QueryFactory
  ) {
    return {
      templateUrl:
        'js/XG/widgets/hpoapp/home_admin_data/views/utilities/rules/set_rule_hpo_regroupement.html',
      restrict: 'EA',
      scope: {
        attr: '=',
        fti: '=',
        res: '=?',
        conditions: '=',
        usespecialfilters: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        scope.conditions = angular.copy(scope.res) || {
          value: undefined,
          interpreteconditions: 'or',
          list: [],
        };
        scope.addCondition = function() {
          scope.conditions.list.push({});
        };
        scope.removeFromList = function(idx) {
          scope.idx = idx;
          var callback = function(isconfirm) {
            if (isconfirm) {
              scope.conditions.list.splice(scope.idx, 1);
              try {
                scope.$apply();
              } catch(err) {}
            }
            scope.idx = undefined;
          };
          var message = $filter('translate')(
            'hpo.data.prepare.correctiontools.correctallvalues.removeCondition'
          );
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('hpo.common.warning'),
            message,
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };

        scope.showAllValues = false;
        scope.searchForValues = function() {
          if (!scope.showAllValues) {
            gaDomUtils.showGlobalLoader();
            var promise = QueryFactory.dataattributeCorrectedDate(
              scope.fti.uid,
              scope.attr.name
            );
            promise.then(
              function(res) {
                if (res.data.length > 0) {
                  scope.autocompleteglobalsearch = res.data;
                } else {
                  scope.autocompleteglobalsearch = [];
                  require('toastr').error(
                    $filter('translate')('elastic.search.novalues')
                  );
                }
                scope.showAllValues = !scope.showAllValues;
                gaDomUtils.hideGlobalLoader();
              },
              function(res) {
                scope.autocompleteglobalsearch = [];
                scope.showAllValues = !scope.showAllValues;
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(
                  $filter('translate')('elastic.search.novalues')
                );
              }
            );
          } else {
            scope.showAllValues = !scope.showAllValues;
          }
        };

        scope.extractConditions = function() {
          if (
            scope.usespecialfilters &&
            scope.usespecialfilters.operands &&
            scope.usespecialfilters.operands.length > 0
          ) {
            scope.conditions.list = angular.copy(
              scope.usespecialfilters.operands
                .map(function(x) {
                  if (x.name === scope.attr.name) return x.operand;
                })
                .filter(function(x) {
                  if (x) return x;
                })
            );
            scope.conditions.interpreteconditions =
              scope.usespecialfilters.conditionattributes;
          }
        };
      },
    };
  };

  setRuleHpoRegroupement.$inject = [
    'AlertHpoFactory',
    'FeatureTypeFactory',
    'HpoCarteAppFactory',
    '$window',
    'ImportExportFactory',
    'ngDialog',
    '$q',
    '$filter',
    '$rootScope',
    '$timeout',
    'gaUrlUtils',
    'ParametersFactory',
    'ngTableParams',
    'gaDomUtils',
    'EditFactory',
    'QueryFactory',
  ];
  return setRuleHpoRegroupement;
});
