'use strict';
define(function() {
  var basemapwidget = function(
    gcPropertiesLayers,
    gclayers,
    ParametersFactory,
    gcPopup,
    extendedNgDialog,
    $filter,
    $translate,
    SelectManager,
    $rootScope,
    GeoTreatmentFactory,
    gaDomUtils,
    $timeout
  ) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/geotreatment/views/geotreatmentwidget.html',
      restrict: 'A',
      link: function(scope, elt, attrs, ctrl) {
        var map = scope.map;
        scope.activetreatment = '';

        scope.monform = {
          data: [
            {
              label: 'Première branche',
              children: [],
              template: {
                fields: [
                  {
                    label: 'Nom',
                    type: 'attribute',
                    description: '',
                    config: {
                      name: 'NOM',
                      res: 'current',
                      ftid: '74463f10-c055-432b-8543-8efc46e601fb',
                    },
                    title: '',
                    placeholder: '',
                    readonly: false,
                    disabled: false,
                    test: [],
                    required: false,
                  },
                  {
                    label: 'Long',
                    type: 'attribute',
                    description: '',
                    config: {
                      name: 'Longueur',
                      res: 'current',
                      ftid: '74463f10-c055-432b-8543-8efc46e601fb',
                    },
                    title: '',
                    placeholder: '',
                    readonly: false,
                    disabled: false,
                  },
                  {
                    label: 'Drag and Buffer',
                    type: 'select',
                    description: '',
                    config: {
                      name: 'dragandbuffer',
                      ftisid: ['86c305fe-be7b-48b4-97cb-12a17cc0bc30'],
                      res: 'related_object',
                      typebuffer: 'ROUND',
                      distance: 10,
                      resbuffer: 'current',
                    },
                  },
                  {
                    label: 'Enregistrement Objet',
                    type: 'edit',
                    description: '',
                    config: {
                      name: 'add',
                      finish: ['alertMessage("coucou")'],
                      ftid: '74463f10-c055-432b-8543-8efc46e601fb',
                      feats: 'current',
                      related: 'related_object',
                      res: 'current',
                    },
                  },
                ],
                tabs: [],
                activeTab: -1,
              },
              visible: true,
              classes: ['leaf'],
            },
          ],
          variables: [
            { label: 'current', description: 'Default Object', fields: [] },
            { label: 'related_object', description: '', fields: [] },
          ],
          events: [{ origin: { key: '', value: '' }, actions: [] }],
        };

        let handlePromiseError= () =>{
          scope.inprogress = false;
        };

        function showMoreResults(res) {
          SelectManager.closepop();
          SelectManager.clear();
          if ( res.data.featureCollection ) {
            SelectManager.addFeaturesFromGeojson(res.data.featureCollection);
            let selectScope = $rootScope.$new(true);
            selectScope.map = scope.map;
            selectScope.panelsManager = scope.panelsManager;
            SelectManager.openpop(selectScope);
          }
        }

        function selectFeatures(treatScope) {
          var mapsrid = map
            .getView()
            .getProjection()
            .getCode();
          GeoTreatmentFactory.moreResults(treatScope.state, mapsrid).then(res=>{
              showMoreResults(res);
              $timeout(()=>{
                if (treatScope.hasOwnProperty('attrUpdate')){
                    treatScope.attrUpdate=null;
                }
                if (treatScope.hasOwnProperty('currentselectfti')){
                  treatScope.currentselectfti=null;
                }
                scope.panelsManager.addPanel({
                  id: 'selecttab',
                  stickToRight: true,
                  templateUrl:
                    'js/XG/widgets/mapapp/geotreatment/views/panels/panel.datatable.html',
                  scope: treatScope,
                  stickToBorder: true,
                  visible: true,
                });
              },0);
          }
          ).catch(handlePromiseError);
        }

        function resultHasBeenRemoved(evt, arg1) {
          let item= arg1.removedItem[0].properties;
          SelectManager.removefeatures(item.line1);
        }

        scope.$on('datatableGeoJsonChanged', resultHasBeenRemoved);

        scope.vopenResult = function(treatScope) {
          treatScope.geoj = treatScope.result;
          if (treatScope.panelsManager) {
            treatScope.panelsManager.removePanel('selecttab');
          }
          selectFeatures(treatScope);
        };

        scope.applychange = function(
          geoj,
          typeOfGeotreatment,
          attributesTochange,
          insertNew
        ) {
          gaDomUtils.showGlobalLoader();
          GeoTreatmentFactory.applychange(
            geoj,
            typeOfGeotreatment,
            attributesTochange,
            insertNew
          ).then(function() {
            if (scope.dependdialog) scope.dependdialog.close();
            scope.closePanelIsConfirmed = true;
            scope.closepanel('fromConfirmation');
            SelectManager.closepop();
            SelectManager.clear();
            swal({
              title: $filter('translate')('geotreat.succes'),
              text: $filter('translate')('geotreat.succes_fusion'),
              type: 'success',
            });
            gaDomUtils.hideGlobalLoader();
          }).catch(handlePromiseError);
        };

        scope.closepanel = function(fromCode) {
          if (fromCode != 'fromConfirmation')
            scope.closePanelIsConfirmed = false;
          if (fromCode == 'fromCode' || fromCode == 'fromConfirmation') {
            gclayers.clearhighLightFeatures();
            gclayers
              .getDrawLayer()
              .getSource()
              .clear();
            scope.panelsManager.removePanel('selecttab');
          }
          if (scope.IntersectionLines) scope.IntersectionLines.close();
          if (scope.NearestLine) scope.NearestLine.close();
          if (scope.FusionLine) scope.FusionLine.close();
          if (scope.SetValueFromGeometry) scope.SetValueFromGeometry.close();
          if (scope.OrientedPoint) scope.OrientedPoint.close();
          if (scope.GeoCalcul) scope.GeoCalcul.close();
          if (scope.SetInfoToRelation) scope.SetInfoToRelation.close();
          if (scope.GetInfoFromRelation) scope.GetInfoFromRelation.close();
          if (scope.GenerateNode) scope.GenerateNode.close();
        };

        function userAskForClosing(confirmMSG) {
          scope.listnerToOpen = 'wait';
          if (scope.closePanelIsConfirmed) return true;
          swal({
              title: $filter('translate')('geotreat.geotreatments'),
              text: confirmMSG,
              type: 'warning',
              confirmButtonColor: '#DD6B55',
              cancelButtonColor: '#6BDD55',
              confirmButtonText: $filter('translate')('common.yes'),
              showCancelButton: true,
              cancelButtonText: $filter('translate')('common.no'),
              closeOnConfirm: true,
            },
            function(isConfirm) {
              if (isConfirm) {
                if (scope.dependdialog) scope.dependdialog.close();
                scope.closePanelIsConfirmed = true;
                scope.closepanel('fromConfirmation');
                SelectManager.closepop();
                SelectManager.clear();
                scope.listnerToOpen = 'yes';
              } else {
                scope.listnerToOpen = 'no';
              }
            }
          );
          return false;
        }

        function openGeoPanel(name) {
          var confirmMSG = $filter('translate')('common.SureToQuit');
          if (listnerWatcher)
            //check for watch exists
            listnerWatcher(); //this line will destruct watch if its already there
          switch (name) {
            case 'IntersectionLines': //DNS
              scope.activetreatment = 'IntersectionLines';
              scope.IntersectionLines = extendedNgDialog.open({
                preCloseCallback: function(value) {
                  return userAskForClosing(confirmMSG);
                },
                template:
                  'js/XG/widgets/mapapp/geotreatment/views/modals/modals.treatment.html',
                className: 'ngdialog-theme-plain width400 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                draggable: true,
                title: $filter('translate')('geotreat.Intersections_Lines'),
              });
              break;
            case 'NearestLine': //
              scope.activetreatment = 'NearestLine';
              scope.NearestLine = extendedNgDialog.open({
                preCloseCallback: function(value) {
                  return userAskForClosing(confirmMSG);
                },
                template:
                  'js/XG/widgets/mapapp/geotreatment/views/modals/modals.treatment.html',
                className: 'ngdialog-theme-plain width400 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                draggable: true,
                title: $filter('translate')('geotreat.NearestLine'),
              });
              break;
            case 'FusionLine': //
              scope.activetreatment = 'FusionLine';
              scope.FusionLine = extendedNgDialog.open({
                preCloseCallback: function(value) {
                  return userAskForClosing(confirmMSG);
                },
                template:
                  'js/XG/widgets/mapapp/geotreatment/views/modals/modals.treatment.html',
                className: 'ngdialog-theme-plain width400 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                draggable: true,
                title: $filter('translate')('geotreat.Fusion_Line'),
              });
              break;
            case 'SetValueFromGeometry': //SetValueFromGeometry
              scope.activetreatment = 'SetValueFromGeometry';
              scope.SetValueFromGeometry = extendedNgDialog.open({
                preCloseCallback: function(value) {
                  return userAskForClosing(confirmMSG);
                },
                template:
                  'js/XG/widgets/mapapp/geotreatment/views/modals/modals.treatment.html',
                className: 'ngdialog-theme-plain width400 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                draggable: true,
                title: $filter('translate')(
                  'geotreat.SetAttributeValueFromGeometry'
                ),
              });
              break;
            case 'OrientedPoint': //SetValueFromGeometry
              scope.activetreatment = 'OrientedPoint';
              scope.OrientedPoint = extendedNgDialog.open({
                preCloseCallback: function(value) {
                  return userAskForClosing(confirmMSG);
                },
                template:
                  'js/XG/widgets/mapapp/geotreatment/views/modals/modals.treatment.html',
                className: 'ngdialog-theme-plain width400 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                draggable: true,
                title: $filter('translate')('geotreat.OrientedPoint'),
              });
              break;
            case 'GeoCalcul': //SetValueFromGeometry
              scope.activetreatment = 'GeoCalcul';
              scope.GeoCalcul = extendedNgDialog.open({
                preCloseCallback: function(value) {
                  return userAskForClosing(confirmMSG);
                },
                template:
                  'js/XG/widgets/mapapp/geotreatment/views/modals/modals.treatment.html',
                className: 'ngdialog-theme-plain width400 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                draggable: true,
                title: $filter('translate')('geotreat.GeoCalcul'),
              });
              break;
            case 'SetInfoToRelation': //SetValueFromGeometry
              scope.activetreatment = 'SetInfoToRelation';
              scope.SetInfoToRelation = extendedNgDialog.open({
                preCloseCallback: function(value) {
                  return userAskForClosing(confirmMSG);
                },
                template:
                  'js/XG/widgets/mapapp/geotreatment/views/modals/modals.treatment.html',
                className: 'ngdialog-theme-plain min_width400 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                draggable: true,
                title: $filter('translate')('geotreat.SetInfoToRelation'),
              });
              break;
            case 'GetInfoFromRelation': //SetValueFromGeometry
              scope.activetreatment = 'GetInfoFromRelation';
              scope.GetInfoFromRelation = extendedNgDialog.open({
                preCloseCallback: function(value) {
                  return userAskForClosing(confirmMSG);
                },
                template:
                  'js/XG/widgets/mapapp/geotreatment/views/modals/modals.treatment.html',
                className: 'ngdialog-theme-plain min_width400 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                draggable: true,
                title: $filter('translate')('geotreat.GetInfoFromRelation'),
              });
              break;
            case 'GenerateNode': //SetValueFromGeometry
              scope.activetreatment = 'GenerateNode';
              scope.GenerateNode = extendedNgDialog.open({
                preCloseCallback: function(value) {
                  return userAskForClosing(confirmMSG);
                },
                template:
                  'js/XG/widgets/mapapp/geotreatment/views/modals/modals.treatment.html',
                className: 'ngdialog-theme-plain width400 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                draggable: true,
                title: $filter('translate')('geotreat.GenerateNode'),
              });
              break;
          }
        }

        scope.listnerToOpen = null;
        var listnerWatcher;
        scope.open = function(name) {
          scope.listnerToOpen = null;
          scope.closepanel('fromCode');
          if (scope.listnerToOpen !== 'wait') {
            openGeoPanel(name);
          } else {
            listnerWatcher = scope.$watch(
              'listnerToOpen',
              function(newVal, oldVal) {
                if (newVal == 'yes') {
                  var firstTime = true;
                  scope.$on('onNgDialogClosed', function(event, id) {
                    if (firstTime) {
                      openGeoPanel(name);
                      scope.closePanelIsConfirmed = false;
                      firstTime = false;
                    }
                  });
                }
              },
              true
            );
          }
        };
      },
    };
  };

  basemapwidget.$inject = [
    'gcPropertiesLayers',
    'gclayers',
    'ParametersFactory',
    'gcPopup',
    'extendedNgDialog',
    '$filter',
    '$translate',
    'SelectManager',
    '$rootScope',
    'GeoTreatmentFactory',
    'gaDomUtils',
    '$timeout'
  ];
  return basemapwidget;
});
