'use strict';
define(() => {
  class importxlsxwidgetconfig {
    constructor(
        FeatureTypeFactory,
        ConfigFactory,
        ngDialog,
        $filter
    ) {
      return {
        templateUrl:
            'js/XG/widgets/mapapp/importxlsx/views/importxlsxwidgetconfig.html',
        restrict: 'AE',
        link: function (scope) {

          const initConfig = () => {
            // Récupération de la configuration sauvegardée
            scope.configTemp = angular.copy(scope.config);

            // Génère les ftis pour l'autocomplétion des champs components
            if (!scope.ftis) {
              FeatureTypeFactory.get().then(
                  res => {
                    scope.ftis = res.map(fti => {
                      return {
                        alias: fti.alias,
                        uid: fti.uid,
                        attributes: fti.attributes
                      };
                    });
                    reloadAttributeList();
                  });
            } else {
              reloadAttributeList();
            }
          };

          /**
           *  Chargement de la liste des attribut pour le gcautocomplete
           *  s'execute à l'ouverture de la configuration et au changement de choix de composant
           */
          const reloadAttributeList = () => {
            const component = scope.ftis.find(fti => fti.uid === scope.configTemp.territoryComponentUid);
            if (component) {
              scope.attributes = component.attributes;
            }
          };

          /**
           * Vide l'attribut selectionné lors du changement de composant
           */
          scope.onTerritoryPick = () => {
            scope.configTemp.territoryAttributeName = undefined;
            reloadAttributeList();
          }

          /**
           * Récupération du fichier JSON de configuration
           * @param fileContainer
           */
          scope.uploadFile = fileContainer => {
            const file = fileContainer.files[0];
            if(file) {
              file.text().then(res => {
                try {
                  scope.configTemp.jsonFileData = JSON.parse(res);
                  scope.configTemp.jsonFileName = file.name;
                  // Le nom du fichier ne se met pas à jour dans l'interface sans $apply()
                  scope.$apply();
                } catch (e) {
                  require('toastr').error($filter('translate')('importxlsxwidget.errorParsingJson'));
                  console.error(e);
                }
              });
            }
          };

          let jsonDialog;
          /**
           * Ouvre le mode d'édition du JSON
           */
          scope.editJson = () => {
            scope.editConfig = {
              data: angular.copy(scope.configTemp.jsonFileData),
              options: {
                mode: 'tree',
              },
            };
            // Bouton de changement mode texte / json
            scope.jsonEditionChangeMode = () => {
              scope.editConfig.options.mode = (scope.editConfig.options.mode === 'code') ? 'tree' : 'code';
            }
            // Bouton sauvegarder
            scope.applyDebuggedVersion = () => {
              if (confirm($filter('translate')('common.sure_to_apply_modif'))) {
                scope.configTemp.jsonFileData = angular.copy(scope.editConfig.data);
                jsonDialog.close();
              }
            };
            // Fenêtre d'édition JSON
            jsonDialog = ngDialog.open({
              template:
                  'js/XG/widgets/utilities/form/views/modal/modal.form_debug.html',
              className: 'ngdialog-theme-plain width1000 nopadding miniclose',
              closeByDocument: false,
              scope: scope,
            });
          };

          /**
           * Sauvegarde la configuration
           */
          scope.saveConfig = () => {
            // Suppression de champs d'une ancienne configuration
            delete scope.configTemp.territoryComponent;
            delete scope.configTemp.territoryAttribute;
            // Sauvegarde configuration
            ConfigFactory.add(scope.configTemp, 'widgets', scope.ConfigName).then(res => {
              if (res.data === true) {
                scope.checkConfigAndGetTerritoryValues(scope.configTemp);
                require('toastr').success($filter('translate')('importexportwidget.config.SaveSuccessMsg'));
              } else {
                require('toastr').error($filter('translate')('importexportwidget.config.SaveErrorMsg'));
              }
            });
          };

          initConfig();
        }
      }
    }
  }

  importxlsxwidgetconfig.$inject = [
    'FeatureTypeFactory',
    'ConfigFactory',
    'ngDialog',
    '$filter'
  ];
  return importxlsxwidgetconfig;
});