'use strict';
define(function() {
  var versionlibwidget = function(gcPopup, VersionFactory) {
    return {
      templateUrl:
        'js/XG/widgets/mapapp/versionlib/views/toolbarversionlib.html',

      restrict: 'A',

      link: function(scope) {
        //// creation du popup info version kis et librairies
        scope.openPopupVersionLib = function() {
          scope.pop = gcPopup.open({
            scope: scope,
            title: 'Librairies et versions',
            template:
              'js/XG/widgets/mapapp/versionlib/views/popup_versionlib.html',
            showClose: true,
          });
        };
        /// recuperation de la version du serveur "Kis" à partir de la factory VersionFactory
        var promise = VersionFactory.get();
        promise.then(function(vers) {
          scope.versionServeur = vers.data;
        });

        /// recuperation de la version du client "Kis" à partir de la factory VersionFactory
        var promise = VersionFactory.getClient();
        promise.then(
          function(vers) {
            scope.versionClient = vers.data.version;
            scope.versionClientDate = vers.data.date;
            scope.versionClientExist = true;
          },
          function() {
            scope.versionClientExist = false;
          }
        );

        /// creation du tableau json des infos librairies

        scope.libs = [
          {
            name: 'angular',
            version: '1.2.24',
          },
          {
            name: 'angular-animate',
            version: '1.2.24',
          },
          {
            name: 'angular-bootstrap-colorpicker',
            version: '3.0.11',
          },
          {
            name: 'angular-bootstrap-nav-tree',
            version: '0.2.0',
          },
          {
            name: 'angular-bootstrap-slider',
            version: '0.1.1',
          },
          {
            name: 'ng-responsive-calendar',
            version: '0.1.8',
          },
          {
            name: 'nangular-contextmenu',
            version: '',
          },
          {
            name: 'angular-cookies',
            version: '1.3.8',
          },
          {
            name: 'angular-drag-and-drop-lists',
            version: '1.3.0',
          },
          {
            name: 'angular-form-builder',
            version: '0.1.0',
          },
          {
            name: 'angular-hotkeys',
            version: '1.4.5',
          },
          {
            name: 'angular-mocks',
            version: '1.2.18',
          },
          {
            name: 'angular-motion',
            version: '0.3.2',
          },
          {
            name: 'angular-dragdrop',
            version: '1.0.1',
          },
          {
            name: 'angular-nvd3',
            version: '1.0.5',
          },
          {
            name: 'angular-rangeslider',
            version: '0.0.12',
          },
          {
            name: 'angular-recursion',
            version: '1.0.4',
          },
          {
            name: 'angular-resource',
            version: '1.3.8',
          },
          {
            name: 'angular-route',
            version: '1.2.24',
          },
          {
            name: 'angular-sanitize',
            version: '1.4.0-build.3838+sha.5b52286',
          },
          {
            name: 'angular-strap',
            version: '2.2.0',
          },
          {
            name: 'angular-toggle-switch',
            version: '1.0.0',
          },
          {
            name: 'angular-touch',
            version: 'v1.2.24',
          },
          {
            name: 'angular-translate',
            version: '2.2.0',
          },
          {
            name: 'angular-translate-handler-log',
            version: '2.0.1',
          },
          {
            name: 'angular-translate-loader-partial',
            version: '2.6.1',
          },
          {
            name: 'angular-translate-loader-static-files',
            version: '2.2.0',
          },
          {
            name: 'angular-ui-calendar',
            version: '1.0.1',
          },
          {
            name: 'angular-validator',
            version: '0.2.3',
          },
          {
            name: 'angular-x2js',
            version: '0.1.1',
          },
          {
            name: 'angular-xeditable',
            version: '0.1.9',
          },
          {
            name: 'angularjs-nvd3-directives',
            version: '0.0.7',
          },
          {
            name: 'spectrum',
            version: '1.7.1',
          },
          {
            name: 'bootstrap',
            version: '3.2.0',
          },
          {
            name: 'bootstrap-css-only',
            version: '',
          },
          {
            name: 'Chartist',
            version: '0.7.3',
          },
          {
            name: 'clipboard',
            version: '1.5.12',
          },
          {
            name: 'closure-library',
            version: '',
          },
          {
            name: 'CodeMirror',
            version: '',
          },
          {
            name: 'colpick Color Picker',
            version: '',
          },
          {
            name: 'crosstab',
            version: 'v0.2.10',
          },
          {
            name: 'd3',
            version: '3.5.6',
          },
          {
            name: 'dragula',
            version: '',
          },
          {
            name: 'dropzone',
            version: '4.0.1',
          },
          {
            name: 'EaselJS',
            version: '',
          },
          {
            name: 'font-awesome',
            version: '4.3.0',
          },
          {
            name: 'fullcalendar',
            version: '2.3.1',
          },
          {
            name: 'interact',
            version: '1.2.4',
          },
          {
            name: 'jquery',
            version: '2.1.1',
          },
          {
            name: 'moment',
            version: '2.12.0',
          },
          {
            name: 'ngBonita',
            version: '1.1.1',
          },
          {
            name: 'ng-csv',
            version: '0.3.1',
          },
          {
            name: 'ngPopup',
            version: '0.3.0',
          },
          {
            name: 'ng-table',
            version: '0.3.2',
          },
          {
            name: 'ng-table-export',
            version: '0.1.0',
          },
          {
            name: 'ngCordova',
            version: '0.1.26-alpha',
          },
          {
            name: 'ngDialog',
            version: '0.3.0',
          },
          {
            name: 'ngDraggable',
            version: '0.1.4',
          },
          {
            name: 'ngLocale',
            version: '',
          },
          {
            name: 'ngprogress',
            version: '1.1.3',
          },
          {
            name: 'nvd3',
            version: '1.8.1',
          },
          {
            name: 'OpenLayers',
            version: '4.0.1',
          },
          {
            name: 'opentype',
            version: '',
          },
          {
            name: 'palette',
            version: '',
          },
          {
            name: 'proj4',
            version: '2.3.10-alpha',
          },
          {
            name: 'rangy',
            version: '1.2.3',
          },
          {
            name: 'requirejs',
            version: '2.1.15',
          },
          {
            name: 'textAngular',
            version: '1.3.11',
          },
          {
            name: 'tierce',
            version: '',
          },
          {
            name: 'toastr',
            version: '2.0.3',
          },
        ];
      },
    };
  };
  versionlibwidget.$inject = ['gcPopup', 'VersionFactory'];
  return versionlibwidget;
});
