'use strict';
define(function() {
  var CarteAppFactory = function(
    $http,
    FeatureTypeFactory,
    $filter,
    $rootScope,
    $location,
    HpoAppFactory,
    CarteAppFactory,
    InitProvider,
    CarteInitProvider
  ) {
    function getAppFactory() {
      if ($rootScope.xgos && $rootScope.xgos.sector === 'hpo')
        return HpoAppFactory;
      else {
        return CarteAppFactory;
      }
    }

    function getInitProvider() {
      if ($rootScope.xgos && $rootScope.xgos.sector === 'hpo')
        return InitProvider;
      else {
        return CarteInitProvider;
      }
    }

    return {
      getAppFactory: getAppFactory,
      getInitProvider: getInitProvider,
    };
  };
  CarteAppFactory.$inject = [
    '$http',
    'FeatureTypeFactory',
    '$filter',
    '$rootScope',
    '$location',
    'HpoAppFactory',
    'CarteAppFactory',
    'InitProvider',
    'CarteInitProvider',
  ];
  return CarteAppFactory;
});
