'use strict';

define(function() {
  /*
   * SirocoNavigationCtrl
   */
  var SirocoNavigationCtrl = function(
    $scope,
    $location,
    SirocoFactory,
    ParametersFactory,
    $rootScope
  ) {
    var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));
    var disabled_results = true;

    $scope.sirocoNotValidated = true;

    if (sirocoCfg == null) {
      SirocoFactory.getSirocoCfg().then(function() {
        var sirocoCfg = JSON.parse(sessionStorage.getItem('sirocoCfg'));
        if (sirocoCfg.mainConfig.validation_faite) {
          activateNavigationInit();
        }
      });
    } else {
      if (sirocoCfg.mainConfig.validation_faite)
        $scope.sirocoNotValidated = false;
    }

    SirocoFactory.upgradeDataModel().then(function() {});

    // if siroco_variante_selectionnee is set, activate navigation results links
    ParametersFactory.getbytype('siroco_variante_selectionnee').then(function(
      res
    ) {
      if (res.data.length > 0) activateNavigationResults();
    });

    var search = $location.url().split('?');
    $scope.urlParameters = '';
    if (search.length > 1) {
      $scope.urlParameters = '?' + search[1];
    }

    $scope.getSirocoNotValidated = function() {
      return $scope.sirocoNotValidated;
    };

    $scope.initNavigation = {
      main_title: 'siroco.navigation.init.title',
      icon: 'picture',
      subs: [
        {
          label: 'siroco.navigation.init.sig_to_siroco',
          icon: 'power-off',
          target: 'siroco/init',
          visible: true,
        },
        {
          label: 'siroco.navigation.init.map',
          icon: 'globe',
          target: 'siroco/map',
          visible: true,
          disabled: $scope.getSirocoNotValidated(),
        },
        {
          label: 'siroco.navigation.init.casses',
          icon: 'download',
          target: 'siroco/casses',
          visible: true,
          disabled: $scope.getSirocoNotValidated(),
        },
        {
          label: 'siroco.navigation.init.parameters',
          icon: 'cog',
          target: 'siroco/parameters',
          visible: true,
          disabled: $scope.getSirocoNotValidated(),
        },
        /*{label: "siroco.navigation.init.expert_parameters", icon: "cogs", target:"siroco/expert_parameters", visible: true}*/
      ],
    };
    $scope.optimizationNavigation = {
      main_title: 'siroco.navigation.optimization.title',
      icon: 'picture',
      subs: [
        {
          label: 'siroco.navigation.optimization.criterias',
          icon: 'list-alt',
          target: 'siroco/ponderation',
          visible: true,
          disabled: $scope.getSirocoNotValidated(),
        },
        /*   {label: "siroco.navigation.optimization.criticality", icon: "cubes", target:"siroco/criticality", visible: true},*/
        {
          label: 'siroco.navigation.optimization.scenarii',
          icon: 'cube',
          target: 'siroco/scenarii',
          visible: true,
          disabled: $scope.getSirocoNotValidated(),
        },
        {
          label: 'siroco.navigation.optimization.scenarii_comparison',
          icon: 'list',
          target: 'siroco/scenarii_comparison',
          visible: true,
          disabled: $scope.getSirocoNotValidated(),
        },
        {
          label: 'siroco.navigation.optimization.refine',
          icon: 'cubes',
          target: 'siroco/refine',
          visible: true,
          disabled: $scope.getSirocoNotValidated(),
        },
      ],
    };
    $scope.exploitationNavigation = {
      main_title: 'siroco.navigation.exploitation.title',
      icon: 'picture',
      subs: [
        {
          label: 'siroco.navigation.exploitation.sites',
          icon: 'map-o',
          target: 'siroco/sites',
          visible: true,
          disabled: disabled_results,
        },
        {
          label: 'siroco.navigation.exploitation.sites_planning',
          icon: 'calendar',
          target: 'siroco/sites_planning',
          visible: true,
          disabled: disabled_results,
        },
      ],
    };
    $scope.exportNavigation = {
      main_title: 'siroco.navigation.export.title',
      icon: 'picture',
      subs: [
        //{label: "siroco.navigation.export.print", icon: "print", target:"siroco/print", visible: true, disabled: disabled_results},
        {
          label: 'siroco.navigation.export.sites_list',
          icon: 'file-o',
          target: 'siroco/sites_list',
          visible: true,
          disabled: disabled_results,
        },
        {
          label: 'siroco.navigation.export.schedule',
          icon: 'calendar-check-o',
          target: 'siroco/schedule',
          visible: true,
          disabled: disabled_results,
        },
        {
          label: 'siroco.navigation.export.gis',
          icon: 'download',
          target: 'siroco/gis',
          visible: true,
          disabled: disabled_results,
        },
      ],
    };

    var activateNavigationInit = function() {
      $scope.optimizationNavigation.subs.forEach(function(x) {
        x.disabled = false;
      });
      $scope.initNavigation.subs.forEach(function(x) {
        x.disabled = false;
      });
    };

    var activateNavigationResults = function() {
      $scope.exploitationNavigation.subs.forEach(function(x) {
        x.disabled = false;
      });
      $scope.exportNavigation.subs.forEach(function(x) {
        x.disabled = false;
      });
    };
    $rootScope.$on('siroco.activateNavigationInit', function() {
      activateNavigationInit();
    });
    $rootScope.$on('siroco.activateNavigationResults', function() {
      activateNavigationResults();
    });

    /**
     * Returns if the current page is the one selected in the nav bar
     *
     * @param path
     * @returns {boolean}
     */
    $scope.isCurrentPath = function(path) {
      if (typeof path == 'string') {
        return $location.path().replace(/\//g, '') == path.replace(/\//g, '');
      } else {
        return path.indexOf($location.path()) !== -1;
      }
    };
  };

  SirocoNavigationCtrl.$inject = [
    '$scope',
    '$location',
    'SirocoFactory',
    'ParametersFactory',
    '$rootScope',
  ];
  return SirocoNavigationCtrl;
});
