'use strict';
define(function() {
  var gcelement = function(
    gclayers,
    $timeout,
    gcRestrictionProvider,
    gcInteractions,
    FeatureTypeFactory,
    gcWFS
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/edit/views/gceditline.html',
      restrict: 'A',
      scope: {
        map: '=map',
        res: '=res',
        onclick: '&?onclick',
        onfinish: '&?onfinish',
        drawinteraction: '=?drawinteraction',
        snaptolerance: '=snaptolerance',
        isActive: '=?isactive',
        ftid: '=ftid',
        toolbarwidget: '=?toolbarwidget',
        disabled: '=disabled'
      },
      link: function(scope, element, attrs) {
        scope.geom = {};
        scope.drawinteraction = {};
        scope.feature = '';
        scope.isActive = false;
        scope.onfinish = scope.onfinish || function () {};
        //Recuperation du fti du comosant if there is a ftid
        if (scope.ftid) { // Make sure that there is a ftid
          scope.fti = FeatureTypeFactory.getFeatureByUid(scope.ftid);
        }
        // Functions snap interaction
        function getSnapRule() {
          var fti = scope.fti;

          if (!fti || !fti.uid) fti = scope.$parent.$parent.selectfti;

          var ruleSnap = undefined;

          if (angular.isDefined(fti)) {
            var rules = fti.rules || [];

            for (var i = 0; i < rules.length; i++) {
              if (rules[i].name == 'SnapOn') {
                ruleSnap = rules[i];
              }
            }
          }

          return ruleSnap;
        }
        function snapOn(ruleConf) {
          //var ruleConf = getSnapRule();
          var layersToLoad = [];
          var layers = gclayers.getOperationalLayer();
          var layerNames = ruleConf.parameters['layers'];
          //Pour chaque nom de layer en config de cette règle
          for (var j = 0; j < layerNames.length; j++) {
            var name = layerNames[j].name;
            //Pour chaque layer opérationelle
            for (var i = 0; i < layers.length; i++) {
              var l = layers[i];
              if (l.name == undefined) continue;
              if (name == l.name) {
                var fti = l.fti;
                layersToLoad.push(fti);
                break;
              }
            }
          }
          //Chargement des objets des couches sur lesquelles s'accrocher
          var wfsLayer = gcWFS.getOlLayerFromFeaturetypeInfoArray(layersToLoad,scope.map);
          //map.addLayer(wfsLayer);
          gclayers.addSnapLayer(wfsLayer);
          var srcDrawedDXF = gclayers.getImportLayer().getSource();
          wfsLayer.getSource().addFeatures(srcDrawedDXF.getFeatures());
          if (scope.snaptolerance == undefined) {
            scope.snaptolerance = 20;
          }
          scope.snap = new ol.interaction.Snap({
            source: wfsLayer.getSource(),
            edge: true,
            vertex: true,
            pixelTolerance: scope.snaptolerance,
          });
        }

        function removeWfsLayers() {
          var layersToRemove = [];
          var layers = scope.map.getLayers().getArray();
          for (var i = 0; i < layers.length; i++) {
            var l = layers[i];
            if (l.type == 'wfs') {
              layersToRemove.push(l);
            }
          }
          for (var j = 0; j < layersToRemove.length; j++) {
            scope.map.removeLayer(layersToRemove[j]);
          }
        }


        /**
         * La fin de ligne est un double click.
         * On enleve le zoom par double click, sinon,
         * en même temps que l'on termine la ligne,
         * on fait un zoom et c'est désagréable.
         */
        let removeDblClickZoom = () => {
          scope.dblClickInteraction = undefined;
          // find DoubleClickZoom interaction
          scope.map.getInteractions().getArray().forEach(function(interaction) {
            if (interaction instanceof ol.interaction.DoubleClickZoom) {
              scope.dblClickInteraction = interaction;
              // remove from map
              scope.map.removeInteraction(interaction);
            }
          });
        };


        let resetDblClickZoom = () => {
          if (scope.dblClickInteraction) {
            scope.map.addInteraction(scope.dblClickInteraction);
          }
        };

        /**
         * [removefeatures description]
         * @return {No} [description]
         */
        scope.removefeatures = function() {
          gclayers
            .getDrawLayer()
            .getSource()
            .clear();
          scope.features = {};
        };
        scope.add = function() {
          var map = scope.map;
          map.removeInteraction(scope.drawinteraction);
          var ruleConf = getSnapRule();
          if (ruleConf != undefined) {
            scope.map.removeInteraction(scope.snap);
            map.dispatchEvent({ type: 'snapRemovedEvent' });
            removeWfsLayers();
          }

          if (
            scope.isActive &&
            scope.drawinteraction &&
            scope.drawinteraction.getActive()
          ) {
            if (
              scope.drawinteraction &&
              scope.drawinteraction instanceof ol.interaction.Draw
            )
              scope.drawinteraction.setActive(false);
            map.removeInteraction(scope.drawinteraction);
            scope.removefeatures();
            scope.isActive = false;
            ruleConf = getSnapRule();
            if (ruleConf != undefined) {
              scope.map.removeInteraction(scope.snap);
              map.dispatchEvent({ type: 'snapRemovedEvent' });
              removeWfsLayers();
            }
          } else {
            scope.isActive = true;
          }

          if (scope.isActive) {
            scope.drawinteraction = new ol.interaction.Draw({
              source: gclayers.getDrawLayer().getSource(),
              type: 'LineString',
            });

            scope.drawinteraction.set('gctype', 'kis');
            scope.drawinteraction.set('interaction', 'Draw');
            scope.drawinteraction.set('widget', 'editionoutil' + Math.random());
            scope.drawinteraction.setActive(true);
            gcInteractions.setCurrentToolBar(scope.toolbarwidget);
            map.addInteraction(scope.drawinteraction);
            removeDblClickZoom();
            ruleConf = getSnapRule();
            if (ruleConf != undefined) {
              snapOn(ruleConf);
              scope.map.addInteraction(scope.snap);
              if (
                map
                  .getInteractions()
                  .getArray()
                  .indexOf(scope.snap) !== -1
              ) {
                //Envoi de l'information de l'interaction ajoutée.
                map.dispatchEvent({ type: 'snapAddedEvent' });
              }
            }

            // snapping test on line
            /*snap = new ol.interaction.Snap({source: gclayers.getDrawLayer().getSource()});
            			snap.set('gctype' , 'kis');
            			snap.set('interaction' , 'Snap');
            			snap.set('widget' , "editionoutil");
            			snap.setActive(true);
                        map.addInteraction(snap);*/

            //on start
            scope.drawinteraction.on('drawstart', function() {
              console.log('drawstart');
              scope.test = 'drawstart';
              try {
                scope.$apply(scope);
              } catch(err) {}
            });

            // on end
            scope.drawinteraction.on('drawend', function(evt) {
              //scope.features = evt.feature;
              var format = new ol.format.GeoJSON();

              resetDblClickZoom();

              //console.log( );
              var feature = format.writeFeatureObject(evt.feature);

              if (gcRestrictionProvider.hasRestrictionEdition()) {
                gcRestrictionProvider
                  .GeometryInRestriction(
                    feature.geometry,
                    map.getView().getProjection().getCode()
                  )
                  .then(
                    function(res) {
                      if (JSON.parse(res.data)) {
                        scope.drawinteraction.setActive(false);
                        map.removeInteraction(scope.drawinteraction);
                        var ruleConf = getSnapRule();
                        if (ruleConf != undefined) {
                          scope.map.removeInteraction(scope.snap);
                          map.dispatchEvent({
                            type: 'snapRemovedEvent',
                          });
                          removeWfsLayers();
                        }
                        /*snap.setActive(false);
					map.removeInteraction(snap);*/
                        scope.isActive = false;
                        //scope.res = scope.feature;
                        scope.onfinish();
                        $timeout(function() {
                          scope.res = feature.geometry;
                        });
                      } else {
                        gcRestrictionProvider.showErrorMessage();
                        scope.onfinish();
                      }
                    },
                    function(res) {
                      console.error(res.data);
                    }
                  );
              } else {
                scope.drawinteraction.setActive(false);
                map.removeInteraction(scope.drawinteraction);
                var ruleConf = getSnapRule();
                if (ruleConf != undefined) {
                  scope.map.removeInteraction(scope.snap);
                  map.dispatchEvent({
                    type: 'snapRemovedEvent',
                  });
                  removeWfsLayers();
                }
                /*snap.setActive(false);
				map.removeInteraction(snap);*/
                scope.isActive = false;
                //scope.res = scope.feature;
                scope.onfinish();
                $timeout(function() {
                  scope.res = feature.geometry;
                });
              }
            });
            try {
              if (attrs.onclick != undefined) {
                scope.onclick();
              }
            } catch (e) {
              console.error(e);
            }
          }
        };
      },
    };
  };

  gcelement.$inject = [
    'gclayers',
    '$timeout',
    'gcRestrictionProvider',
    'gcInteractions',
    'FeatureTypeFactory',
    'gcWFS',
  ];
  return gcelement;
});
