'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    $filter,
    ElasticFactory,
    $rootScope,
    AncAppFactory,
    BacAppFactory,
    gaJsUtils,
    $timeout,
    attributeRestrictionsUtils
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/elastic/views/elasticRules.html',
      restrict: 'A',
      scope: {
        map: '=?map',
        condition: '=?condition',
        components: '=?components',
        filter: '=?filter',
        onRemove: '&',
        allowFieldsConfiguration: '=?', // allow the user to specifiy rule configuration (ie visibility)
        fieldsConfiguration: '=?', // configuration des champs : visibilite par exemple (utilise dans elasticEditRequest)
        disableAttributeSelection: '=?', //  empeche la selection de l'attribut
        fakeJsonFti: '=?',
        resolvedFilter: '=?',
        ftid: '=?',
        interventionSimpleMode: '=?',
      },
      link: function(scope, element, attrs, ctrl) {
        // intialisation d'un id si inexistant
        if (!angular.isDefined(scope.filter.guid)) {
          scope.filter.guid = gaJsUtils.guid();
        }

        let fti;
        let configFtiWithFtid = (ftid) => {
          fti = FeatureTypeFactory.getFeatureByUid(ftid);
          //avoid empty object
          fti = fti.uid == '' ? undefined : fti;
          if (fti != undefined && scope.filter && (!scope.filter.selectedfti
             || (scope.filter.selectedfti && scope.filter.selectedfti.uid !== fti.uid))) {
            scope.filter.selectedfti = fti;
          } else if (scope.filter.selectedfti && !fti){
            fti = scope.filter.selectedfti;
          }
          if (fti && fti.uid && scope.ftid !== fti.uid) {
            scope.ftid = fti.uid;
          }
        };
        configFtiWithFtid(scope.ftid);
        /**
         * Dans la facturation,  les listes d'attributs viennent de scope.filter directement
         * Donc on ne se base pas sur le ftid.
         */
        if (!scope.filter) {

          scope.$watch('ftid', (newValue, oldValue) => {
            configFtiWithFtid(newValue);
          });
        }

        // handle legacy
        // handle legacy
        if (scope.filter && scope.filter.attr
          && Array.isArray(scope.filter.attr.restrictions)
          && scope.filter.attr.restrictions.length > 0
          && scope.filter.attr.restrictions[0].type === attributeRestrictionsUtils.TABLE
          && scope.filter.tableRestrictionKey) {
          scope.filter.restrictedValue = scope.filter.tableRestrictionKey;
          delete scope.filter.tableRestrictionKey;
        }

        var CurrentAppFactory = scope.applicationType == 'bac' ? BacAppFactory : AncAppFactory;

        var map = scope.map;
        var data = scope.data;

        scope.applicationType = $rootScope.xgos.sector;
        scope.applicationIsAnc =
          scope.applicationType === 'anc' || scope.applicationType === 'bac';
        scope.controleReponseRule = false;
        scope.controleReponseRulev2 = false;
        scope.controleReponseRuleAttribute = {};

        scope.filter.attr = {};
        scope.filter.showAllValues = false;

        // This is a weird hack to make sure these are numbers
        scope.booleans = ['False', 'True'];
        scope.booleansOrder = ['True', 'False'];

        function getDefaultSuggestion(query, field) {
          var q = {
            query: {
              bool: {
                must: {},
              },
            },
          };
          switch (scope.filter.operand) {
            case 'startWith':
              q.query.bool.must.prefix = {};
              q.query.bool.must.prefix[field] = query;
              break;
            case 'endWith':
              q.query.bool.must.regexp = {};
              q.query.bool.must.regexp[field] = '.*' + query;
              break;
            case 'regexp':
              q.query.bool.must.regexp = {};
              q.query.bool.must.regexp[field] = '.*' + query + '.*';
              break;
            case 'equals':
            case 'boolean':
              q.query.bool.must.regexp = {};
              q.query.bool.must.regexp[field] = '.*' + query + '.*';
              break;
            case 'notEquals':
              q.query.bool.must.regexp = {};
              q.query.bool.must.regexp[field] = '.*' + query + '.*';
              break;
            case 'include':
              q.query.bool.must.terms = {};
              q.query.bool.must.terms[field] = query.split(',');
              break;
          }
          return q;
        }

        scope.howToUser = function() {
          swal({
            title: $filter('translate')('elastic.search.info'),
            text: $filter('translate')('elastic.search.useparmi'),
            type: 'info',
          });
        };

        function getDefaultSuggestionTerm(query, field) {
          var q = {
            query: {
              bool: {
                must: {
                  term: {},
                },
              },
            },
          };
          q.query.bool.must.term[field] = query;
          return q;
        }

        scope.cleanFieldValue = function(filter) {
          ElasticFactory.cleanFieldValue(filter);
        };

        try {
          var index = scope.components
            .map(function(x) {
              return x.alias;
            })
            .indexOf(scope.condition.selectGlobaladvancedFti);
          scope.controleReponseRule = false;

          if (index === -1) {
            // anc : dossier_controle_reponse
            // ancienne version qui est remplacée par @RB nouvelle facon de gérer les controles json
            // on laisse actif pour le moment pour la retrocompatibilité
            if (scope.applicationIsAnc) {
              //console.log(scope.condition.selectGlobaladvancedFti);

              var indexCtrlAnc = CurrentAppFactory.appCfg.main.controleCfg
                .map(function(c) {
                  return c.label_court;
                })
                .indexOf(scope.condition.selectGlobaladvancedFti);
              if (indexCtrlAnc === -1) {
                require('toastr').error(
                  $filter('translate')('elastic.search.indexElementtoUse')
                );
                scope.onRemove();
              } else {
                // construction d' un objet fakeCtrlReponseFti pour alimenter le reste des comportements
                scope.controleReponseRule = true;

                CurrentAppFactory.getBuildedFakeCtrlReponseFtiForElasticSearch(
                  CurrentAppFactory.appCfg.main.controleCfg[indexCtrlAnc].type
                ).then(function(res) {
                  scope.filter.selectedfti = res;
                  scope.filter.attributesaliases = scope.filter.selectedfti.attributes.map(
                    function(x) {
                      return x;
                    }
                  );

                  // correction du fait que l'option n'est pas recuperee quand on ouvre une requete existante
                  //console.log('ici');
                  //alert('ici')

                  if (angular.isDefined(scope.filter.att)) {
                    var attr = scope.filter.attributesaliases.filter(function(
                      x
                    ) {
                      return x.name == scope.filter.att;
                    });
                    //console.log(attr);
                    if (attr.length) scope.filter.attr = attr[0];
                  }
                });
              }
            } else {
              require('toastr').error(
                $filter('translate')('elastic.search.cannotFindComponent')
                + ': ' + scope.condition.selectGlobaladvancedFti
              );
              scope.onRemove();
            }
          } else {
            // @RB nouvelle facon de gérer les controles json
            if (scope.applicationIsAnc) {
              var checkCtrlAlias = FeatureTypeFactory.resources.featuretypes.filter(
                function(x) {
                  return scope.applicationType === 'bac'
                    ? x.name == 'kis_bac_dossier_controle'
                    : x.name == 'kis_anc_dossier_controle';
                }
              );
            }

            if (
              scope.applicationIsAnc &&
              scope.components[index].name == checkCtrlAlias[0].name
            ) {
              scope.controleReponseRulev2 = true;
              if (!scope.resolvedFilter) {
                scope.$watch('fakeJsonFti', function() {
                  $timeout(function() {
                    scope.filter.selectedfti = scope.components[index];
                    scope.filter.attributesaliases = scope.filter.selectedfti.attributes;
                    if (scope.filter.name || scope.filter.attr) {
                      const attrName = scope.filter.attr && scope.filter.attr.name || scope.filter.name;
                      const attr = scope.filter.attributesaliases.find(attributeAlias => attributeAlias.name === attrName);
                      if (attr) {
                        scope.filter.attr = Object.assign(scope.filter.attr || {}, attr);
                        scope.filter.att = Object.assign(scope.filter.att || {}, attr);
                      }
                    }
                  });

                // chargement d'une requete existante
                // if (angular.isDefined(scope.filter.att) && angular.isUndefined(scope.filter.attr) && scope.filter.att.alias.indexOf("json_") == 0) {
                // if (angular.isDefined(scope.filter.att) && angular.isUndefined(scope.filter.attr) && scope.filter.att.isCtrJsonAttribute == 0) {
                //     var idx = scope.filter.attributesaliases.map(function (x) {
                //         return x.alias;
                //     }).indexOf(scope.filter.att.alias);
                //     scope.filter.attr = scope.filter.attributesaliases[idx];
                // }
                });
              }
            } else {
              scope.filter.selectedfti = FeatureTypeFactory.resources.featuretypes[index];
              scope.filter.attributesaliases = scope.filter.selectedfti.attributes.map(
                function(x) {
                  return x.alias;
                }
              );
            }
          }
        } catch (e) {
          FeatureTypeFactory.get().then(function(res) {
            if (angular.isDefined(scope.condition)) {
              const index = FeatureTypeFactory.resources.featuretypes
                .map(function(x) {
                  if (x.inElasticSearch) return x.alias;
                })
                .indexOf(scope.condition.selectGlobaladvancedFti);
              if(index > -1) {
                scope.filter.selectedfti = FeatureTypeFactory.resources.featuretypes[index];
              }
              scope.filter.attributesaliases = scope.filter.selectedfti.attributes.map(
                function(x) {
                  return x.alias;
                }
              );
            }
          });
        }

        /* displayTranslatedAlias
         * @param alias
         * @returns {string}
         */
        scope.displayTranslatedAlias = function(alias) {
          let attribute;
          if (scope.filter && scope.filter.selectedfti
            && Array.isArray(scope.filter.selectedfti.attributes)) {
            attribute = scope.filter.selectedfti.attributes.find(x => x.alias === alias);
          }
          if (!attribute) { return alias; }
          const name = attribute.name;
          const key =
            'features.' +
            scope.filter.selectedfti.name +
            '.properties.' +
            name;

          return !~$filter('translate')(key).indexOf(key)
            ? $filter('translate')(key)
            : alias;
        };

        scope.translateValueItem = (item) => {
          if (!scope.filter.attr || !scope.filter.attr.name || scope.filter.attr.name.indexOf('extraFormFields.') !== 0) {
            return item;
          }
          let extraFormFieldFound;
          try {
            extraFormFieldFound = CurrentAppFactory.appCfg.main.properties.extraFormFields.fields.find(extraFormField => extraFormField.attribute === scope.filter.attr.name.split('.')[1]);
          } catch(err) { return item; }
          if (!extraFormFieldFound) { return item; }

          const key = 'features.' +
            extraFormFieldFound.origine +
            '.domaine.' +
            extraFormFieldFound.attribute +
            '.' +
            item;
          return !~$filter('translate')(key).indexOf(key)
            ? $filter('translate')(key)
            : item;
        };

        scope.$watch('filter.att', function(newval, oldval) {
          if (newval) {
            if (!scope.controleReponseRule && !scope.controleReponseRulev2) {
              if (fti && fti.attributes) {
                let correctAttribute;
                if (scope.filter.selectedfti.attributes) {
                  //if we are in ANC facturation
                  correctAttribute = scope.filter.selectedfti.attributes.find(
                    attribute => attribute.alias === newval);
                } else {
                  correctAttribute = fti.attributes.find(attribute => {
                    return attribute.alias == newval;
                  });
                }
                if (correctAttribute) {
                  scope.filter.attr = correctAttribute;
                } else {
                  // this case can happen if the alias as been changed since last time we configured the filter
                  // let's find the alias for the current name
                  if (scope.filter.name) {
                    scope.filter.attr = fti.attributes.find(attribute => {
                      return attribute.name == scope.filter.name;
                    });
                  }
                }
                if (scope.filter.attr) {
                  scope.filter.att = scope.filter.attr.alias;
                }
              }
              //scope.filter.operand = undefined;
              //scope.filter.value = undefined;

              // kis_anc_controle_reponse
            } else {
              // a effacer le moment venu
              if (scope.controleReponseRule) {
                var index = scope.filter.attributesaliases
                  .map(function(x) {
                    return x.alias;
                  })
                  .indexOf(newval);
                scope.filter.attr = scope.filter.attributesaliases[index];
              }

              if (scope.controleReponseRulev2) {
                $timeout(function() {
                  var index = scope.filter.attributesaliases
                    .map(function(x) {
                      return x.alias;
                    })
                    .indexOf(newval.alias);
                  scope.filter.attr = scope.filter.attributesaliases[index];
                });
              }
            }
          }
        });

        scope.setLabel = function() {
          scope.filter.label = scope.filter.att;
        };

        scope.inputNeeded = function() {
          var needs = [
            'startWith',
            'endWith',
            'regexp',
            'equals',
            'notEquals',
            'include',
            'gt',
            'gte',
            'lt',
            'lte',
          ];

          return ~needs.indexOf(scope.filter.operand);
        };
        scope.inputFloatNeeded = function() {
          var needs = ['equals', 'gt', 'gte', 'lt', 'lte'];

          return ~needs.indexOf(scope.filter.operand);
        };

        scope.inputBooleanNeeded = function() {
          var needs = ['equals'];

          return ~needs.indexOf(scope.filter.operand);
        };

        scope.inputdayNeeded = function() {
          var needs = ['last', 'next'];

          return ~needs.indexOf(scope.filter.operand);
        };

        scope.inputRestrictionNeeded = function() {
          var needs = ['equals', 'notEquals'];

          return ~needs.indexOf(scope.filter.operand);
        };

        scope.isInputHidden = function() {
          return ~['exists', 'notExists'].indexOf(scope.filter.operand);
        };

        // On regarde la liste
        scope.$watch('filter.attr', function(newVal, oldVal) {
          if (angular.isDefined(newVal) && Object.keys(newVal).length) {
            scope.filter.name = scope.filter.attr.name;
            scope.filter.type = scope.filter.attr.type;
            scope.autocompleteglobalsearch = [];
            scope.filter.showAllValues = false;
          }
        });

        if (!scope.autocompleteglobalsearch)
          scope.autocompleteglobalsearch = [];

        scope.$watch(
          'filter.newValueUtil',
          function(newval) {
            if (!newval || !newval[Object.keys(newval)[0]]) return;
            scope.filter.value = newval[Object.keys(newval)[0]];
          },
          1
        );

        scope.$watch('filter.value', function(newVal) {
          if (newVal && !scope.filter.showAllValues
            && scope.interventionSimpleMode == undefined) {
            var types = ['java.lang.String'];
            if (
              angular.isDefined(scope.filter.attr) &&
              types.indexOf(scope.filter.attr.type) !== -1 &&
              ((typeof newVal === 'string' && newVal.length > 0) ||
                typeof newVal === 'number')
            ) {
              if (typeof newVal === 'string' || newVal instanceof String) {
                var str = newVal.split(' ')[newVal.split(' ').length - 1];
                var query = getDefaultSuggestion(str, scope.filter.attr.name);
                var promise = ElasticFactory.getSuggestionsFromType(
                  str,
                  query,
                  scope.filter.selectedfti.name,
                  scope.filter.attr.name
                );
                promise.then(
                  function(res) {
                    if (res.data.length > 0) {
                      scope.autocompleteglobalsearch = res.data.map(function(x) {
                        var data = newVal.replace(str, '');
                        return data + x;
                      });
                    } else {
                      scope.autocompleteglobalsearch = [];
                    }
                  },
                  function(res) {
                    console.error(res);
                    scope.autocompleteglobalsearch = [];
                  }
                );
              }
            }
          }
        });

        scope.clickedCheckbox = function() {
          scope.filter.value = scope.autocompleteglobalsearchinclude
            .map(function(x) {
              if (x.selected) return x.name;
            })
            .filter(function(x) {
              if (x) return x;
            })
            .join(',');
        };

        scope.listes_deroulantes_controles = FeatureTypeFactory.getFeatureByUid(
          scope.applicationType === 'bac'
            ?'kis_bac_listes_deroulantes_controles'
            :'kis_anc_listes_deroulantes_controles'
        );

        const checkAndRepaceSearchListeDeroulanteKeyWithValues = ()=> {
          if (scope.filter.attr.name
            && Array.isArray(scope.autocompleteglobalsearch)
            && scope.autocompleteglobalsearch.length > 0){
            const attributeName = scope.filter.attr.name.lastIndexOf('.') > -1
              ? getObjectLastPropertyName(scope.filter.attr.name)
              :scope.filter.attr.name;

            const attr = scope.listes_deroulantes_controles.attributes.find(
              (x)=> { return x.name == attributeName; });

            if (attr) {
              if (attr.restrictions.length) {
                const restrictions = attr.restrictions[0].listofValues;
                scope.autocompleteglobalsearch = scope.autocompleteglobalsearch
                  .map((key)=>{ return restrictions[key] || key; });
              }
            }
          }
        };

        const getObjectLastPropertyName = (name)=>{
          return name.split('.').pop();
        };

        var setVillesDespRegieAnc = function(operand) {
          var villes = AncAppFactory.appCfg.main.infosSpancListeVillesCfg
            .filter(function(x) {
              return (
                x.gere_spanc == true &&
                (operand == 'anc_ville_regie'
                  ? x.dsp_regie == '1'
                  : x.dsp_regie == '0')
              );
            })
            .map(function(x) {
              return x.value;
            });

          console.log(operand + ' ---> ' + villes.join(','));

          return villes.join(',');
        };

        scope.checkOperandAnc = function(filter) {
          if (!angular.isDefined(filter)) return;
          if (
            filter.operand == 'anc_ville_regie' ||
            filter.operand == 'anc_ville_dsp'
          ) {
            filter.value = setVillesDespRegieAnc(filter.operand);
          }
        };

        /**
         * Limite l'affichage du label à 25 caractères
         * @param label label du champ de formulaire IS
         * @returns {string|*} label limité à 25 caractères
         */
        scope.truncateLabel = (label) => {
          return label.length>25 ? label.substring(0,22) + '...' : label;
        };

        /**
         * set  the operator to default value if it's undefined
         * attention! sometimes the operator is named "operand" in the code
         * (the operator is named operand in the forms data)
         * @param {object} filter
         * @param {string} defaultValue
         */
        scope.initOperator = function (filter, defaultValue) {
          filter.operand = filter.operand ? filter.operand : defaultValue;
        };

        /**
         * Vérifie si le formIS est en mode édition ou rendu
         * d'après le boolean disableAttributeSelection
         * @returns {boolean} true si le form IS est en mode édition
         */
        scope.isEditMode = () => {
          return !scope.disableAttributeSelection;
        };

        /**
         * concat the label and the operator
         * take the alias as label if there is no label
         * @param {object} filter
         * @returns
         */
        scope.getLabelAndOperator = function (filter) {
          let formatedString;
          if (filter) {
            //on vérifie si le champ possède un label
            if (filter.label) {
              formatedString = filter.label + scope.getOperatorString(filter.operand, filter.attr.type);
            } else {
              formatedString = filter.att + scope.getOperatorString(filter.operand, filter.attr.type);
            }
            return formatedString;
          }
          return '';
        };

        /**
         * takes the alias as label if there is no label
         * @param {object} filter
         * @returns
         */
        scope.getLabel = function (filter) {
          let formatedString;
          if (filter) {
            //on vérifie si le champ possède un label
            if (filter.label) {
              return filter.label;
            } else {
              return filter.att;
            }
          } else {
            return '';
          }
        };

        /**
         * format and eventually translate the operator
         *  attention! sometimes the operator is named "operand" in the code
         *  (the operator is named operand in the forms data)
         * @param {*} operatorValue
         * @returns the operator formated as string
         */
        scope.getOperatorString = function (operatorValue, attributeType) {
          let operatorString = ' ';
          if(operatorValue){
            switch (operatorValue) {
              case 'startWith':
                operatorString += $filter('translate')('elastic.search.rule.startswith');
                break;
              case 'endWith':
                operatorString += $filter('translate')('elastic.search.rule.endswith');
                break;
              case 'regexp':
                operatorString += $filter('translate')('elastic.search.rule.contains');
                break;
              case 'equals':
                if (attributeType === 'java.lang.String') {
                  operatorString += $filter('translate')('elastic.search.rule.equals');
                } else {
                  operatorString += '=';
                }
                break;
              case 'notEquals':
                operatorString += $filter('translate')('elastic.search.rule.notequals');
                break;
              case 'include':
                // is included in a list of value
                operatorString += $filter('translate')('elastic.search.rule.include');
                break;
              case 'gt':
                // '>' greater than
                operatorString += '>';
                break;
              case 'gte':
                // '>=' greater than or equals
                operatorString += '≥';
                break;
              case 'lt':
                // '<'
                operatorString += '<';
                break;
              case 'lte':
                // '<='
                operatorString += '≤';
                break;
              case 'exists':
                operatorString += $filter('translate')('elastic.search.rule.exists');
                break;
              case 'notExists':
                operatorString += $filter('translate')('elastic.search.rule.notexists');
                break;
              case 'last':
                operatorString += $filter('translate')('elastic.search.rule.last');
                break;
              case 'next':
                operatorString += $filter('translate')('elastic.search.rule.next');
                break;
              default:
                //leave operatorString empty
                break;
            }
          }
          return operatorString;
        };
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    '$filter',
    'ElasticFactory',
    '$rootScope',
    'AncAppFactory',
    'BacAppFactory',
    'gaJsUtils',
    '$timeout',
    'attributeRestrictionsUtils'
  ];
  return gcelement;
});
