'use strict';
define(function() {
  var getBranchesCondition = function(tab, conditions) {
    if (!angular.isDefined(conditions)) conditions = [];
    for (var i in tab) {
      var cfg = tab[i].cfg;
      if (angular.isDefined(cfg) && cfg.displayCondition) {
        // seulement si on watch une variable
        if (
          cfg.displayCondition.active &&
          cfg.displayCondition.variable.indexOf('$') != -1
        ) {
          conditions.push({
            branch: tab[i],
            displayCondition: cfg.displayCondition,
          });
        }
      }
      // subbranches
      if (tab[i].children.length) {
        var subBranches = getBranchesCondition(tab[i].children);
        for (var j in subBranches) conditions.push(subBranches[j]);
      }
    }
    return conditions;
  };

  var gcelement = function(
    gcformfunction,
    $timeout,
    $rootScope,
    FeatureTypeFactory,
    UsersFactory,
    $q,
    EditFactory,
    gaDomUtils,
    gaJsUtils,
    mapJsUtils,
    defaultFiltersFactory,
    gclayers,
    $filter,
    ngDialog,
    AssociationFactory,
    SelectManager,
    attributeRestrictionsUtils,
    FeatureAttachmentFactory,
    isUtils,
    IndigauFormFactory
  ) {
    return {
      templateUrl: 'js/XG/widgets/utilities/form/views/formRender.html',
      restrict: 'A',
      scope: {
        map: '=map',
        onload: '=onload',
        fti: '=fti',
        res: '=res',
        templateform: '=templateform',
        editsession: '=editsession',
        relationholddata: '=relationholddata',
        chainpopup: '=chainpopup',
        editdescription: '=editdescription',
        ftisToUse: '=?',
        noDefaultEdit: '=?', // For datatable hide edit button
        onvalidate: '&',
        groupedattribute: '=?',
        dlgPopup: '=',
        // interventionSimpleWithoutSearchTab -> true si on ouvre l'intervention simple en mode 'withoutSearchTab'
        // cela permet d'utiliser une intervention simple comme si c'était un formulaire normal.
        // on passe directement en parametre l'objet à modifier: res.current
        // dans ce mode: -on ouvre l'intervention sur le dernier onglet (onglet édition)
        //               -l'onglet liste contient un objet correspondant à res.current
        //               -on masque le volet recherche
        interventionSimpleWithoutSearchTab: '=?'
      },
      controller: [
        '$scope',
        function($scope) {
          // need to declare it in the controller before abn tree gets instanciated....
          $scope.feattree = {};
          $scope.hasTree = angular.isArray($scope.templateform.data);

          // need to be sure the list of featureType has been loaded
          if (FeatureTypeFactory.resources.featuretypes.length == 0) {
            FeatureTypeFactory.get();
          }

          // templateForm has to be an array or abntreeview wont init

          // encapsulate within a new object's data key if not no data key is present
          /*   if(!$scope.templateform.hasOwnProperty('data')){
                 var tmp = {};
                 // templateForm has to be an array or abntreeview wont init
                 tmp.data =  !angular.isArray($scope.templateform) ? [$scope.templateform] : $scope.templateform;
                 $scope.templateform = tmp;
                 }*/
          // if(!angular.isArray($scope.templateform)) $scope.templateform = [$scope.templateform];
        },
      ],
      link: function(scope, elt) {
        scope.uploadfile = {};
        scope.callbacks = {};
        scope.removedfile = new Set();

        var _watchers = [];
        scope.xgos = $rootScope.xgos;

        let ObjectsCiblesfakefti = {
          'uid': '3a716ffb-77f4-4ffa-909e-5bae9f581f47',
          'historicFtiUid': null,
          'historicColumnName': null,
          'parameters': null,
          'name': 'ObjectsCiblesfakefti',
          'storeName': 'COMMON',
          'alias': 'ObjectsCiblesfakefti',
          'srid': 'EPSG:3857',
          'attributes': [
            {
              'name': 'Identifiant',
              'alias': 'Identifiant',
              'type': 'java.lang.Integer',
              'isNillable': false,
              'mandatory': false,
              'size': 500,
              'restrictions': [],
              'popup': false,
              'autoCalcul': null,
              'nillable': false,
              '$$hashKey': 'object:6097'
            },
            {
              'name': 'Couche',
              'alias': 'Couche',
              'type': 'java.lang.String',
              'isNillable': false,
              'mandatory': false,
              'size': 500,
              'restrictions': [],
              'popup': false,
              'autoCalcul': null,
              'nillable': false,
              '$$hashKey': 'object:6096'
            },
            {
              'name': 'Alias',
              'alias': 'Alias',
              'type': 'java.lang.String',
              'isNillable': false,
              'mandatory': false,
              'size': 500,
              'restrictions': [],
              'popup': false,
              'autoCalcul': null,
              'nillable': false,
              '$$hashKey': 'object:6095'
            }
          ],
          'relations': [],
          'bbox': null,
          'published': true,
          'type': 'g2c',
          'wms': null,
          'wfs': null,
          'ogcId': '0',
          'ogcProperties': null,
          'wkt': null,
          'geographic': true,
          'typeInfo': 'POLYGON',
          'defaultsAction': null,
          'rules': [],
          'actions': [],
          'isTiledMap': true,
          'hasPopup': false,
          'inElasticSearch': false,
          'theme': 'Default',
          'defaultStyle': '',
          'styles': [],
          'parentLayer': null,
          'processid': null,
          'showFid': true,
          'useDifferentFID': false,
          'esriIdField': 'objectid',
          'fileType': 'db',
          'nameAliasMapping': {
            'Couche': 'Couche',
            'Alias': 'Alias',
            'Identifiant': 'Identifiant'
          },
          '$selected': true,
          'bboxselection': false
        };

        /**
         * addConditionWatcher
         * Ajoute un watcher sur les variables coditionnant l'affichage des branches
         * @param {*} bC
         */
        var addConditionWatcher = function(bC) {
          var _dc = bC.displayCondition,
            _variableName = _dc.variable.replace('$', ''),
            _variableValue = _dc.value;

          _watchers.push(
            scope.$watch(
              'res',
              function(res) {
                var show = false,
                  tmp = gaJsUtils.checkNestedProperty(_variableName, scope.res);

                // la variable existe
                if (tmp) {
                  var valueToCompare = _variableValue;
                  //la value est aussi une variable
                  if (_variableValue && _variableValue.indexOf('$') === 0) {
                    var computedValue = gaJsUtils.checkNestedProperty(
                      _variableValue.replace('$', 'res.'),
                      scope
                    );
                    if (computedValue) valueToCompare = computedValue;
                  }

                  console.log(
                    '---' +
                      _variableName +
                      '(' +
                      _variableValue +
                      ')---> ' +
                      show +
                      '---'
                  );

                  // comparaison des valeurs
                  var operandData = _dc.operand.split('_');
                  switch (operandData[0]) {
                    case 'string':
                      if (operandData[1] == 'equals')
                        show = tmp == valueToCompare;
                      if (operandData[1] == 'differs')
                        show = tmp !== valueToCompare;
                      break;
                    case 'integer':
                      if (operandData[1] == 'equals')
                        show = tmp == valueToCompare;
                      if (operandData[1] == 'gt') show = tmp > valueToCompare;
                      if (operandData[1] == 'gte') show = tmp >= valueToCompare;
                      if (operandData[1] == 'lt') show = tmp < valueToCompare;
                      if (operandData[1] == 'lte') show = tmp <= valueToCompare;
                      if (operandData[1] == 'differs')
                        show = tmp !== valueToCompare;
                      break;
                    case 'date':
                      tmp = new Date(
                        moment(tmp)
                          .hours(0)
                          .minutes(0)
                          .toDate()
                      );
                      valueToCompare = new Date(
                        moment(valueToCompare)
                          .hours(0)
                          .minutes(0)
                          .toDate()
                      );
                      if (operandData[1] == 'equals')
                        show = tmp == valueToCompare;
                      if (operandData[1] == 'gt') show = tmp > valueToCompare;
                      if (operandData[1] == 'gte') show = tmp >= valueToCompare;
                      if (operandData[1] == 'lt') show = tmp < valueToCompare;
                      if (operandData[1] == 'lte') show = tmp <= valueToCompare;
                      if (operandData[1] == 'differs')
                        show = tmp !== valueToCompare;
                      break;
                    case 'boolean':
                      if (operandData[1] == 'true') show = tmp === true;
                      if (operandData[1] == 'false') show = tmp === false;
                      break;
                  }

                  if (
                    !angular.isDefined(valueToCompare) &&
                    operandData[0] != 'boolean'
                  )
                    show = false;
                }

                if (show) {
                  console.log('Trigger affichage branche (formrender)');
                  bC.branch.classes.splice(
                    bC.branch.classes.indexOf('hiddenTreeBranch')
                  );
                } else {
                  console.log('Trigger cache branche (formrender)');
                  if (bC.branch.classes.indexOf('hiddenTreeBranch') == -1) {
                    bC.branch.classes.push('hiddenTreeBranch');
                  }
                }
              },
              1
            )
          );
        };

        // With or without a tree
        scope.curtemplate = {};

        scope.reset = { all: true };
        if (scope.hasTree) {
          //scope.feattree.expand_all();
          $timeout(function() {
            scope.feattree.reset_rows();
            scope.feattree.collapse_all();
            scope.feattree.select_first_branch();
          }, 0);
        } else {
          scope.curtemplate = angular.copy(scope.templateform.data);
          if (
            angular.isDefined(scope.groupedattribute) &&
            scope.groupedattribute
          ) {
            scope.bkp = angular.copy(scope.templateform);
            var tempAttr = [];
            scope.curtemplate.fields.forEach(function(attr) {
              if (angular.isDefined(attr.edit_group) && attr.edit_group)
                tempAttr.push(attr);
            });
            scope.curtemplate.fields = tempAttr;
          }
        }

        /** interventions simples */
        // scope.isObjectActions = [];
        scope.resultdatatable = {};
        if ((scope.templateform.formtype === 'intervention_simple'
          || scope.templateform.formtype === 'table_simple'
          || scope.templateform.formtype === 'recherche_donnees') &&
          angular.isDefined(scope.curtemplate.fti_info)
        ) {
          scope.isComponent = {
            x: angular.copy(
              FeatureTypeFactory.getFeatureByNameAndDatastore(
                scope.curtemplate.fti_info.storeName,
                scope.curtemplate.fti_info.name
              )
            ),
          };
          // scope.isObjectActions = scope.isComponent.x.actions;
        }

        // if multiple feat, get only grouped attribute


        const getFti = () => {
          if (scope.isComponent && scope.isComponent.x) {
            return scope.isComponent.x;
          }
          if (scope.res && scope.res.current && scope.res.current.id) {
            if (scope.res.current.id.indexOf('.') !== -1) {
              return scope.res.current.id.split('.')[0];
            }
          }
        };


        // --------------------------------------------
        // HANDLING GLOBAL EVENTS
        // & branch display conditions
        // --------------------------------------------
        // 09/18 added timeout, or branchevents won't fire
        var checkActions;
        $timeout(function() {
          if (scope.templateform && scope.templateform.events) {
            var objects = {
              res: scope.res,
              feattree: scope.feattree,
              map: scope.map
            };
            var eventWasFired = [];

            checkActions = function(eventOrigin) {
              scope.templateform.events.forEach(function(event, index) {
                //   console.log(event);
                eventWasFired[index] = false;

                // --------------- formEvents --------------------
                if (event.origin.key == 'formEvents') {
                  if (event.origin.type == 'load') {
                    //inclusion dans un timeout pour assurer que objects.res soit mis à jour
                    $timeout(() => {
                      gcformfunction.evaluateExpression(event.actions, objects,
                        undefined, getFti(), eventOrigin);
                      eventWasFired[index] = true;
                    });
                  }
                  if (event.origin.type == 'close') {
                    var id = $('.ngdialog-overlay:last').attr('id');
                    if (id == undefined)
                      id = $('.ngdialog-no-overlay:last').attr('id');
                    $rootScope.$on('ngDialog.closed', function(e, $dialog) {
                      if (id == $dialog.attr('id')) {
                        gcformfunction.evaluateExpression(
                          event.actions, objects, undefined, getFti());
                        eventWasFired[index] = true;
                      }
                    });
                  }
                }
                // --------------- formVariableEvents --------------------
                if (event.origin.key == 'formVariableEvents') {
                  if (event.origin.type == 'load') {
                    var watcher = scope.$watch(
                      'res',
                      function(res, resold) {
                        if (
                          res.hasOwnProperty(event.origin.target) &&
                          !eventWasFired[index]
                        ) {
                          gcformfunction.evaluateExpression(
                            event.actions,
                            objects
                          );
                          eventWasFired[index] = true;
                          watcher();
                        }
                      },
                      1
                    );
                  }
                  if (event.origin.type == 'edit') {
                    scope.$watch(
                      'res',
                      function(res, resold) {
                        if (
                          res.hasOwnProperty(event.origin.target) &&
                          resold.hasOwnProperty(event.origin.target)
                        ) {
                          gcformfunction.evaluateExpression(
                            event.actions,
                            objects
                          );
                          eventWasFired[index] = true;
                        }
                      },
                      1
                    );
                  }
                }
                // --------------- branchEvents --------------------
                if (event.origin.key == 'branchEvents') {
                  scope.branchEvents = [];

                  var dereg = scope.$watch('feattree', function(feattree) {
                    if (Object.keys(feattree).length > 0) {
                      console.log(event.actions);
                      var func = function(branch, prevbranch) {
                        var branchToCheck = gcformfunction._getTreeBranch(
                          feattree,
                          event.origin.target.replace(/'/g, '')
                        );
                        if (
                          event.origin.type == 'enter' &&
                          branch == branchToCheck
                        ) {
                          gcformfunction.evaluateExpression(
                            event.actions,
                            objects
                          );
                        }

                        if (
                          event.origin.type == 'leave' &&
                          branch != branchToCheck &&
                          prevbranch == branchToCheck
                        ) {
                          gcformfunction.evaluateExpression(
                            event.actions,
                            objects
                          );
                        }
                      };
                      scope.branchEvents.push(func);
                      dereg();
                    }
                  });
                }

                // --------------- externalsEvents --------------------
                if (event.origin.key == 'externalsEvents') {
                  if (event.origin.type == 'receiveMessage') {
                    var quotesRemoved = event.origin.target.replace(
                      /['"]+/g,
                      ''
                    );
                    $rootScope.$on(quotesRemoved, function() {
                      gcformfunction.evaluateExpression(event.actions, objects);
                      eventWasFired[index] = true;
                    });
                  }
                }
              });
            };
            if (scope.templateform.formtype !== 'intervention_simple'
              && scope.templateform.formtype !== 'table_simple'
              && scope.templateform.formtype !== 'recherche_donnees') {
              checkActions();
            }
            scope.$on('reloadActions', checkActions);
            // this callbacks will be executed by gcFormFunction
            scope.callbacks.reloadActions = checkActions;
          }

          // condition d'affichage des branches
          if (scope.hasTree) {
            var branchesCondition = getBranchesCondition(
              scope.templateform.data
            );

            // ajout d'un watcher par condition
            for (var i in branchesCondition) {
              //if (branchesCondition[i].displayCondition.variable.split('.').length) {
              addConditionWatcher(branchesCondition[i]);
              //}
            }
          }

          scope.$emit('formRenderLoaded', {});
        }, 0);


        /**
         * Sauvegarde la position des tabs dans les branches
         * @param {} x
         */
        var saveTabPosInBranch = function(x) {
          console.log(x);
          console.log(scope.curbranch.uid);
          if (x != -1) {
            savedTabsPosInOnglets[scope.curbranch.uid] = x;
          }
          console.log(savedTabsPosInOnglets);
        };

        scope.svgPreviousBranch = {};
        var savedTabsPosInOnglets = {};
        var watchTabsPos = false;

        // var _branchWatchers = [];
        scope.tree_handler = function(branch) {
          if (angular.isDefined(scope.branchEvents)) {
            scope.branchEvents.forEach(function(branchEvent) {
              branchEvent(branch, scope.svgPreviousBranch);
            });
          }
          scope.curbranch = branch;
          scope.curtemplate = branch.template;
          scope.svgPreviousBranch = branch;

          scope.curtemplate = angular.copy(branch.template);

          scope.svgPreviousBranch = branch;
          if (!watchTabsPos) {
            watchTabsPos = true;
            // check les changements de branche pour les sauvegarder et les reset
            // quand on revient sur l'onglet
            scope.$watch('curtemplate.activeTab', function(x) {
              saveTabPosInBranch(x);
            });
          }

          // presence d'onglets
          $timeout(function() {
            // si rien n'est set on recupere la valeur precedente (branche deja parse) ou a minima on mets 0
            if (scope.curtemplate.activeTab == -1)
              scope.curtemplate.activeTab = savedTabsPosInOnglets[branch.uid]
                ? savedTabsPosInOnglets[branch.uid]
                : 0;
          });
          if (
            angular.isDefined(scope.groupedattribute) &&
            scope.groupedattribute
          ) {
            scope.bkp = angular.copy(scope.templateform);
            var tempAttr = [];
            scope.curtemplate.fields.forEach(function(attr) {
              if (angular.isDefined(attr.edit_group) && attr.edit_group)
                tempAttr.push(attr);
            });
            scope.curtemplate.fields = tempAttr;
          }
        };

        scope.editObj = function() {
          //alert('Sauvegarde de l\'objet');
        };

        scope.$on('$destroy', function() {
          for (var i in _watchers) {
            console.log('deregWatcher formRender.js');
            _watchers[i]();
          }
        });

        /**
         * Intervention simple
         */
        scope.isTabs = [
          {
            title: 'Recherche',
          },
          {
            title: 'Liste',
          },
          {
            title: 'Édition',
          },
        ];

        scope.editionLeftTabs = [
          { title: 'Attributs', id:'Attributs'},
          { title: 'Pièces jointes', id:'PJ'}
        ];
        if (scope.templateform.formtype === 'intervention_simple') {
          scope.editionLeftTabs.splice(1, 0,
            { title: 'Objets cibles', id: 'objects_cibles' });
        }
        if (scope.templateform.formtype !== 'table_simple') {
          scope.editionLeftTabs.splice(1, 0, { title: 'Géométrie', id:'Géométrie'});
        }
        if (scope.templateform.formtype !== 'intervention_simple') {
          scope.editionLeftTabs.activeTab = 0;
        }

        scope.resultatElastic = {};

        scope.onElasticFilterSearchSuccess = (whereClause) => {
          scope.isTabs.activeTab = 1;
          scope.initialwhereclause = whereClause;
        };

        const FUNCTION_LOCALISE_AND_DISPLAY_INFO = 'LocaliseAndDisplayInformation(false)'

        scope.testActions = [
          {
            label: 'btn',
            btnclass: 'default',
            cfg: {
              iconOrLabel: 'icon',
              label: '',
              size: 'btn-xs',
              style: 'btn-default',
              icon: {
                name: 'location-arrow',
              },
            },
            config: {
              click: [FUNCTION_LOCALISE_AND_DISPLAY_INFO],
            },
          },
          {
            label: 'btn',
            btnclass: 'default',
            cfg: {
              iconOrLabel: 'icon',
              label: '',
              size: 'btn-xs',
              style: 'btn-info',
              icon: {
                name: 'edit',
              },
            },
            config: {
              click: ['iSimple_EditFeatureFromList()'],
            },
          },
          {
            label: 'btn',
            btnclass: 'default',
            cfg: {
              iconOrLabel: 'icon',
              label: '',
              size: 'btn-xs',
              style: 'btn-danger',
              icon: {
                name: 'times',
              },
            },
            config: {
              click: ['interventionSimple_DeleteFeatureFromList()'],
            },
          },
        ];
        // 'recherche_donnees' doesn't need edition and delete buttons
        if (scope.templateform.formtype === 'recherche_donnees') {
          //remove buttons from the list
          scope.testActions = scope.testActions.filter((action) => {
            if (action && action.config
              && Array.isArray(action.config.click)
              && action.config.click.length > 0 &&
              (action.config.click[0]==='iSimple_EditFeatureFromList()'
              ||action.config.click[0]==='interventionSimple_DeleteFeatureFromList()')) {
              return false;
            } else return true;
          });
        }

        // 'table_simple' don't have geometric data -> no localisation needed
        if (scope.templateform.formtype === 'table_simple') {
          //remove localisation button
          scope.testActions = scope.testActions.filter((action) => {
            if (action && action.config
              && Array.isArray(action.config.click)
              && action.config.click.length > 0 &&
              action.config.click[0]===FUNCTION_LOCALISE_AND_DISPLAY_INFO) {
              return false;
            } else return true;
          });
        }

        scope.canEditIsObject = { v: false };
        scope.changeIsTab = function(num) {
          if (num == 2 && !scope.canEditIsObject.v) return;
          scope.isTabs.activeTab = num;
          scope.$broadcast('setInitialDataTableHeight');
        };

        scope.localiseIsObject = function(obj) {
          mapJsUtils.localiseData(obj, scope.map);
        };

        // TEST A VIRER POTENTIELLEMENT POCCD93 COPIE DEPUIS FORMFIELDRENDER.JS
        scope.evaluateExpression = function(
          expressions,
          fields,
          selectedObject
        ) {
          console.log(scope.canEditIsObject);
          scope.canEditIsObject.v = true;

          var def = $q.defer();

          var objects = {
            res: scope.res,
            feattree: scope.feattree,
            map: scope.map,
          };

          if (angular.isDefined(selectedObject)) {
            objects.selectedObject = selectedObject;
          }

          if (scope.templateform.formtype === 'intervention_simple'
            || scope.templateform.formtype === 'table_simple') {
            objects.isTabs = scope.isTabs;
            objects.canEditIsObject = scope.canEditIsObject;
          }

          if (angular.isDefined(expressions)) {
            gcformfunction
              .evaluateExpression(expressions, objects, scope.templatefields,
                getFti(), undefined, scope.callbacks)
              .then(function() {
                def.resolve();
              });
          } else {
            def.resolve();
          }
          return def.promise;
        };

        scope.fermerEditionIs = function() {

          const isDirty = gaJsUtils.notNullAndDefined(scope.res, 'current.id')
            && isUtils.isForm[elt[0].closest('.popupContainer').id].isDirty;

          let hasConfirmed = true;
          if (scope.templateform.formtype !== 'intervention_simple'
              || (scope.templateform.formtype === 'intervention_simple'
              && (isUtils.hasSelectedFeatures || isDirty))) {
            hasConfirmed
              = confirm($filter('translate')('tools.builder.intervention_simple.exitConfirm'));
          }
          if (hasConfirmed) {
            // reset autres variables que 'current'
            scope.resetFormVariables();
            SelectManager.clear();
            gclayers.getDrawLayer().getSource().clear();
            scope.canEditIsObject.v = false;
            scope.isTabs.activeTab = 1;

            // vide la sélection (KIS-2808)
            if (gaJsUtils.notNullAndDefined(scope.templateform, 'data.savefield.config.association')
                && scope.res[scope.templateform.data.savefield.config.association]) {
              delete scope.res[scope.templateform.data.savefield.config.association];
            }

            // rétabli le filtre de données éventuellement désactivé par la fonction
            // deactivateFilter
            if (defaultFiltersFactory.isFormOpen() && scope.templateform
                && scope.templateform.formtype === 'intervention_simple'
                && scope.templateform.events) {
              defaultFiltersFactory.checkAndReactivateFilters(scope.templateform.events);
            }
            scope.$broadcast('setInitialDataTableHeight');
          }
        };

        /**
         * Nouvel objet vierge
         */
        scope.createNewIsObject = function() {
          scope.res.current = {
            type: 'Feature',
            properties: {},
          };

          // reset other variables
          scope.resetFormVariables();


          initialiseDefaultValues();

          if(angular.isDefined(checkActions)){
            checkActions('addButton');
          }

          scope.res.objectCibleCrudList = [];
          if (scope.templateform.data
            && scope.templateform.data.association
            && scope.templateform.data.association.associationResultat) {
            scope.res[scope.templateform.data.association.associationResultat] = {features: []};
          }

          scope.openInterventionSimpleEditionTabWith(scope.res.current);

          scope.res.ObjectsCiblesfakefti = angular.copy(ObjectsCiblesfakefti);

          if (scope.templateform.formtype === 'intervention_simple') {
            isUtils.setIsDefaultLabelsAndIcons(scope.curtemplate);
            scope.curtemplate.breadcrumb.goNext = true;
          }
        };

        const initialiseDefaultValues = () => {
          if (scope.isComponent && scope.isComponent.x) {
            // automatic fill user restriction
            for (const attribute of scope.isComponent.x.attributes) {
              const restriction = attribute.restrictions[0];
              // Initialise User restriction values
              if (restriction && restriction.type === 'User') {
                UsersFactory.getLightUsersByRoles(restriction.roles)
                  .then((lightUsers) => {
                    if (lightUsers.data && Array.isArray(lightUsers.data)) {
                      const currentUser = lightUsers.data.find( user => user.login === $rootScope.xgos.user.login);
                      if (currentUser) {
                        // in default case: isLoginKey=true
                        scope.res.current.properties[attribute.name] = restriction.isLoginKey === false ?
                          attributeRestrictionsUtils.buildFullname(currentUser.name, currentUser.vorname)
                          : currentUser.login;
                      }
                    }
                  },
                  () => {
                    require('toastr').error($filter('translate')('rights.roles.retrieve_error'));
                  });
              }
            }
          }
        }

        /**
         * ouvre le volet edition avec 'newCurrent' comme variable 'current'
         * et réinitialise les autres variables
         * @param {*} newCurrent La l'objet à édité dans le formulaire
         */
        scope.openInterventionSimpleEditionTabWith = (newCurrent) => {
          scope.canEditIsObject.v = true;
          // change tab intervention simple
          scope.isTabs.activeTab = 2;
          if (newCurrent) {
            scope.res.current = angular.copy(newCurrent);
          } else {
            scope.res.current = {};
          }
          // dans le cas d'une création d'objet
          if (!scope.res.current.id) {
            initialiseDefaultValues();
          }
          // change tab left menu
          if (scope.templateform.formtype === 'intervention_simple') {
            const isNew = !gaJsUtils.notNullAndDefined(scope.res, 'current.id');
            const popupContainer = elt[0].closest('.popupContainer');
            const idDialog = popupContainer.id;
            scope.curtemplate.breadcrumb = isUtils.initIsBreadCrumb('render', scope.curtemplate, isNew, popupContainer);
            scope.res.selectedObjectsFakeFti = isUtils.selectedObjectsFti;
            if (!isUtils.isForm[idDialog]) {
              isUtils.isForm[idDialog] = {};
            }
            isUtils.isForm[idDialog].isDirty = false;
            isUtils.isForm[idDialog].isInitialized = false;
          } else if (scope.res.current.id) {
            scope.editionLeftTabs.activeTab = 0;
          }

          scope.res.geometrie_cible = scope.res.current.geometry;
          scope.$broadcast('refreshAssociation');
          scope.initObjetsCibles();
        };

        scope.minimifyDialog = function($event) {
          var element = angular.element($event.currentTarget);

          var ngDialogWrapper = $(element).closest('.ngdialog');
          ngDialogWrapper.addClass('ngdialog-minimified');

          var modalTitle = $(element)
            .closest('.ngdialog-content')
            .find('.modalTitle');
          modalTitle.on('dblclick', function() {
            //console.log('unminimify');
            ngDialogWrapper.removeClass('ngdialog-minimified');
          });
        };

        scope.isSelectedList = {};
        scope.isSelectedGeom = {};
        scope.isObjectSelected = function() {
          if (typeof scope.isSelectedList.x === 'object' && scope.isSelectedList.x !== null
              && Number.isInteger(scope.isSelectedList.x.totalFeatures)
              && scope.isSelectedList.x.totalFeatures > 0) {
            scope.resultatElastic = angular.copy(scope.isSelectedList);
            scope.isTabs.activeTab = 1;
          }
        };

        scope.copyFeatureData = (featureToCopy) => {
          scope.dlgPopup.scope.doSave = true;
          scope.dlgPopup.scope.featureToCopy = featureToCopy;
          scope.dlgPopup.close();
        };

        scope.closeDialog = () => {
          scope.dlgPopup.scope.doSave = false;
          scope.dlgPopup.close();
        };

        /**
         * (Save intervention simple)
         * saves the feature contained in the variable 'current'
         */
        scope.saveIs = function() {
          gaDomUtils.showGlobalLoader();
          AppliquerPreValidationFunctions();
          var ftc = gaJsUtils.setNewFeatureCollection(scope.res.current);

          // add
          if (!scope.res.current.id) {
            EditFactory.add(
              scope.isComponent.x.uid,
              ftc,
              scope.isComponent.x.srid
            ).then(
              function(res) {
                var data = res.data;
                gaDomUtils.hideGlobalLoader();

                //Si la reponse n'est pas un objet du service d'édition, il y a une erreur
                if (data.create == undefined) {
                  var msg =
                    'Erreur serveur: ' +
                    data.message +
                    ', details:' +
                    data.details[0];
                  require('toastr').error(msg);
                  console.error(msg);
                  return;
                }

                scope.res.current.id = data.create;
                require('toastr').success('&#10003; Objet enregistré');
              },
              function() {
                require('toastr').error(
                  'Erreur lors de la sauvegarde de l\'objet'
                );
                gaDomUtils.hideGlobalLoader();
              }
            );
            // update
          } else {
            EditFactory.update(
              scope.isComponent.x.uid,
              ftc,
              scope.isComponent.x.srid
            ).then(
              function() {
                require('toastr').success('&#10003; Objet mis à jour');
                gaDomUtils.hideGlobalLoader();
              },
              function() {
                require('toastr').error(
                  'Erreur lors de la sauvegarde de l\'objet'
                );
                gaDomUtils.hideGlobalLoader();
              }
            );
          }
        };

        function AppliquerPreValidationFunctions() {
          if(angular.isDefined(scope.curtemplate) && angular.isDefined(scope.curtemplate.tabs)){
            scope.curtemplate.tabs.forEach((tab) => {
              if(angular.isDefined(tab.fields)){
                tab.fields.forEach((field) => {
                  if (angular.isDefined(field.preValidationFunction) && angular.isDefined(field.preValidationFunction.leftData) &&
                    field.preValidationFunction.leftData.length > 0) {
                    AppliquerPreValidationFunctionsToAttribute(field.config.name, field.preValidationFunction.leftData);
                  }
                });
              }
            });
          }
          if(angular.isDefined(scope.curtemplate) &&
              angular.isDefined(scope.curtemplate.fields) ){
            scope.curtemplate.fields.forEach((field) => {
              if (angular.isDefined(field.preValidationFunction) && angular.isDefined(field.preValidationFunction.leftData) &&
                field.preValidationFunction.leftData.length > 0) {
                AppliquerPreValidationFunctionsToAttribute(field.config.name, field.preValidationFunction.leftData);
              }
            });
          }
        }

        function AppliquerPreValidationFunctionsToAttribute(attribute,functionList) {
          functionList.forEach((func) => {
            switch (func.name) {
              case 'setUserAttribut':
                scope.res.current.properties[attribute] = $rootScope.xgos.user.name;
                break;
              case 'setDateAttribut':
                scope.res.current.properties[attribute] = new Date();
                break;
              case 'setUserCreationOnly':
                if (!scope.res.current.id) {
                  scope.res.current.properties[attribute] = $rootScope.xgos.user.name;
                }
                break;
              case 'setDateCreationOnly':
                if (!scope.res.current.id) {
                  scope.res.current.properties[attribute] = new Date();
                }
                break;
              default: break;
            }
          });
        }

        /**
        *    Un feature a été mis à jour.
        *  On vérifie si c'est celui édité dans ce formulaire et
        *  dans la variable indiquée dans le paramétrage
        *  de l'action "getFeatureFromDb".
        *  Si c'est le cas, on actualise les valeurs d'attribut.
        */
        scope.$on('refreshFeature', function(event, params) {
          if (
            scope.res[params.variable] &&
            scope.res[params.variable].id == params.refreshedFeature.id
          ) {
            for (var prop in params.refreshedFeature.properties) {
              scope.res[params.variable].properties[prop] =
                params.refreshedFeature.properties[prop];
            }
          }
        });

        /**
         * Au clic sur le bouton "Edit" d'une gcdatatable
         * ré-initialisation des variables autres que 'current'
         */
        scope.$on('editFormLine', () => {
          if (scope.templateform && scope.templateform.formtype && scope.templateform.formtype === 'intervention_simple') {
            scope.resetFormVariables();
          }
        });

        /**
         * Au clic sur le bouton "Edit" d'une gcdatatable et à l'enregistrement de l'intervention
         * ré-initialisation des variables autres que 'current'
         */
        scope.$on('refreshObjectCible', ()=>{
          scope.initObjetsCibles();
        });

        /**
         *  Met à jour l'affichage des features dans le gcDatatable
         *  à partir des données modifiées dans le gceditsave
         *  @see gceditsave
         */
        const updateGcDatatable = () => {
          if (scope.resultatElastic && scope.resultatElastic.x) {
            if (scope.interventionSimpleWithoutSearchTab
                && scope.resultatElastic.x.features.length > 0
                && scope.resultatElastic.x.features[0].id === undefined) {
              // Dans le mode 'interventionSimpleWithoutSearchTab'
              scope.resultatElastic.x.features[0] = angular.copy(scope.res.current);
            } else if (Array.isArray(scope.resultatElastic.x.features)) {
              for (let i = 0; i < scope.resultatElastic.x.features.length; i++) {
                if (scope.res.current.id
                    === scope.resultatElastic.x.features[i].id) {
                  scope.resultatElastic.x.features[i] = angular.copy(scope.res.current);
                  break;
                }
              }
            }
            scope.$broadcast('reloadDatatable');
          }
        };
        /**
         * A la réception de l'évènement "updateGcdatatable",
         * met à jour l'élement du tableau resultatElastic.X.features correspondant à la variable current (objet courant créé/modifié)
         * @param {object} data contient un booleen pour distinguer le mode création du mode édition et l'id de la popup dont on veut mettre à jour la datatable
         */
        scope.$on('updateGcdatatable', (event, data) => {
          if (!Number.isNaN(data.idPopup) && scope.dlgPopup.features.iddiv === data.idPopup
              && scope.templateform.formtype === 'intervention_simple') {
            // ajoute l'objet créé à la liste de l'onglet "Liste" si une liste existe.
            if (data.isNew && scope.resultatElastic.x) {
              scope.resultatElastic.x.totalFeatures ++;
              if (Array.isArray(scope.resultatElastic.x.features)) {
                scope.resultatElastic.x.features.push(scope.res.current);
              }
            }
            updateGcDatatable();
          }
        });

        /**
         * Ré-initialisation des variables
         * Tout sauf 'current' et 'associations'
         */
        scope.resetFormVariables = () => {
          const persistentVariables = ['current'];
          for (const [key, value] of Object.entries(scope.res)) {
            if (!persistentVariables.includes(key)) {
              if (Array.isArray(value)) {
                scope.res[key] = scope.res[key].splice(value.length);
              } else if (typeof value === 'object' && value !== null) {
                scope.res[key] = {};
              } else {
                scope.res[key] = null;
              }
            }
          }
        };

        scope.initObjetsCibles = () => {
          scope.res.objectCibleCrudList = [];
          if (gaJsUtils.notNullAndDefined(scope.templateform, 'data.association')
              && Array.isArray(scope.templateform.data.association.associationToLoad)
              && scope.templateform.data.association.associationToLoad.length > 0
              && scope.res.current.id) {

            //KIS-3084: erreur lors de l'ouverture d'un formulaire IS existant via la fonction OpenForm (scope.$$childHead = null)
            const renderedForm = isUtils.getLocalLoaderTarget(scope.$$childHead, scope.dlgPopup.dialog[0]);
            if (renderedForm) {
              gaDomUtils.showLocalLoader(renderedForm);
            }

            AssociationFactory.getListObjectsCibles($rootScope.xgos.portal.parameters.mainDB, scope.templateform.data.association.associationToLoad, scope.res.current.id).then((res) => {
              scope.res[scope.templateform.data.association.associationResultat] = res.data;
              scope.res.ObjectsCiblesfakefti = angular.copy(ObjectsCiblesfakefti);
            }, (err) => {
              require('toastr').error($filter('translate')(err.data));
            }).finally(() => {
              if (renderedForm) {
                gaDomUtils.removeLocalLoader(renderedForm);
              }
              if (scope.templateform.formtype === 'intervention_simple') {

                // marque la fin du chargement de l'IS et des inputs du volet "Attributs"
                // A partir de ce moment, toute modification d'input modifie la variable isUtils.isForm.isDirty
                startWatchingIsChanges();

                // ajuste la hauteur du corps des onglets en présence de plusieurs lignes d'onglets
                if (gaJsUtils.notNullAndDefined(scope.dlgPopup, 'dialog')) {
                  const iddiv = scope.dlgPopup.dialog.attr('dialog-id');
                  isUtils.adjustTabContentHeight(iddiv, 3);
                }
              }
            });
          } else if (scope.templateform.formtype === 'intervention_simple') {

            // marque la fin du chargement de l'IS sans associations et des inputs du volet "Attributs"
            // A partir de ce moment, toute modification d'input modifie la variable isUtils.isForm.isDirty
            startWatchingIsChanges();

            // ajuste la hauteur du corps des onglets en présence de plusieurs lignes d'onglets
            if (gaJsUtils.notNullAndDefined(scope.dlgPopup, 'dialog')) {
              const iddiv = scope.dlgPopup.dialog.attr('dialog-id');
              isUtils.adjustTabContentHeight(iddiv, 3);
            }
          }
        };


        scope.removeObjectCibleAfterConfirm = (obj) => {
          if (confirm($filter('translate')('tools.builder.intervention_simple.confirm_delete_objet_cible'))) {
            scope.removeObjectCible(obj);
          }
        };


        scope.removeObjectCible = (obj) => {
          scope.res[scope.templateform.data.association.associationResultat].features =
            scope.res[scope.templateform.data.association.associationResultat].features.filter((feature) => feature.id != obj.id);
          scope.res[scope.templateform.data.association.associationResultat].totalFeatures -= 1;
          //to refresh the datatable
          scope.res.ObjectsCiblesfakefti = angular.copy(scope.res.ObjectsCiblesfakefti);
          scope.res.objectCibleCrudList.push({
            'action': 'd',
            'associationToLoad': scope.curtemplate.association.associationToLoad,
            'FeatureID': scope.res.current.id,
            'couche': obj.properties.Couche,
            'identifiant': obj.properties.Identifiant
          });

          // KIS-2823: Ajouter des listeners sur la suppression d’un élément
          if (scope.templateform.formtype === 'intervention_simple') {
            isUtils.isForm[elt[0].closest('.popupContainer').id].isDirty = true;
          }
        };

        let cDialog;
        scope.updateObjectCible = (obj) => {
          scope.objCible = obj;
          scope.objCibleAlias = angular.copy(obj.properties.Alias);
          cDialog = ngDialog.open({
            template:
              'js/XG/modules/model/views/modals/modal.objectscibles.changealias.html',
            className: 'width300 ngdialog-theme-plain',
            closeByDocument: false,
            scope: scope,
          });
        };


        scope.updateAlias = (objCibleAlias) => {
          // KIS-2823: Ajouter des listeners sur l'édition de l’Alias
          if (scope.templateform.formtype === 'intervention_simple' && scope.objCible.properties.Alias !== objCibleAlias) {
            isUtils.isForm[elt[0].closest('.popupContainer').id].isDirty = true;
          }

          scope.objCible.properties.Alias = objCibleAlias;
          scope.res.objectCibleCrudList.push({
            'action': 'u',
            'associationToLoad': scope.curtemplate.association.associationToLoad,
            'FeatureID': scope.res.current.id,
            'couche': scope.objCible.properties.Couche,
            'identifiant': scope.objCible.properties.Identifiant,
            'alias': objCibleAlias
          });
          cDialog.close();
        };


        scope.viderSelection = () => {
          if (scope.templateform.data.savefield.config.association && scope.res[scope.templateform.data.savefield.config.association]) {
            delete scope.res[scope.templateform.data.savefield.config.association];
            gclayers.clearEditLayer();
          }
          // clearDrawLayer
          gclayers.getDrawLayer().getSource().clear();
          // clearHighLayer
          gclayers.clearhighLightFeatures();
          SelectManager.clear();

          // mode édition: supprime le tableau temporaire des objets sélectionnés et supprime l'étape "Objets sélectionnés"
          clearSelectedTempFeatures();
        };


        scope.vidergeometry = () => {
          if (confirm($filter('translate')('tools.builder.intervention_simple.confirm_delete_all_objet_cible'))) {
            if (scope.res.current.geometry) {
              scope.oldGeometry = angular.copy(scope.res.current.geometry);
              delete scope.res.current.geometry;
            }
            if (scope.res[scope.templateform.data.association.associationResultat]) {
              scope.res[scope.templateform.data.association.associationResultat].features.forEach((obj) => {
                scope.removeObjectCible(obj);
              });
            }
            // clearDrawLayer
            gclayers.getDrawLayer().getSource().clear();
            // clearHighLayer
            gclayers.clearhighLightFeatures();
            SelectManager.clear();
          }
        };


        scope.reloadGeometry = () => {
          if (scope.oldGeometry) {
            scope.res.current.geometry = angular.copy(scope.oldGeometry);
            delete scope.oldGeometry;
          }
          scope.initObjetsCibles();
        };


        scope.specialActionsObjetsCibles = [
          {
            class: 'btn btn-info btn-xs',
            icone: 'fa fa-pencil',
            text: $filter('translate')('tools.builder.association.editAlias'),
            callFunction: scope.updateObjectCible,
          },
          {
            class: 'btn btn-danger btn-xs',
            icone: 'fa fa-times',
            text: $filter('translate')('tools.builder.association.remove'),
            callFunction: scope.removeObjectCibleAfterConfirm,
          },
        ];

        scope.refreshbtn = {
          extraActions: [
            {
              name: $filter('translate')('hpo.common.refresh'),
              class: 'btn-default margin-left-right pull-right',
              func: scope.initObjetsCibles,
              icon: 'fa-refresh',
              special: true,
            },
          ],
        };

        /**
         * Rétabli les filtres désactivés (non-intervention simple) au clic sur le bouton close
         * Ne se déclenche pas sur les tables d'associations ni sur les tables d'association (#ngdialog1)
         */
        $rootScope.$on('ngDialog.closed', (event, $dialog) => {
          gcformfunction.removeMarker(scope.map);
          gclayers.clearhighLightFeatures();
          if (defaultFiltersFactory.isFormOpen() && scope.templateform && scope.templateform.events
              && $dialog !== undefined && $dialog.length > 0 && $dialog[0].id === scope.dlgPopup.id) {
            defaultFiltersFactory.checkAndReactivateFilters(scope.templateform.events);
          }
        });

        /**
         * Au clic sur le bouton "Réinitialiser" ou "Rechercher" ou au clis sur un bouton de sélection graphique,
         * efface l'objet édité courant et rend le 3ème onglet IS inactif
         */
        scope.resetCurrent = () => {
          if (scope.templateform && scope.templateform.formtype
            && (scope.templateform.formtype === 'intervention_simple'
            || scope.templateform.formtype === 'table_simple')
            && scope.res && scope.res.current) {
            scope.canEditIsObject = {v: false};
            scope.res.current = {};
          }
        };

        /**
         * Re-programme l'intervention simple sélectionnée (sourceFeature):<ul><li>
         * copie une sélection d'attributs de l'objet source</li><li>
         * copie une sélection d'associations de l'objet source</li><li>
         * associe les objets cibles de l'objet source à l'objet de destination</li><li>
         * associe les fichiers attachés des attributs sélectionnés de l'objet source à l'objet de destination</li></ul>
         * @param {*} sourceFeature l'objet édité dans le formulaire
         */
        scope.reprogramInterventionSimple = (sourceFeature) => {
          if (sourceFeature) {
            gaDomUtils.showLocalLoader('#is_' + scope.$$childHead.$id);
            reprogramFeature(sourceFeature);
            reprogramAssociations(sourceFeature)
              .finally(() => {
                reprogramObjetsCibles(sourceFeature)
                  .finally(() => {
                    reprogramAttachments(sourceFeature)
                      .finally(() => {
                        launchReprogramBreadcrumb(elt[0].closest('.popupContainer'));
                        gaDomUtils.removeLocalLoader('#is_' + scope.$$childHead.$id);
                      });
                  });
              });
          }
        };

        /**
         * Dans le cadre d'une reprogrammation d'une intervention simple
         * Créé un nouveau objet à partir de l'objet source
         * en tenant compte exclusivement des attributs souhaités dans la configuration de la fonction de reprogrammation
         * @param sourceFeature objet intervention simple (ex. curage)
         */
        const reprogramFeature = (sourceFeature) => {
          scope.canEditIsObject.v = true;

          // duplique l'objet current
          scope.res.current = angular.copy(sourceFeature);

          // supprime l'id de l'IS copiée
          delete scope.res.current.id;

          // KIS-3192: variable permettant l'affichage du bandeau bleu indiquant la présence d'une géométrie
          // quand l'objet est une reprogrammation et n'a pas encore d'id
          scope.res.current.isReprog = true;

          // récupère la géométrie
          scope.res.geometrie_cible = scope.res.current.geometry;

          // supprime objectid (ArcGIS)
          if (scope.isComponent.x.type === 'esri' && scope.res.current.properties.hasOwnProperty('objectid')) {
            scope.res.current.properties['objectid'] = null;
          }

          // supprime la valeur de l'id personnalisé (ArcGIS)
          if (scope.isComponent.x.type === 'esri' && typeof scope.isComponent.x.esriIdField === 'string'
              && scope.isComponent.x.esriIdField !== 'objectid') {
            scope.res.current.properties[scope.isComponent.x.esriIdField] = null;
          }

          // récupère les valeurs d'attributs à reprogrammer
          const attributesToLoad = scope.templateform.data.reprogram.attributesToLoad.map(attr => attr.name);
          for (const attribute of Object.keys(sourceFeature.properties)) {
            if (!attributesToLoad.includes(attribute)) {
              delete scope.res.current.properties[attribute];
            }
          }
        };

        /**
         * Dans le cadre d'une reprogrammation d'une intervention simple
         * Récupère les valeurs des associations de l'objet source et associe ces valeurs avec l'objet de destionation.
         * @param sourceFeature objet intervention simple (ex. curage)
         * @return {Promise}
         */
        const reprogramAssociations = (sourceFeature) => {
          const defer = $q.defer();
          if (scope.templateform.data.reprogram
              && scope.templateform.data.reprogram.associationToLoad
              && scope.templateform.data.reprogram.associationToLoad.length > 0) {

            // prépare les associations
            const mainDb = $rootScope.xgos.portal.parameters.mainDB;
            const associationsToLoad = scope.templateform.data.reprogram.associationToLoad;

            const promises = [];
            const assocNames = [];
            for (const association of associationsToLoad) {
              const promise = AssociationFactory.getAssociatedValues(mainDb, association.name, sourceFeature.id);
              promises.push(promise);
              assocNames.push(association.name);
            }
            $q.all(promises).then(
              res => {
                if (Array.isArray(res)) {
                  const associations = {};
                  for (let i = 0; i < res.length; i++) {
                    if (res[i].data && Array.isArray(res[i].data.features)) {
                      if (!Array.isArray(associations[assocNames[i]])) {
                        associations[assocNames[i]] = []
                      }
                      associations[assocNames[i]].push(...res[i].data.features);
                    }
                  }
                  if (Object.keys(associations).length > 0) {
                    scope.res.associations = angular.copy(associations);
                  }
                }
              }
            ).finally(() => defer.resolve());
          } else {
            defer.resolve();
          }
          return defer.promise;
        };

        /**
         * Dans le cadre d'une reprogrammation d'une intervention simple,
         * récupère les objets cibles de l'objet source et les associe à l'objet de destination
         * @param sourceFeature objet intervention simple (ex. curage)
         * @return {Promise}
         */
        const reprogramObjetsCibles = (sourceFeature) => {
          const defer = $q.defer();

          if (gaJsUtils.notNullAndDefined(scope.templateform, 'data.association.associationToLoad')
              && Array.isArray(scope.templateform.data.association.associationToLoad)
              && scope.templateform.data.association.associationToLoad.length > 0) {
            const associationToLoad = scope.templateform.data.association.associationToLoad;
            const mainDb = $rootScope.xgos.portal.parameters.mainDB;

            // associe les objets cibles à l'objet créé
            AssociationFactory.getListObjectsCibles(mainDb, associationToLoad, sourceFeature.id).then(
              (res) => {
                if (res.data && Array.isArray(res.data.features)) {
                  scope.res[scope.curtemplate.savefield.config.association] = angular.copy(res.data);
                  scope.res[scope.templateform.data.association.associationResultat] = angular.copy(res.data);
                  scope.res.ObjectsCiblesfakefti = angular.copy(ObjectsCiblesfakefti);
                  if (res.data.features.length > 0) {
                    isUtils.hasSelectedFeatures = true;
                  }
                  scope.$broadcast('reprogrammingWithTargetFeatures');
                }
                defer.resolve();
              },
              err => {
                require('toastr').error(err.data);
                defer.resolve();
              }
            );
          } else {
            defer.resolve();
          }
          return defer.promise;
        };

        /**
         * Dans le cadre d'une reprogrammation d'une intervention simple,
         * associe à l'objet de destination les fichiers attachés des attributs sélectionnés de l'objet source
         * @param sourceFeature objet intervention simple (ex. curage)
         * @return {Promise}
         */
        const reprogramAttachments = (sourceFeature) => {
          const defer = $q.defer();
          // liste les fichiers attachés présents dans les éventuels attributs reprogrammés
          const attachedFiles = {};

          const attachmentTypes = ['g2c.attachment', 'g2c.attachments'];

          // re-initialise la liste de l'onglet "pièces jointes"
          if (Array.isArray(scope.attachmentFiles)) {
            const filesCount = scope.attachmentFiles.length
            scope.attachmentFiles.splice(0, filesCount)
          } else {
            scope.attachmentFiles = [];
          }

          // construit un objet contenant en clé un uid et en valeur une string des noms de fichiers de l'attribut (séparés par une virgule)
          for (const attributeName of Object.keys(scope.res.current.properties)) {
            const attribute = scope.isComponent.x.attributes.find(attr => attr.name === attributeName);

            // vérifie si l'attribut de l'objet contient des données
            const hasAttachments = scope.res.current.properties.hasOwnProperty(attributeName)
                && typeof scope.res.current.properties[attributeName] === 'string'
                && scope.res.current.properties[attributeName].length > 0;

            // récupère la configuration du champ attachments
            const attributeField = findAttributeFieldInTabs(attribute.name);

            if (attribute && attachmentTypes.includes(attribute.type) && hasAttachments && attributeField) {
              // KIS-2877: ajoute un identifiant unique à la configuration du champ qui sera utilisé comme nom de dossier dans le repertoire UPLOAD du repo.
              // Cet identifiant unique fait le lien entre les fichiers uploadés et le champ de formulaire
              // Il est nécessaire pour pouvoir attacher le fichier (enregistrement de l'IS) ou supprimer le fichier uploadé (annulation de l'IS)
              const attachmentId = gaJsUtils.guid();
              attributeField.attachmentId = attachmentId;

              // vérifie l'absence de valeurs vides dans la valeur de l'attribut (ex: ",,")
              attachedFiles[attachmentId] = FeatureAttachmentFactory.preventEmptyAttachedFile(attribute.type, scope.res.current.properties[attributeName]);
            }
          }

          // prépare la copie des fichiers attachés
          if (Object.keys(attachedFiles).length > 0) {
            const source = Object({
              layername: scope.isComponent.x.name,
              featureid: gaJsUtils.getIdInCaseEsriId(sourceFeature, scope.isComponent.x, null)
            });

            // copie les fichiers attachés dans le dossier du nouveau feature
            FeatureAttachmentFactory.copyFilesToUpload(source, attachedFiles)
              .finally(() => {
                defer.resolve();
              });
          } else {
            defer.resolve();
          }
          return defer.promise;
        };

        /**
         * Dernière étape de la reprogrammation d'une IS,
         * prépare le fil d'ariane pour l'objet issu de la reprogrammation
         * @param {HTMLDivElement} popupContainer conteneur principal de la popup de l'IS
         */
        const launchReprogramBreadcrumb = (popupContainer) => {
          scope.isTabs.activeTab = 2;
          scope.breadcrumb = isUtils.initIsBreadCrumb('render', scope.curtemplate, true, popupContainer);

          // KIS-3192: Lorsque je reprogramme une IS, le nouveau formulaire s’ouvre sur la page Attributs du fil d’Ariane
          scope.breadcrumb.currentStep = 2;
          for (const step of scope.breadcrumb.steps) {
            step.show = true;
          }

          // affiche le bouton prev (<<), masque le bouton next (>>), affiche les étapes avec une propriété display flex
          scope.breadcrumb.goBack = true;
          scope.breadcrumb.goNext = false;
          scope.moreStepsShown = true;

          // KIS-3194: affiche l'étape "Objets sélectionnés seulement si la la liste des objets sélectionnés n'est pas vide
          if (isUtils.hasSelectedFeatures) {
            const labels = scope.curtemplate.labels.edition.steps;
            const selectedStep = isUtils.createStep(labels, 4, true);
            scope.breadcrumb.steps.push(selectedStep);
            isUtils.navigationArray.creation.push(4);

            // affiche le bouton next (>>) pour passer de l'étape "Attributs" à l'étape "Objets sélectionnés"
            scope.breadcrumb.goNext = true;
          }
          // MutationObserver bug dans Chrome
          // Utiliser un timeout serait la solution
          $timeout(() => {
            isUtils.addIsListenersAndObservers(popupContainer);
            if (!isUtils.isForm[popupContainer.id]) {
              isUtils.isForm[popupContainer.id] = {};
            }
            isUtils.isForm[popupContainer.id].isInitialized = true;
          }, 3000);
        };

        /**
         * Récupère la configuration du champ dans le formulaire IS dont le nom d'attribut est fourni en paramètre
         * @param {string} attributeName nom de l'attribut dont on veut récupérer le champ
         * @return {null|object} configuration du formulaire concernant l'attribut dont le nom est fourni en paramètre (scope.fields.tabs.fields[i])
         */
        const findAttributeFieldInTabs = (attributeName) => {
          for (const tab of scope.curtemplate.tabs) {
            const attachmentField = tab.fields.find(field => field.config.name === attributeName);
            if (attachmentField) {
              return attachmentField;
            }
          }
          return null;
        };

        /**
         * Gestion de l'affichage du bouton reprogrammation d'une IS
         * @return {boolean} true en mode builder ou en mode render et édition
         */
        scope.showIsReprogramButton = () => {
          return scope.templateform.formtype === 'intervention_simple' && scope.res.current.id;
        };

        /**
         * Gestion de l'affichage des boutons Enregistrer dans une IS
         * Les boutons sont affichés<ul><li>
         * En mode édition, Le bouton « Enregistrer » n’est accessible que si une action de modification sur les attributs ou sur la géométrie a été faite. Dans ce
         * cas, l’enregistrement peut se faire depuis n’importe quel volet</li><li>
         * En mode création, le bouton "Enregistrer" n'est accessible qu'à l'étape "Attributs"</li></ul>
         *
         * @return {boolean|boolean|*} true en mode builder ou en mode render et édition et si le formulaire est modifié ou en mode création à l'étape "Attributs"
         */
        scope.showIsSaveButton = () => {
          const isNew = scope.res.current !== undefined && !scope.res.current.id;
          const isCurrentStepAttributes = scope.curtemplate.breadcrumb !== undefined && scope.curtemplate.breadcrumb.currentStep === 2;
          const popupContainer = elt[0].closest('.popupContainer');
          if (!isUtils.isForm[popupContainer.id]) {
            isUtils.isForm[popupContainer.id] = {};
          }
          return scope.templateform.formtype !== 'intervention_simple'
              || (scope.templateform.formtype === 'intervention_simple'
              && ((isNew && isCurrentStepAttributes) || (!isNew && (isUtils.isForm[popupContainer.id].isDirty || isUtils.hasSelectedFeatures))));
        };

        /**
         * Au clic sur le bouton "Supprimer" (croix) d'une ligne de la table des objets sélectionnés à l'étape "Objets sélectionnés" d'une IS.
         * Enlève un objet de la liste des objets sélectionnés d'une IS
         * Modifie le tableau d'objets sélectionnés et le tableau d'objets sélectionnés en version simplifiée (<code>isSelectedObj</code>)
         * @param feature objet sélectionné de la ligne de la table
         */
        scope.isSelectedObjectRemove = (feature) => {
          scope.res.isSelectedObj.features = scope.res.isSelectedObj.features.filter(selFeat => selFeat.id !== feature.id);
          scope.res.isSelectedObj.totalFeatures -= 1;

          scope.res[scope.curtemplate.savefield.config.association].features = scope.res[scope.curtemplate.savefield.config.association].features.filter(feat => feat.id !== feature.id);
          SelectManager.removefeatures(feature.id);
          $rootScope.$broadcast('gcSelectChange');
          scope.$broadcast('reloadDatatable');

          // supprime l'étape "Objets sélectionnés" lorsque la table est vide
          if (scope.res.isSelectedObj.features.length === 0) {
            scope.curtemplate.breadcrumb.steps = scope.curtemplate.breadcrumb.steps.filter(step => step.id !== 4);
            if (gaJsUtils.notNullAndDefined(scope.res, 'current.id')) {
              isUtils.navigationArray.edition = isUtils.navigationArray.edition.filter(stepId => stepId !== 4);
            } else {
              isUtils.navigationArray.creation = isUtils.navigationArray.creation.filter(stepId => stepId !== 4);
            }
          }
        };

        scope.isSelectedObjectsSpecialActions = [
          {
            class: 'btn btn-danger btn-xs',
            icone: 'fa fa-times',
            text: $filter('translate')('tools.builder.intervention_simple.edition.deleteSelected'),
            callFunction: scope.isSelectedObjectRemove,
          },
        ];

        /**
         * Au clic sur le bouton "Vider la sélection" de l'étape "Géométrie".<br>
         * Supprime le tableau temporaire des objets sélectionnés simplifiés du conteneur
         * des variables du formulaire
         */
        const clearSelectedTempFeatures = () => {
          if (scope.templateform.formtype === 'intervention_simple' && isUtils.hasSelectedFeatures
              && gaJsUtils.notNullAndDefined(scope.curtemplate, 'breadcrumb')
              && Array.isArray(scope.curtemplate.breadcrumb.steps)) {

            // supprime l'étape "Objets sélectionnés" du fil d'ariane
            scope.curtemplate.breadcrumb.steps
              = scope.curtemplate.breadcrumb.steps.filter(step => step.id !== 4);

            scope.res.isSelectedObj = null;
            isUtils.hasSelectedFeatures = false;

            // propage la suppression de l'étape "Objets sélectionnés" dans le tableau de base
            // de la navigation entre étapes
            if (gaJsUtils.notNullAndDefined(scope.res, 'current.id')) {
              isUtils.navigationArray.edition = isUtils.navigationArray.edition.filter(
                stepId => stepId !== 4);
            } else {
              isUtils.navigationArray.creation = isUtils.navigationArray.creation.filter(
                stepId => stepId !== 4);
            }
          }
        };

        /**
         * Marque la fin du chargement de l'IS des inputs du volet "Attributs".
         * A partir de ce moment, toute modification d'input modifie
         * la variable isUtils.isForm.isDirty.
         * L'appel de cette méthode est effectué dans le corps de la méthode initObjetsCibles
         * car elle est censée terminer le chargement des IS
         */
        const startWatchingIsChanges = () => {
          isUtils.isForm[elt[0].closest('.popupContainer').id].isInitialized = true;
        };

        // réceptionne un changement de valeur d'un champ basé sur un(e) domaine/table
        // de restriction
        scope.$on('attributeRestrictionChange', () => {
          if (scope.templateform.formtype === 'intervention_simple') {
            isUtils.isForm[elt[0].closest('.popupContainer').id].isDirty = true;
          }
        });


        scope.$on('hpo_calculer_chantier', () => {
          IndigauFormFactory.calculerChantier(scope.res.current);
        });

        scope.$on('objects_added_to_relation', (event, params) => {
          IndigauFormFactory.prepareCalculerChantier(params);
        });


        /**
         *
         * initalisation apres ouverture de la dialog
         *
         */
        const init = () => {
          //alimenter les callbacks pour les boutons de la gcDatatable
          scope.callbacks.openEditionTabWith = scope.openInterventionSimpleEditionTabWith;
          scope.callbacks.reprogramEditionTabWith = scope.reprogramInterventionSimple;

          // dans le mode 'WithoutSearchTab', la variable current est déjà renseigné
          if (scope.interventionSimpleWithoutSearchTab) {
            if (scope.res == undefined) {
              scope.res = {};
            }
            if (scope.res.current == undefined) {
              scope.createNewIsObject();
            } else {
              // open edition tab
              scope.openInterventionSimpleEditionTabWith(scope.res.current);
            }

            // KIS-3079: après enregistrement d'une IS en mode Ajout,
            // la liste résultat contient 2 fois le curage nouvellement créé
            // on évite d'insérer l'objet vierge directement à l'ouverture du formulaire
            scope.resultatElastic.x =
              {
                crs: {type: 'name',
                  properties: {name: scope.map.getView().getProjection().getCode()}},
                features: [],
                totalFeatures: 0,
                type: 'FeatureCollection'
              };
            scope.$broadcast('reloadDatatable');
            // open edition tab
            scope.openInterventionSimpleEditionTabWith(scope.res.current);
          } else {
            if (scope.templateform.formtype === 'intervention_simple'
                || scope.templateform.formtype === 'table_simple'
                || scope.templateform.formtype === 'recherche_donnees') {
              // récupère les labels personnalisés de l'IS
              // exécuté à ce moment permet de récupérer les labels des pages Recherche et Liste
              isUtils.setIsDefaultLabelsAndIcons(scope.curtemplate);
            }
            scope.isTabs.activeTab = 0;
          }
        };
        init();
      },
    };
  };

  gcelement.$inject = [
    'gcformfunction',
    '$timeout',
    '$rootScope',
    'FeatureTypeFactory',
    'UsersFactory',
    '$q',
    'EditFactory',
    'gaDomUtils',
    'gaJsUtils',
    'mapJsUtils',
    'defaultFiltersFactory',
    'gclayers',
    '$filter',
    'ngDialog',
    'AssociationFactory',
    'SelectManager',
    'attributeRestrictionsUtils',
    'FeatureAttachmentFactory',
    'isUtils', 'IndigauFormFactory'
  ];
  return gcelement;
});
